/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.data.generation.provider;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import io.github.mortuusars.wares.Wares;
import io.github.mortuusars.wares.block.CardboardBoxBlock;
import io.github.mortuusars.wares.data.agreement.SealedDeliveryAgreement;
import io.github.mortuusars.wares.data.agreement.component.SteppedInt;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.data.loot.packs.VanillaChestLoot;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class LootTables {

    public static class ChestLoot
    extends VanillaChestLoot {
        public void m_245126_(@NotNull BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(Wares.resource("gameplay/empty_package"), this.agreementItems(this.item((ItemLike)Items.f_42516_, 1)));
            for (Pair<ResourceLocation, LootTable.Builder> locAndTable : this.villageTables()) {
                consumer.accept((ResourceLocation)locAndTable.getFirst(), (LootTable.Builder)locAndTable.getSecond());
            }
            LootPoolSingletonContainer.Builder[] dyes = new LootPoolSingletonContainer.Builder[DyeColor.values().length];
            for (DyeColor value : DyeColor.values()) {
                dyes[value.ordinal()] = this.item((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft:" + String.valueOf(value) + "_dye")), 2, 12);
            }
            consumer.accept(Wares.resource("agreement/wandering_trader/dyes"), this.agreementItems(dyes));
            consumer.accept(Wares.resource("agreement/wandering_trader/regular_price"), this.agreementItems(this.item((ItemLike)Items.f_42616_, 4, 12)));
            consumer.accept(Wares.resource("agreement/wandering_trader/regular_ware"), this.agreementItems(this.item((ItemLike)Items.f_42401_, 8, 16), this.item((ItemLike)Items.f_42403_, 8, 16), this.item((ItemLike)Items.f_42688_, 4, 16), this.item((ItemLike)Items.f_41996_, 3, 10), LootTableReference.m_79776_((ResourceLocation)Wares.resource("agreement/wandering_trader/dyes"))));
            consumer.accept(Wares.resource("agreement/wandering_trader/rare_price"), this.agreementItems(this.item((ItemLike)Items.f_42616_, 10, 20)));
            consumer.accept(Wares.resource("agreement/wandering_trader/rare_ware"), this.agreementItems(this.item((ItemLike)Items.f_42436_, 2, 6), this.item((ItemLike)Items.f_42677_, 2, 6), this.item((ItemLike)Items.f_42534_, 4, 16), this.item((ItemLike)Items.f_151049_, 2, 8)));
        }

        public List<Pair<ResourceLocation, LootTable.Builder>> villageTables() {
            ArrayList<Pair<ResourceLocation, LootTable.Builder>> list = new ArrayList<Pair<ResourceLocation, LootTable.Builder>>();
            list.addAll(this.plains());
            list.addAll(this.taiga());
            list.addAll(this.desert());
            list.addAll(this.savanna());
            list.addAll(this.snowy());
            return list;
        }

        private List<Pair<ResourceLocation, LootTable.Builder>> plains() {
            ArrayList<Pair<ResourceLocation, LootTable.Builder>> list = new ArrayList<Pair<ResourceLocation, LootTable.Builder>>();
            String type = "plains";
            list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_requested_sell"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42405_, 8, 14), this.item((ItemLike)Items.f_42620_, 8, 14), this.item((ItemLike)Items.f_42454_, 4, 10), this.item((ItemLike)Items.f_42516_, 10, 16), this.item((ItemLike)Items.f_42579_, 2, 6), this.item((ItemLike)Items.f_42485_, 2, 6), this.item((ItemLike)Items.f_42581_, 2, 6), this.item((ItemLike)Items.f_42406_, 3, 6))));
            list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_payment_sell"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42616_, 1, 3))));
            list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_requested_buy"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42616_, 3, 8))));
            list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_payment_buy"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42405_, 6, 14), this.item((ItemLike)Items.f_42620_, 6, 14), this.item((ItemLike)Items.f_42454_, 4, 10), this.item((ItemLike)Items.f_42516_, 8, 16), this.item((ItemLike)Items.f_42579_, 2, 6), this.item((ItemLike)Items.f_42485_, 2, 6), this.item((ItemLike)Items.f_42581_, 2, 6), this.item((ItemLike)Items.f_42406_, 3, 6), this.item((ItemLike)Items.f_41939_, 6, 10), this.item((ItemLike)Items.f_42206_, 5, 10))));
            list.add(Pair.of((Object)Wares.resource("chests/village/" + type + "_warehouse"), (Object)this.chestLootTableWithAgreement(type)));
            list.add(Pair.of((Object)Wares.resource("package/village/" + type), (Object)LootTable.m_79147_().m_79165_(LootContextParamSets.f_81411_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42405_, 12, 32).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42620_, 12, 32).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42619_, 12, 32).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42516_, 10, 30).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42517_, 4, 12).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42498_, 6, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42454_, 6, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42485_, 4, 10).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42579_, 4, 10).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42658_, 4, 10).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42206_, 4, 10).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42210_, 4, 10).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42616_, 8, 20).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42612_, 2, 8).m_79707_(2)))));
            return list;
        }

        private List<Pair<ResourceLocation, LootTable.Builder>> taiga() {
            ArrayList<Pair<ResourceLocation, LootTable.Builder>> list = new ArrayList<Pair<ResourceLocation, LootTable.Builder>>();
            String type = "taiga";
            list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_requested_sell"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42046_, 4, 12), this.item((ItemLike)Items.f_42780_, 10, 16), this.item((ItemLike)Items.f_42454_, 4, 10), this.item((ItemLike)Items.f_42516_, 10, 16), this.item((ItemLike)Items.f_42800_, 6, 16), this.item((ItemLike)Items.f_41838_, 4, 12), this.item((ItemLike)Items.f_42620_, 10, 18), this.item((ItemLike)Items.f_42406_, 3, 6), this.item((ItemLike)Items.f_41953_, 8, 14), this.item((ItemLike)Items.f_41952_, 8, 14))));
            list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_payment_sell"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42616_, 1, 3))));
            list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_requested_buy"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42616_, 3, 8))));
            list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_payment_buy"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42046_, 6, 14).m_79707_(10), this.item((ItemLike)Items.f_42620_, 6, 14).m_79707_(10), this.item((ItemLike)Items.f_42454_, 4, 10).m_79707_(10), this.item((ItemLike)Items.f_42516_, 8, 16).m_79707_(10), this.item((ItemLike)Items.f_42800_, 16, 24).m_79707_(10), this.item((ItemLike)Items.f_41838_, 14, 24).m_79707_(10), this.item((ItemLike)Items.f_42406_, 6, 12).m_79707_(10), this.item((ItemLike)Items.f_41998_, 12, 24).m_79707_(4), this.item((ItemLike)Items.f_42435_, 12, 24).m_79707_(4), this.item((ItemLike)Items.f_41953_, 8, 14).m_79707_(4), this.item((ItemLike)Items.f_41952_, 8, 14).m_79707_(4))));
            list.add(Pair.of((Object)Wares.resource("chests/village/" + type + "_warehouse"), (Object)this.chestLootTableWithAgreement(type)));
            list.add(Pair.of((Object)Wares.resource("package/village/" + type), (Object)LootTable.m_79147_().m_79165_(LootContextParamSets.f_81411_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42780_, 12, 32).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42046_, 8, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42620_, 12, 32).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42516_, 10, 30).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42517_, 4, 12).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42498_, 6, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42454_, 6, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41838_, 16, 32).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42800_, 8, 18).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41865_, 8, 18).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42211_, 8, 18).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42616_, 8, 20).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42612_, 2, 8).m_79707_(2)))));
            return list;
        }

        private List<Pair<ResourceLocation, LootTable.Builder>> desert() {
            ArrayList<Pair<ResourceLocation, LootTable.Builder>> list = new ArrayList<Pair<ResourceLocation, LootTable.Builder>>();
            String type = "desert";
            list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_requested_sell"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42405_, 6, 16), this.item((ItemLike)Items.f_41982_, 4, 12), this.item((ItemLike)Items.f_42496_, 8, 16), this.item((ItemLike)Items.f_42461_, 8, 14), this.item((ItemLike)Items.f_41856_, 10, 16), this.item((ItemLike)Items.f_42252_, 10, 16), this.item((ItemLike)Items.f_42199_, 10, 16), this.item((ItemLike)Items.f_42126_, 10, 16), this.item((ItemLike)Items.f_42163_, 10, 16), this.item((ItemLike)Items.f_42649_, 4, 10), this.item((ItemLike)Items.f_42516_, 10, 16), this.item((ItemLike)Items.f_42406_, 3, 6))));
            list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_payment_sell"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42616_, 1, 3))));
            list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_requested_buy"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42616_, 3, 8))));
            list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_payment_buy"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42405_, 4, 8).m_79707_(10), this.item((ItemLike)Items.f_41982_, 4, 8).m_79707_(10), this.item((ItemLike)Items.f_42649_, 4, 10).m_79707_(10), this.item((ItemLike)Items.f_42516_, 8, 16).m_79707_(10), this.item((ItemLike)Items.f_42461_, 8, 14).m_79707_(8), this.item((ItemLike)Items.f_41866_, 8, 16).m_79707_(6), this.item((ItemLike)Items.f_42406_, 6, 12).m_79707_(10))));
            list.add(Pair.of((Object)Wares.resource("chests/village/" + type + "_warehouse"), (Object)this.chestLootTableWithAgreement(type)));
            list.add(Pair.of((Object)Wares.resource("package/village/" + type), (Object)LootTable.m_79147_().m_79165_(LootContextParamSets.f_81411_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41982_, 8, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42461_, 8, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42405_, 6, 12).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42516_, 10, 30).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42517_, 4, 12).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42498_, 6, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42649_, 6, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41866_, 8, 18).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42245_, 6, 16).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42241_, 6, 16).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42244_, 6, 16).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42230_, 6, 16).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42648_, 2, 6).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42616_, 8, 20).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42612_, 2, 8).m_79707_(2)))));
            return list;
        }

        private List<Pair<ResourceLocation, LootTable.Builder>> savanna() {
            ArrayList<Pair<ResourceLocation, LootTable.Builder>> list = new ArrayList<Pair<ResourceLocation, LootTable.Builder>>();
            String type = "savanna";
            list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_requested_sell"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42619_, 6, 16), this.item((ItemLike)Items.f_42732_, 6, 16), this.item((ItemLike)Items.f_42587_, 8, 14), this.item((ItemLike)Items.f_42252_, 10, 16), this.item((ItemLike)Items.f_41841_, 10, 16), this.item((ItemLike)Items.f_41827_, 10, 16), this.item((ItemLike)Items.f_42516_, 10, 16), this.item((ItemLike)Items.f_42406_, 3, 6))));
            list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_payment_sell"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42616_, 1, 3))));
            list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_requested_buy"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42616_, 3, 8))));
            list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_payment_buy"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42619_, 4, 8).m_79707_(10), this.item((ItemLike)Items.f_42732_, 4, 8).m_79707_(10), this.item((ItemLike)Items.f_42417_, 2, 6).m_79707_(10), this.item((ItemLike)Items.f_42516_, 8, 16).m_79707_(10), this.item((ItemLike)Items.f_41827_, 8, 14).m_79707_(8), this.item((ItemLike)Items.f_41841_, 8, 16).m_79707_(6), this.item((ItemLike)Items.f_42406_, 6, 12).m_79707_(10))));
            list.add(Pair.of((Object)Wares.resource("chests/village/" + type + "_warehouse"), (Object)this.chestLootTableWithAgreement(type)));
            list.add(Pair.of((Object)Wares.resource("package/village/" + type), (Object)LootTable.m_79147_().m_79165_(LootContextParamSets.f_81411_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42619_, 8, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42732_, 8, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42405_, 6, 12).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42516_, 10, 30).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42517_, 4, 12).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42498_, 6, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41866_, 8, 18).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42658_, 6, 12).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42029_, 6, 12).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42777_, 1, 3).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42616_, 8, 20).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42612_, 2, 8).m_79707_(2)))));
            return list;
        }

        private List<Pair<ResourceLocation, LootTable.Builder>> snowy() {
            ArrayList<Pair<ResourceLocation, LootTable.Builder>> list = new ArrayList<Pair<ResourceLocation, LootTable.Builder>>();
            String type = "snowy";
            list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_requested_sell"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42620_, 6, 16), this.item((ItemLike)Items.f_42778_, 3, 8), this.item((ItemLike)Items.f_42413_, 8, 16), this.item((ItemLike)Items.f_41846_, 8, 14), this.item((ItemLike)Items.f_42700_, 10, 16), this.item((ItemLike)Items.f_42516_, 10, 16), this.item((ItemLike)Items.f_42406_, 3, 6))));
            list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_payment_sell"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42616_, 1, 3))));
            list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_requested_buy"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42616_, 3, 8))));
            list.add(Pair.of((Object)Wares.resource("agreement/village/" + type + "_payment_buy"), (Object)this.agreementItems(this.item((ItemLike)Items.f_42620_, 3, 8).m_79707_(10), this.item((ItemLike)Items.f_41981_, 8, 14).m_79707_(10), this.item((ItemLike)Items.f_41980_, 8, 14).m_79707_(10), this.item((ItemLike)Items.f_42363_, 6, 12).m_79707_(10), this.item((ItemLike)Items.f_42452_, 14, 24).m_79707_(10), this.item((ItemLike)Items.f_42406_, 6, 12).m_79707_(10))));
            list.add(Pair.of((Object)Wares.resource("chests/village/" + type + "_warehouse"), (Object)this.chestLootTableWithAgreement(type)));
            list.add(Pair.of((Object)Wares.resource("package/village/" + type), (Object)LootTable.m_79147_().m_79165_(LootContextParamSets.f_81411_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42620_, 8, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41981_, 12, 20).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41980_, 12, 20).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42363_, 12, 20).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41846_, 12, 20).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42517_, 4, 12).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42498_, 6, 16).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42777_, 1, 3).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42616_, 8, 20).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42612_, 2, 8).m_79707_(2)))));
            return list;
        }

        @NotNull
        private LootTable.Builder chestLootTableWithAgreement(String type) {
            SealedDeliveryAgreement agreementSell = new SealedDeliveryAgreement.Builder().requested(Wares.resource("agreement/village/" + type + "_requested_sell")).payment(Wares.resource("agreement/village/" + type + "_payment_sell")).ordered(new SteppedInt(64, 256, 8)).experience(new SteppedInt(12, 32, 4)).build();
            ItemStack sealedStackSell = new ItemStack((ItemLike)Wares.Items.SEALED_DELIVERY_AGREEMENT.get());
            agreementSell.toItemStack(sealedStackSell);
            SealedDeliveryAgreement agreementBuy = new SealedDeliveryAgreement.Builder().requested(Wares.resource("agreement/village/" + type + "_requested_buy")).payment(Wares.resource("agreement/village/" + type + "_payment_buy")).ordered(new SteppedInt(64, 256, 8)).experience(new SteppedInt(12, 32, 4)).build();
            ItemStack sealedStackBuy = new ItemStack((ItemLike)Wares.Items.SEALED_DELIVERY_AGREEMENT.get());
            agreementBuy.toItemStack(sealedStackBuy);
            return LootTable.m_79147_().m_79165_(LootContextParamSets.f_81411_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)6.0f)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42516_, 1, 3).m_79707_(10))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)6.0f)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Wares.Items.CARDBOARD_BOX.get(), 1, 1).m_79707_(8))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)Wares.Items.SEALED_DELIVERY_AGREEMENT.get())).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)sealedStackSell.m_41784_())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79707_(6)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)Wares.Items.SEALED_DELIVERY_AGREEMENT.get())).m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)sealedStackBuy.m_41784_())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_()));
        }

        private LootTable.Builder agreementItems(LootPoolSingletonContainer.Builder<?> ... items) {
            Preconditions.checkArgument((items.length > 0 ? 1 : 0) != 0, (Object)"No items were provided.");
            LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
            for (LootPoolSingletonContainer.Builder<?> item : items) {
                pool.m_79076_(item);
            }
            return LootTable.m_79147_().m_79165_(LootContextParamSets.f_81411_).m_79161_(pool);
        }

        public LootPoolSingletonContainer.Builder<?> item(ItemLike item, int count) {
            return this.item(item, count, count);
        }

        public LootPoolSingletonContainer.Builder<?> item(ItemLike item, int min, int max) {
            LootPoolSingletonContainer.Builder itemBuilder = LootItem.m_79579_((ItemLike)item);
            if (min == max) {
                itemBuilder.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)min)));
            } else {
                itemBuilder.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)));
            }
            return itemBuilder;
        }
    }

    public static class BlockLoot
    extends VanillaBlockLoot {
        @NotNull
        protected Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getEntries().stream().filter(e -> ((ResourceKey)e.getKey()).m_135782_().m_135827_().equals("wares")).map(Map.Entry::getValue).collect(Collectors.toList());
        }

        protected void m_245660_() {
            this.m_245724_((Block)Wares.Blocks.DELIVERY_TABLE.get());
            this.m_247577_((Block)Wares.Blocks.PACKAGE.get(), BlockLoot.m_246386_());
            CardboardBoxBlock cardboardBox = (CardboardBoxBlock)((Object)Wares.Blocks.CARDBOARD_BOX.get());
            this.m_247577_(cardboardBox, LootTable.m_79147_().m_79165_(LootContextParamSets.f_81421_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)Wares.Items.CARDBOARD_BOX.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)cardboardBox).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CardboardBoxBlock.BOXES, 2)))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)cardboardBox).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CardboardBoxBlock.BOXES, 3)))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)4.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)cardboardBox).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CardboardBoxBlock.BOXES, 4)))))));
        }
    }
}

