/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.data.agreement.component;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.github.mortuusars.wares.data.agreement.component.WeightedComponent;
import io.github.mortuusars.wares.data.serialization.ComponentCodec;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;

public record TextProvider(Either<Component, List<WeightedComponent>> provider) {
    public static final Codec<TextProvider> CODEC = Codec.either(ComponentCodec.CODEC, (Codec)Codec.list(WeightedComponent.CODEC)).flatXmap(i -> DataResult.success((Object)new TextProvider((Either<Component, List<WeightedComponent>>)i)), i -> DataResult.success(i.provider));
    public static final TextProvider EMPTY = TextProvider.of((Component)Component.m_237119_());

    public static TextProvider of(Component component) {
        return new TextProvider((Either<Component, List<WeightedComponent>>)Either.left((Object)component));
    }

    public static TextProvider of(List<WeightedComponent> list) {
        return new TextProvider((Either<Component, List<WeightedComponent>>)Either.right(list));
    }

    public static TextProvider of(WeightedComponent ... components) {
        return new TextProvider((Either<Component, List<WeightedComponent>>)Either.right(Arrays.stream(components).toList()));
    }

    public Component get(RandomSource random) {
        return (Component)this.provider.map(component -> component, weightedComponents -> TextProvider.fromWeightedList(weightedComponents, random));
    }

    private static Component fromWeightedList(List<WeightedComponent> weightedComponents, RandomSource random) {
        SimpleWeightedRandomList.Builder weightedList = SimpleWeightedRandomList.m_146263_();
        for (WeightedComponent weightedComponent : weightedComponents) {
            weightedList.m_146271_((Object)weightedComponent.component(), weightedComponent.weight().m_146281_());
        }
        Optional randomValue = weightedList.m_146270_().m_216820_(random);
        if (randomValue.isEmpty()) {
            throw new IllegalStateException("No result from Weighted List. Something must be wrong. List: [" + weightedComponents.stream().map(Record::toString).collect(Collectors.joining(",")));
        }
        return (Component)randomValue.get();
    }
}

