/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.client.gui.agreement;

import io.github.mortuusars.mpfui.component.Rectangle;
import io.github.mortuusars.wares.client.gui.agreement.AgreementLayout;
import io.github.mortuusars.wares.config.Config;
import io.github.mortuusars.wares.data.agreement.DeliveryAgreement;
import io.github.mortuusars.wares.data.agreement.component.RequestedItem;
import io.github.mortuusars.wares.menu.ItemDisplaySlot;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AgreementMenu
extends AbstractContainerMenu {
    public static final Rectangle AREA = new Rectangle(0, 0, 200, 256);
    public static final Rectangle CONTENT_AREA = AREA.shrink(12, 21, 12, 46);
    public static final Rectangle AREA_SHORT = new Rectangle(0, 0, 200, 212);
    public static final Rectangle CONTENT_AREA_SHORT = AREA_SHORT.shrink(12, 21, 12, 46);
    public static final int SHORT_AGREEMENT_THRESHOLD = 45;
    public static final int ELEMENTS_SPACING = 14;
    public final Inventory playerInventory;
    public final Player player;
    public final Level level;
    protected final Supplier<DeliveryAgreement> agreementSupplier;
    protected AgreementLayout layout;
    public final boolean isShort;
    public int posYOffset;

    public AgreementMenu(int containerId, Inventory playerInventory, Supplier<DeliveryAgreement> agreementSupplier) {
        super(null, containerId);
        this.player = playerInventory.f_35978_;
        this.level = playerInventory.f_35978_.m_9236_();
        this.playerInventory = playerInventory;
        this.agreementSupplier = agreementSupplier;
        if (!playerInventory.f_35978_.m_9236_().f_46443_) {
            throw new IllegalStateException("AgreementMenu can exist only on client-side.");
        }
        this.layout = this.layoutAgreementElements(CONTENT_AREA, 14);
        int height = this.layout.getHeight();
        if (CONTENT_AREA.height() - height >= 45) {
            this.isShort = true;
            this.layout = this.layoutAgreementElements(CONTENT_AREA_SHORT, 14);
            yOffsetToCenter = (CONTENT_AREA_SHORT.height() - this.layout.getHeight()) / 2;
            this.posYOffset = CONTENT_AREA_SHORT.top() + yOffsetToCenter;
        } else {
            yOffsetToCenter = (CONTENT_AREA.height() - height) / 2;
            this.posYOffset = CONTENT_AREA.top() + yOffsetToCenter;
            this.isShort = false;
        }
        DeliveryAgreement agreement = this.getAgreement();
        int requestedSlotsCount = agreement.getRequested().size();
        int paymentSlotsCount = agreement.getPayment().size();
        boolean shouldCenterY = requestedSlotsCount > 3 || paymentSlotsCount > 3;
        Function<Integer, List<ItemStack>> requestedStacksForSlot = integer -> {
            List<ItemStack> stacks = agreement.getRequested().get((int)integer).getStacks();
            if (stacks.size() == 0) {
                ItemStack barrier = new ItemStack((ItemLike)Items.f_42127_);
                barrier.m_41714_((Component)Component.m_237115_((String)"gui.wares.agreement.empty_tag"));
                stacks = List.of(barrier);
            }
            return stacks;
        };
        Function<Integer, Component> requestedTooltipForSlot = integer -> {
            RequestedItem requestedItem = agreement.getRequested().get((int)integer);
            return (Component)requestedItem.getTagOrItem().map(tag -> Component.m_237110_((String)"gui.wares.agreement.tag_slot_tooltip", (Object[])new Object[]{"#" + String.valueOf(tag.f_203868_())}), item -> Component.m_237119_());
        };
        Function<Integer, List<ItemStack>> paymentStacksForSlot = integer -> List.of(agreement.getPayment().get((int)integer));
        Function<Integer, Component> paymentTooltipForSlot = integer -> Component.m_237119_();
        Rectangle slotsRect = this.layout.getElement(AgreementLayout.Element.SLOTS);
        if (slotsRect != null) {
            int slotsPosY = this.posYOffset + slotsRect.top();
            this.arrangeDisplaySlotsInGrid(requestedSlotsCount, 0, 30, slotsPosY, shouldCenterY, requestedStacksForSlot, requestedTooltipForSlot);
            this.arrangeDisplaySlotsInGrid(paymentSlotsCount, requestedSlotsCount, 116, slotsPosY, shouldCenterY, paymentStacksForSlot, paymentTooltipForSlot);
        }
    }

    public int getUIWidth() {
        return this.isShort ? AREA_SHORT.width() : AREA.width();
    }

    public int getUIHeight() {
        return this.isShort ? AREA_SHORT.height() : AREA.height();
    }

    public AgreementLayout getLayout() {
        return this.layout;
    }

    public DeliveryAgreement getAgreement() {
        return this.agreementSupplier.get();
    }

    public MutableComponent getTitle() {
        Component title = this.getAgreement().getTitle();
        return title.equals(Component.m_237119_()) ? Component.m_237115_((String)"gui.wares.agreement.title") : title.m_6881_();
    }

    public MutableComponent getMessage() {
        MutableComponent message = (MutableComponent)this.getAgreement().getMessage();
        MutableComponent mutableComponent = message = message.equals((Object)Component.m_237119_()) ? Component.m_237115_((String)"gui.wares.agreement.message") : message.m_6881_();
        if (((Boolean)Config.AGREEMENT_APPEND_BUYER_INFO_TO_MESSAGE.get()).booleanValue()) {
            boolean hasBuyerAddress;
            boolean hasBuyerName = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.getAgreement().getBuyerName()) != 0;
            boolean bl = hasBuyerAddress = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.getAgreement().getBuyerAddress()) != 0;
            if (hasBuyerName || hasBuyerAddress) {
                message.m_130946_("\n");
            }
            if (hasBuyerName) {
                message.m_130946_("\n");
                message.m_7220_(this.getAgreement().getBuyerName());
            }
            if (hasBuyerAddress) {
                message.m_130946_("\n");
                message.m_7220_(this.getAgreement().getBuyerAddress());
            }
        }
        return message;
    }

    protected AgreementLayout layoutAgreementElements(Rectangle availableArea, int elementsSpacing) {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int lineHeight = 9;
        int slotsHeight = this.getAgreement().getRequested().size() > 3 || this.getAgreement().getPayment().size() > 3 ? 36 : 18;
        boolean shouldDisplayOrderedCount = !this.getAgreement().isInfinite() || (Boolean)Config.AGREEMENT_INFINITY_SYMBOL.get() != false;
        boolean shouldDisplayExpirationTime = !this.getAgreement().isExpired(this.level.m_46467_());
        int infoHeight = 0;
        if (shouldDisplayOrderedCount) {
            infoHeight += lineHeight;
        }
        if (shouldDisplayExpirationTime) {
            infoHeight += lineHeight;
        }
        int heightWithoutMessage = lineHeight + elementsSpacing + slotsHeight + (infoHeight > 0 ? elementsSpacing + infoHeight : 0);
        int heightForMessage = availableArea.height() - heightWithoutMessage - elementsSpacing;
        List messageLines = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)this.getMessage(), availableArea.width());
        int messageHeight = Math.min(heightForMessage, messageLines.size() * lineHeight);
        AgreementLayout layout = new AgreementLayout();
        layout.append(AgreementLayout.Element.TITLE, availableArea.x(), availableArea.width(), lineHeight, 0);
        if (messageHeight > 0) {
            layout.append(AgreementLayout.Element.MESSAGE, availableArea.x(), availableArea.width(), messageHeight, elementsSpacing);
        }
        layout.append(AgreementLayout.Element.SLOTS, availableArea.x() + 18, availableArea.width() - 36, slotsHeight, elementsSpacing);
        int infoSpacing = elementsSpacing;
        if (shouldDisplayOrderedCount) {
            layout.append(AgreementLayout.Element.ORDERED, availableArea.x(), availableArea.width(), lineHeight, infoSpacing);
            infoSpacing = 0;
        }
        if (shouldDisplayExpirationTime) {
            layout.append(AgreementLayout.Element.EXPIRY, availableArea.x(), availableArea.width(), lineHeight, infoSpacing);
        }
        return layout;
    }

    protected void arrangeDisplaySlotsInGrid(int count, int startIndex, int startX, int startY, boolean centeredY, Function<Integer, List<ItemStack>> stacksForSlotIndex, Function<Integer, Component> tooltipsForSlotIndex) {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        if (count == 4) {
            rows.add(2);
            rows.add(2);
        } else {
            for (int i = 0; i < count / 3; ++i) {
                rows.add(3);
            }
            int partialRow = count % 3;
            if (partialRow != 0) {
                rows.add(partialRow);
            }
        }
        int index = 0;
        for (int row = 0; row < rows.size(); ++row) {
            int slots = (Integer)rows.get(row);
            int x = startX + (27 - 18 * slots / 2);
            int y = count <= 3 && centeredY ? startY + 9 : startY;
            for (int column = 0; column < slots; ++column) {
                List<ItemStack> stacks = stacksForSlotIndex.apply(index);
                Component tooltip = tooltipsForSlotIndex.apply(index);
                this.m_38897_(new ItemDisplaySlot(stacks, tooltip, startIndex + index, x + column * 18, y + row * 18));
                ++index;
            }
        }
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        return ItemStack.f_41583_;
    }

    public void m_150399_(int pSlotId, int pButton, @NotNull ClickType pClickType, @NotNull Player pPlayer) {
        super.m_150399_(pSlotId, pButton, pClickType, pPlayer);
    }

    public boolean m_6875_(@NotNull Player player) {
        return this.getAgreement() != DeliveryAgreement.EMPTY;
    }
}

