/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import net.mehvahdjukaar.moonlight.api.block.IColored;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class AwningBlock
extends WaterBlock
implements IColored {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty BOTTOM = BlockStateProperties.f_61427_;
    public static final BooleanProperty SLANTED = ModBlockProperties.SLANTED;
    protected static final VoxelShape BOTTOM_INTERACTION = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape BOTTOM_COLLISION = Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape TOP_INTERACTION = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape TOP_COLLISION = Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final DyeColor color;

    public AwningBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SLANTED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean m_5946_(BlockState state, Fluid fluid) {
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        return !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState behindAbove;
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos behind = pos.m_121945_(direction.m_122424_());
        BlockState behindState = level.m_8055_(behind);
        if (behindState.m_280296_()) {
            return true;
        }
        if (behindState.m_60734_() instanceof AwningBlock) {
            if (!((Boolean)behindState.m_61143_((Property)SLANTED)).booleanValue()) {
                return true;
            }
            if (((Boolean)behindState.m_61143_((Property)SLANTED)).booleanValue() && ((Boolean)state.m_61143_((Property)BOTTOM)).booleanValue()) {
                return true;
            }
        }
        if ((behindAbove = level.m_8055_(behind.m_7494_())).m_60734_() instanceof AwningBlock && ((Boolean)behindAbove.m_61143_((Property)SLANTED)).booleanValue()) {
            return true;
        }
        BlockState left = level.m_8055_(pos.m_121945_(direction.m_122427_()));
        BlockState right = level.m_8055_(pos.m_121945_(direction.m_122428_()));
        return left.m_280296_() || right.m_280296_();
    }

    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        if (side.m_122434_().m_122479_() && !((Boolean)state.m_61143_((Property)SLANTED)).booleanValue() && adjacentBlockState.m_60734_() instanceof AwningBlock && adjacentBlockState.m_61143_((Property)BOTTOM) == state.m_61143_((Property)BOTTOM)) {
            if (((Boolean)adjacentBlockState.m_61143_((Property)SLANTED)).booleanValue()) {
                return state.m_61143_((Property)FACING) != adjacentBlockState.m_61143_((Property)FACING);
            }
            return true;
        }
        return super.m_6104_(state, adjacentBlockState, side);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)BOTTOM) != false ? BOTTOM_INTERACTION : TOP_INTERACTION;
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)BOTTOM) != false ? BOTTOM_COLLISION : TOP_COLLISION;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)BOTTOM) != false ? BOTTOM_INTERACTION : TOP_INTERACTION;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext ec;
        boolean bottom = (Boolean)state.m_61143_((Property)BOTTOM);
        if (CommonConfigs.Building.AWNING_FALL_THROUGH.get().booleanValue() && context instanceof EntityCollisionContext && (ec = (EntityCollisionContext)context).m_193113_() != null && (context.m_6226_() || !context.m_6513_(bottom ? TOP_COLLISION : BOTTOM_COLLISION, bottom ? pos.m_7495_() : pos, false))) {
            return Shapes.m_83040_();
        }
        return super.m_5939_(state, level, pos, context);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SLANTED});
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{BOTTOM});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockState = super.m_5573_(context);
        Direction face = context.m_43719_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        LinkedList<Direction> directions = new LinkedList<Direction>(Arrays.stream(context.m_6232_()).toList());
        BlockState clickedOn = level.m_8055_(pos.m_121945_(face.m_122424_()));
        boolean slanted = false;
        if (clickedOn.m_60734_() instanceof AwningBlock) {
            Direction dir = ((Direction)clickedOn.m_61143_((Property)FACING)).m_122424_();
            if (context.m_7820_() == dir) {
                directions.remove(dir);
                directions.add(0, dir);
                if (((Boolean)clickedOn.m_61143_((Property)SLANTED)).booleanValue()) {
                    slanted = true;
                }
            }
        }
        for (Direction direction : directions) {
            if (!direction.m_122434_().m_122479_()) continue;
            Direction opposite = direction.m_122424_();
            boolean bottom = !(face == Direction.DOWN || face != Direction.UP && context.m_43720_().f_82480_ - (double)pos.m_123342_() > 0.5);
            ArrayList<BlockPos> behindPos = new ArrayList<BlockPos>();
            behindPos.add(pos.m_121945_(direction));
            if (!bottom) {
                behindPos.add(pos.m_121945_(direction).m_7494_());
            }
            if (!CommonConfigs.Building.AWNING_SLANT.get().booleanValue()) {
                behindPos.clear();
            }
            for (int i = 0; i < behindPos.size(); ++i) {
                BlockState behindState = level.m_8055_((BlockPos)behindPos.get(i));
                if (!(behindState.m_60734_() instanceof AwningBlock) || !((Boolean)behindState.m_61143_((Property)SLANTED)).booleanValue() || behindState.m_61143_((Property)FACING) != direction.m_122424_()) continue;
                bottom = i == 0;
                slanted = true;
                break;
            }
            if (!(blockState = (BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(bottom))).m_61124_((Property)SLANTED, (Comparable)Boolean.valueOf(slanted))).m_61124_((Property)FACING, (Comparable)opposite)).m_60710_((LevelReader)level, pos)) continue;
            return blockState;
        }
        return null;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (entity.m_20162_()) {
            super.m_142072_(level, state, pos, entity, fallDistance);
        } else {
            entity.m_142535_(fallDistance, 0.0f, level.m_269111_().m_268989_());
        }
    }

    public void m_5548_(BlockGetter level, Entity entity) {
        if (entity.m_20162_() || entity.m_6095_().m_204039_(ModTags.AWNING_BLACKLIST)) {
            super.m_5548_(level, entity);
        }
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!entity.m_20162_() && !entity.m_6095_().m_204039_(ModTags.AWNING_BLACKLIST)) {
            Vec3 movement = entity.m_20184_();
            if (movement.f_82480_ < (double)-0.32f) {
                Vector3f normal = AwningBlock.getNormalVector(state);
                Vector3f newMovement = movement.m_252839_().reflect((Vector3fc)normal);
                entity.m_20256_(new Vec3(newMovement));
                entity.f_19812_ = true;
                level.m_5594_(null, pos, ModSounds.AWNING_BOUNCES.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                entity.m_20256_(entity.m_20184_().m_82542_(1.0, 0.0, 1.0));
            }
        }
        super.m_141947_(level, pos, state, entity);
    }

    @NotNull
    public static Vector3f getNormalVector(BlockState state) {
        if (!((Boolean)state.m_61143_((Property)SLANTED)).booleanValue()) {
            return new Vector3f(0.0f, 1.0f, 0.0f);
        }
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        Vector3f normal = new Vector3f(0.0f, 1.0f, 0.0f);
        if (((Boolean)state.m_61143_((Property)SLANTED)).booleanValue()) {
            double angleDeg = CommonConfigs.Building.AWNINGS_BOUNCE_ANGLE.get();
            normal.rotate((Quaternionfc)Axis.f_252529_.m_252977_((float)(90.0 - angleDeg)));
        }
        normal.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-dir.m_122435_()));
        return normal;
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public boolean supportsBlankColor() {
        return true;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_21120_(hand).m_41619_() && CommonConfigs.Building.AWNING_SLANT.get().booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)SLANTED), 3);
            boolean isSlanted = (Boolean)state.m_61143_((Property)SLANTED);
            level.m_5594_(player, pos, SoundEvents.f_12642_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
            level.m_142346_((Entity)player, isSlanted ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }
}

