/*
 * Decompiled with CFR 0.152.
 */
package toni.darkwindowbar;

import com.mojang.blaze3d.platform.Window;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.glfw.GLFWNativeWin32;
import org.lwjgl.system.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import toni.darkwindowbar.DwmApi;

@Mod(value="darkwindowbar")
public class DarkWindowBar {
    public static final String MODNAME = "Dark Window Bar";
    public static final String ID = "darkwindowbar";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Dark Window Bar");

    public static void setDarkWindowBar(Window window) {
        if (Platform.get() != Platform.WINDOWS) {
            LOGGER.warn("Dark Window Bar only works on Windows!");
            return;
        }
        WinNT.OSVERSIONINFO osversioninfo = new WinNT.OSVERSIONINFO();
        Kernel32.INSTANCE.GetVersionEx(osversioninfo);
        if (osversioninfo.dwMajorVersion.longValue() < 10L || osversioninfo.dwBuildNumber.longValue() < 17763L) {
            LOGGER.warn("DarkTitleBar requires Windows 10 version 1809 or newer!");
            return;
        }
        long glfwWindow = window.m_85439_();
        long hwndLong = GLFWNativeWin32.glfwGetWin32Window((long)glfwWindow);
        WinDef.HWND hwnd = new WinDef.HWND(Pointer.createConstant((long)hwndLong));
        Memory mem = new Memory((long)Native.POINTER_SIZE);
        mem.setInt(0L, 1);
        DwmApi.INSTANCE.DwmSetWindowAttribute(hwnd, DwmApi.DWMWA_USE_IMMERSIVE_DARK_MODE, new WinDef.LPVOID((Pointer)mem), new WinDef.DWORD(4L));
        mem.close();
        int oldWidth = window.m_85443_();
        window.m_166447_(oldWidth + 2, window.m_85444_());
        window.m_166447_(oldWidth, window.m_85444_());
    }
}

