/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.util.easing;

@FunctionalInterface
public interface EasingFunction {
    public float compute(float var1);

    default public EasingFunction reverse() {
        return progress -> 1.0f - this.compute(progress);
    }

    default public EasingFunction scale(float scale) {
        return progress -> this.compute(progress * (1.0f / scale));
    }

    default public EasingFunction merge(EasingFunction other, float ratio) {
        return progress -> {
            if (progress <= ratio) {
                float local = progress / ratio;
                return this.compute(local) * ratio;
            }
            float local = (progress - ratio) / (1.0f - ratio);
            return ratio + other.compute(local) * (1.0f - ratio);
        };
    }

    default public EasingFunction mergeOut(EasingFunction other, float ratio) {
        return progress -> {
            if (progress <= ratio) {
                float local = progress / ratio;
                return this.compute(local);
            }
            float local = (progress - ratio) / (1.0f - ratio);
            return 1.0f - other.compute(local);
        };
    }
}

