/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.util;

import java.util.Comparator;
import java.util.List;

public abstract class BinarySearch<E> {
    public static <T extends Comparable> BinarySearch<T> on(final List<T> list) {
        return new BinarySearch<T>(){

            @Override
            protected int compare(int index, T element) {
                return ((Comparable)list.get(index)).compareTo(element);
            }

            @Override
            protected int getLastIndex() {
                return list.size() - 1;
            }
        };
    }

    public static <T> BinarySearch<T> on(final List<T> list, final Comparator<T> comparator) {
        return new BinarySearch<T>(){

            @Override
            protected int compare(int index, T element) {
                return comparator.compare(list.get(index), element);
            }

            @Override
            protected int getLastIndex() {
                return list.size() - 1;
            }
        };
    }

    public static <T extends Comparable> BinarySearch<T> on(T[] array) {
        return new BinarySearch<T>((Comparable[])array){
            final /* synthetic */ Comparable[] val$array;
            {
                this.val$array = comparableArray;
            }

            @Override
            protected int compare(int index, T element) {
                return this.val$array[index].compareTo(element);
            }

            @Override
            protected int getLastIndex() {
                return this.val$array.length - 1;
            }
        };
    }

    public static <T> BinarySearch<T> on(final T[] array, final Comparator<T> comparator) {
        return new BinarySearch<T>(){

            @Override
            protected int compare(int index, T element) {
                return comparator.compare(array[index], element);
            }

            @Override
            protected int getLastIndex() {
                return array.length - 1;
            }
        };
    }

    protected abstract int compare(int var1, E var2);

    protected abstract int getLastIndex();

    public int find(E element) {
        return this.find(element, 0, this.getLastIndex());
    }

    public int find(E element, int low, int high) {
        while (low <= high) {
            int mid = low + high >>> 1;
            int delta = this.compare(mid, element);
            if (delta < 0) {
                low = mid + 1;
                continue;
            }
            if (delta > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int findFirst(E o) {
        return this.findFirst(o, 0, this.getLastIndex());
    }

    public int findFirst(E o, int low, int high) {
        int ndx = -1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int delta = this.compare(mid, o);
            if (delta < 0) {
                low = mid + 1;
                continue;
            }
            if (delta == 0) {
                ndx = mid;
            }
            high = mid - 1;
        }
        if (ndx == -1) {
            return -(low + 1);
        }
        return ndx;
    }

    public int findLast(E o) {
        return this.findLast(o, 0, this.getLastIndex());
    }

    public int findLast(E o, int low, int high) {
        int ndx = -1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int delta = this.compare(mid, o);
            if (delta > 0) {
                high = mid - 1;
                continue;
            }
            if (delta == 0) {
                ndx = mid;
            }
            low = mid + 1;
        }
        if (ndx == -1) {
            return -(low + 1);
        }
        return ndx;
    }
}

