/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.typeconverter.impl;

import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConversionException;
import com.hypherionmc.simplerpc.jodd.typeconverter.TypeConverter;
import com.hypherionmc.simplerpc.jodd.util.StringUtil;

public class LongConverter
implements TypeConverter<Long> {
    @Override
    public Long convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == Long.class) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? Long.valueOf(1L) : Long.valueOf(0L);
        }
        try {
            String stringValue = value.toString().trim();
            if (StringUtil.startsWithChar(stringValue, '+')) {
                stringValue = stringValue.substring(1);
            }
            return Long.valueOf(stringValue);
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

