/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.integrations.launchers.types;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.hypherionmc.simplerpc.api.utils.APIUtils;
import com.hypherionmc.simplerpc.enums.LauncherType;
import com.hypherionmc.simplerpc.integrations.launchers.Launcher;
import java.io.File;

public final class CurseForge
implements Launcher {
    private boolean hasLoaded = false;
    private String packName = "Unknown Pack";
    private LauncherType type = LauncherType.GDLAUNCHER;

    @Override
    public LauncherType getLauncherType() {
        return this.type;
    }

    @Override
    public void tryLoadLauncher() {
        File pack = new File(new File(APIUtils.CUR_DIR), "manifest.json");
        File alternative = new File(new File(APIUtils.CUR_DIR), "minecraftinstance.json");
        File gdDir = new File(new File(APIUtils.CUR_DIR).getParentFile().getParent());
        if (pack.exists() || alternative.exists()) {
            try {
                String packString = this.readLauncherFile(pack.exists() ? pack : alternative);
                JsonObject object = (JsonObject)new Gson().fromJson(packString, JsonObject.class);
                this.packName = object.getAsJsonPrimitive("name").getAsString();
                this.hasLoaded = true;
                if (gdDir.getName().contains("gdl")) {
                    this.type = LauncherType.GDLAUNCHER;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean hasLoaded() {
        return this.hasLoaded;
    }

    @Override
    public String getLauncherName() {
        return this.type == LauncherType.CURSEFORGE ? "CurseForge" : "GDLauncher";
    }

    @Override
    public String getPackName() {
        return this.packName;
    }

    @Override
    public String getPackIcon() {
        return this.type == LauncherType.CURSEFORGE ? "curseforge" : "gdlauncher";
    }
}

