/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.miscellaneous.bucket;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.item.AetherItems;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;

public class SkyrootBucketItem
extends BucketItem {
    public static final Map<Supplier<? extends Item>, Supplier<? extends Item>> REPLACEMENTS = new HashMap<Supplier<? extends Item>, Supplier<? extends Item>>();

    public SkyrootBucketItem(Supplier<? extends Fluid> supplier, Item.Properties properties) {
        super(supplier, properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        BlockHitResult blockhitResult;
        ItemStack heldStack = player.m_21120_(hand);
        InteractionResultHolder interactionResult = ForgeEventFactory.onBucketUse((Player)player, (Level)level, (ItemStack)heldStack, (HitResult)(blockhitResult = SkyrootBucketItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)(this.getFluid() == Fluids.f_76191_ ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE))));
        if (interactionResult != null) {
            return interactionResult;
        }
        if (blockhitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)heldStack);
        }
        if (blockhitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)heldStack);
        }
        BlockPos blockPos = blockhitResult.m_82425_();
        Direction direction = blockhitResult.m_82434_();
        BlockPos relativePos = blockPos.m_121945_(direction);
        if (level.m_7966_(player, blockPos) && player.m_36204_(relativePos, direction, heldStack)) {
            BlockPos newPos;
            if (this.getFluid() == Fluids.f_76191_) {
                BlockState blockState = level.m_8055_(blockPos);
                FluidState fluidState = level.m_6425_(blockPos);
                Block block = blockState.m_60734_();
                if (block instanceof BucketPickup) {
                    BucketPickup bucketPickup = (BucketPickup)block;
                    if (blockState.m_204336_(AetherTags.Blocks.ALLOWED_BUCKET_PICKUP) || fluidState.m_205070_(AetherTags.Fluids.ALLOWED_BUCKET_PICKUP)) {
                        ItemStack bucketStack = bucketPickup.m_142598_((LevelAccessor)level, blockPos, blockState);
                        if (!(bucketStack = SkyrootBucketItem.swapBucketType(bucketStack)).m_41619_()) {
                            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                            bucketPickup.getPickupSound(blockState).ifPresent(soundEvent -> player.m_5496_(soundEvent, 1.0f, 1.0f));
                            level.m_142346_((Entity)player, GameEvent.f_157816_, blockPos);
                            ItemStack resultStack = ItemUtils.m_41813_((ItemStack)heldStack, (Player)player, (ItemStack)bucketStack);
                            if (!level.m_5776_()) {
                                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, bucketStack);
                            }
                            return InteractionResultHolder.m_19092_((Object)resultStack, (boolean)level.m_5776_());
                        }
                    }
                }
                return InteractionResultHolder.m_19100_((Object)heldStack);
            }
            BlockState blockState = level.m_8055_(blockPos);
            BlockPos blockPos2 = newPos = this.canBlockContainFluid(level, blockPos, blockState) ? blockPos : relativePos;
            if (this.emptyContents(player, level, newPos, blockhitResult, heldStack)) {
                this.m_142131_(player, level, heldStack, newPos);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10591_.m_285767_(serverPlayer, newPos, heldStack);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19092_((Object)SkyrootBucketItem.m_40699_(heldStack, player), (boolean)level.m_5776_());
            }
            return InteractionResultHolder.m_19100_((Object)heldStack);
        }
        return InteractionResultHolder.m_19100_((Object)heldStack);
    }

    public static ItemStack swapBucketType(ItemStack filledStack) {
        Supplier<Item> filledItem = () -> ((ItemStack)filledStack).m_41720_();
        for (Map.Entry<Supplier<? extends Item>, Supplier<? extends Item>> entry : REPLACEMENTS.entrySet()) {
            if (filledItem.get() != entry.getKey().get()) continue;
            Item replacedItem = entry.getValue().get();
            ItemStack newStack = new ItemStack((ItemLike)replacedItem);
            newStack.m_41751_(filledStack.m_41783_());
            return newStack;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack m_40699_(ItemStack bucketStack, Player player) {
        return !player.m_150110_().f_35937_ ? new ItemStack((ItemLike)AetherItems.SKYROOT_BUCKET.get()) : bucketStack;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag tag) {
        return null;
    }

    public int getBurnTime(ItemStack itemStack, RecipeType<?> recipeType) {
        return 200;
    }

    protected boolean canBlockContainFluid(Level level, BlockPos pos, BlockState state) {
        LiquidBlockContainer liquidBlockContainer;
        Block block = state.m_60734_();
        return block instanceof LiquidBlockContainer && (liquidBlockContainer = (LiquidBlockContainer)block).m_6044_((BlockGetter)level, pos, state, this.getFluid());
    }
}

