/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.listeners.abilities;

import com.aetherteam.aether.event.hooks.AbilityHooks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="aether")
public class ToolAbilityListener {
    public static InteractionHand INTERACTION_HAND;

    @SubscribeEvent
    public static void setupToolModifications(BlockEvent.BlockToolModificationEvent event) {
        ToolAction toolAction;
        BlockState oldState;
        BlockPos pos;
        LevelAccessor levelAccessor = event.getLevel();
        BlockState newState = AbilityHooks.ToolHooks.setupToolActions(levelAccessor, pos = event.getPos(), oldState = event.getState(), toolAction = event.getToolAction());
        if (newState != oldState && !event.isSimulated() && !event.isCanceled()) {
            event.setFinalState(newState);
        }
    }

    @SubscribeEvent
    public static void doHolystoneAbility(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        Level level = player.m_9236_();
        BlockPos blockPos = event.getPos();
        ItemStack itemStack = player.m_21205_();
        BlockState blockState = event.getState();
        if (!event.isCanceled()) {
            AbilityHooks.ToolHooks.handleHolystoneToolAbility(player, level, blockPos, itemStack, blockState);
        }
    }

    @SubscribeEvent
    public static void modifyBreakSpeed(PlayerEvent.BreakSpeed event) {
        BlockState blockState = event.getState();
        Player player = event.getEntity();
        ItemStack itemStack = player.m_21205_();
        if (!event.isCanceled()) {
            event.setNewSpeed(AbilityHooks.ToolHooks.handleZaniteToolAbility(itemStack, event.getNewSpeed()));
            event.setNewSpeed(AbilityHooks.ToolHooks.reduceToolEffectiveness(player, blockState, itemStack, event.getNewSpeed()));
        }
    }

    @SubscribeEvent
    public static void doGoldenOakStripping(BlockEvent.BlockToolModificationEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        BlockState oldState = event.getState();
        ItemStack itemStack = event.getHeldItemStack();
        ToolAction toolAction = event.getToolAction();
        UseOnContext context = event.getContext();
        if (!event.isSimulated() && !event.isCanceled()) {
            AbilityHooks.ToolHooks.stripGoldenOak(levelAccessor, oldState, itemStack, toolAction, context);
        }
    }

    @SubscribeEvent
    public static void onEntityAttack(AttackEntityEvent event) {
        ToolAbilityListener.checkEntityTooFar((PlayerEvent)event, event.getTarget(), event.getEntity(), InteractionHand.MAIN_HAND);
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent event) {
        if (event instanceof PlayerInteractEvent.EntityInteractSpecific) {
            PlayerInteractEvent.EntityInteractSpecific entityInteractSpecific = (PlayerInteractEvent.EntityInteractSpecific)event;
            ToolAbilityListener.checkEntityTooFar((PlayerEvent)entityInteractSpecific, entityInteractSpecific.getTarget(), entityInteractSpecific.getEntity(), entityInteractSpecific.getHand());
        } else if (event instanceof PlayerInteractEvent.EntityInteract) {
            PlayerInteractEvent.EntityInteract entityInteract = (PlayerInteractEvent.EntityInteract)event;
            ToolAbilityListener.checkEntityTooFar((PlayerEvent)entityInteract, entityInteract.getTarget(), entityInteract.getEntity(), entityInteract.getHand());
        } else if (event instanceof PlayerInteractEvent.RightClickBlock) {
            PlayerInteractEvent.RightClickBlock rightClickBlock = (PlayerInteractEvent.RightClickBlock)event;
            ToolAbilityListener.checkBlockTooFar((PlayerEvent)event, rightClickBlock.getEntity(), rightClickBlock.getHand());
        } else if (event instanceof PlayerInteractEvent.LeftClickBlock) {
            PlayerInteractEvent.LeftClickBlock leftClickBlock = (PlayerInteractEvent.LeftClickBlock)event;
            ToolAbilityListener.checkBlockTooFar((PlayerEvent)event, leftClickBlock.getEntity(), leftClickBlock.getHand());
        } else if (event instanceof PlayerInteractEvent.RightClickItem) {
            PlayerInteractEvent.RightClickItem rightClickItem = (PlayerInteractEvent.RightClickItem)event;
            INTERACTION_HAND = rightClickItem.getHand();
        }
    }

    private static void checkEntityTooFar(PlayerEvent event, Entity target, Player player, InteractionHand hand) {
        if (!event.isCanceled() && AbilityHooks.ToolHooks.entityTooFar(target, player, hand)) {
            event.setCanceled(true);
        }
    }

    private static void checkBlockTooFar(PlayerEvent event, Player player, InteractionHand hand) {
        if (!event.isCanceled() && AbilityHooks.ToolHooks.blockTooFar(player, hand)) {
            event.setCanceled(true);
        }
    }
}

