/*
 * Decompiled with CFR 0.152.
 */
package net.kenddie.fantasyarmor.client.armor.render.lib;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.kenddie.fantasyarmor.client.armor.render.lib.FAArmorRenderer;
import net.kenddie.fantasyarmor.item.armor.FAArmorItem;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class DyeableGeoLayer<T extends FAArmorItem>
extends GeoRenderLayer<T> {
    protected static final Map<String, ResourceLocation> ARMOR_PATH_CACHE = new Object2ObjectOpenHashMap();

    public DyeableGeoLayer(FAArmorRenderer<T> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType baseRenderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        if (animatable == null) {
            return;
        }
        ResourceLocation textureResLoc = this.getArmorResource((FAArmorItem)((Object)animatable));
        FAArmorRenderer armorRenderer = (FAArmorRenderer)this.renderer;
        ItemStack armorItemStack = armorRenderer.getCurrentStack();
        if (!animatable.m_41113_(armorItemStack)) {
            return;
        }
        int color = animatable.m_41121_(armorItemStack);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        VertexConsumer vertexConsumer = this.getArmorBuffer(bufferSource, null, textureResLoc, armorItemStack.m_41790_());
        this.renderer.reRender(bakedModel, poseStack, bufferSource, animatable, baseRenderType, vertexConsumer, partialTick, packedLight, packedOverlay, r, g, b, 1.0f);
    }

    public ResourceLocation getArmorResource(FAArmorItem armorItem) {
        String texture = "fantasy_armor:" + armorItem.getArmorSet().getOverlayPath();
        return ARMOR_PATH_CACHE.computeIfAbsent(texture, ResourceLocation::new);
    }

    protected VertexConsumer getArmorBuffer(MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable ResourceLocation texturePath, boolean enchanted) {
        if (renderType == null) {
            renderType = RenderType.m_110431_((ResourceLocation)texturePath);
        }
        return ItemRenderer.m_115184_((MultiBufferSource)bufferSource, (RenderType)renderType, (boolean)false, (boolean)enchanted);
    }
}

