/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.core.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.apex.forge.apexcore.lib.util.RegistryHelper;

public abstract class ParticleProvider
implements DataProvider {
    public static final Logger LOGGER = LogManager.getLogger();
    protected static final ExistingFileHelper.ResourceType TEXTURE = new ExistingFileHelper.ResourceType(PackType.CLIENT_RESOURCES, ".png", "textures");
    protected final PackOutput output;
    protected final CompletableFuture<HolderLookup.Provider> registriesLookup;
    protected final ExistingFileHelper fileHelper;
    private final Map<ResourceLocation, ParticleDefinition> particleDefinitions = Maps.newHashMap();

    public ParticleProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registriesLookup, ExistingFileHelper fileHelper) {
        this.output = output;
        this.registriesLookup = registriesLookup;
        this.fileHelper = fileHelper;
    }

    public abstract void registerParticleDefs();

    public final CompletableFuture<?> m_213708_(CachedOutput cache) {
        return this.registriesLookup.thenCompose(provider -> {
            this.particleDefinitions.clear();
            this.registerParticleDefs();
            this.validateParticleDefs();
            Path dataPath = this.output.m_247566_(PackOutput.Target.RESOURCE_PACK);
            return CompletableFuture.allOf((CompletableFuture[])this.particleDefinitions.entrySet().stream().map(entry -> ParticleProvider.saveParticleDefinition(cache, (ResourceLocation)entry.getKey(), (ParticleDefinition)entry.getValue(), dataPath)).toArray(CompletableFuture[]::new));
        });
    }

    public String m_6055_() {
        return "Particles";
    }

    private void validateParticleDefs() {
        this.particleDefinitions.forEach((particleName, definition) -> {
            for (ResourceLocation texture : definition.textures) {
                ResourceLocation relativePath = new ResourceLocation(texture.m_135827_(), "particle/%s".formatted(texture.m_135815_()));
                Preconditions.checkArgument((boolean)this.fileHelper.exists(relativePath, (ExistingFileHelper.IResourceType)TEXTURE), (String)"Texture %s does not exist in any known resource pack", (Object)relativePath);
            }
        });
    }

    public static CompletableFuture<?> saveParticleDefinition(CachedOutput cache, ResourceLocation particleName, ParticleDefinition definition, Path dataPath) {
        Path particlePath = dataPath.resolve(Paths.get(particleName.m_135827_(), "particles", "%s.json".formatted(particleName.m_135815_())));
        JsonElement serialized = ParticleProvider.serializeParticleDefinition(definition);
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)serialized, (Path)particlePath);
    }

    private static JsonElement serializeParticleDefinition(ParticleDefinition definition) {
        JsonObject json = new JsonObject();
        JsonArray texturesJson = new JsonArray();
        definition.textures.stream().map(Object::toString).forEach(arg_0 -> ((JsonArray)texturesJson).add(arg_0));
        json.add("textures", (JsonElement)texturesJson);
        return json;
    }

    public ParticleDefinition definition(ParticleType<?> particleType) {
        ResourceLocation name = RegistryHelper.getRegistryName((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, particleType);
        return this.particleDefinitions.computeIfAbsent(name, $ -> new ParticleDefinition());
    }

    public final class ParticleDefinition {
        private final Set<ResourceLocation> textures = Sets.newHashSet();

        private ParticleDefinition() {
        }

        public ParticleDefinition texture(ParticleType<?> particleType) {
            ResourceLocation name = RegistryHelper.getRegistryName((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, particleType);
            return this.texture(name);
        }

        public ParticleDefinition texture(ResourceLocation texture) {
            this.textures.add(texture);
            return this;
        }

        public ParticleDefinition textures(ResourceLocation ... textures) {
            Collections.addAll(this.textures, textures);
            return this;
        }

        public ParticleDefinition texture(String namespace, String texturePath) {
            return this.texture(new ResourceLocation(namespace, texturePath));
        }
    }
}

