/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.core;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xyz.apex.forge.apexcore.lib.block.BaseBlock;
import xyz.apex.forge.apexcore.lib.block.BaseMultiBlock;
import xyz.apex.forge.apexcore.lib.block.VoxelShaper;
import xyz.apex.forge.apexcore.lib.block.WallLightBlock;
import xyz.apex.forge.fantasyfurniture.AllBlocks;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.BedDoubleBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.BedSingleBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.BenchBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.BookshelfBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.ChairBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.ChandelierBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.ChestBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.CounterBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.CushionBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.DeskBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.DrawerBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.DresserBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.FloorLightBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.FurnitureDoorBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.LockboxBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.OvenMultiBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.PaintingSmallBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.PaintingWideBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.ShelfBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.SofaBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.StoolBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.TableLargeBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.TableSmallBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.TableWideBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.WardrobeBottomBlock;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.WardrobeTopBlock;
import xyz.apex.forge.fantasyfurniture.core.HitBox;

public abstract class HitBoxes {
    public static final HitBoxes NORDIC = new Nordic();
    public static final HitBoxes DUNMER = new Dunmer();
    public static final HitBoxes VENTHYR = new Venthyr();
    public static final HitBoxes BONE = new Bone();
    public static final HitBoxes ROYAL = new Royal();
    public static final HitBoxes NECROLORD = new Necrolord();
    private final HitBox.WithShaper bedDouble = new HitBox.WithShaper(this::bedDoubleShape, Direction.NORTH);
    private final HitBox.WithShaper bedSingle = new HitBox.WithShaper(this::bedSingleShape, Direction.NORTH);
    private final HitBox.WithShaper bench = new HitBox.WithShaper(this::benchShape, Direction.NORTH);
    private final HitBox.WithShaper bookshelf = new HitBox.WithShaper(this::bookshelfShape, Direction.NORTH);
    private final HitBox.WithShaper chair = new HitBox.WithShaper(this::chairShape, Direction.NORTH);
    private final HitBox chandelier = new HitBox(this::chandelierShape);
    private final HitBox.WithShaper chest = new HitBox.WithShaper(this::chestShape, Direction.NORTH);
    private final HitBox.WithShaper cushion = new HitBox.WithShaper(this::cushionShape, Direction.NORTH);
    private final HitBox.WithShaper deskLeft = new HitBox.WithShaper(this::deskLeftShape, Direction.NORTH);
    private final HitBox.WithShaper deskRight = new HitBox.WithShaper(this::deskRightShape, Direction.NORTH);
    private final HitBox.WithShaper drawer = new HitBox.WithShaper(this::drawerShape, Direction.NORTH);
    private final HitBox.WithShaper dresser = new HitBox.WithShaper(this::dresserShape, Direction.NORTH);
    private final HitBox.WithShaper lockbox = new HitBox.WithShaper(this::lockboxShape, Direction.NORTH);
    private final HitBox.WithShaper floorLight = new HitBox.WithShaper(this::floorLightShape, Direction.NORTH);
    private final HitBox.WithShaper paintingSmall = new HitBox.WithShaper(this::paintingSmallShape, Direction.NORTH);
    private final HitBox.WithShaper paintingWide = new HitBox.WithShaper(this::paintingWideShape, Direction.NORTH);
    private final HitBox.WithShaper shelfSingle = new HitBox.WithShaper(this::shelfSingleShape, Direction.NORTH);
    private final HitBox.WithShaper shelfCenter = new HitBox.WithShaper(this::shelfCenterShape, Direction.NORTH);
    private final HitBox.WithShaper shelfLeft = new HitBox.WithShaper(this::shelfLeftShape, Direction.NORTH);
    private final HitBox.WithShaper shelfRight = new HitBox.WithShaper(this::shelfRightShape, Direction.NORTH);
    private final HitBox.WithShaper sofaSingle = new HitBox.WithShaper(this::sofaSingleShape, Direction.NORTH);
    private final HitBox.WithShaper sofaCenter = new HitBox.WithShaper(this::sofaCenterShape, Direction.NORTH);
    private final HitBox.WithShaper sofaLeft = new HitBox.WithShaper(this::sofaLeftShape, Direction.NORTH);
    private final HitBox.WithShaper sofaRight = new HitBox.WithShaper(this::sofaRightShape, Direction.NORTH);
    private final HitBox.WithShaper sofaCorner = new HitBox.WithShaper(this::sofaCornerShape, Direction.NORTH);
    private final HitBox.WithShaper stool = new HitBox.WithShaper(this::stoolShape, Direction.NORTH);
    private final HitBox.WithShaper tableLarge = new HitBox.WithShaper(this::tableLargeShape, Direction.NORTH);
    private final HitBox.WithShaper tableSmall = new HitBox.WithShaper(this::tableSmallShape, Direction.NORTH);
    private final HitBox.WithShaper tableWide = new HitBox.WithShaper(this::tableWideShape, Direction.NORTH);
    private final HitBox.WithShaper wallLight = new HitBox.WithShaper(this::wallLightShape, Direction.NORTH);
    private final HitBox.WithShaper wardrobeTop = new HitBox.WithShaper(this::wardrobeTopShape, Direction.NORTH);
    private final HitBox.WithShaper wardrobeBottom = new HitBox.WithShaper(this::wardrobeBottomShape, Direction.NORTH);
    private final HitBox.WithShaper doorDouble = new HitBox.WithShaper(this::doorDoubleShape, Direction.NORTH);
    private final HitBox.WithShaper doorSingle = new HitBox.WithShaper(this::doorSingleShape, Direction.NORTH);
    private final HitBox.WithShaper counterSingle = new HitBox.WithShaper(this::counterSingleShape, Direction.NORTH);
    private final HitBox.WithShaper counterCorner = new HitBox.WithShaper(this::counterCornerShape, Direction.NORTH);
    private final HitBox.WithShaper oven = new HitBox.WithShaper(this::ovenShape, Direction.NORTH);

    public final VoxelShape bedDouble(BedDoubleBlock block, BlockState blockState) {
        Direction facing = BaseBlock.getFacing((BlockState)blockState);
        VoxelShape shape = this.bedDouble.get(blockState);
        int index = block.getMultiBlockIndex(blockState);
        if (index == 1 || index == 3) {
            Direction other = facing.m_122427_();
            shape = shape.m_83216_((double)other.m_122429_(), 0.0, (double)other.m_122431_());
        }
        if (index == 2 || index == 3) {
            shape = shape.m_83216_((double)facing.m_122429_(), 0.0, (double)facing.m_122431_());
        }
        return shape;
    }

    public final VoxelShape bedSingle(BedSingleBlock block, BlockState blockState) {
        VoxelShape shape = this.bedSingle.get(blockState);
        if (!block.isMultiBlockOrigin(blockState)) {
            Direction facing = BaseBlock.getFacing((BlockState)blockState);
            shape = shape.m_83216_((double)facing.m_122429_(), 0.0, (double)facing.m_122431_());
        }
        return shape;
    }

    public final VoxelShape bench(BenchBlock block, BlockState blockState) {
        VoxelShape shape = this.bench.get(blockState);
        if (!block.isMultiBlockOrigin(blockState)) {
            Direction other = BaseBlock.getFacing((BlockState)blockState).m_122427_();
            shape = shape.m_83216_((double)other.m_122429_(), 0.0, (double)other.m_122431_());
        }
        return shape;
    }

    public final VoxelShape bookshelf(BookshelfBlock block, BlockState blockState) {
        Direction facing = BaseBlock.getFacing((BlockState)blockState);
        VoxelShape shape = this.bookshelf.get(blockState);
        int index = block.getMultiBlockIndex(blockState);
        if (index == 1 || index == 3) {
            Direction other = facing.m_122427_();
            shape = shape.m_83216_((double)other.m_122429_(), 0.0, (double)other.m_122431_());
        }
        if (index == 2 || index == 3) {
            shape = shape.m_83216_(0.0, -1.0, 0.0);
        }
        return shape;
    }

    public final VoxelShape chair(ChairBlock block, BlockState blockState) {
        VoxelShape shape = this.chair.get(blockState);
        if (!block.isMultiBlockOrigin(blockState)) {
            shape = shape.m_83216_(0.0, -1.0, 0.0);
        }
        return shape;
    }

    public final VoxelShape chandelier(ChandelierBlock block, BlockState blockState) {
        return this.chandelier.get(blockState);
    }

    public final VoxelShape chest(ChestBlock block, BlockState blockState) {
        VoxelShape shape = this.chest.get(blockState);
        if (!block.isMultiBlockOrigin(blockState)) {
            Direction other = BaseBlock.getFacing((BlockState)blockState).m_122427_();
            shape = shape.m_83216_((double)other.m_122429_(), 0.0, (double)other.m_122431_());
        }
        return shape;
    }

    public final VoxelShape cushion(CushionBlock block, BlockState blockState) {
        return this.cushion.get(blockState);
    }

    public final VoxelShape deskLeft(DeskBlock block, BlockState blockState) {
        VoxelShape shape = this.deskLeft.get(blockState);
        if (!block.isMultiBlockOrigin(blockState)) {
            Direction other = BaseBlock.getFacing((BlockState)blockState).m_122427_();
            shape = shape.m_83216_((double)other.m_122429_(), 0.0, (double)other.m_122431_());
        }
        return shape;
    }

    public final VoxelShape deskRight(DeskBlock block, BlockState blockState) {
        VoxelShape shape = this.deskRight.get(blockState);
        if (!block.isMultiBlockOrigin(blockState)) {
            Direction other = BaseBlock.getFacing((BlockState)blockState).m_122427_();
            shape = shape.m_83216_((double)other.m_122429_(), 0.0, (double)other.m_122431_());
        }
        return shape;
    }

    public final VoxelShape drawer(DrawerBlock block, BlockState blockState) {
        return this.drawer.get(blockState);
    }

    public final VoxelShape dresser(DresserBlock block, BlockState blockState) {
        VoxelShape shape = this.dresser.get(blockState);
        if (!block.isMultiBlockOrigin(blockState)) {
            Direction other = BaseBlock.getFacing((BlockState)blockState).m_122427_();
            shape = shape.m_83216_((double)other.m_122429_(), 0.0, (double)other.m_122431_());
        }
        return shape;
    }

    public final VoxelShape lockbox(LockboxBlock block, BlockState blockState) {
        return this.lockbox.get(blockState);
    }

    public final VoxelShape floorLight(FloorLightBlock block, BlockState blockState) {
        VoxelShape shape = this.floorLight.get(blockState);
        return block.isMultiBlockOrigin(blockState) ? shape : shape.m_83216_(0.0, -1.0, 0.0);
    }

    public final VoxelShape paintingSmall(PaintingSmallBlock block, BlockState blockState) {
        return this.paintingSmall.get(blockState);
    }

    public final VoxelShape paintingWide(PaintingWideBlock block, BlockState blockState) {
        VoxelShape shape = this.paintingWide.get(blockState);
        if (!block.isMultiBlockOrigin(blockState)) {
            Direction other = BaseBlock.getFacing((BlockState)blockState).m_122427_();
            shape = shape.m_83216_((double)other.m_122429_(), 0.0, (double)other.m_122431_());
        }
        return shape;
    }

    public final VoxelShape shelf(ShelfBlock block, BlockState blockState) {
        Direction facing = BaseBlock.getFacing((BlockState)blockState);
        ShelfBlock.Connection connection = blockState.m_61145_(ShelfBlock.CONNECTION).orElse(ShelfBlock.Connection.SINGLE);
        VoxelShaper shaper = switch (connection) {
            default -> throw new IncompatibleClassChangeError();
            case ShelfBlock.Connection.SINGLE -> this.shelfSingle.shaper();
            case ShelfBlock.Connection.LEFT -> this.shelfLeft.shaper();
            case ShelfBlock.Connection.CENTER -> this.shelfCenter.shaper();
            case ShelfBlock.Connection.RIGHT -> this.shelfRight.shaper();
        };
        return shaper.get(facing);
    }

    public final VoxelShape sofa(SofaBlock block, BlockState blockState) {
        Direction facing = BaseBlock.getFacing((BlockState)blockState);
        SofaBlock.Connection connection = blockState.m_61145_(SofaBlock.CONNECTION).orElse(SofaBlock.Connection.SINGLE);
        VoxelShaper shaper = switch (connection) {
            default -> throw new IncompatibleClassChangeError();
            case SofaBlock.Connection.SINGLE -> this.sofaSingle.shaper();
            case SofaBlock.Connection.LEFT -> this.sofaLeft.shaper();
            case SofaBlock.Connection.CENTER -> this.sofaCenter.shaper();
            case SofaBlock.Connection.RIGHT -> this.sofaRight.shaper();
            case SofaBlock.Connection.CORNER -> this.sofaCorner.shaper();
        };
        return shaper.get(facing);
    }

    public final VoxelShape stool(StoolBlock block, BlockState blockState) {
        return this.stool.get(blockState);
    }

    public final VoxelShape tableLarge(TableLargeBlock block, BlockState blockState) {
        Direction facing = BaseBlock.getFacing((BlockState)blockState);
        VoxelShape shape = this.tableLarge.get(blockState);
        int index = block.getMultiBlockIndex(blockState);
        if (index == 1 || index == 3) {
            Direction other = facing.m_122427_();
            shape = shape.m_83216_((double)other.m_122429_(), 0.0, (double)other.m_122431_());
        }
        if (index == 2 || index == 3) {
            shape = shape.m_83216_((double)facing.m_122429_(), 0.0, (double)facing.m_122431_());
        }
        return shape;
    }

    public final VoxelShape tableSmall(TableSmallBlock block, BlockState blockState) {
        return this.tableSmall.get(blockState);
    }

    public final VoxelShape tableWide(TableWideBlock block, BlockState blockState) {
        VoxelShape shape = this.tableWide.get(blockState);
        if (!block.isMultiBlockOrigin(blockState)) {
            Direction opposite = BaseBlock.getFacing((BlockState)blockState).m_122427_();
            shape = shape.m_83216_((double)opposite.m_122429_(), 0.0, (double)opposite.m_122431_());
        }
        return shape;
    }

    public final VoxelShape wallLight(WallLightBlock block, BlockState blockState) {
        return this.wallLight.get(blockState);
    }

    public final VoxelShape wardrobeTop(WardrobeTopBlock block, BlockState blockState) {
        VoxelShape shape = this.wardrobeTop.get(blockState);
        if (!block.isMultiBlockOrigin(blockState)) {
            Direction other = BaseBlock.getFacing((BlockState)blockState).m_122427_();
            shape = shape.m_83216_((double)other.m_122429_(), 0.0, (double)other.m_122431_());
        }
        return shape;
    }

    public final VoxelShape wardrobeBottom(WardrobeBottomBlock block, BlockState blockState) {
        VoxelShape shape = this.wardrobeBottom.get(blockState);
        int index = block.getMultiBlockIndex(blockState);
        if (index == 1 || index == 3) {
            Direction other = BaseBlock.getFacing((BlockState)blockState).m_122427_();
            shape = shape.m_83216_((double)other.m_122429_(), 0.0, (double)other.m_122431_());
        }
        if (index == 2 || index == 3) {
            shape = shape.m_83216_(0.0, -1.0, 0.0);
        }
        return shape;
    }

    public final VoxelShape doorDouble(FurnitureDoorBlock block, BlockState blockState) {
        Direction facing = blockState.m_61145_((Property)FurnitureDoorBlock.f_52726_).orElse(Direction.NORTH);
        Boolean open = blockState.m_61145_((Property)FurnitureDoorBlock.f_52727_).orElse(false);
        DoubleBlockHalf half = blockState.m_61145_((Property)FurnitureDoorBlock.f_52730_).orElse(DoubleBlockHalf.LOWER);
        DoorHingeSide hinge = blockState.m_61145_((Property)FurnitureDoorBlock.f_52728_).orElse(DoorHingeSide.LEFT);
        Direction shapeFacing = hinge == DoorHingeSide.LEFT ? (open != false ? facing.m_122427_() : facing.m_122424_()) : (open != false ? facing.m_122427_() : facing);
        VoxelShape shape = this.doorDouble.shaper().get(shapeFacing);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (half == DoubleBlockHalf.UPPER) {
            y -= 1.0;
        }
        if (hinge == DoorHingeSide.LEFT && open.booleanValue() || hinge == DoorHingeSide.RIGHT && !open.booleanValue()) {
            x -= (double)shapeFacing.m_122429_() * 0.81;
            z -= (double)shapeFacing.m_122431_() * 0.81;
        }
        if (AllBlocks.DUNMER_DOOR_DOUBLE.isIn(blockState) && (hinge == DoorHingeSide.LEFT && open.booleanValue() || hinge == DoorHingeSide.RIGHT && !open.booleanValue())) {
            x -= (double)shapeFacing.m_122429_() * 0.065;
            z -= (double)shapeFacing.m_122431_() * 0.065;
        }
        return shape.m_83216_(x, y, z);
    }

    public final VoxelShape doorSingle(FurnitureDoorBlock block, BlockState blockState) {
        Direction facing = blockState.m_61145_((Property)FurnitureDoorBlock.f_52726_).orElse(Direction.NORTH);
        Boolean open = blockState.m_61145_((Property)FurnitureDoorBlock.f_52727_).orElse(false);
        DoubleBlockHalf half = blockState.m_61145_((Property)FurnitureDoorBlock.f_52730_).orElse(DoubleBlockHalf.LOWER);
        DoorHingeSide hinge = blockState.m_61145_((Property)FurnitureDoorBlock.f_52728_).orElse(DoorHingeSide.LEFT);
        Direction shapeFacing = hinge == DoorHingeSide.LEFT ? (open != false ? facing.m_122427_() : facing.m_122424_()) : (open != false ? facing.m_122427_() : facing);
        VoxelShape shape = this.doorSingle.shaper().get(shapeFacing);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (half == DoubleBlockHalf.UPPER) {
            y -= 1.0;
        }
        if (hinge == DoorHingeSide.LEFT && open.booleanValue() || hinge == DoorHingeSide.RIGHT && !open.booleanValue()) {
            x -= (double)shapeFacing.m_122429_() * 0.81;
            z -= (double)shapeFacing.m_122431_() * 0.81;
        }
        if (AllBlocks.DUNMER_DOOR_SINGLE.isIn(blockState) && (hinge == DoorHingeSide.LEFT && open.booleanValue() || hinge == DoorHingeSide.RIGHT && !open.booleanValue())) {
            x -= (double)shapeFacing.m_122429_() * 0.065;
            z -= (double)shapeFacing.m_122431_() * 0.065;
        }
        return shape.m_83216_(x, y, z);
    }

    public final VoxelShape counter(CounterBlock block, BlockState blockState) {
        Direction facing = BaseBlock.getFacing((BlockState)blockState);
        CounterBlock.Connection connection = blockState.m_61145_(CounterBlock.CONNECTION).orElse(CounterBlock.Connection.SINGLE);
        VoxelShaper shaper = switch (connection) {
            default -> throw new IncompatibleClassChangeError();
            case CounterBlock.Connection.SINGLE -> this.counterSingle.shaper();
            case CounterBlock.Connection.CORNER -> this.counterCorner.shaper();
        };
        return shaper.get(facing);
    }

    public final VoxelShape oven(Block block, BlockState blockState) {
        OvenMultiBlock multiBlock;
        VoxelShape shape = this.oven.get(blockState);
        if (block instanceof OvenMultiBlock && !(multiBlock = (OvenMultiBlock)block).isMultiBlockOrigin(blockState)) {
            Direction facing = BaseMultiBlock.getFacing((BlockState)blockState).m_122427_();
            int offX = facing.m_122429_();
            int offZ = facing.m_122431_();
            shape = shape.m_83216_((double)offX, 0.0, (double)offZ);
        }
        return shape;
    }

    protected abstract VoxelShape bedDoubleShape();

    protected abstract VoxelShape bedSingleShape();

    protected abstract VoxelShape benchShape();

    protected abstract VoxelShape bookshelfShape();

    protected abstract VoxelShape chairShape();

    protected abstract VoxelShape chandelierShape();

    protected abstract VoxelShape chestShape();

    protected abstract VoxelShape cushionShape();

    protected abstract VoxelShape deskLeftShape();

    protected abstract VoxelShape deskRightShape();

    protected abstract VoxelShape drawerShape();

    protected abstract VoxelShape dresserShape();

    protected abstract VoxelShape lockboxShape();

    protected abstract VoxelShape floorLightShape();

    protected abstract VoxelShape paintingSmallShape();

    protected abstract VoxelShape paintingWideShape();

    protected abstract VoxelShape shelfSingleShape();

    protected abstract VoxelShape shelfCenterShape();

    protected abstract VoxelShape shelfLeftShape();

    protected abstract VoxelShape shelfRightShape();

    protected abstract VoxelShape sofaSingleShape();

    protected abstract VoxelShape sofaCenterShape();

    protected abstract VoxelShape sofaLeftShape();

    protected abstract VoxelShape sofaRightShape();

    protected abstract VoxelShape sofaCornerShape();

    protected abstract VoxelShape stoolShape();

    protected abstract VoxelShape tableLargeShape();

    protected abstract VoxelShape tableSmallShape();

    protected abstract VoxelShape tableWideShape();

    protected abstract VoxelShape wallLightShape();

    protected abstract VoxelShape wardrobeTopShape();

    protected abstract VoxelShape wardrobeBottomShape();

    protected abstract VoxelShape doorDoubleShape();

    protected abstract VoxelShape doorSingleShape();

    protected abstract VoxelShape counterSingleShape();

    protected abstract VoxelShape counterCornerShape();

    protected abstract VoxelShape ovenShape();

    private static final class Nordic
    extends HitBoxes {
        private Nordic() {
        }

        @Override
        protected VoxelShape bedDoubleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-16.0, (double)3.0, (double)2.0, (double)16.0, (double)5.0, (double)30.0), Block.m_49796_((double)-14.0, (double)5.0, (double)2.0, (double)14.0, (double)8.0, (double)30.0), Block.m_49796_((double)-16.0, (double)3.0, (double)0.0, (double)16.0, (double)5.0, (double)2.0), Block.m_49796_((double)-16.0, (double)0.0, (double)0.0, (double)-14.0, (double)8.0, (double)2.0), Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)2.0), Block.m_49796_((double)-16.0, (double)12.0, (double)0.0, (double)-8.0, (double)14.0, (double)2.0), Block.m_49796_((double)8.0, (double)12.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0), Block.m_49796_((double)-10.0, (double)12.0, (double)0.0, (double)10.0, (double)16.0, (double)2.0), Block.m_49796_((double)-15.0, (double)5.0, (double)0.0, (double)15.0, (double)12.0, (double)2.0), Block.m_49796_((double)-15.0, (double)5.0, (double)30.0, (double)15.0, (double)12.0, (double)32.0), Block.m_49796_((double)-16.0, (double)3.0, (double)30.0, (double)16.0, (double)5.0, (double)32.0), Block.m_49796_((double)-16.0, (double)0.0, (double)30.0, (double)-14.0, (double)8.0, (double)32.0), Block.m_49796_((double)14.0, (double)0.0, (double)30.0, (double)16.0, (double)8.0, (double)32.0), Block.m_49796_((double)-16.0, (double)12.0, (double)30.0, (double)-8.0, (double)14.0, (double)32.0), Block.m_49796_((double)8.0, (double)12.0, (double)30.0, (double)16.0, (double)14.0, (double)32.0), Block.m_49796_((double)-10.0, (double)12.0, (double)30.0, (double)10.0, (double)16.0, (double)32.0)});
        }

        @Override
        protected VoxelShape bedSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0), Block.m_49796_((double)0.0, (double)0.0, (double)30.0, (double)16.0, (double)14.0, (double)32.0), Block.m_49796_((double)0.0, (double)3.0, (double)2.0, (double)16.0, (double)5.0, (double)30.0), Block.m_49796_((double)1.0, (double)5.0, (double)2.0, (double)15.0, (double)8.0, (double)30.0)});
        }

        @Override
        protected VoxelShape benchShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)4.0), Block.m_49796_((double)-14.0, (double)0.0, (double)2.0, (double)-12.0, (double)3.0, (double)4.0), Block.m_49796_((double)-14.0, (double)0.0, (double)12.0, (double)-12.0, (double)3.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)3.0, (double)14.0), Block.m_49796_((double)12.0, (double)3.0, (double)11.5, (double)14.0, (double)5.0, (double)13.5), Block.m_49796_((double)12.0, (double)3.0, (double)2.5, (double)14.0, (double)5.0, (double)4.5), Block.m_49796_((double)-14.0, (double)3.0, (double)2.5, (double)-12.0, (double)5.0, (double)4.5), Block.m_49796_((double)-14.0, (double)3.0, (double)11.5, (double)-12.0, (double)5.0, (double)13.5), Block.m_49796_((double)-13.5, (double)3.5, (double)4.5, (double)-12.5, (double)4.5, (double)11.5), Block.m_49796_((double)12.5, (double)3.5, (double)4.5, (double)13.5, (double)4.5, (double)11.5), Block.m_49796_((double)-15.0, (double)5.0, (double)2.0, (double)15.0, (double)7.0, (double)14.0)});
        }

        @Override
        protected VoxelShape bookshelfShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)15.0, (double)30.0, (double)15.0), Block.m_49796_((double)-16.0, (double)30.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0)});
        }

        @Override
        protected VoxelShape chairShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)4.0, (double)4.0), Block.m_49796_((double)2.5, (double)4.5, (double)4.5, (double)3.5, (double)5.5, (double)11.5), Block.m_49796_((double)12.5, (double)4.5, (double)4.5, (double)13.5, (double)5.5, (double)11.5), Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)4.0), Block.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)4.0, (double)14.0), Block.m_49796_((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), Block.m_49796_((double)2.0, (double)9.0, (double)13.0, (double)14.0, (double)25.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)4.0, (double)14.0), Block.m_49796_((double)2.0, (double)4.0, (double)11.5, (double)4.0, (double)7.0, (double)13.5), Block.m_49796_((double)12.0, (double)4.0, (double)11.5, (double)14.0, (double)7.0, (double)13.5), Block.m_49796_((double)2.0, (double)4.0, (double)2.5, (double)4.0, (double)7.0, (double)4.5), Block.m_49796_((double)12.0, (double)4.0, (double)2.5, (double)14.0, (double)7.0, (double)4.5)});
        }

        @Override
        protected VoxelShape chandelierShape() {
            return Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        }

        @Override
        protected VoxelShape chestShape() {
            return Block.m_49796_((double)-15.0, (double)0.0, (double)2.0, (double)15.0, (double)14.0, (double)16.0);
        }

        @Override
        protected VoxelShape cushionShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)2.0, (double)4.0), Block.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)2.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)4.0), Block.m_49796_((double)2.0, (double)5.0, (double)2.25, (double)14.0, (double)7.0, (double)13.75), Block.m_49796_((double)1.75, (double)4.0, (double)2.0, (double)14.25, (double)5.0, (double)14.0), Block.m_49796_((double)2.0, (double)2.0, (double)2.5, (double)4.0, (double)4.0, (double)4.5), Block.m_49796_((double)12.0, (double)2.0, (double)2.5, (double)14.0, (double)4.0, (double)4.5), Block.m_49796_((double)12.0, (double)2.0, (double)11.5, (double)14.0, (double)4.0, (double)13.5), Block.m_49796_((double)2.0, (double)2.0, (double)11.5, (double)4.0, (double)4.0, (double)13.5), Block.m_49796_((double)2.5, (double)2.5, (double)4.5, (double)3.5, (double)3.5, (double)11.5), Block.m_49796_((double)12.5, (double)2.5, (double)4.5, (double)13.5, (double)3.5, (double)11.5)});
        }

        @Override
        protected VoxelShape deskLeftShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)15.0, (double)9.0, (double)2.0), Block.m_49796_((double)13.0, (double)7.0, (double)1.0, (double)15.0, (double)13.0, (double)3.0), Block.m_49796_((double)13.0, (double)7.0, (double)13.0, (double)15.0, (double)13.0, (double)15.0), Block.m_49796_((double)-15.0, (double)7.0, (double)13.0, (double)-13.0, (double)13.0, (double)15.0), Block.m_49796_((double)-15.0, (double)0.0, (double)0.0, (double)-13.0, (double)9.0, (double)2.0), Block.m_49796_((double)-15.0, (double)0.0, (double)14.0, (double)-13.0, (double)9.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)14.0, (double)15.0, (double)9.0, (double)16.0), Block.m_49796_((double)-16.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)-15.0, (double)7.0, (double)1.0, (double)-13.0, (double)13.0, (double)3.0), Block.m_49796_((double)5.0, (double)9.0, (double)2.0, (double)12.0, (double)13.0, (double)11.0)});
        }

        @Override
        protected VoxelShape deskRightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)15.0, (double)9.0, (double)2.0), Block.m_49796_((double)13.0, (double)7.0, (double)1.0, (double)15.0, (double)13.0, (double)3.0), Block.m_49796_((double)13.0, (double)7.0, (double)13.0, (double)15.0, (double)13.0, (double)15.0), Block.m_49796_((double)-15.0, (double)7.0, (double)13.0, (double)-13.0, (double)13.0, (double)15.0), Block.m_49796_((double)-15.0, (double)0.0, (double)0.0, (double)-13.0, (double)9.0, (double)2.0), Block.m_49796_((double)-15.0, (double)0.0, (double)14.0, (double)-13.0, (double)9.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)14.0, (double)15.0, (double)9.0, (double)16.0), Block.m_49796_((double)-16.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)-15.0, (double)7.0, (double)1.0, (double)-13.0, (double)13.0, (double)3.0), Block.m_49796_((double)-12.0, (double)9.0, (double)2.0, (double)-5.0, (double)13.0, (double)11.0)});
        }

        @Override
        protected VoxelShape drawerShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0), Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape dresserShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.m_49796_((double)-16.0, (double)13.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)-16.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0)});
        }

        @Override
        protected VoxelShape lockboxShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)9.0, (double)13.0), Block.m_49796_((double)2.0, (double)9.0, (double)5.0, (double)14.0, (double)10.0, (double)11.0)});
        }

        @Override
        protected VoxelShape floorLightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0), Block.m_49796_((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)20.0, (double)9.0), Block.m_49796_((double)6.5, (double)20.75, (double)2.5, (double)9.5, (double)22.75, (double)5.5), Block.m_49796_((double)2.5, (double)20.75, (double)6.5, (double)5.5, (double)22.75, (double)9.5), Block.m_49796_((double)7.25, (double)22.75, (double)3.25, (double)8.75, (double)26.75, (double)4.75), Block.m_49796_((double)3.25, (double)22.75, (double)7.25, (double)4.75, (double)26.75, (double)8.75), Block.m_49796_((double)7.25, (double)22.75, (double)11.25, (double)8.75, (double)26.75, (double)12.75), Block.m_49796_((double)11.25, (double)22.75, (double)7.25, (double)12.75, (double)26.75, (double)8.75), Block.m_49796_((double)10.5, (double)20.75, (double)6.5, (double)13.5, (double)22.75, (double)9.5), Block.m_49796_((double)6.5, (double)20.75, (double)10.5, (double)9.5, (double)22.75, (double)13.5), Block.m_49796_((double)3.0, (double)16.75, (double)7.0, (double)7.0, (double)20.75, (double)9.0), Block.m_49796_((double)9.0, (double)16.75, (double)7.0, (double)13.0, (double)20.75, (double)9.0), Block.m_49796_((double)7.0, (double)16.75, (double)3.0, (double)9.0, (double)20.75, (double)7.0), Block.m_49796_((double)7.0, (double)16.75, (double)9.0, (double)9.0, (double)20.75, (double)13.0)});
        }

        @Override
        protected VoxelShape paintingSmallShape() {
            return Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
        }

        @Override
        protected VoxelShape paintingWideShape() {
            return Block.m_49796_((double)-16.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
        }

        @Override
        protected VoxelShape shelfSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.5, (double)9.0, (double)2.0, (double)2.5, (double)14.0, (double)13.0), Block.m_49796_((double)13.5, (double)9.0, (double)2.0, (double)15.5, (double)14.0, (double)13.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)6.0, (double)13.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)6.0, (double)13.0, (double)3.0, (double)14.0, (double)16.0)});
        }

        @Override
        protected VoxelShape shelfCenterShape() {
            return Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }

        @Override
        protected VoxelShape shelfLeftShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)13.5, (double)9.0, (double)2.0, (double)15.5, (double)14.0, (double)13.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)6.0, (double)13.0, (double)16.0, (double)14.0, (double)16.0)});
        }

        @Override
        protected VoxelShape shelfRightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.5, (double)9.0, (double)2.0, (double)2.5, (double)14.0, (double)13.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)6.0, (double)13.0, (double)3.0, (double)14.0, (double)16.0)});
        }

        @Override
        protected VoxelShape sofaSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)3.0, (double)3.0), Block.m_49796_((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)3.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)3.0), Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)6.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)14.0, (double)10.0, (double)0.0, (double)16.0, (double)12.0, (double)14.0), Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)2.0, (double)12.0, (double)14.0), Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)2.0, (double)10.0, (double)2.0), Block.m_49796_((double)14.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)2.0)});
        }

        @Override
        protected VoxelShape sofaCenterShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)6.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape sofaLeftShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)6.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)14.0, (double)10.0, (double)0.0, (double)16.0, (double)12.0, (double)13.0), Block.m_49796_((double)14.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)2.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)3.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)3.0, (double)15.0)});
        }

        @Override
        protected VoxelShape sofaRightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)6.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)2.0, (double)12.0, (double)13.0), Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)2.0, (double)10.0, (double)2.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)3.0, (double)3.0), Block.m_49796_((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)15.0)});
        }

        @Override
        protected VoxelShape sofaCornerShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)3.0, (double)3.0), Block.m_49796_((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)3.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)3.0), Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)6.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)6.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0)});
        }

        @Override
        protected VoxelShape stoolShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)3.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)3.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)4.0), Block.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)3.0, (double)14.0), Block.m_49796_((double)2.0, (double)3.0, (double)11.5, (double)4.0, (double)5.0, (double)13.5), Block.m_49796_((double)12.0, (double)3.0, (double)11.5, (double)14.0, (double)5.0, (double)13.5), Block.m_49796_((double)12.0, (double)3.0, (double)2.5, (double)14.0, (double)5.0, (double)4.5), Block.m_49796_((double)1.5, (double)5.0, (double)1.75, (double)14.5, (double)7.0, (double)14.25), Block.m_49796_((double)2.0, (double)3.0, (double)2.5, (double)4.0, (double)5.0, (double)4.5), Block.m_49796_((double)2.5, (double)3.5, (double)4.5, (double)3.5, (double)4.5, (double)11.5), Block.m_49796_((double)12.5, (double)3.5, (double)4.5, (double)13.5, (double)4.5, (double)11.5)});
        }

        @Override
        protected VoxelShape tableLargeShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)4.0), Block.m_49796_((double)-14.0, (double)0.0, (double)2.0, (double)-12.0, (double)13.0, (double)4.0), Block.m_49796_((double)-14.0, (double)0.0, (double)28.0, (double)-12.0, (double)13.0, (double)30.0), Block.m_49796_((double)12.0, (double)0.0, (double)28.0, (double)14.0, (double)13.0, (double)30.0), Block.m_49796_((double)-16.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)32.0)});
        }

        @Override
        protected VoxelShape tableSmallShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)13.0, (double)3.0), Block.m_49796_((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)13.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)13.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)13.0, (double)3.0), Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape tableWideShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)15.0, (double)9.0, (double)2.0), Block.m_49796_((double)13.0, (double)7.0, (double)1.0, (double)15.0, (double)13.0, (double)3.0), Block.m_49796_((double)13.0, (double)7.0, (double)13.0, (double)15.0, (double)13.0, (double)15.0), Block.m_49796_((double)-15.0, (double)7.0, (double)13.0, (double)-13.0, (double)13.0, (double)15.0), Block.m_49796_((double)-15.0, (double)0.0, (double)0.0, (double)-13.0, (double)9.0, (double)2.0), Block.m_49796_((double)-15.0, (double)0.0, (double)14.0, (double)-13.0, (double)9.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)14.0, (double)15.0, (double)9.0, (double)16.0), Block.m_49796_((double)-16.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)-15.0, (double)7.0, (double)1.0, (double)-13.0, (double)13.0, (double)3.0)});
        }

        @Override
        protected VoxelShape wallLightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)5.0, (double)15.0, (double)10.0, (double)11.0, (double)16.0), Block.m_49796_((double)6.0, (double)2.0, (double)8.0, (double)10.0, (double)15.0, (double)15.0)});
        }

        @Override
        protected VoxelShape wardrobeTopShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-15.0, (double)3.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0), Block.m_49796_((double)-16.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0)});
        }

        @Override
        protected VoxelShape wardrobeBottomShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-14.75, (double)0.0, (double)0.25, (double)-12.25, (double)31.0, (double)2.75), Block.m_49796_((double)-14.75, (double)0.0, (double)13.25, (double)-12.25, (double)31.0, (double)15.75), Block.m_49796_((double)12.25, (double)0.0, (double)13.25, (double)14.75, (double)31.0, (double)15.75), Block.m_49796_((double)12.25, (double)0.0, (double)0.25, (double)14.75, (double)31.0, (double)2.75), Block.m_49796_((double)-14.0, (double)2.0, (double)1.0, (double)14.0, (double)31.0, (double)15.0), Block.m_49796_((double)-15.0, (double)31.0, (double)0.0, (double)15.0, (double)32.0, (double)16.0)});
        }

        @Override
        protected VoxelShape doorDoubleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)2.0, (double)3.0), Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)13.0, (double)12.0, (double)3.0), Block.m_49796_((double)0.0, (double)20.0, (double)0.0, (double)13.0, (double)22.0, (double)3.0), Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)3.0), Block.m_49796_((double)12.0, (double)28.0, (double)0.0, (double)13.0, (double)32.0, (double)3.0), Block.m_49796_((double)10.0, (double)29.0, (double)0.0, (double)12.0, (double)32.0, (double)3.0), Block.m_49796_((double)8.0, (double)30.0, (double)0.0, (double)10.0, (double)32.0, (double)3.0), Block.m_49796_((double)3.0, (double)31.0, (double)0.0, (double)8.0, (double)32.0, (double)3.0), Block.m_49796_((double)0.0, (double)2.0, (double)0.5, (double)13.0, (double)32.0, (double)2.5)});
        }

        @Override
        protected VoxelShape doorSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)2.0, (double)3.0), Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)13.0, (double)12.0, (double)3.0), Block.m_49796_((double)0.0, (double)20.0, (double)0.0, (double)13.0, (double)22.0, (double)3.0), Block.m_49796_((double)0.0, (double)30.0, (double)0.0, (double)13.0, (double)32.0, (double)3.0), Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)3.0), Block.m_49796_((double)0.0, (double)2.0, (double)0.5, (double)13.0, (double)30.0, (double)2.5)});
        }

        @Override
        protected VoxelShape counterSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)12.0, (double)3.0)});
        }

        @Override
        protected VoxelShape counterCornerShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)13.0, (double)4.0), Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape ovenShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)9.0, (double)16.0), Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)1.0, (double)10.0, (double)3.0, (double)15.0, (double)14.0, (double)16.0), Block.m_49796_((double)2.0, (double)14.0, (double)3.0, (double)14.0, (double)16.0, (double)16.0)});
        }
    }

    private static final class Dunmer
    extends HitBoxes {
        private Dunmer() {
        }

        @Override
        protected VoxelShape bedDoubleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-16.0, (double)0.0, (double)0.0, (double)-14.0, (double)13.0, (double)2.0), Block.m_49796_((double)-16.0, (double)0.0, (double)30.0, (double)-14.0, (double)11.0, (double)32.0), Block.m_49796_((double)14.0, (double)0.0, (double)30.0, (double)16.0, (double)11.0, (double)32.0), Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)2.0), Block.m_49796_((double)-14.0, (double)3.0, (double)0.0, (double)14.0, (double)14.25, (double)2.0), Block.m_49796_((double)-14.0, (double)3.0, (double)30.0, (double)14.0, (double)12.25, (double)32.0), Block.m_49796_((double)-15.0, (double)5.0, (double)2.0, (double)15.0, (double)8.0, (double)30.0), Block.m_49796_((double)-16.0, (double)3.0, (double)2.0, (double)16.0, (double)5.0, (double)30.0)});
        }

        @Override
        protected VoxelShape bedSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)13.0, (double)2.0), Block.m_49796_((double)0.0, (double)0.0, (double)30.0, (double)2.0, (double)11.0, (double)32.0), Block.m_49796_((double)14.0, (double)0.0, (double)30.0, (double)16.0, (double)11.0, (double)32.0), Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)2.0), Block.m_49796_((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)14.25, (double)2.0), Block.m_49796_((double)2.0, (double)3.0, (double)30.0, (double)14.0, (double)12.25, (double)32.0), Block.m_49796_((double)1.0, (double)5.0, (double)2.0, (double)15.0, (double)8.0, (double)30.0), Block.m_49796_((double)0.0, (double)3.0, (double)2.0, (double)16.0, (double)5.0, (double)30.0)});
        }

        @Override
        protected VoxelShape benchShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)5.0, (double)4.0), Block.m_49796_((double)-14.0, (double)0.0, (double)2.0, (double)-12.0, (double)5.0, (double)4.0), Block.m_49796_((double)-14.0, (double)0.0, (double)12.0, (double)-12.0, (double)5.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)5.0, (double)14.0), Block.m_49796_((double)-15.0, (double)5.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), Block.m_49796_((double)12.5, (double)2.5, (double)4.0, (double)13.5, (double)3.5, (double)12.0), Block.m_49796_((double)-13.5, (double)2.5, (double)4.0, (double)-12.5, (double)3.5, (double)12.0)});
        }

        @Override
        protected VoxelShape bookshelfShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-14.0, (double)0.0, (double)2.0, (double)-12.0, (double)30.0, (double)4.0), Block.m_49796_((double)-14.0, (double)0.0, (double)12.0, (double)-12.0, (double)30.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)30.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)30.0, (double)4.0), Block.m_49796_((double)-12.0, (double)9.0, (double)4.0, (double)12.0, (double)32.0, (double)12.0), Block.m_49796_((double)-15.0, (double)9.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0), Block.m_49796_((double)-15.0, (double)19.0, (double)1.0, (double)15.0, (double)21.0, (double)15.0), Block.m_49796_((double)-15.0, (double)30.0, (double)1.0, (double)15.0, (double)32.0, (double)15.0)});
        }

        @Override
        protected VoxelShape chairShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)4.0, (double)4.0), Block.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)4.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)4.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)4.0), Block.m_49796_((double)11.5, (double)4.0, (double)2.5, (double)13.5, (double)7.0, (double)4.5), Block.m_49796_((double)2.5, (double)4.0, (double)2.5, (double)4.5, (double)7.0, (double)4.5), Block.m_49796_((double)2.5, (double)4.0, (double)11.5, (double)4.5, (double)7.0, (double)13.5), Block.m_49796_((double)11.5, (double)4.0, (double)11.5, (double)13.5, (double)7.0, (double)13.5), Block.m_49796_((double)2.0, (double)7.0, (double)1.0, (double)14.0, (double)9.0, (double)15.0), Block.m_49796_((double)2.5, (double)9.0, (double)11.5, (double)13.5, (double)31.5, (double)13.5)});
        }

        @Override
        protected VoxelShape chandelierShape() {
            return Block.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        }

        @Override
        protected VoxelShape chestShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)4.0), Block.m_49796_((double)-14.0, (double)0.0, (double)2.0, (double)-12.0, (double)14.0, (double)4.0), Block.m_49796_((double)-14.0, (double)0.0, (double)12.0, (double)-12.0, (double)14.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)14.0, (double)14.0), Block.m_49796_((double)-15.0, (double)4.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0), Block.m_49796_((double)-15.0, (double)14.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.m_49796_((double)-13.0, (double)6.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), Block.m_49796_((double)-2.0, (double)11.0, (double)2.0, (double)2.0, (double)14.0, (double)3.0)});
        }

        @Override
        protected VoxelShape cushionShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)5.0, (double)4.0, (double)5.0), Block.m_49796_((double)3.0, (double)0.0, (double)11.0, (double)5.0, (double)4.0, (double)13.0), Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)13.0, (double)4.0, (double)13.0), Block.m_49796_((double)11.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)5.0), Block.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0), Block.m_49796_((double)2.5, (double)5.0, (double)2.5, (double)13.5, (double)7.0, (double)13.5)});
        }

        @Override
        protected VoxelShape deskLeftShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)4.0), Block.m_49796_((double)-14.0, (double)0.0, (double)2.0, (double)-12.0, (double)14.0, (double)4.0), Block.m_49796_((double)-14.0, (double)0.0, (double)12.0, (double)-12.0, (double)14.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)14.0, (double)14.0), Block.m_49796_((double)-16.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)4.0, (double)10.0, (double)2.0, (double)11.0, (double)14.0, (double)11.0)});
        }

        @Override
        protected VoxelShape deskRightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)4.0), Block.m_49796_((double)-14.0, (double)0.0, (double)2.0, (double)-12.0, (double)14.0, (double)4.0), Block.m_49796_((double)-14.0, (double)0.0, (double)12.0, (double)-12.0, (double)14.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)14.0, (double)14.0), Block.m_49796_((double)-16.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)-11.0, (double)10.0, (double)2.0, (double)-4.0, (double)14.0, (double)11.0)});
        }

        @Override
        protected VoxelShape drawerShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)14.0, (double)3.0), Block.m_49796_((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)14.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)3.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)1.0, (double)6.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0)});
        }

        @Override
        protected VoxelShape dresserShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-13.0, (double)14.0, (double)3.0), Block.m_49796_((double)-15.0, (double)0.0, (double)13.0, (double)-13.0, (double)14.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)3.0), Block.m_49796_((double)-16.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)-15.0, (double)6.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)-14.0, (double)8.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0)});
        }

        @Override
        protected VoxelShape lockboxShape() {
            return Block.m_49796_((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)14.0, (double)13.0);
        }

        @Override
        protected VoxelShape floorLightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0), Block.m_49796_((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)22.0, (double)9.0), Block.m_49796_((double)6.0, (double)22.0, (double)6.0, (double)10.0, (double)27.0, (double)10.0), Block.m_49796_((double)7.0, (double)27.0, (double)7.0, (double)9.0, (double)28.0, (double)9.0)});
        }

        @Override
        protected VoxelShape paintingSmallShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)1.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)0.0, (double)13.0, (double)14.0, (double)16.0, (double)15.0, (double)16.0), Block.m_49796_((double)1.0, (double)3.0, (double)14.0, (double)15.0, (double)13.0, (double)16.0)});
        }

        @Override
        protected VoxelShape paintingWideShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-16.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)-16.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)-15.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0, (double)16.0)});
        }

        @Override
        protected VoxelShape shelfSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)13.0, (double)8.0, (double)14.0, (double)15.0, (double)14.0, (double)16.0), Block.m_49796_((double)1.0, (double)8.0, (double)14.0, (double)3.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape shelfCenterShape() {
            return Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }

        @Override
        protected VoxelShape shelfLeftShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)13.0, (double)8.0, (double)14.0, (double)15.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape shelfRightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)8.0, (double)14.0, (double)3.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape sofaSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)4.0, (double)1.0, (double)16.0, (double)6.0, (double)15.0), Block.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)4.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)4.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)4.0, (double)14.0), Block.m_49796_((double)1.0, (double)6.0, (double)12.0, (double)15.0, (double)16.0, (double)14.0), Block.m_49796_((double)13.0, (double)10.0, (double)2.0, (double)15.0, (double)12.0, (double)12.0), Block.m_49796_((double)13.0, (double)6.0, (double)3.0, (double)15.0, (double)10.0, (double)5.0), Block.m_49796_((double)1.0, (double)6.0, (double)3.0, (double)3.0, (double)10.0, (double)5.0), Block.m_49796_((double)1.0, (double)10.0, (double)2.0, (double)3.0, (double)12.0, (double)12.0), Block.m_49796_((double)3.0, (double)6.0, (double)2.0, (double)13.0, (double)7.0, (double)13.0)});
        }

        @Override
        protected VoxelShape sofaCenterShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)4.0, (double)1.0, (double)16.0, (double)6.0, (double)15.0), Block.m_49796_((double)0.0, (double)6.0, (double)2.0, (double)16.0, (double)7.0, (double)12.0), Block.m_49796_((double)0.0, (double)6.0, (double)12.0, (double)16.0, (double)16.0, (double)14.0)});
        }

        @Override
        protected VoxelShape sofaLeftShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)4.0, (double)1.0, (double)16.0, (double)6.0, (double)15.0), Block.m_49796_((double)0.0, (double)6.0, (double)2.0, (double)13.0, (double)7.0, (double)12.0), Block.m_49796_((double)0.0, (double)6.0, (double)12.0, (double)15.0, (double)16.0, (double)14.0), Block.m_49796_((double)13.0, (double)10.0, (double)2.0, (double)15.0, (double)12.0, (double)12.0), Block.m_49796_((double)13.0, (double)6.0, (double)3.0, (double)15.0, (double)10.0, (double)12.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)4.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)4.0)});
        }

        @Override
        protected VoxelShape sofaRightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)4.0, (double)1.0, (double)16.0, (double)6.0, (double)15.0), Block.m_49796_((double)3.0, (double)6.0, (double)2.0, (double)16.0, (double)7.0, (double)12.0), Block.m_49796_((double)1.0, (double)6.0, (double)12.0, (double)16.0, (double)16.0, (double)14.0), Block.m_49796_((double)1.0, (double)10.0, (double)2.0, (double)3.0, (double)12.0, (double)12.0), Block.m_49796_((double)1.0, (double)6.0, (double)3.0, (double)3.0, (double)10.0, (double)12.0), Block.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)4.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)4.0, (double)4.0)});
        }

        @Override
        protected VoxelShape sofaCornerShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)4.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)4.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)4.0, (double)14.0), Block.m_49796_((double)12.0, (double)6.0, (double)12.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)12.0, (double)6.0, (double)0.0, (double)14.0, (double)16.0, (double)12.0), Block.m_49796_((double)0.0, (double)6.0, (double)12.0, (double)12.0, (double)16.0, (double)14.0), Block.m_49796_((double)1.0, (double)4.0, (double)0.0, (double)15.0, (double)6.0, (double)15.0), Block.m_49796_((double)0.0, (double)4.0, (double)1.0, (double)1.0, (double)6.0, (double)15.0), Block.m_49796_((double)0.0, (double)6.0, (double)2.0, (double)13.0, (double)7.0, (double)13.0), Block.m_49796_((double)2.0, (double)6.0, (double)0.0, (double)13.0, (double)7.0, (double)2.0)});
        }

        @Override
        protected VoxelShape stoolShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)5.0, (double)4.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)5.0, (double)4.0), Block.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)5.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)5.0, (double)14.0), Block.m_49796_((double)1.0, (double)5.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), Block.m_49796_((double)12.5, (double)2.5, (double)4.0, (double)13.5, (double)3.5, (double)12.0), Block.m_49796_((double)2.5, (double)2.5, (double)4.0, (double)3.5, (double)3.5, (double)12.0)});
        }

        @Override
        protected VoxelShape tableLargeShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)4.0), Block.m_49796_((double)-14.0, (double)0.0, (double)2.0, (double)-12.0, (double)14.0, (double)4.0), Block.m_49796_((double)-14.0, (double)0.0, (double)28.0, (double)-12.0, (double)14.0, (double)30.0), Block.m_49796_((double)12.0, (double)0.0, (double)28.0, (double)14.0, (double)14.0, (double)30.0), Block.m_49796_((double)-16.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)32.0)});
        }

        @Override
        protected VoxelShape tableSmallShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)14.0, (double)3.0), Block.m_49796_((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)14.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)3.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape tableWideShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)4.0), Block.m_49796_((double)-14.0, (double)0.0, (double)2.0, (double)-12.0, (double)14.0, (double)4.0), Block.m_49796_((double)-14.0, (double)0.0, (double)12.0, (double)-12.0, (double)14.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)14.0, (double)14.0), Block.m_49796_((double)-16.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape wallLightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.5, (double)1.0, (double)7.5, (double)11.5, (double)2.0, (double)14.5), Block.m_49796_((double)4.5, (double)8.0, (double)7.5, (double)11.5, (double)9.0, (double)14.5), Block.m_49796_((double)5.0, (double)2.0, (double)8.0, (double)11.0, (double)8.0, (double)14.0), Block.m_49796_((double)6.0, (double)9.0, (double)9.0, (double)10.0, (double)10.0, (double)13.0), Block.m_49796_((double)7.5, (double)10.0, (double)10.5, (double)8.5, (double)13.0, (double)11.5), Block.m_49796_((double)7.0, (double)13.0, (double)9.0, (double)9.0, (double)15.0, (double)15.0), Block.m_49796_((double)6.0, (double)12.0, (double)15.0, (double)10.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape wardrobeTopShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)3.0), Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-13.0, (double)8.0, (double)3.0), Block.m_49796_((double)-15.0, (double)0.0, (double)13.0, (double)-13.0, (double)8.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)-16.0, (double)8.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)-13.0, (double)0.0, (double)2.0, (double)13.0, (double)8.0, (double)14.0)});
        }

        @Override
        protected VoxelShape wardrobeBottomShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-13.0, (double)30.0, (double)3.0), Block.m_49796_((double)-15.0, (double)0.0, (double)13.0, (double)-13.0, (double)30.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)30.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)30.0, (double)3.0), Block.m_49796_((double)-16.0, (double)30.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0), Block.m_49796_((double)-16.0, (double)20.0, (double)0.0, (double)16.0, (double)22.0, (double)16.0), Block.m_49796_((double)-16.0, (double)2.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)-13.0, (double)4.0, (double)2.0, (double)13.0, (double)30.0, (double)14.0)});
        }

        @Override
        protected VoxelShape doorDoubleShape() {
            return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)2.0);
        }

        @Override
        protected VoxelShape doorSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)21.0, (double)2.0), Block.m_49796_((double)0.0, (double)29.0, (double)0.0, (double)16.0, (double)32.0, (double)2.0), Block.m_49796_((double)13.0, (double)21.0, (double)0.0, (double)16.0, (double)29.0, (double)2.0), Block.m_49796_((double)0.0, (double)21.0, (double)0.0, (double)3.0, (double)29.0, (double)2.0), Block.m_49796_((double)4.0, (double)21.0, (double)0.5, (double)5.0, (double)30.0, (double)1.5), Block.m_49796_((double)6.0, (double)21.0, (double)0.5, (double)7.0, (double)30.0, (double)1.5), Block.m_49796_((double)9.0, (double)21.0, (double)0.5, (double)10.0, (double)30.0, (double)1.5), Block.m_49796_((double)11.0, (double)21.0, (double)0.5, (double)12.0, (double)30.0, (double)1.5), Block.m_49796_((double)3.0, (double)27.0, (double)0.5, (double)13.0, (double)28.0, (double)1.5), Block.m_49796_((double)3.0, (double)22.0, (double)0.5, (double)13.0, (double)23.0, (double)1.5)});
        }

        @Override
        protected VoxelShape counterSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)2.0, (double)1.0, (double)5.0), Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)1.0, (double)16.0), Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)14.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)5.0), Block.m_49796_((double)0.0, (double)1.0, (double)3.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape counterCornerShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)1.0, (double)2.0), Block.m_49796_((double)11.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)5.0), Block.m_49796_((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)5.0), Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)1.0, (double)3.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)13.0, (double)14.0, (double)3.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape ovenShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.5, (double)0.0, (double)6.5, (double)15.5, (double)3.0, (double)9.5), Block.m_49796_((double)-15.5, (double)0.0, (double)6.5, (double)-12.5, (double)3.0, (double)9.5), Block.m_49796_((double)-15.0, (double)3.0, (double)7.0, (double)-13.0, (double)16.0, (double)9.0), Block.m_49796_((double)13.0, (double)3.0, (double)7.0, (double)15.0, (double)16.0, (double)9.0), Block.m_49796_((double)-16.0, (double)12.0, (double)7.0, (double)16.0, (double)14.0, (double)9.0), Block.m_49796_((double)-5.0, (double)10.5, (double)5.5, (double)5.0, (double)15.5, (double)10.5), Block.m_49796_((double)-6.0, (double)0.0, (double)2.0, (double)6.0, (double)3.0, (double)14.0)});
        }
    }

    private static final class Venthyr
    extends HitBoxes {
        private Venthyr() {
        }

        @Override
        protected VoxelShape bedDoubleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-16.0, (double)0.0, (double)0.0, (double)-13.0, (double)2.0, (double)3.0), Block.m_49796_((double)-15.5, (double)2.0, (double)0.5, (double)-13.5, (double)12.0, (double)2.5), Block.m_49796_((double)-15.5, (double)2.0, (double)29.5, (double)-13.5, (double)12.0, (double)31.5), Block.m_49796_((double)13.5, (double)2.0, (double)29.5, (double)15.5, (double)12.0, (double)31.5), Block.m_49796_((double)13.5, (double)2.0, (double)0.5, (double)15.5, (double)12.0, (double)2.5), Block.m_49796_((double)-16.0, (double)12.0, (double)0.0, (double)-13.0, (double)14.0, (double)3.0), Block.m_49796_((double)-16.0, (double)12.0, (double)29.0, (double)-13.0, (double)14.0, (double)32.0), Block.m_49796_((double)13.0, (double)12.0, (double)29.0, (double)16.0, (double)14.0, (double)32.0), Block.m_49796_((double)13.0, (double)12.0, (double)0.0, (double)16.0, (double)14.0, (double)3.0), Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)3.0), Block.m_49796_((double)13.0, (double)0.0, (double)29.0, (double)16.0, (double)2.0, (double)32.0), Block.m_49796_((double)-16.0, (double)0.0, (double)29.0, (double)-13.0, (double)2.0, (double)32.0), Block.m_49796_((double)-15.5, (double)0.0, (double)2.5, (double)15.5, (double)5.0, (double)29.5), Block.m_49796_((double)-13.5, (double)0.0, (double)29.5, (double)13.5, (double)12.0, (double)31.5), Block.m_49796_((double)-13.5, (double)0.0, (double)0.5, (double)13.5, (double)14.0, (double)2.5), Block.m_49796_((double)-14.5, (double)0.0, (double)2.5, (double)14.5, (double)8.0, (double)29.5)});
        }

        @Override
        protected VoxelShape bedSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)29.0, (double)3.0, (double)2.0, (double)32.0), Block.m_49796_((double)13.0, (double)0.0, (double)29.0, (double)16.0, (double)2.0, (double)32.0), Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)3.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)2.0, (double)3.0), Block.m_49796_((double)0.5, (double)2.0, (double)0.5, (double)2.5, (double)12.0, (double)2.5), Block.m_49796_((double)0.5, (double)2.0, (double)29.5, (double)2.5, (double)12.0, (double)31.5), Block.m_49796_((double)13.5, (double)2.0, (double)29.5, (double)15.5, (double)12.0, (double)31.5), Block.m_49796_((double)13.5, (double)2.0, (double)0.5, (double)15.5, (double)12.0, (double)2.5), Block.m_49796_((double)13.0, (double)12.0, (double)0.0, (double)16.0, (double)14.0, (double)3.0), Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)3.0, (double)14.0, (double)3.0), Block.m_49796_((double)0.0, (double)12.0, (double)29.0, (double)3.0, (double)14.0, (double)32.0), Block.m_49796_((double)13.0, (double)12.0, (double)29.0, (double)16.0, (double)14.0, (double)32.0), Block.m_49796_((double)0.5, (double)0.0, (double)2.0, (double)15.5, (double)5.0, (double)30.0), Block.m_49796_((double)2.5, (double)0.0, (double)29.5, (double)13.5, (double)11.0, (double)31.5), Block.m_49796_((double)2.5, (double)0.0, (double)0.5, (double)13.5, (double)13.0, (double)2.5), Block.m_49796_((double)1.5, (double)5.0, (double)2.5, (double)14.5, (double)8.0, (double)29.5)});
        }

        @Override
        protected VoxelShape benchShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-14.0, (double)0.0, (double)2.0, (double)-11.0, (double)4.0, (double)5.0), Block.m_49796_((double)-14.0, (double)0.0, (double)11.0, (double)-11.0, (double)4.0, (double)14.0), Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)14.0, (double)4.0, (double)14.0), Block.m_49796_((double)11.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)5.0), Block.m_49796_((double)-15.0, (double)4.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0)});
        }

        @Override
        protected VoxelShape bookshelfShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-16.0, (double)0.0, (double)2.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)-15.0, (double)3.0, (double)3.0, (double)15.0, (double)29.0, (double)16.0), Block.m_49796_((double)-16.0, (double)29.0, (double)2.0, (double)16.0, (double)32.0, (double)16.0)});
        }

        @Override
        protected VoxelShape chairShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)5.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)5.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)5.0, (double)15.0), Block.m_49796_((double)0.5, (double)5.0, (double)0.5, (double)15.5, (double)9.0, (double)15.5), Block.m_49796_((double)1.0, (double)9.0, (double)12.0, (double)15.0, (double)31.0, (double)15.0)});
        }

        @Override
        protected VoxelShape chandelierShape() {
            return Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        }

        @Override
        protected VoxelShape chestShape() {
            return Block.m_49796_((double)-13.0, (double)0.0, (double)1.0, (double)13.0, (double)14.25, (double)15.0);
        }

        @Override
        protected VoxelShape cushionShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)5.0, (double)3.0, (double)5.0), Block.m_49796_((double)2.0, (double)0.0, (double)11.0, (double)5.0, (double)3.0, (double)14.0), Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)14.0, (double)3.0, (double)14.0), Block.m_49796_((double)11.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)5.0), Block.m_49796_((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0), Block.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)7.0, (double)14.0)});
        }

        @Override
        protected VoxelShape deskLeftShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-12.0, (double)2.0, (double)4.0), Block.m_49796_((double)-15.0, (double)0.0, (double)12.0, (double)-12.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.5, (double)2.0, (double)1.5, (double)14.5, (double)13.0, (double)3.5), Block.m_49796_((double)-14.5, (double)2.0, (double)1.5, (double)-12.5, (double)13.0, (double)3.5), Block.m_49796_((double)-14.5, (double)2.0, (double)12.5, (double)-12.5, (double)13.0, (double)14.5), Block.m_49796_((double)12.5, (double)2.0, (double)12.5, (double)14.5, (double)13.0, (double)14.5), Block.m_49796_((double)-16.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)5.0, (double)9.0, (double)2.0, (double)12.0, (double)13.0, (double)11.0), Block.m_49796_((double)12.5, (double)9.0, (double)3.5, (double)14.5, (double)13.0, (double)12.5), Block.m_49796_((double)-14.5, (double)9.0, (double)3.5, (double)-12.5, (double)13.0, (double)12.5)});
        }

        @Override
        protected VoxelShape deskRightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-12.0, (double)2.0, (double)4.0), Block.m_49796_((double)-15.0, (double)0.0, (double)12.0, (double)-12.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.5, (double)2.0, (double)1.5, (double)14.5, (double)13.0, (double)3.5), Block.m_49796_((double)-14.5, (double)2.0, (double)1.5, (double)-12.5, (double)13.0, (double)3.5), Block.m_49796_((double)-14.5, (double)2.0, (double)12.5, (double)-12.5, (double)13.0, (double)14.5), Block.m_49796_((double)12.5, (double)2.0, (double)12.5, (double)14.5, (double)13.0, (double)14.5), Block.m_49796_((double)-16.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)-12.0, (double)9.0, (double)2.0, (double)-5.0, (double)13.0, (double)11.0), Block.m_49796_((double)12.5, (double)9.0, (double)3.5, (double)14.5, (double)13.0, (double)12.5), Block.m_49796_((double)-14.5, (double)9.0, (double)3.5, (double)-12.5, (double)13.0, (double)12.5)});
        }

        @Override
        protected VoxelShape drawerShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.5, (double)0.0, (double)0.5, (double)3.5, (double)2.0, (double)3.5), Block.m_49796_((double)0.5, (double)0.0, (double)12.5, (double)3.5, (double)2.0, (double)15.5), Block.m_49796_((double)12.5, (double)0.0, (double)12.5, (double)15.5, (double)2.0, (double)15.5), Block.m_49796_((double)12.5, (double)0.0, (double)0.5, (double)15.5, (double)2.0, (double)3.5), Block.m_49796_((double)13.0, (double)2.0, (double)1.0, (double)15.0, (double)13.0, (double)3.0), Block.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)3.0, (double)13.0, (double)3.0), Block.m_49796_((double)1.0, (double)2.0, (double)13.0, (double)3.0, (double)13.0, (double)15.0), Block.m_49796_((double)13.0, (double)2.0, (double)13.0, (double)15.0, (double)13.0, (double)15.0), Block.m_49796_((double)1.0, (double)5.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0), Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape dresserShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-15.5, (double)0.0, (double)0.5, (double)-12.5, (double)2.0, (double)3.5), Block.m_49796_((double)-15.5, (double)0.0, (double)12.5, (double)-12.5, (double)2.0, (double)15.5), Block.m_49796_((double)12.5, (double)0.0, (double)12.5, (double)15.5, (double)2.0, (double)15.5), Block.m_49796_((double)12.5, (double)0.0, (double)0.5, (double)15.5, (double)2.0, (double)3.5), Block.m_49796_((double)13.0, (double)2.0, (double)1.0, (double)15.0, (double)13.0, (double)3.0), Block.m_49796_((double)-15.0, (double)2.0, (double)1.0, (double)-13.0, (double)13.0, (double)3.0), Block.m_49796_((double)-15.0, (double)2.0, (double)13.0, (double)-13.0, (double)13.0, (double)15.0), Block.m_49796_((double)13.0, (double)2.0, (double)13.0, (double)15.0, (double)13.0, (double)15.0), Block.m_49796_((double)-15.0, (double)5.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0), Block.m_49796_((double)-16.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape lockboxShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)1.0, (double)4.0, (double)14.0, (double)10.0, (double)12.0), Block.m_49796_((double)1.5, (double)6.0, (double)3.5, (double)14.5, (double)7.0, (double)12.5), Block.m_49796_((double)1.5, (double)1.0, (double)3.5, (double)14.5, (double)2.0, (double)12.5), Block.m_49796_((double)7.0, (double)4.0, (double)3.5, (double)9.0, (double)6.0, (double)4.25), Block.m_49796_((double)12.0, (double)0.0, (double)4.0, (double)14.0, (double)1.0, (double)6.0), Block.m_49796_((double)2.0, (double)0.0, (double)4.0, (double)4.0, (double)1.0, (double)6.0), Block.m_49796_((double)2.0, (double)0.0, (double)10.0, (double)4.0, (double)1.0, (double)12.0), Block.m_49796_((double)12.0, (double)0.0, (double)10.0, (double)14.0, (double)1.0, (double)12.0)});
        }

        @Override
        protected VoxelShape floorLightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0), Block.m_49796_((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)20.0, (double)9.0), Block.m_49796_((double)4.0, (double)17.75, (double)7.0, (double)7.0, (double)21.75, (double)9.0), Block.m_49796_((double)9.0, (double)17.75, (double)7.0, (double)12.0, (double)21.75, (double)9.0), Block.m_49796_((double)7.0, (double)17.75, (double)4.0, (double)9.0, (double)21.75, (double)7.0), Block.m_49796_((double)7.0, (double)17.75, (double)9.0, (double)9.0, (double)21.75, (double)12.0), Block.m_49796_((double)2.5, (double)20.75, (double)2.5, (double)13.5, (double)24.0, (double)13.5), Block.m_49796_((double)10.25, (double)24.0, (double)10.25, (double)12.5, (double)28.75, (double)12.5), Block.m_49796_((double)3.5, (double)24.0, (double)10.25, (double)5.75, (double)28.75, (double)12.5), Block.m_49796_((double)3.5, (double)24.0, (double)3.5, (double)5.75, (double)28.75, (double)5.75), Block.m_49796_((double)10.25, (double)24.0, (double)3.5, (double)12.5, (double)28.75, (double)5.75)});
        }

        @Override
        protected VoxelShape paintingSmallShape() {
            return Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
        }

        @Override
        protected VoxelShape paintingWideShape() {
            return Block.m_49796_((double)-16.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
        }

        @Override
        protected VoxelShape shelfSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)9.0, (double)10.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)13.0, (double)11.0, (double)3.0, (double)16.0, (double)13.0, (double)10.0), Block.m_49796_((double)13.0, (double)10.0, (double)0.0, (double)16.0, (double)13.0, (double)3.0), Block.m_49796_((double)13.0, (double)6.0, (double)13.0, (double)16.0, (double)9.0, (double)16.0), Block.m_49796_((double)13.0, (double)3.0, (double)12.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)3.0, (double)12.0, (double)3.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)9.0, (double)10.0, (double)3.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)11.0, (double)3.0, (double)3.0, (double)13.0, (double)10.0), Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0), Block.m_49796_((double)0.0, (double)6.0, (double)13.0, (double)3.0, (double)9.0, (double)16.0)});
        }

        @Override
        protected VoxelShape shelfCenterShape() {
            return Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }

        @Override
        protected VoxelShape shelfLeftShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)3.0, (double)12.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)13.0, (double)9.0, (double)10.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)13.0, (double)11.0, (double)3.0, (double)16.0, (double)13.0, (double)10.0), Block.m_49796_((double)13.0, (double)10.0, (double)0.0, (double)16.0, (double)13.0, (double)3.0), Block.m_49796_((double)13.0, (double)6.0, (double)13.0, (double)16.0, (double)9.0, (double)16.0)});
        }

        @Override
        protected VoxelShape shelfRightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)3.0, (double)12.0, (double)3.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)6.0, (double)13.0, (double)3.0, (double)9.0, (double)16.0), Block.m_49796_((double)0.0, (double)9.0, (double)10.0, (double)3.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)11.0, (double)3.0, (double)3.0, (double)13.0, (double)10.0), Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0), Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape sofaSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)13.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)13.0), Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)3.0, (double)10.0, (double)13.0), Block.m_49796_((double)0.0, (double)6.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape sofaCenterShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)6.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape sofaLeftShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)13.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)13.0), Block.m_49796_((double)0.0, (double)6.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape sofaRightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0), Block.m_49796_((double)0.0, (double)2.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)3.0, (double)10.0, (double)13.0), Block.m_49796_((double)3.0, (double)2.0, (double)0.0, (double)16.0, (double)6.0, (double)13.0)});
        }

        @Override
        protected VoxelShape sofaCornerShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)13.0, (double)6.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)6.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0)});
        }

        @Override
        protected VoxelShape stoolShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)5.0, (double)4.0, (double)5.0), Block.m_49796_((double)2.0, (double)0.0, (double)11.0, (double)5.0, (double)4.0, (double)14.0), Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)14.0, (double)4.0, (double)14.0), Block.m_49796_((double)11.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)5.0), Block.m_49796_((double)1.0, (double)4.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0)});
        }

        @Override
        protected VoxelShape tableLargeShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-12.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)28.0, (double)15.0, (double)2.0, (double)31.0), Block.m_49796_((double)-15.0, (double)0.0, (double)28.0, (double)-12.0, (double)2.0, (double)31.0), Block.m_49796_((double)-14.5, (double)2.0, (double)1.5, (double)-12.5, (double)13.0, (double)3.5), Block.m_49796_((double)-14.5, (double)2.0, (double)28.5, (double)-12.5, (double)13.0, (double)30.5), Block.m_49796_((double)12.5, (double)2.0, (double)28.5, (double)14.5, (double)13.0, (double)30.5), Block.m_49796_((double)12.5, (double)2.0, (double)1.5, (double)14.5, (double)13.0, (double)3.5), Block.m_49796_((double)-16.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)32.0)});
        }

        @Override
        protected VoxelShape tableSmallShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.5, (double)2.0, (double)1.5, (double)14.5, (double)13.0, (double)3.5), Block.m_49796_((double)1.5, (double)2.0, (double)1.5, (double)3.5, (double)13.0, (double)3.5), Block.m_49796_((double)1.5, (double)2.0, (double)12.5, (double)3.5, (double)13.0, (double)14.5), Block.m_49796_((double)12.5, (double)2.0, (double)12.5, (double)14.5, (double)13.0, (double)14.5), Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape tableWideShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-12.0, (double)2.0, (double)4.0), Block.m_49796_((double)-15.0, (double)0.0, (double)12.0, (double)-12.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.5, (double)2.0, (double)12.5, (double)14.5, (double)13.0, (double)14.5), Block.m_49796_((double)12.5, (double)2.0, (double)1.5, (double)14.5, (double)13.0, (double)3.5), Block.m_49796_((double)-14.5, (double)2.0, (double)1.5, (double)-12.5, (double)13.0, (double)3.5), Block.m_49796_((double)-14.5, (double)2.0, (double)12.5, (double)-12.5, (double)13.0, (double)14.5), Block.m_49796_((double)-16.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape wallLightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)1.0, (double)15.0, (double)10.0, (double)3.0, (double)16.0), Block.m_49796_((double)5.0, (double)3.0, (double)15.0, (double)11.0, (double)12.0, (double)16.0), Block.m_49796_((double)6.0, (double)12.0, (double)15.0, (double)10.0, (double)14.0, (double)16.0), Block.m_49796_((double)7.0, (double)3.5, (double)14.0, (double)9.0, (double)5.5, (double)15.0), Block.m_49796_((double)4.25, (double)2.5, (double)10.5, (double)11.75, (double)11.5, (double)14.0)});
        }

        @Override
        protected VoxelShape wardrobeTopShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)15.0, (double)9.0, (double)15.0), Block.m_49796_((double)-16.0, (double)9.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0)});
        }

        @Override
        protected VoxelShape wardrobeBottomShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-16.0, (double)0.0, (double)0.0, (double)-12.0, (double)3.0, (double)4.0), Block.m_49796_((double)-16.0, (double)0.0, (double)12.0, (double)-12.0, (double)3.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)4.0), Block.m_49796_((double)-15.0, (double)1.0, (double)1.0, (double)15.0, (double)29.0, (double)15.0), Block.m_49796_((double)-16.0, (double)29.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0)});
        }

        @Override
        protected VoxelShape doorDoubleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)3.0), Block.m_49796_((double)14.0, (double)1.0, (double)0.0, (double)16.0, (double)32.0, (double)3.0), Block.m_49796_((double)0.0, (double)31.0, (double)0.0, (double)14.0, (double)32.0, (double)3.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)31.0, (double)3.0), Block.m_49796_((double)6.0, (double)30.0, (double)0.0, (double)14.0, (double)31.0, (double)3.0), Block.m_49796_((double)8.0, (double)29.0, (double)0.0, (double)14.0, (double)30.0, (double)3.0), Block.m_49796_((double)10.0, (double)27.0, (double)0.0, (double)14.0, (double)29.0, (double)3.0), Block.m_49796_((double)11.0, (double)25.0, (double)0.0, (double)14.0, (double)27.0, (double)3.0), Block.m_49796_((double)12.0, (double)22.0, (double)0.0, (double)14.0, (double)25.0, (double)3.0), Block.m_49796_((double)13.0, (double)17.0, (double)0.0, (double)14.0, (double)22.0, (double)3.0), Block.m_49796_((double)1.0, (double)1.0, (double)0.5, (double)14.0, (double)31.0, (double)2.5)});
        }

        @Override
        protected VoxelShape doorSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)3.0), Block.m_49796_((double)14.0, (double)1.0, (double)0.0, (double)16.0, (double)32.0, (double)3.0), Block.m_49796_((double)0.0, (double)30.0, (double)0.0, (double)14.0, (double)32.0, (double)3.0), Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)30.0, (double)3.0), Block.m_49796_((double)1.0, (double)1.0, (double)0.5, (double)14.0, (double)30.0, (double)2.5)});
        }

        @Override
        protected VoxelShape counterSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)12.0, (double)3.0)});
        }

        @Override
        protected VoxelShape counterCornerShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)12.0, (double)3.0)});
        }

        @Override
        protected VoxelShape ovenShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)1.0, (double)4.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)3.0, (double)5.0, (double)0.0, (double)13.0, (double)13.0, (double)1.0)});
        }
    }

    private static final class Bone
    extends HitBoxes {
        private Bone() {
        }

        @Override
        protected VoxelShape bedDoubleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-16.0, (double)0.0, (double)0.0, (double)-12.0, (double)2.0, (double)4.0), Block.m_49796_((double)-16.0, (double)0.0, (double)28.0, (double)-12.0, (double)2.0, (double)32.0), Block.m_49796_((double)12.0, (double)0.0, (double)28.0, (double)16.0, (double)2.0, (double)32.0), Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.0, (double)12.0, (double)28.0, (double)16.0, (double)14.0, (double)32.0), Block.m_49796_((double)-16.0, (double)12.0, (double)28.0, (double)-12.0, (double)14.0, (double)32.0), Block.m_49796_((double)12.0, (double)12.0, (double)0.0, (double)16.0, (double)14.0, (double)4.0), Block.m_49796_((double)-16.0, (double)12.0, (double)0.0, (double)-12.0, (double)14.0, (double)4.0), Block.m_49796_((double)13.0, (double)2.0, (double)29.0, (double)15.0, (double)12.0, (double)31.0), Block.m_49796_((double)-15.0, (double)2.0, (double)29.0, (double)-13.0, (double)12.0, (double)31.0), Block.m_49796_((double)-15.0, (double)2.0, (double)1.0, (double)-13.0, (double)12.0, (double)3.0), Block.m_49796_((double)13.0, (double)2.0, (double)1.0, (double)15.0, (double)12.0, (double)3.0), Block.m_49796_((double)-13.0, (double)4.0, (double)1.0, (double)13.0, (double)13.0, (double)3.0), Block.m_49796_((double)-13.0, (double)4.0, (double)29.0, (double)13.0, (double)13.0, (double)31.0), Block.m_49796_((double)-15.0, (double)4.0, (double)3.0, (double)15.0, (double)8.0, (double)29.0)});
        }

        @Override
        protected VoxelShape bedSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)2.0, (double)4.0), Block.m_49796_((double)0.0, (double)0.0, (double)28.0, (double)4.0, (double)2.0, (double)32.0), Block.m_49796_((double)12.0, (double)0.0, (double)28.0, (double)16.0, (double)2.0, (double)32.0), Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.0, (double)12.0, (double)28.0, (double)16.0, (double)14.0, (double)32.0), Block.m_49796_((double)0.0, (double)12.0, (double)28.0, (double)4.0, (double)14.0, (double)32.0), Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)14.0, (double)4.0), Block.m_49796_((double)12.0, (double)12.0, (double)0.0, (double)16.0, (double)14.0, (double)4.0), Block.m_49796_((double)13.0, (double)2.0, (double)29.0, (double)15.0, (double)12.0, (double)31.0), Block.m_49796_((double)1.0, (double)2.0, (double)29.0, (double)3.0, (double)12.0, (double)31.0), Block.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)3.0, (double)12.0, (double)3.0), Block.m_49796_((double)13.0, (double)2.0, (double)1.0, (double)15.0, (double)12.0, (double)3.0), Block.m_49796_((double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)13.0, (double)3.0), Block.m_49796_((double)4.0, (double)4.0, (double)29.0, (double)12.0, (double)13.0, (double)31.0), Block.m_49796_((double)1.0, (double)4.0, (double)3.0, (double)15.0, (double)8.0, (double)29.0)});
        }

        @Override
        protected VoxelShape benchShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-12.0, (double)2.0, (double)4.0), Block.m_49796_((double)-15.0, (double)0.0, (double)12.0, (double)-12.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)-14.5, (double)2.0, (double)1.5, (double)-12.5, (double)5.0, (double)3.5), Block.m_49796_((double)12.5, (double)2.0, (double)1.5, (double)14.5, (double)5.0, (double)3.5), Block.m_49796_((double)12.5, (double)2.0, (double)12.5, (double)14.5, (double)5.0, (double)14.5), Block.m_49796_((double)-14.5, (double)2.0, (double)12.5, (double)-12.5, (double)5.0, (double)14.5), Block.m_49796_((double)-15.5, (double)4.5, (double)-0.5, (double)15.5, (double)7.5, (double)16.5)});
        }

        @Override
        protected VoxelShape bookshelfShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)5.0), Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-11.0, (double)2.0, (double)5.0), Block.m_49796_((double)-15.0, (double)0.0, (double)11.0, (double)-11.0, (double)2.0, (double)15.0), Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)-15.0, (double)3.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0), Block.m_49796_((double)-15.0, (double)30.0, (double)1.0, (double)15.0, (double)32.0, (double)15.0), Block.m_49796_((double)-14.0, (double)5.0, (double)2.0, (double)14.0, (double)30.0, (double)14.0), Block.m_49796_((double)12.0, (double)2.0, (double)2.0, (double)14.0, (double)3.0, (double)4.0), Block.m_49796_((double)12.0, (double)2.0, (double)12.0, (double)14.0, (double)3.0, (double)14.0), Block.m_49796_((double)-14.0, (double)2.0, (double)12.0, (double)-12.0, (double)3.0, (double)14.0), Block.m_49796_((double)-14.0, (double)2.0, (double)2.0, (double)-12.0, (double)3.0, (double)4.0)});
        }

        @Override
        protected VoxelShape chairShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.5, (double)0.0, (double)1.5, (double)4.5, (double)3.0, (double)4.5), Block.m_49796_((double)1.5, (double)0.0, (double)11.5, (double)4.5, (double)3.0, (double)14.5), Block.m_49796_((double)11.5, (double)0.0, (double)11.5, (double)14.5, (double)3.0, (double)14.5), Block.m_49796_((double)11.5, (double)0.0, (double)1.5, (double)14.5, (double)3.0, (double)4.5), Block.m_49796_((double)2.0, (double)3.0, (double)12.0, (double)4.0, (double)7.0, (double)14.0), Block.m_49796_((double)2.0, (double)3.0, (double)2.0, (double)4.0, (double)7.0, (double)4.0), Block.m_49796_((double)12.0, (double)3.0, (double)2.0, (double)14.0, (double)7.0, (double)4.0), Block.m_49796_((double)12.0, (double)3.0, (double)12.0, (double)14.0, (double)7.0, (double)14.0), Block.m_49796_((double)1.5, (double)7.0, (double)1.5, (double)14.5, (double)9.0, (double)14.5), Block.m_49796_((double)2.0, (double)9.0, (double)12.0, (double)14.0, (double)26.0, (double)14.0)});
        }

        @Override
        protected VoxelShape chandelierShape() {
            return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }

        @Override
        protected VoxelShape chestShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)11.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)5.0), Block.m_49796_((double)-14.0, (double)0.0, (double)2.0, (double)-11.0, (double)2.0, (double)5.0), Block.m_49796_((double)-14.0, (double)0.0, (double)11.0, (double)-11.0, (double)2.0, (double)14.0), Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)14.0, (double)2.0, (double)14.0), Block.m_49796_((double)11.5, (double)2.0, (double)11.5, (double)13.5, (double)11.0, (double)13.5), Block.m_49796_((double)11.5, (double)2.0, (double)2.5, (double)13.5, (double)11.0, (double)4.5), Block.m_49796_((double)-13.5, (double)2.0, (double)2.5, (double)-11.5, (double)11.0, (double)4.5), Block.m_49796_((double)-13.5, (double)2.0, (double)11.5, (double)-11.5, (double)11.0, (double)13.5), Block.m_49796_((double)-14.0, (double)11.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0), Block.m_49796_((double)-14.0, (double)3.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0), Block.m_49796_((double)-13.0, (double)5.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0)});
        }

        @Override
        protected VoxelShape cushionShape() {
            return Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0);
        }

        @Override
        protected VoxelShape deskLeftShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-12.0, (double)2.0, (double)4.0), Block.m_49796_((double)-15.0, (double)0.0, (double)12.0, (double)-12.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.0, (double)12.0, (double)1.0, (double)15.0, (double)14.0, (double)4.0), Block.m_49796_((double)-15.0, (double)12.0, (double)1.0, (double)-12.0, (double)14.0, (double)4.0), Block.m_49796_((double)12.0, (double)12.0, (double)12.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)-15.0, (double)12.0, (double)12.0, (double)-12.0, (double)14.0, (double)15.0), Block.m_49796_((double)12.5, (double)2.0, (double)1.5, (double)14.5, (double)12.0, (double)3.5), Block.m_49796_((double)-14.5, (double)2.0, (double)1.5, (double)-12.5, (double)12.0, (double)3.5), Block.m_49796_((double)12.5, (double)2.0, (double)12.5, (double)14.5, (double)12.0, (double)14.5), Block.m_49796_((double)-14.5, (double)2.0, (double)12.5, (double)-12.5, (double)12.0, (double)14.5), Block.m_49796_((double)-16.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)5.0, (double)9.0, (double)3.0, (double)12.0, (double)14.0, (double)13.0)});
        }

        @Override
        protected VoxelShape deskRightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-12.0, (double)2.0, (double)4.0), Block.m_49796_((double)-15.0, (double)0.0, (double)12.0, (double)-12.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.0, (double)12.0, (double)1.0, (double)15.0, (double)14.0, (double)4.0), Block.m_49796_((double)-15.0, (double)12.0, (double)1.0, (double)-12.0, (double)14.0, (double)4.0), Block.m_49796_((double)12.0, (double)12.0, (double)12.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)-15.0, (double)12.0, (double)12.0, (double)-12.0, (double)14.0, (double)15.0), Block.m_49796_((double)12.5, (double)2.0, (double)1.5, (double)14.5, (double)12.0, (double)3.5), Block.m_49796_((double)-14.5, (double)2.0, (double)1.5, (double)-12.5, (double)12.0, (double)3.5), Block.m_49796_((double)12.5, (double)2.0, (double)12.5, (double)14.5, (double)12.0, (double)14.5), Block.m_49796_((double)-14.5, (double)2.0, (double)12.5, (double)-12.5, (double)12.0, (double)14.5), Block.m_49796_((double)-16.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)-12.0, (double)9.0, (double)3.0, (double)-5.0, (double)14.0, (double)13.0)});
        }

        @Override
        protected VoxelShape drawerShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), Block.m_49796_((double)1.0, (double)12.0, (double)1.0, (double)4.0, (double)14.0, (double)4.0), Block.m_49796_((double)1.5, (double)1.0, (double)1.5, (double)3.5, (double)12.0, (double)3.5), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0), Block.m_49796_((double)1.0, (double)12.0, (double)12.0, (double)4.0, (double)14.0, (double)15.0), Block.m_49796_((double)1.5, (double)1.0, (double)12.5, (double)3.5, (double)12.0, (double)14.5), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)12.0, (double)12.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)12.5, (double)1.0, (double)12.5, (double)14.5, (double)12.0, (double)14.5), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.0, (double)12.0, (double)1.0, (double)15.0, (double)14.0, (double)4.0), Block.m_49796_((double)12.5, (double)1.0, (double)1.5, (double)14.5, (double)12.0, (double)3.5), Block.m_49796_((double)1.5, (double)6.0, (double)1.5, (double)14.5, (double)14.0, (double)14.5), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape dresserShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-12.0, (double)2.0, (double)4.0), Block.m_49796_((double)-15.0, (double)12.0, (double)1.0, (double)-12.0, (double)14.0, (double)4.0), Block.m_49796_((double)-14.5, (double)1.0, (double)1.5, (double)-12.5, (double)12.0, (double)3.5), Block.m_49796_((double)-15.0, (double)0.0, (double)12.0, (double)-12.0, (double)2.0, (double)15.0), Block.m_49796_((double)-15.0, (double)12.0, (double)12.0, (double)-12.0, (double)14.0, (double)15.0), Block.m_49796_((double)-14.5, (double)1.0, (double)12.5, (double)-12.5, (double)12.0, (double)14.5), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)12.0, (double)12.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)12.5, (double)1.0, (double)12.5, (double)14.5, (double)12.0, (double)14.5), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.0, (double)12.0, (double)1.0, (double)15.0, (double)14.0, (double)4.0), Block.m_49796_((double)12.5, (double)1.0, (double)1.5, (double)14.5, (double)12.0, (double)3.5), Block.m_49796_((double)-14.5, (double)6.0, (double)1.5, (double)14.5, (double)14.0, (double)14.5), Block.m_49796_((double)-16.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape lockboxShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)4.0, (double)5.0, (double)2.0, (double)7.0), Block.m_49796_((double)2.0, (double)0.0, (double)9.0, (double)5.0, (double)2.0, (double)12.0), Block.m_49796_((double)11.0, (double)0.0, (double)9.0, (double)14.0, (double)2.0, (double)12.0), Block.m_49796_((double)11.0, (double)0.0, (double)4.0, (double)14.0, (double)2.0, (double)7.0), Block.m_49796_((double)1.0, (double)2.0, (double)3.0, (double)15.0, (double)4.0, (double)13.0), Block.m_49796_((double)1.5, (double)4.0, (double)3.5, (double)14.5, (double)12.25, (double)12.5)});
        }

        @Override
        protected VoxelShape floorLightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0), Block.m_49796_((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)23.0, (double)9.0), Block.m_49796_((double)2.5, (double)21.75, (double)6.5, (double)5.5, (double)23.75, (double)9.5), Block.m_49796_((double)3.25, (double)23.75, (double)7.25, (double)4.75, (double)27.75, (double)8.75), Block.m_49796_((double)7.25, (double)24.75, (double)7.25, (double)8.75, (double)28.75, (double)8.75), Block.m_49796_((double)11.25, (double)23.75, (double)7.25, (double)12.75, (double)27.75, (double)8.75), Block.m_49796_((double)10.5, (double)21.75, (double)6.5, (double)13.5, (double)23.75, (double)9.5), Block.m_49796_((double)6.5, (double)22.75, (double)6.5, (double)9.5, (double)24.75, (double)9.5), Block.m_49796_((double)3.0, (double)17.75, (double)7.0, (double)7.0, (double)21.75, (double)9.0), Block.m_49796_((double)9.0, (double)17.75, (double)7.0, (double)13.0, (double)21.75, (double)9.0)});
        }

        @Override
        protected VoxelShape paintingSmallShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)13.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)13.0, (double)13.0, (double)3.0, (double)16.0, (double)16.0), Block.m_49796_((double)3.0, (double)13.0, (double)13.5, (double)13.0, (double)15.5, (double)15.5), Block.m_49796_((double)3.0, (double)0.5, (double)13.5, (double)13.0, (double)3.0, (double)15.5), Block.m_49796_((double)0.5, (double)3.0, (double)13.5, (double)15.5, (double)13.0, (double)15.5)});
        }

        @Override
        protected VoxelShape paintingWideShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-16.0, (double)0.0, (double)13.0, (double)-13.0, (double)3.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)13.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)-16.0, (double)13.0, (double)13.0, (double)-13.0, (double)16.0, (double)16.0), Block.m_49796_((double)-13.0, (double)13.0, (double)13.5, (double)13.0, (double)15.5, (double)15.5), Block.m_49796_((double)-13.0, (double)0.5, (double)13.5, (double)13.0, (double)3.0, (double)15.5), Block.m_49796_((double)-15.5, (double)3.0, (double)13.5, (double)15.5, (double)13.0, (double)15.5)});
        }

        @Override
        protected VoxelShape shelfSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)6.0, (double)13.0, (double)3.0, (double)8.0, (double)16.0), Block.m_49796_((double)13.0, (double)6.0, (double)13.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.5, (double)8.0, (double)14.0, (double)2.5, (double)14.0, (double)16.0), Block.m_49796_((double)13.5, (double)8.0, (double)14.0, (double)15.5, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape shelfCenterShape() {
            return Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }

        @Override
        protected VoxelShape shelfLeftShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)13.0, (double)6.0, (double)13.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)13.5, (double)8.0, (double)14.0, (double)15.5, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape shelfRightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)6.0, (double)13.0, (double)3.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.5, (double)8.0, (double)14.0, (double)2.5, (double)15.0, (double)16.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape sofaSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.5, (double)0.0, (double)1.0, (double)4.5, (double)2.0, (double)4.0), Block.m_49796_((double)1.5, (double)0.0, (double)12.0, (double)4.5, (double)2.0, (double)15.0), Block.m_49796_((double)11.5, (double)0.0, (double)12.0, (double)14.5, (double)2.0, (double)15.0), Block.m_49796_((double)11.5, (double)0.0, (double)1.0, (double)14.5, (double)2.0, (double)4.0), Block.m_49796_((double)12.0, (double)2.0, (double)1.5, (double)14.0, (double)4.0, (double)3.5), Block.m_49796_((double)2.0, (double)2.0, (double)1.5, (double)4.0, (double)4.0, (double)3.5), Block.m_49796_((double)2.0, (double)2.0, (double)12.5, (double)4.0, (double)4.0, (double)14.5), Block.m_49796_((double)12.0, (double)2.0, (double)12.5, (double)14.0, (double)4.0, (double)14.5), Block.m_49796_((double)12.0, (double)3.0, (double)3.5, (double)14.0, (double)4.0, (double)12.5), Block.m_49796_((double)2.0, (double)3.0, (double)3.5, (double)4.0, (double)4.0, (double)12.5), Block.m_49796_((double)2.0, (double)4.0, (double)1.5, (double)14.0, (double)6.0, (double)14.5), Block.m_49796_((double)2.0, (double)6.0, (double)12.5, (double)14.0, (double)15.0, (double)14.5), Block.m_49796_((double)14.0, (double)3.5, (double)12.0, (double)16.0, (double)15.5, (double)15.0), Block.m_49796_((double)14.0, (double)6.0, (double)2.0, (double)16.0, (double)11.5, (double)12.0), Block.m_49796_((double)14.0, (double)3.5, (double)1.0, (double)16.0, (double)6.5, (double)12.0), Block.m_49796_((double)0.0, (double)3.5, (double)1.0, (double)2.0, (double)6.5, (double)12.0), Block.m_49796_((double)0.0, (double)3.5, (double)12.0, (double)2.0, (double)15.5, (double)15.0), Block.m_49796_((double)0.0, (double)6.0, (double)2.0, (double)2.0, (double)11.5, (double)12.0)});
        }

        @Override
        protected VoxelShape sofaCenterShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)4.0, (double)1.5, (double)16.0, (double)6.0, (double)14.5), Block.m_49796_((double)0.0, (double)6.0, (double)12.5, (double)16.0, (double)15.0, (double)14.5)});
        }

        @Override
        protected VoxelShape sofaLeftShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)4.0, (double)1.5, (double)14.0, (double)6.0, (double)14.5), Block.m_49796_((double)0.0, (double)6.0, (double)12.5, (double)14.0, (double)15.0, (double)14.5), Block.m_49796_((double)14.0, (double)3.5, (double)12.0, (double)16.0, (double)15.5, (double)15.0), Block.m_49796_((double)14.0, (double)3.5, (double)2.0, (double)16.0, (double)11.5, (double)12.0), Block.m_49796_((double)14.0, (double)3.5, (double)1.0, (double)16.0, (double)6.5, (double)2.0), Block.m_49796_((double)12.0, (double)2.0, (double)1.5, (double)14.0, (double)4.0, (double)3.5), Block.m_49796_((double)12.0, (double)2.0, (double)12.5, (double)14.0, (double)4.0, (double)14.5), Block.m_49796_((double)12.0, (double)3.0, (double)3.5, (double)14.0, (double)4.0, (double)12.5), Block.m_49796_((double)11.5, (double)0.0, (double)1.0, (double)14.5, (double)2.0, (double)4.0), Block.m_49796_((double)11.5, (double)0.0, (double)12.0, (double)14.5, (double)2.0, (double)15.0)});
        }

        @Override
        protected VoxelShape sofaRightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)4.0, (double)1.5, (double)16.0, (double)6.0, (double)14.5), Block.m_49796_((double)2.0, (double)6.0, (double)12.5, (double)16.0, (double)15.0, (double)14.5), Block.m_49796_((double)0.0, (double)3.5, (double)12.0, (double)2.0, (double)15.5, (double)15.0), Block.m_49796_((double)0.0, (double)3.5, (double)2.0, (double)2.0, (double)11.5, (double)12.0), Block.m_49796_((double)0.0, (double)3.5, (double)1.0, (double)2.0, (double)6.5, (double)2.0), Block.m_49796_((double)2.0, (double)2.0, (double)1.5, (double)4.0, (double)4.0, (double)3.5), Block.m_49796_((double)2.0, (double)2.0, (double)12.5, (double)4.0, (double)4.0, (double)14.5), Block.m_49796_((double)2.0, (double)3.0, (double)3.5, (double)4.0, (double)4.0, (double)12.5), Block.m_49796_((double)1.5, (double)0.0, (double)1.0, (double)4.5, (double)2.0, (double)4.0), Block.m_49796_((double)1.5, (double)0.0, (double)12.0, (double)4.5, (double)2.0, (double)15.0)});
        }

        @Override
        protected VoxelShape sofaCornerShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)11.5, (double)4.0, (double)2.0, (double)14.5), Block.m_49796_((double)11.5, (double)0.0, (double)11.5, (double)14.5, (double)2.0, (double)14.5), Block.m_49796_((double)11.5, (double)0.0, (double)1.0, (double)14.5, (double)2.0, (double)4.0), Block.m_49796_((double)12.0, (double)2.0, (double)1.5, (double)14.0, (double)4.0, (double)3.5), Block.m_49796_((double)1.5, (double)2.0, (double)1.5, (double)3.5, (double)4.0, (double)3.5), Block.m_49796_((double)1.5, (double)2.0, (double)12.0, (double)3.5, (double)4.0, (double)14.0), Block.m_49796_((double)12.0, (double)2.0, (double)12.0, (double)14.0, (double)4.0, (double)14.0), Block.m_49796_((double)0.0, (double)4.0, (double)1.5, (double)1.5, (double)6.0, (double)14.5), Block.m_49796_((double)1.5, (double)4.0, (double)0.0, (double)14.5, (double)6.0, (double)14.5), Block.m_49796_((double)12.5, (double)6.0, (double)0.0, (double)14.5, (double)15.0, (double)14.5), Block.m_49796_((double)12.0, (double)4.0, (double)12.0, (double)15.0, (double)15.5, (double)15.0), Block.m_49796_((double)0.0, (double)6.0, (double)12.5, (double)12.0, (double)15.0, (double)14.5)});
        }

        @Override
        protected VoxelShape stoolShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)1.5, (double)2.0, (double)12.5, (double)3.5, (double)5.0, (double)14.5), Block.m_49796_((double)1.5, (double)2.0, (double)1.5, (double)3.5, (double)5.0, (double)3.5), Block.m_49796_((double)12.5, (double)2.0, (double)12.5, (double)14.5, (double)5.0, (double)14.5), Block.m_49796_((double)12.5, (double)2.0, (double)1.5, (double)14.5, (double)5.0, (double)3.5), Block.m_49796_((double)1.0, (double)5.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0)});
        }

        @Override
        protected VoxelShape tableLargeShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-12.0, (double)2.0, (double)4.0), Block.m_49796_((double)-15.0, (double)0.0, (double)28.0, (double)-12.0, (double)2.0, (double)31.0), Block.m_49796_((double)12.0, (double)0.0, (double)28.0, (double)15.0, (double)2.0, (double)31.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.0, (double)12.0, (double)1.0, (double)15.0, (double)14.0, (double)4.0), Block.m_49796_((double)-15.0, (double)12.0, (double)1.0, (double)-12.0, (double)14.0, (double)4.0), Block.m_49796_((double)12.0, (double)12.0, (double)28.0, (double)15.0, (double)14.0, (double)31.0), Block.m_49796_((double)-15.0, (double)12.0, (double)28.0, (double)-12.0, (double)14.0, (double)31.0), Block.m_49796_((double)12.5, (double)2.0, (double)1.5, (double)14.5, (double)12.0, (double)3.5), Block.m_49796_((double)-14.5, (double)2.0, (double)1.5, (double)-12.5, (double)12.0, (double)3.5), Block.m_49796_((double)12.5, (double)2.0, (double)28.5, (double)14.5, (double)12.0, (double)30.5), Block.m_49796_((double)-14.5, (double)2.0, (double)28.5, (double)-12.5, (double)12.0, (double)30.5), Block.m_49796_((double)-16.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)32.0)});
        }

        @Override
        protected VoxelShape tableSmallShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.0, (double)12.0, (double)1.0, (double)15.0, (double)14.0, (double)4.0), Block.m_49796_((double)1.0, (double)12.0, (double)1.0, (double)4.0, (double)14.0, (double)4.0), Block.m_49796_((double)12.0, (double)12.0, (double)12.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)1.0, (double)12.0, (double)12.0, (double)4.0, (double)14.0, (double)15.0), Block.m_49796_((double)12.5, (double)2.0, (double)1.5, (double)14.5, (double)12.0, (double)3.5), Block.m_49796_((double)1.5, (double)2.0, (double)1.5, (double)3.5, (double)12.0, (double)3.5), Block.m_49796_((double)12.5, (double)2.0, (double)12.5, (double)14.5, (double)12.0, (double)14.5), Block.m_49796_((double)1.5, (double)2.0, (double)12.5, (double)3.5, (double)12.0, (double)14.5), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape tableWideShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-12.0, (double)2.0, (double)4.0), Block.m_49796_((double)-15.0, (double)0.0, (double)12.0, (double)-12.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.0, (double)12.0, (double)1.0, (double)15.0, (double)14.0, (double)4.0), Block.m_49796_((double)-15.0, (double)12.0, (double)1.0, (double)-12.0, (double)14.0, (double)4.0), Block.m_49796_((double)12.0, (double)12.0, (double)12.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)-15.0, (double)12.0, (double)12.0, (double)-12.0, (double)14.0, (double)15.0), Block.m_49796_((double)12.5, (double)2.0, (double)1.5, (double)14.5, (double)12.0, (double)3.5), Block.m_49796_((double)-14.5, (double)2.0, (double)1.5, (double)-12.5, (double)12.0, (double)3.5), Block.m_49796_((double)12.5, (double)2.0, (double)12.5, (double)14.5, (double)12.0, (double)14.5), Block.m_49796_((double)-14.5, (double)2.0, (double)12.5, (double)-12.5, (double)12.0, (double)14.5), Block.m_49796_((double)-16.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape wallLightShape() {
            return Block.m_49796_((double)6.0, (double)4.0, (double)9.0, (double)10.0, (double)15.0, (double)16.0);
        }

        @Override
        protected VoxelShape wardrobeTopShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)11.0, (double)10.0, (double)1.0, (double)15.0, (double)12.0, (double)5.0), Block.m_49796_((double)-15.0, (double)10.0, (double)1.0, (double)-11.0, (double)12.0, (double)5.0), Block.m_49796_((double)-15.0, (double)10.0, (double)11.0, (double)-11.0, (double)12.0, (double)15.0), Block.m_49796_((double)11.0, (double)10.0, (double)11.0, (double)15.0, (double)12.0, (double)15.0), Block.m_49796_((double)11.0, (double)7.0, (double)11.0, (double)15.0, (double)9.0, (double)15.0), Block.m_49796_((double)11.0, (double)7.0, (double)1.0, (double)15.0, (double)9.0, (double)5.0), Block.m_49796_((double)-15.0, (double)7.0, (double)1.0, (double)-11.0, (double)9.0, (double)5.0), Block.m_49796_((double)-15.0, (double)7.0, (double)11.0, (double)-11.0, (double)9.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)10.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)4.0), Block.m_49796_((double)-14.0, (double)0.0, (double)2.0, (double)-12.0, (double)10.0, (double)4.0), Block.m_49796_((double)-14.0, (double)0.0, (double)12.0, (double)-12.0, (double)10.0, (double)14.0), Block.m_49796_((double)-14.0, (double)0.0, (double)2.0, (double)14.0, (double)10.5, (double)14.0)});
        }

        @Override
        protected VoxelShape wardrobeBottomShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)5.0), Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-11.0, (double)2.0, (double)5.0), Block.m_49796_((double)-15.0, (double)0.0, (double)11.0, (double)-11.0, (double)2.0, (double)15.0), Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)2.0, (double)12.0, (double)14.0, (double)30.0, (double)14.0), Block.m_49796_((double)-14.0, (double)2.0, (double)12.0, (double)-12.0, (double)30.0, (double)14.0), Block.m_49796_((double)-14.0, (double)2.0, (double)2.0, (double)-12.0, (double)30.0, (double)4.0), Block.m_49796_((double)12.0, (double)2.0, (double)2.0, (double)14.0, (double)30.0, (double)4.0), Block.m_49796_((double)-15.0, (double)3.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0), Block.m_49796_((double)-15.0, (double)30.0, (double)1.0, (double)15.0, (double)32.0, (double)15.0), Block.m_49796_((double)-14.0, (double)5.0, (double)2.0, (double)14.0, (double)30.0, (double)14.0)});
        }

        @Override
        protected VoxelShape doorDoubleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0), Block.m_49796_((double)0.0, (double)29.0, (double)0.0, (double)16.0, (double)32.0, (double)3.0), Block.m_49796_((double)14.0, (double)2.0, (double)0.5, (double)16.0, (double)29.0, (double)2.5), Block.m_49796_((double)10.5, (double)2.0, (double)0.5, (double)12.5, (double)29.0, (double)2.5), Block.m_49796_((double)7.0, (double)2.0, (double)0.5, (double)9.0, (double)29.0, (double)2.5), Block.m_49796_((double)3.5, (double)2.0, (double)0.5, (double)5.5, (double)29.0, (double)2.5), Block.m_49796_((double)0.0, (double)2.0, (double)0.5, (double)2.0, (double)29.0, (double)2.5)});
        }

        @Override
        protected VoxelShape doorSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0), Block.m_49796_((double)0.0, (double)29.0, (double)0.0, (double)16.0, (double)32.0, (double)3.0), Block.m_49796_((double)14.0, (double)2.0, (double)0.5, (double)16.0, (double)29.0, (double)2.5), Block.m_49796_((double)10.5, (double)2.0, (double)0.5, (double)12.5, (double)29.0, (double)2.5), Block.m_49796_((double)7.0, (double)2.0, (double)0.5, (double)9.0, (double)29.0, (double)2.5), Block.m_49796_((double)3.5, (double)2.0, (double)0.5, (double)5.5, (double)29.0, (double)2.5), Block.m_49796_((double)0.0, (double)2.0, (double)0.5, (double)2.0, (double)29.0, (double)2.5)});
        }

        @Override
        protected VoxelShape counterSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)1.0, (double)2.0, (double)2.0, (double)15.0, (double)11.0, (double)3.0)});
        }

        @Override
        protected VoxelShape counterCornerShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)13.0, (double)3.0), Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape ovenShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)2.0, (double)3.0), Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)2.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)3.0), Block.m_49796_((double)13.0, (double)12.0, (double)0.0, (double)16.0, (double)14.0, (double)3.0), Block.m_49796_((double)13.0, (double)12.0, (double)13.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)12.0, (double)13.0, (double)3.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)3.0, (double)14.0, (double)3.0), Block.m_49796_((double)0.5, (double)0.5, (double)0.5, (double)15.5, (double)14.0, (double)15.5), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }
    }

    private static final class Royal
    extends HitBoxes {
        private Royal() {
        }

        @Override
        protected VoxelShape bedDoubleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-16.0, (double)0.0, (double)0.0, (double)-13.0, (double)3.0, (double)2.0), Block.m_49796_((double)-15.0, (double)3.0, (double)0.0, (double)-13.0, (double)9.0, (double)2.0), Block.m_49796_((double)-16.0, (double)9.0, (double)0.0, (double)-13.0, (double)12.0, (double)2.0), Block.m_49796_((double)-16.0, (double)9.0, (double)30.0, (double)-13.0, (double)12.0, (double)32.0), Block.m_49796_((double)-16.0, (double)0.0, (double)30.0, (double)-13.0, (double)3.0, (double)32.0), Block.m_49796_((double)-15.0, (double)3.0, (double)30.0, (double)-13.0, (double)9.0, (double)32.0), Block.m_49796_((double)13.0, (double)9.0, (double)30.0, (double)16.0, (double)12.0, (double)32.0), Block.m_49796_((double)13.0, (double)0.0, (double)30.0, (double)16.0, (double)3.0, (double)32.0), Block.m_49796_((double)13.0, (double)3.0, (double)30.0, (double)15.0, (double)9.0, (double)32.0), Block.m_49796_((double)13.0, (double)9.0, (double)0.0, (double)16.0, (double)12.0, (double)2.0), Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0), Block.m_49796_((double)13.0, (double)3.0, (double)0.0, (double)15.0, (double)9.0, (double)2.0), Block.m_49796_((double)-15.0, (double)3.0, (double)2.0, (double)15.0, (double)5.0, (double)32.0), Block.m_49796_((double)-13.0, (double)2.0, (double)30.0, (double)-12.0, (double)3.0, (double)32.0), Block.m_49796_((double)12.0, (double)2.0, (double)30.0, (double)13.0, (double)3.0, (double)32.0), Block.m_49796_((double)12.0, (double)2.0, (double)0.0, (double)13.0, (double)3.0, (double)2.0), Block.m_49796_((double)-13.0, (double)2.0, (double)0.0, (double)-12.0, (double)3.0, (double)2.0), Block.m_49796_((double)-14.0, (double)3.0, (double)0.0, (double)14.0, (double)15.0, (double)2.0), Block.m_49796_((double)-14.0, (double)3.0, (double)30.0, (double)14.0, (double)15.0, (double)32.0), Block.m_49796_((double)-14.0, (double)3.0, (double)2.0, (double)14.0, (double)8.0, (double)30.0)});
        }

        @Override
        protected VoxelShape bedSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)2.0), Block.m_49796_((double)1.0, (double)3.0, (double)0.0, (double)3.0, (double)9.0, (double)2.0), Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)3.0, (double)12.0, (double)2.0), Block.m_49796_((double)0.0, (double)9.0, (double)30.0, (double)3.0, (double)12.0, (double)32.0), Block.m_49796_((double)0.0, (double)0.0, (double)30.0, (double)3.0, (double)3.0, (double)32.0), Block.m_49796_((double)1.0, (double)3.0, (double)30.0, (double)3.0, (double)9.0, (double)32.0), Block.m_49796_((double)13.0, (double)9.0, (double)30.0, (double)16.0, (double)12.0, (double)32.0), Block.m_49796_((double)13.0, (double)0.0, (double)30.0, (double)16.0, (double)3.0, (double)32.0), Block.m_49796_((double)13.0, (double)3.0, (double)30.0, (double)15.0, (double)9.0, (double)32.0), Block.m_49796_((double)13.0, (double)9.0, (double)0.0, (double)16.0, (double)12.0, (double)2.0), Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0), Block.m_49796_((double)13.0, (double)3.0, (double)0.0, (double)15.0, (double)9.0, (double)2.0), Block.m_49796_((double)1.0, (double)3.0, (double)2.0, (double)15.0, (double)5.0, (double)32.0), Block.m_49796_((double)3.0, (double)2.0, (double)30.0, (double)4.0, (double)3.0, (double)32.0), Block.m_49796_((double)12.0, (double)2.0, (double)30.0, (double)13.0, (double)3.0, (double)32.0), Block.m_49796_((double)12.0, (double)2.0, (double)0.0, (double)13.0, (double)3.0, (double)2.0), Block.m_49796_((double)3.0, (double)2.0, (double)0.0, (double)4.0, (double)3.0, (double)2.0), Block.m_49796_((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)15.0, (double)2.0), Block.m_49796_((double)2.0, (double)3.0, (double)30.0, (double)14.0, (double)15.0, (double)32.0), Block.m_49796_((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)8.0, (double)30.0)});
        }

        @Override
        protected VoxelShape benchShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-11.0, (double)4.0, (double)5.0), Block.m_49796_((double)-15.0, (double)0.0, (double)11.0, (double)-11.0, (double)4.0, (double)15.0), Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)15.0, (double)4.0, (double)15.0), Block.m_49796_((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)5.0), Block.m_49796_((double)-14.5, (double)4.0, (double)1.5, (double)14.5, (double)6.0, (double)14.5)});
        }

        @Override
        protected VoxelShape bookshelfShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)4.0), Block.m_49796_((double)-16.0, (double)0.0, (double)0.0, (double)-12.0, (double)4.0, (double)4.0), Block.m_49796_((double)-16.0, (double)0.0, (double)12.0, (double)-12.0, (double)4.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)-15.0, (double)4.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0), Block.m_49796_((double)-15.0, (double)30.0, (double)1.0, (double)15.0, (double)32.0, (double)15.0), Block.m_49796_((double)12.0, (double)6.0, (double)2.0, (double)14.0, (double)30.0, (double)4.0), Block.m_49796_((double)12.0, (double)6.0, (double)12.0, (double)14.0, (double)30.0, (double)14.0), Block.m_49796_((double)-14.0, (double)6.0, (double)12.0, (double)-12.0, (double)30.0, (double)14.0), Block.m_49796_((double)-14.0, (double)6.0, (double)2.0, (double)-12.0, (double)30.0, (double)4.0), Block.m_49796_((double)-13.0, (double)6.0, (double)4.0, (double)13.0, (double)30.0, (double)13.0), Block.m_49796_((double)-13.0, (double)17.0, (double)2.0, (double)13.0, (double)19.0, (double)4.0)});
        }

        @Override
        protected VoxelShape chairShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)3.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)3.0, (double)3.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)12.0, (double)15.0, (double)3.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)4.0), Block.m_49796_((double)13.0, (double)3.0, (double)2.0, (double)15.0, (double)5.0, (double)4.0), Block.m_49796_((double)13.0, (double)3.0, (double)12.0, (double)15.0, (double)5.0, (double)14.0), Block.m_49796_((double)1.0, (double)3.0, (double)12.0, (double)3.0, (double)5.0, (double)14.0), Block.m_49796_((double)1.0, (double)3.0, (double)2.0, (double)3.0, (double)5.0, (double)4.0), Block.m_49796_((double)1.0, (double)5.0, (double)1.5, (double)15.0, (double)7.0, (double)14.5), Block.m_49796_((double)1.0, (double)7.0, (double)2.0, (double)15.0, (double)9.0, (double)14.0), Block.m_49796_((double)13.0, (double)9.0, (double)2.0, (double)15.0, (double)12.0, (double)4.0), Block.m_49796_((double)1.0, (double)9.0, (double)2.0, (double)3.0, (double)12.0, (double)4.0), Block.m_49796_((double)1.0, (double)12.0, (double)1.0, (double)3.0, (double)15.0, (double)4.0), Block.m_49796_((double)13.0, (double)12.0, (double)1.0, (double)15.0, (double)15.0, (double)4.0), Block.m_49796_((double)13.0, (double)12.0, (double)4.0, (double)15.0, (double)14.0, (double)12.0), Block.m_49796_((double)1.0, (double)12.0, (double)4.0, (double)3.0, (double)14.0, (double)12.0), Block.m_49796_((double)1.0, (double)7.0, (double)12.0, (double)15.0, (double)14.0, (double)14.0), Block.m_49796_((double)2.0, (double)14.0, (double)12.0, (double)14.0, (double)20.0, (double)14.0), Block.m_49796_((double)1.0, (double)20.0, (double)12.0, (double)15.0, (double)25.0, (double)14.0), Block.m_49796_((double)3.0, (double)25.0, (double)12.0, (double)13.0, (double)26.0, (double)14.0), Block.m_49796_((double)5.0, (double)26.0, (double)12.0, (double)11.0, (double)27.0, (double)14.0)});
        }

        @Override
        protected VoxelShape chandelierShape() {
            return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }

        @Override
        protected VoxelShape chestShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)7.5, (double)0.0, (double)0.75, (double)11.25, (double)4.0, (double)4.5), Block.m_49796_((double)-11.25, (double)0.0, (double)0.75, (double)-7.5, (double)4.0, (double)4.5), Block.m_49796_((double)-11.25, (double)0.0, (double)11.5, (double)-7.5, (double)4.0, (double)15.25), Block.m_49796_((double)7.5, (double)0.0, (double)11.5, (double)11.25, (double)4.0, (double)15.25), Block.m_49796_((double)-12.0, (double)4.0, (double)1.0, (double)12.0, (double)6.0, (double)15.0), Block.m_49796_((double)-11.0, (double)6.0, (double)2.0, (double)11.0, (double)16.0, (double)14.0)});
        }

        @Override
        protected VoxelShape cushionShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)5.0, (double)4.0, (double)5.0), Block.m_49796_((double)1.0, (double)0.0, (double)11.0, (double)5.0, (double)4.0, (double)15.0), Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)15.0, (double)4.0, (double)15.0), Block.m_49796_((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)5.0), Block.m_49796_((double)1.5, (double)4.0, (double)1.5, (double)14.5, (double)6.0, (double)14.5), Block.m_49796_((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0)});
        }

        @Override
        protected VoxelShape deskLeftShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-16.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)11.0, (double)1.0, (double)15.0, (double)14.0, (double)4.0), Block.m_49796_((double)13.0, (double)3.0, (double)2.0, (double)15.0, (double)11.0, (double)4.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)4.0), Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-13.0, (double)3.0, (double)4.0), Block.m_49796_((double)-15.0, (double)11.0, (double)1.0, (double)-13.0, (double)14.0, (double)4.0), Block.m_49796_((double)-15.0, (double)3.0, (double)2.0, (double)-13.0, (double)11.0, (double)4.0), Block.m_49796_((double)-15.0, (double)0.0, (double)12.0, (double)-13.0, (double)3.0, (double)15.0), Block.m_49796_((double)-15.0, (double)11.0, (double)12.0, (double)-13.0, (double)14.0, (double)15.0), Block.m_49796_((double)-15.0, (double)3.0, (double)12.0, (double)-13.0, (double)11.0, (double)14.0), Block.m_49796_((double)13.0, (double)0.0, (double)12.0, (double)15.0, (double)3.0, (double)15.0), Block.m_49796_((double)13.0, (double)11.0, (double)12.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)13.0, (double)3.0, (double)12.0, (double)15.0, (double)11.0, (double)14.0), Block.m_49796_((double)4.0, (double)10.0, (double)2.0, (double)12.0, (double)14.0, (double)14.0), Block.m_49796_((double)6.0, (double)12.0, (double)1.0, (double)10.0, (double)13.0, (double)2.0)});
        }

        @Override
        protected VoxelShape deskRightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-16.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)11.0, (double)1.0, (double)15.0, (double)14.0, (double)4.0), Block.m_49796_((double)13.0, (double)3.0, (double)2.0, (double)15.0, (double)11.0, (double)4.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)4.0), Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-13.0, (double)3.0, (double)4.0), Block.m_49796_((double)-15.0, (double)11.0, (double)1.0, (double)-13.0, (double)14.0, (double)4.0), Block.m_49796_((double)-15.0, (double)3.0, (double)2.0, (double)-13.0, (double)11.0, (double)4.0), Block.m_49796_((double)-15.0, (double)0.0, (double)12.0, (double)-13.0, (double)3.0, (double)15.0), Block.m_49796_((double)-15.0, (double)11.0, (double)12.0, (double)-13.0, (double)14.0, (double)15.0), Block.m_49796_((double)-15.0, (double)3.0, (double)12.0, (double)-13.0, (double)11.0, (double)14.0), Block.m_49796_((double)13.0, (double)0.0, (double)12.0, (double)15.0, (double)3.0, (double)15.0), Block.m_49796_((double)13.0, (double)11.0, (double)12.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)13.0, (double)3.0, (double)12.0, (double)15.0, (double)11.0, (double)14.0), Block.m_49796_((double)-12.0, (double)10.0, (double)2.0, (double)-4.0, (double)14.0, (double)14.0), Block.m_49796_((double)-10.0, (double)12.0, (double)1.0, (double)-6.0, (double)13.0, (double)2.0)});
        }

        @Override
        protected VoxelShape drawerShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)3.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)3.0, (double)3.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)12.0, (double)15.0, (double)3.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)4.0), Block.m_49796_((double)13.0, (double)3.0, (double)2.0, (double)15.0, (double)14.0, (double)4.0), Block.m_49796_((double)1.0, (double)3.0, (double)2.0, (double)3.0, (double)14.0, (double)4.0), Block.m_49796_((double)1.0, (double)3.0, (double)12.0, (double)3.0, (double)14.0, (double)14.0), Block.m_49796_((double)13.0, (double)3.0, (double)12.0, (double)15.0, (double)14.0, (double)14.0), Block.m_49796_((double)0.5, (double)5.0, (double)1.5, (double)15.5, (double)7.0, (double)14.5), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)2.0, (double)7.0, (double)3.0, (double)14.0, (double)14.0, (double)13.0)});
        }

        @Override
        protected VoxelShape dresserShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-13.0, (double)3.0, (double)4.0), Block.m_49796_((double)-15.0, (double)0.0, (double)12.0, (double)-13.0, (double)3.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)12.0, (double)15.0, (double)3.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)4.0), Block.m_49796_((double)13.0, (double)3.0, (double)2.0, (double)15.0, (double)14.0, (double)4.0), Block.m_49796_((double)-15.0, (double)3.0, (double)2.0, (double)-13.0, (double)14.0, (double)4.0), Block.m_49796_((double)-15.0, (double)3.0, (double)12.0, (double)-13.0, (double)14.0, (double)14.0), Block.m_49796_((double)13.0, (double)3.0, (double)12.0, (double)15.0, (double)14.0, (double)14.0), Block.m_49796_((double)-15.5, (double)5.0, (double)1.5, (double)15.5, (double)7.0, (double)14.5), Block.m_49796_((double)-16.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)-14.0, (double)7.0, (double)3.0, (double)14.0, (double)14.0, (double)13.0)});
        }

        @Override
        protected VoxelShape lockboxShape() {
            return Block.m_49796_((double)2.5, (double)0.0, (double)3.5, (double)13.5, (double)9.25, (double)12.5);
        }

        @Override
        protected VoxelShape floorLightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0), Block.m_49796_((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)30.0, (double)9.0), Block.m_49796_((double)3.0, (double)20.0, (double)7.0, (double)13.0, (double)22.0, (double)9.0), Block.m_49796_((double)11.0, (double)22.0, (double)7.0, (double)13.0, (double)29.0, (double)9.0), Block.m_49796_((double)3.0, (double)22.0, (double)7.0, (double)5.0, (double)29.0, (double)9.0), Block.m_49796_((double)2.5, (double)24.0, (double)6.5, (double)5.5, (double)25.0, (double)9.5), Block.m_49796_((double)6.5, (double)25.0, (double)6.5, (double)9.5, (double)26.0, (double)9.5), Block.m_49796_((double)10.5, (double)24.0, (double)6.5, (double)13.5, (double)25.0, (double)9.5)});
        }

        @Override
        protected VoxelShape paintingSmallShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)3.0, (double)3.0, (double)16.0), Block.m_49796_((double)0.0, (double)13.0, (double)14.0, (double)3.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)13.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)3.0, (double)1.0, (double)14.0, (double)13.0, (double)3.0, (double)16.0), Block.m_49796_((double)3.0, (double)13.0, (double)14.0, (double)13.0, (double)15.0, (double)16.0), Block.m_49796_((double)1.0, (double)3.0, (double)14.0, (double)15.0, (double)13.0, (double)16.0)});
        }

        @Override
        protected VoxelShape paintingWideShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-16.0, (double)0.0, (double)14.0, (double)-13.0, (double)3.0, (double)16.0), Block.m_49796_((double)-16.0, (double)13.0, (double)14.0, (double)-13.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)13.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)-13.0, (double)1.0, (double)14.0, (double)13.0, (double)3.0, (double)16.0), Block.m_49796_((double)-13.0, (double)13.0, (double)14.0, (double)13.0, (double)15.0, (double)16.0), Block.m_49796_((double)-15.0, (double)3.0, (double)14.0, (double)15.0, (double)13.0, (double)16.0)});
        }

        @Override
        protected VoxelShape shelfSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)11.0, (double)3.0, (double)15.0, (double)14.0, (double)6.0), Block.m_49796_((double)13.0, (double)12.0, (double)6.0, (double)15.0, (double)14.0, (double)16.0), Block.m_49796_((double)13.0, (double)8.0, (double)14.0, (double)15.0, (double)12.0, (double)16.0), Block.m_49796_((double)13.0, (double)5.0, (double)13.0, (double)15.0, (double)8.0, (double)16.0), Block.m_49796_((double)1.0, (double)5.0, (double)13.0, (double)3.0, (double)8.0, (double)16.0), Block.m_49796_((double)1.0, (double)11.0, (double)3.0, (double)3.0, (double)14.0, (double)6.0), Block.m_49796_((double)1.0, (double)12.0, (double)6.0, (double)3.0, (double)14.0, (double)16.0), Block.m_49796_((double)1.0, (double)8.0, (double)14.0, (double)3.0, (double)12.0, (double)16.0)});
        }

        @Override
        protected VoxelShape shelfCenterShape() {
            return Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }

        @Override
        protected VoxelShape shelfLeftShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)11.0, (double)3.0, (double)15.0, (double)14.0, (double)6.0), Block.m_49796_((double)13.0, (double)12.0, (double)6.0, (double)15.0, (double)14.0, (double)16.0), Block.m_49796_((double)13.0, (double)8.0, (double)14.0, (double)15.0, (double)12.0, (double)16.0), Block.m_49796_((double)13.0, (double)5.0, (double)13.0, (double)15.0, (double)8.0, (double)16.0)});
        }

        @Override
        protected VoxelShape shelfRightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)1.0, (double)11.0, (double)3.0, (double)3.0, (double)14.0, (double)6.0), Block.m_49796_((double)1.0, (double)12.0, (double)6.0, (double)3.0, (double)14.0, (double)16.0), Block.m_49796_((double)1.0, (double)8.0, (double)14.0, (double)3.0, (double)12.0, (double)16.0), Block.m_49796_((double)1.0, (double)5.0, (double)13.0, (double)3.0, (double)8.0, (double)16.0)});
        }

        @Override
        protected VoxelShape sofaSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)13.0, (double)0.0, (double)12.0, (double)15.0, (double)3.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)3.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)3.0, (double)3.0, (double)15.0), Block.m_49796_((double)1.0, (double)3.0, (double)12.0, (double)3.0, (double)4.0, (double)14.0), Block.m_49796_((double)13.0, (double)3.0, (double)12.0, (double)15.0, (double)4.0, (double)14.0), Block.m_49796_((double)13.0, (double)3.0, (double)2.0, (double)15.0, (double)4.0, (double)4.0), Block.m_49796_((double)1.0, (double)3.0, (double)2.0, (double)3.0, (double)4.0, (double)4.0), Block.m_49796_((double)1.0, (double)4.0, (double)1.5, (double)15.0, (double)6.0, (double)14.5), Block.m_49796_((double)13.0, (double)6.0, (double)2.0, (double)15.0, (double)9.0, (double)12.0), Block.m_49796_((double)1.0, (double)6.0, (double)2.0, (double)3.0, (double)9.0, (double)12.0), Block.m_49796_((double)1.0, (double)6.0, (double)12.0, (double)15.0, (double)13.0, (double)14.0), Block.m_49796_((double)2.0, (double)13.0, (double)12.0, (double)14.0, (double)15.0, (double)14.0), Block.m_49796_((double)4.0, (double)15.0, (double)12.0, (double)12.0, (double)16.0, (double)14.0)});
        }

        @Override
        protected VoxelShape sofaCenterShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)4.0, (double)1.5, (double)16.0, (double)6.0, (double)14.5), Block.m_49796_((double)0.0, (double)6.0, (double)12.0, (double)16.0, (double)16.0, (double)14.0)});
        }

        @Override
        protected VoxelShape sofaLeftShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)4.0), Block.m_49796_((double)13.0, (double)0.0, (double)12.0, (double)15.0, (double)3.0, (double)15.0), Block.m_49796_((double)13.0, (double)3.0, (double)12.0, (double)15.0, (double)4.0, (double)14.0), Block.m_49796_((double)13.0, (double)3.0, (double)2.0, (double)15.0, (double)4.0, (double)4.0), Block.m_49796_((double)0.0, (double)4.0, (double)1.5, (double)15.0, (double)6.0, (double)14.5), Block.m_49796_((double)0.0, (double)6.0, (double)12.0, (double)15.0, (double)13.0, (double)14.0), Block.m_49796_((double)0.0, (double)13.0, (double)12.0, (double)14.0, (double)15.0, (double)14.0), Block.m_49796_((double)0.0, (double)15.0, (double)12.0, (double)12.0, (double)16.0, (double)14.0), Block.m_49796_((double)13.0, (double)6.0, (double)2.0, (double)15.0, (double)9.0, (double)12.0)});
        }

        @Override
        protected VoxelShape sofaRightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)3.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)3.0, (double)3.0, (double)15.0), Block.m_49796_((double)1.0, (double)3.0, (double)12.0, (double)3.0, (double)4.0, (double)14.0), Block.m_49796_((double)1.0, (double)3.0, (double)2.0, (double)3.0, (double)4.0, (double)4.0), Block.m_49796_((double)1.0, (double)4.0, (double)1.5, (double)16.0, (double)6.0, (double)14.5), Block.m_49796_((double)1.0, (double)6.0, (double)12.0, (double)16.0, (double)13.0, (double)14.0), Block.m_49796_((double)2.0, (double)13.0, (double)12.0, (double)16.0, (double)15.0, (double)14.0), Block.m_49796_((double)4.0, (double)15.0, (double)12.0, (double)16.0, (double)16.0, (double)14.0), Block.m_49796_((double)1.0, (double)6.0, (double)2.0, (double)3.0, (double)9.0, (double)12.0)});
        }

        @Override
        protected VoxelShape sofaCornerShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.5, (double)0.0, (double)0.5, (double)4.25, (double)4.0, (double)4.25), Block.m_49796_((double)11.5, (double)0.0, (double)11.25, (double)15.25, (double)4.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)3.0), Block.m_49796_((double)12.0, (double)3.0, (double)1.0, (double)14.0, (double)4.0, (double)3.0), Block.m_49796_((double)1.0, (double)3.0, (double)12.0, (double)3.0, (double)4.0, (double)14.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)3.0, (double)3.0, (double)15.0), Block.m_49796_((double)0.0, (double)4.0, (double)1.5, (double)1.5, (double)6.0, (double)14.5), Block.m_49796_((double)1.5, (double)4.0, (double)0.0, (double)14.5, (double)6.0, (double)14.5), Block.m_49796_((double)12.0, (double)6.0, (double)0.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)0.0, (double)6.0, (double)12.0, (double)12.0, (double)16.0, (double)14.0)});
        }

        @Override
        protected VoxelShape stoolShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)5.0, (double)4.0, (double)5.0), Block.m_49796_((double)1.0, (double)0.0, (double)11.0, (double)5.0, (double)4.0, (double)15.0), Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)15.0, (double)4.0, (double)15.0), Block.m_49796_((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)5.0), Block.m_49796_((double)1.5, (double)4.0, (double)1.5, (double)14.5, (double)6.0, (double)14.5)});
        }

        @Override
        protected VoxelShape tableLargeShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-11.0, (double)14.0, (double)5.0), Block.m_49796_((double)-15.0, (double)0.0, (double)27.0, (double)-11.0, (double)14.0, (double)31.0), Block.m_49796_((double)11.0, (double)0.0, (double)27.0, (double)15.0, (double)14.0, (double)31.0), Block.m_49796_((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)5.0), Block.m_49796_((double)-16.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)32.0)});
        }

        @Override
        protected VoxelShape tableSmallShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)5.0, (double)14.0, (double)5.0), Block.m_49796_((double)1.0, (double)0.0, (double)11.0, (double)5.0, (double)14.0, (double)15.0), Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)5.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape tableWideShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-11.0, (double)14.0, (double)5.0), Block.m_49796_((double)-15.0, (double)0.0, (double)11.0, (double)-11.0, (double)14.0, (double)15.0), Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)5.0), Block.m_49796_((double)-16.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape wallLightShape() {
            return Block.m_49796_((double)4.75, (double)1.0, (double)11.75, (double)11.25, (double)13.0, (double)16.0);
        }

        @Override
        protected VoxelShape wardrobeTopShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)4.0), Block.m_49796_((double)-14.0, (double)0.0, (double)2.0, (double)-12.0, (double)14.0, (double)4.0), Block.m_49796_((double)-14.0, (double)0.0, (double)12.0, (double)-12.0, (double)14.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)14.0, (double)14.0), Block.m_49796_((double)-15.0, (double)14.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.m_49796_((double)-13.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0)});
        }

        @Override
        protected VoxelShape wardrobeBottomShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)5.0), Block.m_49796_((double)-14.0, (double)0.0, (double)2.0, (double)-12.0, (double)3.0, (double)5.0), Block.m_49796_((double)-14.0, (double)0.0, (double)11.0, (double)-12.0, (double)3.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)11.0, (double)14.0, (double)3.0, (double)14.0), Block.m_49796_((double)12.0, (double)3.0, (double)11.0, (double)14.0, (double)4.0, (double)13.0), Block.m_49796_((double)12.0, (double)3.0, (double)3.0, (double)14.0, (double)4.0, (double)5.0), Block.m_49796_((double)-14.0, (double)3.0, (double)3.0, (double)-12.0, (double)4.0, (double)5.0), Block.m_49796_((double)-14.0, (double)3.0, (double)11.0, (double)-12.0, (double)4.0, (double)13.0), Block.m_49796_((double)-15.0, (double)4.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0), Block.m_49796_((double)12.0, (double)6.0, (double)2.0, (double)14.0, (double)30.0, (double)4.0), Block.m_49796_((double)-14.0, (double)6.0, (double)2.0, (double)-12.0, (double)30.0, (double)4.0), Block.m_49796_((double)-14.0, (double)6.0, (double)12.0, (double)-12.0, (double)30.0, (double)14.0), Block.m_49796_((double)12.0, (double)6.0, (double)12.0, (double)14.0, (double)30.0, (double)14.0), Block.m_49796_((double)-12.0, (double)6.0, (double)3.0, (double)12.0, (double)30.0, (double)13.0), Block.m_49796_((double)-15.0, (double)30.0, (double)1.0, (double)15.0, (double)32.0, (double)15.0)});
        }

        @Override
        protected VoxelShape doorDoubleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.5, (double)14.0, (double)30.0, (double)2.5), Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)3.0), Block.m_49796_((double)13.0, (double)25.0, (double)0.0, (double)14.0, (double)32.0, (double)3.0), Block.m_49796_((double)12.0, (double)27.0, (double)0.0, (double)13.0, (double)32.0, (double)3.0), Block.m_49796_((double)9.0, (double)28.0, (double)0.0, (double)12.0, (double)32.0, (double)3.0), Block.m_49796_((double)5.0, (double)29.0, (double)0.0, (double)9.0, (double)32.0, (double)3.0), Block.m_49796_((double)0.0, (double)30.0, (double)0.0, (double)5.0, (double)32.0, (double)3.0)});
        }

        @Override
        protected VoxelShape doorSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)32.0, (double)3.0), Block.m_49796_((double)2.0, (double)30.0, (double)0.0, (double)14.0, (double)32.0, (double)3.0), Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)3.0), Block.m_49796_((double)2.0, (double)0.0, (double)0.5, (double)14.0, (double)30.0, (double)2.5)});
        }

        @Override
        protected VoxelShape counterSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape counterCornerShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)13.0, (double)3.0), Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape ovenShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.5, (double)4.0, (double)3.5), Block.m_49796_((double)0.0, (double)0.0, (double)12.5, (double)3.5, (double)4.0, (double)16.0), Block.m_49796_((double)12.5, (double)0.0, (double)12.5, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)12.5, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)3.5), Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.5, (double)6.0, (double)0.5, (double)15.5, (double)14.0, (double)15.5), Block.m_49796_((double)2.5, (double)7.0, (double)-0.5, (double)12.5, (double)13.0, (double)0.5)});
        }
    }

    private static final class Necrolord
    extends HitBoxes {
        private Necrolord() {
        }

        @Override
        protected VoxelShape bedDoubleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-16.0, (double)0.0, (double)0.0, (double)-12.0, (double)2.0, (double)4.0), Block.m_49796_((double)-16.0, (double)0.0, (double)28.0, (double)-12.0, (double)2.0, (double)32.0), Block.m_49796_((double)12.0, (double)0.0, (double)28.0, (double)16.0, (double)2.0, (double)32.0), Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.0, (double)13.0, (double)0.0, (double)16.0, (double)15.0, (double)4.0), Block.m_49796_((double)-16.0, (double)13.0, (double)0.0, (double)-12.0, (double)15.0, (double)4.0), Block.m_49796_((double)-16.0, (double)12.0, (double)28.0, (double)-12.0, (double)14.0, (double)32.0), Block.m_49796_((double)12.0, (double)12.0, (double)28.0, (double)16.0, (double)14.0, (double)32.0), Block.m_49796_((double)13.0, (double)2.0, (double)29.0, (double)15.0, (double)12.0, (double)31.0), Block.m_49796_((double)-15.0, (double)2.0, (double)29.0, (double)-13.0, (double)12.0, (double)31.0), Block.m_49796_((double)-15.0, (double)2.0, (double)1.0, (double)-13.0, (double)13.0, (double)3.0), Block.m_49796_((double)13.0, (double)2.0, (double)1.0, (double)15.0, (double)13.0, (double)3.0), Block.m_49796_((double)-13.0, (double)3.0, (double)1.0, (double)13.0, (double)12.0, (double)3.0), Block.m_49796_((double)-13.0, (double)3.0, (double)29.0, (double)13.0, (double)11.0, (double)31.0), Block.m_49796_((double)-15.0, (double)3.0, (double)3.0, (double)15.0, (double)8.0, (double)29.0)});
        }

        @Override
        protected VoxelShape bedSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)2.0, (double)4.0), Block.m_49796_((double)0.0, (double)0.0, (double)28.0, (double)4.0, (double)2.0, (double)32.0), Block.m_49796_((double)12.0, (double)0.0, (double)28.0, (double)16.0, (double)2.0, (double)32.0), Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.0, (double)13.0, (double)0.0, (double)16.0, (double)15.0, (double)4.0), Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)4.0, (double)15.0, (double)4.0), Block.m_49796_((double)0.0, (double)12.0, (double)28.0, (double)4.0, (double)14.0, (double)32.0), Block.m_49796_((double)12.0, (double)12.0, (double)28.0, (double)16.0, (double)14.0, (double)32.0), Block.m_49796_((double)13.0, (double)2.0, (double)29.0, (double)15.0, (double)12.0, (double)31.0), Block.m_49796_((double)1.0, (double)2.0, (double)29.0, (double)3.0, (double)12.0, (double)31.0), Block.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)3.0, (double)13.0, (double)3.0), Block.m_49796_((double)13.0, (double)2.0, (double)1.0, (double)15.0, (double)13.0, (double)3.0), Block.m_49796_((double)3.0, (double)3.0, (double)1.0, (double)13.0, (double)12.0, (double)3.0), Block.m_49796_((double)3.0, (double)3.0, (double)29.0, (double)13.0, (double)11.0, (double)31.0), Block.m_49796_((double)1.0, (double)3.0, (double)3.0, (double)15.0, (double)8.0, (double)29.0)});
        }

        @Override
        protected VoxelShape benchShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.0, (double)5.0, (double)0.0, (double)16.0, (double)7.0, (double)4.0), Block.m_49796_((double)12.0, (double)5.0, (double)12.0, (double)16.0, (double)7.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)-16.0, (double)0.0, (double)12.0, (double)-12.0, (double)2.0, (double)16.0), Block.m_49796_((double)-16.0, (double)5.0, (double)12.0, (double)-12.0, (double)7.0, (double)16.0), Block.m_49796_((double)-16.0, (double)5.0, (double)0.0, (double)-12.0, (double)7.0, (double)4.0), Block.m_49796_((double)-16.0, (double)0.0, (double)0.0, (double)-12.0, (double)2.0, (double)4.0), Block.m_49796_((double)-15.0, (double)2.0, (double)1.0, (double)-13.0, (double)5.0, (double)3.0), Block.m_49796_((double)-15.0, (double)2.0, (double)13.0, (double)-13.0, (double)5.0, (double)15.0), Block.m_49796_((double)13.0, (double)2.0, (double)13.0, (double)15.0, (double)5.0, (double)15.0), Block.m_49796_((double)13.0, (double)2.0, (double)1.0, (double)15.0, (double)5.0, (double)3.0), Block.m_49796_((double)-15.0, (double)5.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0)});
        }

        @Override
        protected VoxelShape bookshelfShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)4.0), Block.m_49796_((double)-16.0, (double)0.0, (double)0.0, (double)-12.0, (double)2.0, (double)4.0), Block.m_49796_((double)-16.0, (double)0.0, (double)12.0, (double)-12.0, (double)2.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)12.0, (double)15.0, (double)12.0, (double)16.0, (double)17.0, (double)16.0), Block.m_49796_((double)12.0, (double)15.0, (double)0.0, (double)16.0, (double)17.0, (double)4.0), Block.m_49796_((double)-16.0, (double)15.0, (double)0.0, (double)-12.0, (double)17.0, (double)4.0), Block.m_49796_((double)-16.0, (double)15.0, (double)12.0, (double)-12.0, (double)17.0, (double)16.0), Block.m_49796_((double)-16.0, (double)30.0, (double)12.0, (double)-12.0, (double)32.0, (double)16.0), Block.m_49796_((double)12.0, (double)30.0, (double)12.0, (double)16.0, (double)32.0, (double)16.0), Block.m_49796_((double)12.0, (double)30.0, (double)0.0, (double)16.0, (double)32.0, (double)4.0), Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)15.0, (double)32.0, (double)15.0)});
        }

        @Override
        protected VoxelShape chairShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), Block.m_49796_((double)1.0, (double)7.0, (double)1.0, (double)4.0, (double)9.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0), Block.m_49796_((double)1.0, (double)7.0, (double)12.0, (double)4.0, (double)9.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)7.0, (double)12.0, (double)15.0, (double)9.0, (double)15.0), Block.m_49796_((double)12.0, (double)7.0, (double)1.0, (double)15.0, (double)9.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), Block.m_49796_((double)2.0, (double)9.0, (double)12.0, (double)14.0, (double)24.0, (double)14.0), Block.m_49796_((double)12.0, (double)20.0, (double)11.5, (double)15.0, (double)24.0, (double)14.5), Block.m_49796_((double)1.0, (double)20.0, (double)11.5, (double)4.0, (double)24.0, (double)14.5), Block.m_49796_((double)2.0, (double)24.0, (double)11.5, (double)5.0, (double)27.0, (double)14.5), Block.m_49796_((double)11.0, (double)24.0, (double)11.5, (double)14.0, (double)27.0, (double)14.5), Block.m_49796_((double)10.0, (double)27.0, (double)11.5, (double)12.0, (double)29.0, (double)14.5), Block.m_49796_((double)4.0, (double)27.0, (double)11.5, (double)6.0, (double)29.0, (double)14.5)});
        }

        @Override
        protected VoxelShape chandelierShape() {
            return Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        }

        @Override
        protected VoxelShape chestShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)10.0, (double)0.0, (double)1.0, (double)14.0, (double)2.0, (double)5.0), Block.m_49796_((double)-14.0, (double)0.0, (double)1.0, (double)-10.0, (double)2.0, (double)5.0), Block.m_49796_((double)-14.0, (double)0.0, (double)11.0, (double)-10.0, (double)2.0, (double)15.0), Block.m_49796_((double)10.0, (double)0.0, (double)11.0, (double)14.0, (double)2.0, (double)15.0), Block.m_49796_((double)10.0, (double)5.0, (double)11.0, (double)14.0, (double)7.0, (double)15.0), Block.m_49796_((double)10.0, (double)5.0, (double)1.0, (double)14.0, (double)7.0, (double)5.0), Block.m_49796_((double)-14.0, (double)5.0, (double)1.0, (double)-10.0, (double)7.0, (double)5.0), Block.m_49796_((double)-14.0, (double)5.0, (double)11.0, (double)-10.0, (double)7.0, (double)15.0), Block.m_49796_((double)-12.0, (double)0.0, (double)3.0, (double)12.0, (double)12.0, (double)13.0), Block.m_49796_((double)11.0, (double)0.0, (double)2.0, (double)13.0, (double)9.0, (double)4.0), Block.m_49796_((double)-13.0, (double)0.0, (double)2.0, (double)-11.0, (double)9.0, (double)4.0), Block.m_49796_((double)-13.0, (double)0.0, (double)12.0, (double)-11.0, (double)9.0, (double)14.0), Block.m_49796_((double)11.0, (double)0.0, (double)12.0, (double)13.0, (double)9.0, (double)14.0), Block.m_49796_((double)10.0, (double)9.0, (double)11.0, (double)14.0, (double)11.0, (double)15.0), Block.m_49796_((double)10.0, (double)9.0, (double)1.0, (double)14.0, (double)11.0, (double)5.0), Block.m_49796_((double)-14.0, (double)9.0, (double)1.0, (double)-10.0, (double)11.0, (double)5.0), Block.m_49796_((double)-14.0, (double)9.0, (double)11.0, (double)-10.0, (double)11.0, (double)15.0)});
        }

        @Override
        protected VoxelShape cushionShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)5.0, (double)2.0, (double)5.0), Block.m_49796_((double)2.0, (double)0.0, (double)11.0, (double)5.0, (double)2.0, (double)14.0), Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)14.0, (double)2.0, (double)14.0), Block.m_49796_((double)11.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)5.0), Block.m_49796_((double)11.0, (double)2.0, (double)3.0, (double)13.0, (double)3.0, (double)5.0), Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)5.0, (double)3.0, (double)5.0), Block.m_49796_((double)3.0, (double)2.0, (double)11.0, (double)5.0, (double)3.0, (double)13.0), Block.m_49796_((double)11.0, (double)2.0, (double)11.0, (double)13.0, (double)3.0, (double)13.0), Block.m_49796_((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), Block.m_49796_((double)2.5, (double)4.0, (double)2.5, (double)13.5, (double)7.0, (double)13.5)});
        }

        @Override
        protected VoxelShape deskLeftShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), Block.m_49796_((double)1.0, (double)12.0, (double)1.0, (double)4.0, (double)14.0, (double)4.0), Block.m_49796_((double)1.0, (double)12.0, (double)12.0, (double)4.0, (double)14.0, (double)15.0), Block.m_49796_((double)12.0, (double)12.0, (double)12.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)12.0, (double)12.0, (double)1.0, (double)15.0, (double)14.0, (double)4.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-11.0, (double)2.0, (double)5.0), Block.m_49796_((double)-15.0, (double)12.0, (double)1.0, (double)-11.0, (double)14.0, (double)5.0), Block.m_49796_((double)-15.0, (double)12.0, (double)11.0, (double)-11.0, (double)14.0, (double)15.0), Block.m_49796_((double)-14.0, (double)2.0, (double)12.0, (double)-12.0, (double)12.0, (double)14.0), Block.m_49796_((double)-14.0, (double)2.0, (double)2.0, (double)-12.0, (double)12.0, (double)4.0), Block.m_49796_((double)-16.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)-15.0, (double)0.0, (double)11.0, (double)-11.0, (double)2.0, (double)15.0)});
        }

        @Override
        protected VoxelShape deskRightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)-12.0, (double)2.0, (double)4.0), Block.m_49796_((double)-15.0, (double)0.0, (double)12.0, (double)-12.0, (double)2.0, (double)15.0), Block.m_49796_((double)-4.0, (double)0.0, (double)12.0, (double)-1.0, (double)2.0, (double)15.0), Block.m_49796_((double)-4.0, (double)0.0, (double)1.0, (double)-1.0, (double)2.0, (double)4.0), Block.m_49796_((double)-4.0, (double)12.0, (double)1.0, (double)-1.0, (double)14.0, (double)4.0), Block.m_49796_((double)-4.0, (double)12.0, (double)12.0, (double)-1.0, (double)14.0, (double)15.0), Block.m_49796_((double)-15.0, (double)12.0, (double)12.0, (double)-12.0, (double)14.0, (double)15.0), Block.m_49796_((double)-15.0, (double)12.0, (double)1.0, (double)-12.0, (double)14.0, (double)4.0), Block.m_49796_((double)-14.0, (double)0.0, (double)2.0, (double)-2.0, (double)14.0, (double)14.0), Block.m_49796_((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)5.0), Block.m_49796_((double)11.0, (double)12.0, (double)1.0, (double)15.0, (double)14.0, (double)5.0), Block.m_49796_((double)11.0, (double)12.0, (double)11.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)12.0, (double)2.0, (double)12.0, (double)14.0, (double)12.0, (double)14.0), Block.m_49796_((double)12.0, (double)2.0, (double)2.0, (double)14.0, (double)12.0, (double)4.0), Block.m_49796_((double)-16.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)15.0, (double)2.0, (double)15.0)});
        }

        @Override
        protected VoxelShape drawerShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)2.0, (double)3.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)3.0, (double)16.0, (double)3.0), Block.m_49796_((double)0.0, (double)14.0, (double)13.0, (double)3.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)2.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)13.0, (double)14.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)3.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)});
        }

        @Override
        protected VoxelShape dresserShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-16.0, (double)0.0, (double)0.0, (double)-13.0, (double)2.0, (double)3.0), Block.m_49796_((double)-16.0, (double)0.0, (double)13.0, (double)-13.0, (double)2.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)3.0), Block.m_49796_((double)13.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), Block.m_49796_((double)13.0, (double)14.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)-16.0, (double)14.0, (double)13.0, (double)-13.0, (double)16.0, (double)16.0), Block.m_49796_((double)-16.0, (double)14.0, (double)0.0, (double)-13.0, (double)16.0, (double)3.0), Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)});
        }

        @Override
        protected VoxelShape lockboxShape() {
            return Block.m_49796_((double)0.5, (double)0.0, (double)2.5, (double)15.5, (double)10.0, (double)13.5);
        }

        @Override
        protected VoxelShape floorLightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), Block.m_49796_((double)6.5, (double)2.0, (double)6.5, (double)9.5, (double)4.0, (double)9.5), Block.m_49796_((double)6.5, (double)10.0, (double)6.5, (double)9.5, (double)12.0, (double)9.5), Block.m_49796_((double)7.0, (double)4.0, (double)7.0, (double)9.0, (double)18.0, (double)9.0), Block.m_49796_((double)1.25, (double)18.0, (double)6.5, (double)14.75, (double)25.0, (double)9.5), Block.m_49796_((double)12.25, (double)25.0, (double)7.0, (double)14.25, (double)28.0, (double)9.0), Block.m_49796_((double)1.75, (double)25.0, (double)7.0, (double)3.75, (double)28.0, (double)9.0), Block.m_49796_((double)7.0, (double)25.0, (double)7.0, (double)9.0, (double)29.0, (double)9.0)});
        }

        @Override
        protected VoxelShape paintingSmallShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0), Block.m_49796_((double)0.0, (double)13.0, (double)13.0, (double)3.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)1.0, (double)1.0, (double)14.0, (double)15.0, (double)15.0, (double)16.0)});
        }

        @Override
        protected VoxelShape paintingWideShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-16.0, (double)0.0, (double)13.0, (double)-13.0, (double)3.0, (double)16.0), Block.m_49796_((double)-16.0, (double)13.0, (double)13.0, (double)-13.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)-15.0, (double)1.0, (double)14.0, (double)15.0, (double)15.0, (double)16.0)});
        }

        @Override
        protected VoxelShape shelfSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)4.0, (double)13.0, (double)15.0, (double)6.0, (double)16.0), Block.m_49796_((double)12.5, (double)6.0, (double)14.0, (double)14.5, (double)11.0, (double)16.0), Block.m_49796_((double)12.0, (double)11.0, (double)13.0, (double)15.0, (double)14.0, (double)16.0), Block.m_49796_((double)12.5, (double)12.0, (double)8.0, (double)14.5, (double)14.0, (double)13.0), Block.m_49796_((double)1.0, (double)4.0, (double)13.0, (double)4.0, (double)6.0, (double)16.0), Block.m_49796_((double)1.5, (double)6.0, (double)14.0, (double)3.5, (double)11.0, (double)16.0), Block.m_49796_((double)1.0, (double)11.0, (double)13.0, (double)4.0, (double)14.0, (double)16.0), Block.m_49796_((double)1.5, (double)12.0, (double)8.0, (double)3.5, (double)14.0, (double)13.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape shelfCenterShape() {
            return Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        }

        @Override
        protected VoxelShape shelfLeftShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)4.0, (double)13.0, (double)15.0, (double)6.0, (double)16.0), Block.m_49796_((double)12.5, (double)6.0, (double)14.0, (double)14.5, (double)11.0, (double)16.0), Block.m_49796_((double)12.0, (double)11.0, (double)13.0, (double)15.0, (double)14.0, (double)16.0), Block.m_49796_((double)12.5, (double)12.0, (double)8.0, (double)14.5, (double)14.0, (double)13.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape shelfRightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)4.0, (double)13.0, (double)4.0, (double)6.0, (double)16.0), Block.m_49796_((double)1.5, (double)6.0, (double)14.0, (double)3.5, (double)11.0, (double)16.0), Block.m_49796_((double)1.0, (double)11.0, (double)13.0, (double)4.0, (double)14.0, (double)16.0), Block.m_49796_((double)1.5, (double)12.0, (double)8.0, (double)3.5, (double)14.0, (double)13.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape sofaSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)4.0, (double)3.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.0, (double)2.0, (double)2.0, (double)14.0, (double)3.0, (double)4.0), Block.m_49796_((double)2.0, (double)2.0, (double)12.0, (double)4.0, (double)3.0, (double)14.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)2.0, (double)12.0, (double)14.0, (double)3.0, (double)14.0), Block.m_49796_((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0), Block.m_49796_((double)1.0, (double)6.0, (double)12.0, (double)15.0, (double)16.0, (double)15.0), Block.m_49796_((double)1.0, (double)9.0, (double)1.0, (double)3.0, (double)11.0, (double)12.0), Block.m_49796_((double)1.0, (double)6.0, (double)2.0, (double)3.0, (double)9.0, (double)4.0), Block.m_49796_((double)13.0, (double)9.0, (double)1.0, (double)15.0, (double)11.0, (double)12.0), Block.m_49796_((double)13.0, (double)6.0, (double)2.0, (double)15.0, (double)9.0, (double)4.0)});
        }

        @Override
        protected VoxelShape sofaCenterShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)3.0, (double)1.0, (double)16.0, (double)6.0, (double)15.0), Block.m_49796_((double)0.0, (double)6.0, (double)12.0, (double)16.0, (double)16.0, (double)15.0)});
        }

        @Override
        protected VoxelShape sofaLeftShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)12.0, (double)2.0, (double)2.0, (double)14.0, (double)3.0, (double)4.0), Block.m_49796_((double)12.0, (double)2.0, (double)12.0, (double)14.0, (double)3.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)0.0, (double)3.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0), Block.m_49796_((double)0.0, (double)6.0, (double)12.0, (double)15.0, (double)16.0, (double)15.0), Block.m_49796_((double)13.0, (double)9.0, (double)1.0, (double)15.0, (double)11.0, (double)12.0), Block.m_49796_((double)13.0, (double)6.0, (double)2.0, (double)15.0, (double)9.0, (double)4.0)});
        }

        @Override
        protected VoxelShape sofaRightShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)4.0, (double)3.0, (double)4.0), Block.m_49796_((double)2.0, (double)2.0, (double)12.0, (double)4.0, (double)3.0, (double)14.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0), Block.m_49796_((double)1.0, (double)3.0, (double)1.0, (double)16.0, (double)6.0, (double)15.0), Block.m_49796_((double)1.0, (double)6.0, (double)12.0, (double)16.0, (double)16.0, (double)15.0), Block.m_49796_((double)1.0, (double)9.0, (double)1.0, (double)3.0, (double)11.0, (double)12.0), Block.m_49796_((double)1.0, (double)6.0, (double)2.0, (double)3.0, (double)9.0, (double)4.0)});
        }

        @Override
        protected VoxelShape sofaCornerShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)2.0, (double)12.0, (double)14.0, (double)3.0, (double)14.0), Block.m_49796_((double)0.0, (double)3.0, (double)12.0, (double)15.0, (double)16.0, (double)15.0), Block.m_49796_((double)12.0, (double)3.0, (double)0.0, (double)15.0, (double)16.0, (double)12.0), Block.m_49796_((double)1.0, (double)3.0, (double)0.0, (double)15.0, (double)6.0, (double)12.0), Block.m_49796_((double)0.0, (double)3.0, (double)1.0, (double)14.0, (double)6.0, (double)12.0)});
        }

        @Override
        protected VoxelShape stoolShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)5.0, (double)2.0, (double)5.0), Block.m_49796_((double)2.0, (double)0.0, (double)11.0, (double)5.0, (double)2.0, (double)14.0), Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)14.0, (double)2.0, (double)14.0), Block.m_49796_((double)11.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)5.0), Block.m_49796_((double)11.0, (double)2.0, (double)3.0, (double)13.0, (double)3.0, (double)5.0), Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)5.0, (double)3.0, (double)5.0), Block.m_49796_((double)3.0, (double)2.0, (double)11.0, (double)5.0, (double)3.0, (double)13.0), Block.m_49796_((double)11.0, (double)2.0, (double)11.0, (double)13.0, (double)3.0, (double)13.0), Block.m_49796_((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0)});
        }

        @Override
        protected VoxelShape tableLargeShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)4.0), Block.m_49796_((double)-16.0, (double)0.0, (double)0.0, (double)-12.0, (double)2.0, (double)4.0), Block.m_49796_((double)-16.0, (double)0.0, (double)28.0, (double)-12.0, (double)2.0, (double)32.0), Block.m_49796_((double)12.0, (double)0.0, (double)28.0, (double)16.0, (double)2.0, (double)32.0), Block.m_49796_((double)12.0, (double)9.0, (double)28.0, (double)16.0, (double)11.0, (double)32.0), Block.m_49796_((double)-16.0, (double)9.0, (double)28.0, (double)-12.0, (double)11.0, (double)32.0), Block.m_49796_((double)-16.0, (double)9.0, (double)0.0, (double)-12.0, (double)11.0, (double)4.0), Block.m_49796_((double)12.0, (double)9.0, (double)0.0, (double)16.0, (double)11.0, (double)4.0), Block.m_49796_((double)12.0, (double)9.0, (double)28.0, (double)16.0, (double)11.0, (double)32.0), Block.m_49796_((double)12.0, (double)14.0, (double)28.0, (double)16.0, (double)16.0, (double)32.0), Block.m_49796_((double)12.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.m_49796_((double)-16.0, (double)14.0, (double)0.0, (double)-12.0, (double)16.0, (double)4.0), Block.m_49796_((double)-16.0, (double)14.0, (double)28.0, (double)-12.0, (double)16.0, (double)32.0), Block.m_49796_((double)-15.0, (double)2.0, (double)29.0, (double)-13.0, (double)14.0, (double)31.0), Block.m_49796_((double)13.0, (double)2.0, (double)29.0, (double)15.0, (double)14.0, (double)31.0), Block.m_49796_((double)13.0, (double)2.0, (double)1.0, (double)15.0, (double)14.0, (double)3.0), Block.m_49796_((double)-15.0, (double)2.0, (double)1.0, (double)-13.0, (double)14.0, (double)3.0), Block.m_49796_((double)-15.0, (double)14.0, (double)1.0, (double)15.0, (double)16.0, (double)31.0)});
        }

        @Override
        protected VoxelShape tableSmallShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)4.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)2.0, (double)4.0), Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)12.0, (double)9.0, (double)12.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)0.0, (double)9.0, (double)12.0, (double)4.0, (double)11.0, (double)16.0), Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)4.0, (double)11.0, (double)4.0), Block.m_49796_((double)12.0, (double)9.0, (double)0.0, (double)16.0, (double)11.0, (double)4.0), Block.m_49796_((double)12.0, (double)9.0, (double)12.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)12.0, (double)14.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)12.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0), Block.m_49796_((double)0.0, (double)14.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0), Block.m_49796_((double)1.0, (double)2.0, (double)13.0, (double)3.0, (double)14.0, (double)15.0), Block.m_49796_((double)13.0, (double)2.0, (double)13.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)13.0, (double)2.0, (double)1.0, (double)15.0, (double)14.0, (double)3.0), Block.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)3.0, (double)14.0, (double)3.0), Block.m_49796_((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)});
        }

        @Override
        protected VoxelShape tableWideShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)4.0), Block.m_49796_((double)-16.0, (double)0.0, (double)0.0, (double)-12.0, (double)2.0, (double)4.0), Block.m_49796_((double)-16.0, (double)0.0, (double)12.0, (double)-12.0, (double)2.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)12.0, (double)9.0, (double)12.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)-16.0, (double)9.0, (double)12.0, (double)-12.0, (double)11.0, (double)16.0), Block.m_49796_((double)-16.0, (double)9.0, (double)0.0, (double)-12.0, (double)11.0, (double)4.0), Block.m_49796_((double)12.0, (double)9.0, (double)0.0, (double)16.0, (double)11.0, (double)4.0), Block.m_49796_((double)12.0, (double)9.0, (double)12.0, (double)16.0, (double)11.0, (double)16.0), Block.m_49796_((double)12.0, (double)14.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)12.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.m_49796_((double)-16.0, (double)14.0, (double)0.0, (double)-12.0, (double)16.0, (double)4.0), Block.m_49796_((double)-16.0, (double)14.0, (double)12.0, (double)-12.0, (double)16.0, (double)16.0), Block.m_49796_((double)-15.0, (double)2.0, (double)13.0, (double)-13.0, (double)14.0, (double)15.0), Block.m_49796_((double)13.0, (double)2.0, (double)13.0, (double)15.0, (double)14.0, (double)15.0), Block.m_49796_((double)13.0, (double)2.0, (double)1.0, (double)15.0, (double)14.0, (double)3.0), Block.m_49796_((double)-15.0, (double)2.0, (double)1.0, (double)-13.0, (double)14.0, (double)3.0), Block.m_49796_((double)-15.0, (double)14.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)});
        }

        @Override
        protected VoxelShape wallLightShape() {
            return Block.m_49796_((double)6.0, (double)4.0, (double)8.0, (double)10.0, (double)14.5, (double)16.0);
        }

        @Override
        protected VoxelShape wardrobeTopShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0), Block.m_49796_((double)12.0, (double)9.0, (double)0.0, (double)16.0, (double)11.0, (double)4.0), Block.m_49796_((double)-16.0, (double)9.0, (double)0.0, (double)-12.0, (double)11.0, (double)4.0), Block.m_49796_((double)-16.0, (double)9.0, (double)12.0, (double)-12.0, (double)11.0, (double)16.0), Block.m_49796_((double)12.0, (double)9.0, (double)12.0, (double)16.0, (double)11.0, (double)16.0)});
        }

        @Override
        protected VoxelShape wardrobeBottomShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)4.0), Block.m_49796_((double)-16.0, (double)0.0, (double)0.0, (double)-12.0, (double)2.0, (double)4.0), Block.m_49796_((double)-16.0, (double)0.0, (double)12.0, (double)-12.0, (double)2.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)12.0, (double)8.0, (double)12.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)-16.0, (double)8.0, (double)12.0, (double)-12.0, (double)10.0, (double)16.0), Block.m_49796_((double)-16.0, (double)8.0, (double)0.0, (double)-12.0, (double)10.0, (double)4.0), Block.m_49796_((double)12.0, (double)8.0, (double)0.0, (double)16.0, (double)10.0, (double)4.0), Block.m_49796_((double)12.0, (double)30.0, (double)0.0, (double)16.0, (double)32.0, (double)4.0), Block.m_49796_((double)-16.0, (double)30.0, (double)0.0, (double)-12.0, (double)32.0, (double)4.0), Block.m_49796_((double)-16.0, (double)30.0, (double)12.0, (double)-12.0, (double)32.0, (double)16.0), Block.m_49796_((double)12.0, (double)30.0, (double)12.0, (double)16.0, (double)32.0, (double)16.0), Block.m_49796_((double)-15.0, (double)0.0, (double)1.0, (double)15.0, (double)32.0, (double)15.0)});
        }

        @Override
        protected VoxelShape doorDoubleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.5, (double)13.0, (double)29.0, (double)2.5), Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)3.0), Block.m_49796_((double)12.0, (double)20.0, (double)0.0, (double)13.0, (double)32.0, (double)3.0), Block.m_49796_((double)11.0, (double)24.0, (double)0.0, (double)12.0, (double)32.0, (double)3.0), Block.m_49796_((double)9.0, (double)27.0, (double)0.0, (double)11.0, (double)32.0, (double)3.0), Block.m_49796_((double)4.0, (double)28.0, (double)0.0, (double)9.0, (double)32.0, (double)3.0), Block.m_49796_((double)0.0, (double)29.0, (double)0.0, (double)4.0, (double)32.0, (double)3.0)});
        }

        @Override
        protected VoxelShape doorSingleShape() {
            return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)3.0);
        }

        @Override
        protected VoxelShape counterSingleShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)12.0, (double)3.0), Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape counterCornerShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)13.0, (double)3.0), Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }

        @Override
        protected VoxelShape ovenShape() {
            return VoxelShaper.or((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        }
    }
}

