/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.common.block.entity;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.block.IMultiBlock;
import xyz.apex.forge.apexcore.lib.block.entity.InventoryBlockEntity;

public final class OvenBlockEntity
extends InventoryBlockEntity
implements ContainerData {
    public static final String NBT_BURN_TIME = "BurnTime";
    public static final String NBT_SMELT_TIME = "SmeltTime";
    public static final String NBT_TOTAL_SMELT_TIME = "TotalSmeltTime";
    public static final String NBT_RECIPES_USED = "RecipesUsed";
    private int burnTime;
    private int totalBurnTime;
    private int smeltTime;
    private int totalSmeltTime;
    @Nullable
    private AbstractCookingRecipe recipe;
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeType<? extends AbstractCookingRecipe> recipeType = RecipeType.f_44110_;
    private final Container container = new RecipeWrapper((IItemHandlerModifiable)this.itemHandler);

    public OvenBlockEntity(BlockEntityType<? extends OvenBlockEntity> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState, 3);
    }

    public CompoundTag serializeData() {
        CompoundTag tagCompound = super.serializeData();
        tagCompound.m_128405_(NBT_BURN_TIME, this.burnTime);
        tagCompound.m_128405_(NBT_SMELT_TIME, this.smeltTime);
        tagCompound.m_128405_(NBT_TOTAL_SMELT_TIME, this.totalSmeltTime);
        CompoundTag recipesUsedTag = new CompoundTag();
        this.recipesUsed.forEach((recipeId, amount) -> recipesUsedTag.m_128405_(recipeId.toString(), amount.intValue()));
        tagCompound.m_128365_(NBT_RECIPES_USED, (Tag)recipesUsedTag);
        return tagCompound;
    }

    public void deserializeData(CompoundTag tagCompound) {
        super.deserializeData(tagCompound);
        this.burnTime = tagCompound.m_128451_(NBT_BURN_TIME);
        this.totalBurnTime = this.getBurnTime(this.itemHandler.getStackInSlot(1));
        this.smeltTime = tagCompound.m_128451_(NBT_SMELT_TIME);
        this.totalSmeltTime = tagCompound.m_128451_(NBT_TOTAL_SMELT_TIME);
        CompoundTag recipesUsedTag = tagCompound.m_128469_(NBT_RECIPES_USED);
        for (String key : recipesUsedTag.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(key), recipesUsedTag.m_128451_(key));
        }
    }

    public int m_6413_(int index) {
        return switch (index) {
            case 0 -> this.burnTime;
            case 1 -> this.totalBurnTime;
            case 2 -> this.smeltTime;
            case 3 -> this.totalSmeltTime;
            default -> -1;
        };
    }

    public void m_8050_(int index, int value) {
        switch (index) {
            case 0: {
                this.burnTime = value;
                break;
            }
            case 1: {
                this.totalBurnTime = value;
                break;
            }
            case 2: {
                this.smeltTime = value;
                break;
            }
            case 3: {
                this.totalSmeltTime = value;
                break;
            }
        }
    }

    public int m_6499_() {
        return 4;
    }

    public void awardRecipesAndExperience(ServerLevel level, @Nullable ServerPlayer player, Vec3 pos) {
        if (this.recipesUsed.isEmpty()) {
            return;
        }
        ArrayList recipes = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            level.m_7465_().m_44043_((ResourceLocation)entry.getKey()).filter(AbstractCookingRecipe.class::isInstance).map(AbstractCookingRecipe.class::cast).ifPresent(recipe -> {
                int useAmount = entry.getIntValue();
                float experience = recipe.m_43750_();
                int i = Mth.m_14143_((float)((float)useAmount * experience));
                float f = Mth.m_14187_((float)((float)useAmount * experience));
                if (f != 0.0f && Math.random() < (double)f) {
                    ++i;
                }
                ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)pos, (int)i);
            });
        }
        if (player != null) {
            player.m_7281_((Collection)recipes);
        }
        this.recipesUsed.clear();
    }

    public void serverTick(Level level, BlockPos pos, BlockState blockState) {
        ItemStack input = this.itemHandler.getStackInSlot(0);
        ItemStack fuel = this.itemHandler.getStackInSlot(1);
        ItemStack output = this.itemHandler.getStackInSlot(2);
        int smeltAmount = this.itemHandler.getSlotLimit(2);
        boolean isBurning = this.isBurning();
        boolean dirty = false;
        if (isBurning) {
            this.burnTime = Math.max(this.burnTime - 1, 0);
        } else if (this.smeltTime > 0) {
            this.smeltTime = Math.max(this.smeltTime - 1, 0);
        } else {
            this.smeltTime = 0;
            this.totalSmeltTime = 0;
            this.recipe = null;
        }
        if (isBurning || this.canBurn(fuel)) {
            int burnTime;
            this.recipe = level.m_7465_().m_44015_(this.recipeType, this.container, level).orElse(null);
            if (!isBurning && this.canSmelt(output, smeltAmount) && (burnTime = this.getBurnTime(fuel)) > 0) {
                this.burnTime = burnTime;
                this.totalBurnTime = burnTime;
                fuel = this.decrementFuel(fuel);
                dirty = true;
            }
            if (this.recipe == null) {
                this.totalSmeltTime = 0;
                this.smeltTime = 0;
            } else if (this.totalSmeltTime == 0) {
                if (this.canSmelt(output, smeltAmount)) {
                    this.smeltTime = 0;
                    this.totalSmeltTime = this.recipe.m_43753_();
                }
            } else {
                this.smeltTime = Math.min(this.smeltTime + 1, this.totalSmeltTime);
                if (this.smeltTime == this.totalSmeltTime) {
                    ItemStack result = this.recipe.m_5874_(this.container, level.m_9598_());
                    if (output.m_41619_()) {
                        output = result.m_41777_();
                        this.itemHandler.setStackInSlot(2, output);
                    } else if (output.m_150930_(result.m_41720_())) {
                        output.m_41769_(result.m_41613_());
                    }
                    this.recipesUsed.addTo((Object)this.recipe.m_6423_(), 1);
                    input.m_41774_(1);
                    this.recipe = null;
                    this.totalSmeltTime = 0;
                    this.smeltTime = 0;
                    dirty = true;
                }
            }
        }
        if (isBurning != this.isBlockStateLit(level, pos, blockState)) {
            dirty = this.setBlockStateLit(level, pos, blockState, isBurning);
            blockState = level.m_8055_(pos);
        }
        if (dirty) {
            OvenBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)blockState);
        }
    }

    private boolean isBlockStateLit(Level level, BlockPos pos, BlockState blockState) {
        Block block = blockState.m_60734_();
        if (block instanceof IMultiBlock) {
            IMultiBlock multiBlock = (IMultiBlock)block;
            BlockPos origin = multiBlock.getMultiBlockOriginPos(blockState, pos);
            return (Boolean)level.m_8055_(origin).m_61143_((Property)BlockStateProperties.f_61443_);
        }
        return (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_);
    }

    private boolean setBlockStateLit(Level level, BlockPos pos, BlockState blockState, boolean lit) {
        Block block = blockState.m_60734_();
        if (block instanceof IMultiBlock) {
            IMultiBlock multiBlock = (IMultiBlock)block;
            BlockPos origin = multiBlock.getMultiBlockOriginPos(blockState, pos);
            boolean changed = false;
            for (BlockPos localPos : multiBlock.getMultiBlockLocalPositions()) {
                BlockPos worldPos = multiBlock.getMultiBlockWorldSpaceFromLocalSpace(blockState, origin, localPos);
                BlockState worldBlockState = level.m_8055_(worldPos);
                BlockState newWorldBlockState = (BlockState)worldBlockState.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(lit));
                if (newWorldBlockState == worldBlockState) continue;
                changed = level.m_46597_(worldPos, newWorldBlockState) || changed;
            }
            return changed;
        }
        BlockState newBlockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(lit));
        if (newBlockState != blockState) {
            return level.m_46597_(pos, newBlockState);
        }
        return false;
    }

    private ItemStack decrementFuel(ItemStack fuel) {
        if (fuel.hasCraftingRemainingItem()) {
            ItemStack result = fuel.getCraftingRemainingItem();
            this.itemHandler.setStackInSlot(1, result);
            return result;
        }
        fuel.m_41774_(1);
        return fuel;
    }

    private boolean canSmelt(ItemStack output, int amount) {
        if (this.recipe != null) {
            ItemStack result = this.recipe.m_5874_(this.container, this.f_58857_.m_9598_());
            if (result.m_41619_()) {
                return false;
            }
            if (output.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_41656_((ItemStack)output, (ItemStack)result)) {
                return false;
            }
            if (output.m_41613_() + result.m_41613_() <= amount && output.m_41613_() + result.m_41613_() <= output.m_41741_()) {
                return true;
            }
            return output.m_41613_() + result.m_41613_() <= result.m_41741_();
        }
        return false;
    }

    private boolean isBurning() {
        return this.burnTime > 0;
    }

    private int getBurnTime(ItemStack stack) {
        if (stack.m_41619_() || stack.m_204117_(ItemTags.f_13153_)) {
            return 0;
        }
        return ForgeHooks.getBurnTime((ItemStack)stack, this.recipeType);
    }

    public boolean canBurn(ItemStack stack) {
        return this.getBurnTime(stack) > 0;
    }
}

