/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.core.mixin;

import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.yirmiri.dungeonsdelight.common.util.DDUtil;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import net.yirmiri.dungeonsdelight.core.registry.DDParticles;
import net.yirmiri.dungeonsdelight.core.registry.DDSounds;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin {
    @Unique
    private static Random random = new Random();
    @Unique
    Player player = (Player)this;

    @Inject(at={@At(value="HEAD")}, method={"hurt"})
    private void dungeonsdelight$hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.player.m_21023_((MobEffect)DDEffects.EXUDATION.get()) && this.player.m_6103_() > 0.0f && this.player.f_20916_ == 0 && !this.player.m_150110_().f_35934_) {
            if (this.player.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)this.player.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)DDParticles.SKULL_HEART_BLAST.get()), this.player.m_20185_(), this.player.m_20186_() + 0.5, this.player.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
            }
            this.player.m_9236_().m_6263_(null, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_(), SoundEvents.f_215771_, SoundSource.NEUTRAL, 0.75f, 2.0f);
            DDUtil.skullHeartBlast(this.player.m_9236_(), (LivingEntity)this.player, (Entity)this.player);
            this.player.f_20916_ = 30;
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"attack"})
    public void dungeonsdelight$attack(Entity entity, CallbackInfo ci) {
        if (this.player.m_21023_((MobEffect)DDEffects.DECISIVE.get())) {
            float amount = (float)this.player.m_21133_(Attributes.f_22281_);
            double decisiveLevel = this.player.m_21124_((MobEffect)DDEffects.DECISIVE.get()).m_19564_();
            DamageSource source = this.player.m_269291_().m_269075_(this.player);
            if (20.0 + decisiveLevel != 0.0 && random.nextDouble(100.0) < 20.0 + decisiveLevel && this.player.m_6084_()) {
                entity.m_6469_(source, amount * 1.75f);
                entity.m_5496_((SoundEvent)DDSounds.DECISIVE_CRIT.get(), 1.0f, 1.0f);
                DDUtil.spreadParticles((ParticleOptions)DDParticles.DECISIVE_CRITICAL.get(), entity, random);
                if (this.player.m_21023_((MobEffect)DDEffects.VORACITY.get())) {
                    this.player.m_7292_(new MobEffectInstance((MobEffect)DDEffects.RAVENOUS_RUSH.get(), this.player.m_21124_((MobEffect)DDEffects.VORACITY.get()).m_19557_() + 60, 0));
                }
            }
        }
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"hurt"}, argsOnly=true)
    public float dungeonsdelight$pouncingHurt(float amount, DamageSource source) {
        if (this.player.m_21023_((MobEffect)DDEffects.POUNCING.get()) && source.m_269533_(DamageTypeTags.f_268549_)) {
            int amplifier = this.player.m_21124_((MobEffect)DDEffects.POUNCING.get()).m_19564_();
            float reduced = amount * (0.8f + 0.05f * (float)amplifier);
            if (reduced < 1.0f) {
                return 0.0f;
            }
            return reduced;
        }
        return amount;
    }

    @Inject(at={@At(value="HEAD")}, method={"isHurt"}, cancellable=true)
    private void dungeonsdelight$canFoodHeal(CallbackInfoReturnable<Boolean> cir) {
        if (this.player.m_21023_((MobEffect)DDEffects.TENACITY.get())) {
            cir.setReturnValue((Object)false);
        }
    }
}

