/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.core.mixin;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import net.yirmiri.dungeonsdelight.core.registry.DDSoundTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Block.class})
public class BlockMixin {
    @Unique
    private static Random random = new Random();

    @Inject(at={@At(value="HEAD")}, method={"playerDestroy"})
    private void dungeonsdelight$playerDestroy(Level level, Player player, BlockPos pos, BlockState state, BlockEntity entity, ItemStack stack, CallbackInfo ci) {
        if (player.m_21023_((MobEffect)DDEffects.BURROW_GUT.get())) {
            player.m_36324_().m_38707_(this.getBurrowGutRefillAmount((LivingEntity)player, state.m_60800_((BlockGetter)level, pos)), 0.1f);
            if ((double)(state.m_60800_((BlockGetter)level, pos) * 10.0f) > random.nextDouble(100.0) && !player.m_21023_((MobEffect)DDEffects.RAVENOUS_RUSH.get())) {
                player.m_7292_(new MobEffectInstance((MobEffect)DDEffects.RAVENOUS_RUSH.get(), 120, 0));
            }
            if (player.m_21023_((MobEffect)DDEffects.RAVENOUS_RUSH.get()) && state.m_60713_(Blocks.f_50719_) && player.m_21023_(MobEffects.f_19614_)) {
                player.m_21195_(MobEffects.f_19614_);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getSoundType"}, cancellable=true)
    private void dungeonsdelight$getSoundType(BlockState state, CallbackInfoReturnable<SoundType> cir) {
        if (state.m_60713_(Blocks.f_50085_)) {
            cir.setReturnValue((Object)DDSoundTypes.STAINED_SCRAP);
        }
    }

    private int getBurrowGutRefillAmount(LivingEntity living, float amount) {
        if (amount < 1.0f) {
            return 1;
        }
        if ((float)(living.m_21124_((MobEffect)DDEffects.BURROW_GUT.get()).m_19564_() + 5) > amount) {
            return (int)amount;
        }
        return living.m_21124_((MobEffect)DDEffects.BURROW_GUT.get()).m_19564_() + 5;
    }
}

