/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.core.event;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import net.azurune.runiclib.core.platform.services.RLRegistryHelper;
import net.azurune.runiclib.core.register.RLMobEffects;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;
import net.yirmiri.dungeonsdelight.DDConfigCommon;
import net.yirmiri.dungeonsdelight.common.entity.misc.AncientEggEntity;
import net.yirmiri.dungeonsdelight.common.entity.misc.RancidReductionEntity;
import net.yirmiri.dungeonsdelight.common.entity.monster_yam.MonsterYamEntity;
import net.yirmiri.dungeonsdelight.common.entity.rotten_zombie.RottenZombieEntity;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import net.yirmiri.dungeonsdelight.core.registry.DDEntities;
import net.yirmiri.dungeonsdelight.core.registry.DDItems;
import net.yirmiri.dungeonsdelight.integration.twilightforest.TFItems;
import vectorwing.farmersdelight.common.registry.ModItems;

@Mod.EventBusSubscriber(modid="dungeonsdelight")
public class DDCommonEvents {
    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        DDCommonEvents.registerDispenserBehaviors();
        DDCommonEvents.registerFlammables();
        DDCommonEvents.registerCompostables();
    }

    @SubscribeEvent
    public static void missingMappingsEvent(MissingMappingsEvent event) {
        ImmutableMap itemsMap = new ImmutableMap.Builder().put((Object)new ResourceLocation("dungeonsdelight", "spider_eye_salmagundi"), DDItems.SPIDER_SALMAGUNDI).put((Object)new ResourceLocation("dungeonsdelight", "silverfish_abdomen"), DDItems.SILVERFISH_ABDOMEN).put((Object)new ResourceLocation("dungeonsdelight", "ossobuco"), DDItems.OSSOBUCO).build();
        ImmutableMap blocksMap = new ImmutableMap.Builder().put((Object)new ResourceLocation("dungeonsdelight", "ossobuco_block"), DDBlocks.OSSOBUCO_BLOCK).put((Object)new ResourceLocation("dungeonsdelight", "wormroots"), DDBlocks.WORMROOT_TENDRILS).build();
        ImmutableMap vanillaItemsMap = new ImmutableMap.Builder().put((Object)new ResourceLocation("dungeonsdelight", "stained_chain"), (Object)Items.f_42026_).build();
        ImmutableMap vanillaBlocksMap = new ImmutableMap.Builder().put((Object)new ResourceLocation("dungeonsdelight", "stained_chain"), (Object)Blocks.f_50184_).build();
        for (MissingMappingsEvent.Mapping itemMapping : event.getMappings(ForgeRegistries.Keys.ITEMS, "dungeonsdelight")) {
            if (itemsMap.get(itemMapping.getKey()) != null) {
                itemMapping.remap((Object)((Item)Objects.requireNonNull((Supplier)itemsMap.get(itemMapping.getKey())).get()));
            }
            if (vanillaItemsMap.get(itemMapping.getKey()) == null) continue;
            itemMapping.remap((Object)Objects.requireNonNull((Item)vanillaItemsMap.get(itemMapping.getKey())));
        }
        for (MissingMappingsEvent.Mapping blockMapping : event.getMappings(ForgeRegistries.Keys.BLOCKS, "dungeonsdelight")) {
            if (blocksMap.get(blockMapping.getKey()) != null) {
                blockMapping.remap((Object)((Block)Objects.requireNonNull((Supplier)blocksMap.get(blockMapping.getKey())).get()));
            }
            if (vanillaBlocksMap.get(blockMapping.getKey()) == null) continue;
            blockMapping.remap((Object)Objects.requireNonNull((Block)vanillaBlocksMap.get(blockMapping.getKey())));
        }
    }

    public static void registerCompostables() {
        ComposterBlock.f_51914_.put((Object)((ItemLike)DDItems.ROTBULB_CROP.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)DDItems.ROTBULB.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)DDItems.GUNK.get()), 0.65f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)DDItems.ROTBULB_PLANT.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)DDItems.SCULK_TART_SLICE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)DDBlocks.SCULK_TART.get()), 1.0f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)DDItems.MONSTER_CAKE_SLICE.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)DDItems.MONSTER_CAKE.get()), 1.0f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)DDItems.MONSTER_MUFFIN.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)DDItems.SPIDER_DONUT.get()), 0.85f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)TFItems.TORCHBERRY_RAISINS.get()), 0.3f);
    }

    public static void registerFlammables() {
        RLRegistryHelper.createFlammable((Block)((Block)DDBlocks.WORMROOTS_BLOCK.get()), (int)5, (int)5);
        RLRegistryHelper.createFlammable((Block)((Block)DDBlocks.WORMWOOD_PLANKS.get()), (int)5, (int)20);
        RLRegistryHelper.createFlammable((Block)((Block)DDBlocks.WORMWOOD_STAIRS.get()), (int)5, (int)20);
        RLRegistryHelper.createFlammable((Block)((Block)DDBlocks.WORMWOOD_SLAB.get()), (int)5, (int)20);
        RLRegistryHelper.createFlammable((Block)((Block)DDBlocks.WORMWOOD_FENCE.get()), (int)5, (int)20);
        RLRegistryHelper.createFlammable((Block)((Block)DDBlocks.WORMWOOD_FENCE_GATE.get()), (int)5, (int)20);
        RLRegistryHelper.createFlammable((Block)((Block)DDBlocks.WORMWOOD_MOSAIC.get()), (int)5, (int)20);
        RLRegistryHelper.createFlammable((Block)((Block)DDBlocks.WORMWOOD_MOSAIC_STAIRS.get()), (int)5, (int)20);
        RLRegistryHelper.createFlammable((Block)((Block)DDBlocks.WORMWOOD_MOSAIC_SLAB.get()), (int)5, (int)20);
        RLRegistryHelper.createFlammable((Block)((Block)DDBlocks.WORMROOT_TENDRILS.get()), (int)15, (int)100);
        RLRegistryHelper.createFlammable((Block)((Block)DDBlocks.ROTBULB_PLANT.get()), (int)60, (int)100);
        RLRegistryHelper.createFlammable((Block)((Block)DDBlocks.WORMROOT_STALK.get()), (int)10, (int)40);
    }

    @SubscribeEvent
    public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)DDEntities.MONSTER_YAM.get(), MonsterYamEntity.createAttributes().m_22265_());
        event.put((EntityType)DDEntities.ROTTEN_ZOMBIE.get(), RottenZombieEntity.m_34328_().m_22265_());
    }

    public static void registerDispenserBehaviors() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)DDItems.ANCIENT_EGG.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level level, Position position, ItemStack stack) {
                return new AncientEggEntity(level, position.m_7096_(), position.m_7098_(), position.m_7094_());
            }
        });
        DispenserBlock.m_52672_((ItemLike)((ItemLike)DDItems.RANCID_REDUCTION.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level level, Position position, ItemStack stack) {
                return new RancidReductionEntity(level, position.m_7096_(), position.m_7098_(), position.m_7094_());
            }
        });
    }

    @SubscribeEvent
    public static void handleAdditionalFoodEffects(LivingEntityUseItemEvent.Finish event) {
        if (((Boolean)DDConfigCommon.FD_STICK_FOODS_GRANT_STRENGTH.get()).booleanValue() && event.getItem().m_41720_().equals(ModItems.BARBECUE_STICK.get())) {
            event.getEntity().m_7292_(new MobEffectInstance(MobEffects.f_19600_, 1200, 0));
        }
        if (((Boolean)DDConfigCommon.FD_STICK_FOODS_GRANT_STRENGTH.get()).booleanValue() && event.getItem().m_41720_().equals(ModItems.MELON_POPSICLE.get())) {
            event.getEntity().m_7292_(new MobEffectInstance(MobEffects.f_19600_, 100, 0));
        }
        if (((Boolean)DDConfigCommon.FD_GLOWING_FOODS_GRANT_PERCEPTION.get()).booleanValue() && event.getItem().m_41720_().equals(ModItems.GLOW_BERRY_CUSTARD.get())) {
            event.getEntity().m_7292_(new MobEffectInstance((MobEffect)RLMobEffects.PERCEPTION.get(), 1200, 0));
        }
    }

    @SubscribeEvent
    public static void feralBiteAttack(LivingHurtEvent event) {
        LivingEntity living;
        Entity entity;
        Random random = new Random();
        LivingEntity target = event.getEntity();
        if (!target.m_9236_().m_5776_() && (entity = event.getSource().m_7640_()) instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_((MobEffect)DDEffects.FERAL_BITE.get()) && random.nextInt(4) == 0) {
            target.m_7292_(new MobEffectInstance((MobEffect)DDEffects.SERRATED.get(), 160, 0));
        }
    }
}

