/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.block.plant.branch.BranchBlock;
import net.regions_unexplored.world.level.block.plant.other.SpanishMossBlock;
import net.regions_unexplored.world.level.feature.configuration.RuTreeConfiguration;

public class KapokTreeFeature
extends Feature<RuTreeConfiguration> {
    public KapokTreeFeature(Codec<RuTreeConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<RuTreeConfiguration> context) {
        RuTreeConfiguration treeConfiguration = (RuTreeConfiguration)context.m_159778_();
        BlockPos pos = context.m_159777_();
        RandomSource randomSource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        int height_main = context.m_225041_().m_188503_(treeConfiguration.sizeVariation) + treeConfiguration.minimumSize;
        BlockPos.MutableBlockPos checkPos = pos.m_122032_();
        for (int check = 0; check <= height_main; ++check) {
            if (!this.checkReplaceable((LevelAccessor)level, (BlockPos)checkPos)) {
                return false;
            }
            checkPos.m_122173_(Direction.UP);
        }
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int placeCheck = 0; placeCheck <= height_main; ++placeCheck) {
            this.placeLog((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
            if (placeCheck > 5) {
                this.placeBranchDecorator((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            if (placeCheck == 0) {
                this.placeRoot((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122012_(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122019_(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122029_(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122024_(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122012_().m_7494_(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122019_().m_7494_(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122029_().m_7494_(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122024_().m_7494_(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122012_().m_6630_(2), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122019_().m_6630_(2), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122029_().m_6630_(2), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122024_().m_6630_(2), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122012_().m_6630_(3), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122019_().m_6630_(3), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122029_().m_6630_(3), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122024_().m_6630_(3), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122012_().m_6630_(4), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122019_().m_6630_(4), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122029_().m_6630_(4), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122024_().m_6630_(4), randomSource, treeConfiguration);
                if (randomSource.m_188503_(3) == 0) {
                    this.placeRoot((LevelAccessor)level, placePos.m_122012_().m_6630_(5), randomSource, treeConfiguration);
                }
                if (randomSource.m_188503_(3) == 0) {
                    this.placeRoot((LevelAccessor)level, placePos.m_122019_().m_6630_(5), randomSource, treeConfiguration);
                }
                if (randomSource.m_188503_(3) == 0) {
                    this.placeRoot((LevelAccessor)level, placePos.m_122029_().m_6630_(5), randomSource, treeConfiguration);
                }
                if (randomSource.m_188503_(3) == 0) {
                    this.placeRoot((LevelAccessor)level, placePos.m_122024_().m_6630_(5), randomSource, treeConfiguration);
                }
                this.placeRoot((LevelAccessor)level, placePos.m_122013_(2), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122020_(2), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122030_(2), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122025_(2), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122013_(2).m_7494_(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122020_(2).m_7494_(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122030_(2).m_7494_(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122025_(2).m_7494_(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122013_(2).m_6630_(2), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122020_(2).m_6630_(2), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122030_(2).m_6630_(2), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.m_122025_(2).m_6630_(2), randomSource, treeConfiguration);
                if (level.m_8055_(placePos.m_122013_(3).m_6625_(2)).m_204336_(BlockTags.f_144274_)) {
                    this.placeRoot((LevelAccessor)level, placePos.m_122013_(3), randomSource, treeConfiguration);
                }
                if (level.m_8055_(placePos.m_122020_(3).m_6625_(2)).m_204336_(BlockTags.f_144274_)) {
                    this.placeRoot((LevelAccessor)level, placePos.m_122020_(3), randomSource, treeConfiguration);
                }
                if (level.m_8055_(placePos.m_122030_(3).m_6625_(2)).m_204336_(BlockTags.f_144274_)) {
                    this.placeRoot((LevelAccessor)level, placePos.m_122030_(3), randomSource, treeConfiguration);
                }
                if (level.m_8055_(placePos.m_122030_(3).m_6625_(2)).m_204336_(BlockTags.f_144274_)) {
                    this.placeRoot((LevelAccessor)level, placePos.m_122030_(3), randomSource, treeConfiguration);
                }
            }
            if (placeCheck == height_main) {
                this.placeTop((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            placePos.m_122173_(Direction.UP);
        }
        return true;
    }

    public void placeTop(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        BlockPos.MutableBlockPos placePos = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_() - 5, pos.m_123343_());
        int n = randomSource.m_188503_(4);
        int s = randomSource.m_188503_(4);
        int e = randomSource.m_188503_(4);
        int w = randomSource.m_188503_(4);
        this.placeLimb(level, placePos.m_6630_(n), randomSource, treeConfiguration, Direction.NORTH);
        this.placeLimb(level, placePos.m_6630_(s), randomSource, treeConfiguration, Direction.SOUTH);
        this.placeLimb(level, placePos.m_6630_(e), randomSource, treeConfiguration, Direction.EAST);
        this.placeLimb(level, placePos.m_6630_(w), randomSource, treeConfiguration, Direction.WEST);
        this.placeLeavesBlob(level, pos, randomSource, treeConfiguration);
    }

    public void placeLimb(LevelAccessor level, BlockPos pos1, RandomSource randomSource, RuTreeConfiguration treeConfiguration, Direction direction) {
        int type = randomSource.m_188503_(8);
        BlockPos.MutableBlockPos pos = pos1.m_122032_();
        if (type == 0) {
            pos.m_122173_(direction);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            pos.m_122173_(direction);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            pos.m_122173_(direction);
            pos.m_122173_(Direction.UP);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            pos.m_122173_(direction);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            this.placeLeavesBlob(level, (BlockPos)pos, randomSource, treeConfiguration);
        } else if (type == 1) {
            pos.m_122173_(direction);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            pos.m_122173_(direction);
            pos.m_122173_(Direction.UP);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            pos.m_122173_(direction);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            pos.m_122173_(direction);
            pos.m_122173_(Direction.UP);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            this.placeLeavesBlob(level, (BlockPos)pos, randomSource, treeConfiguration);
        } else if (type == 2) {
            pos.m_122173_(direction);
            this.placeLog(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            this.placeLogWithVines(level, pos.m_7495_(), randomSource, treeConfiguration, Direction.Axis.Y);
            pos.m_122173_(direction);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            pos.m_122173_(direction);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            pos.m_122173_(direction);
            pos.m_122173_(Direction.UP);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, Direction.Axis.Y);
            pos.m_122173_(Direction.UP);
            this.placeLog(level, (BlockPos)pos, randomSource, treeConfiguration, Direction.Axis.Y);
            this.placeLeavesBlob(level, (BlockPos)pos, randomSource, treeConfiguration);
        } else if (type == 3) {
            pos.m_122173_(direction);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            pos.m_122173_(direction);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            pos.m_122173_(direction);
            pos.m_122173_(Direction.UP);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            pos.m_122173_(direction);
            pos.m_122173_(Direction.UP);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, Direction.Axis.Y);
            pos.m_122173_(Direction.UP);
            this.placeLog(level, (BlockPos)pos, randomSource, treeConfiguration, Direction.Axis.Y);
            this.placeLeavesBlob(level, (BlockPos)pos, randomSource, treeConfiguration);
        } else if (type == 4) {
            pos.m_122173_(direction);
            this.placeLog(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            this.placeLogWithVines(level, pos.m_6625_(2), randomSource, treeConfiguration, direction.m_122434_());
            pos.m_122173_(direction);
            this.placeLog(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            this.placeLogWithVines(level, pos.m_7495_(), randomSource, treeConfiguration, Direction.Axis.Y);
            pos.m_122173_(direction);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            pos.m_122173_(direction);
            pos.m_122173_(Direction.UP);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, Direction.Axis.Y);
            pos.m_122173_(Direction.UP);
            this.placeLog(level, (BlockPos)pos, randomSource, treeConfiguration, Direction.Axis.Y);
            this.placeLeavesBlob(level, (BlockPos)pos, randomSource, treeConfiguration);
        } else if (type == 5) {
            pos.m_122173_(direction);
            this.placeLog(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            this.placeLogWithVines(level, pos.m_6625_(3), randomSource, treeConfiguration, direction.m_122434_());
            pos.m_122173_(direction);
            this.placeLog(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            this.placeLog(level, pos.m_7495_(), randomSource, treeConfiguration, Direction.Axis.Y);
            this.placeLogWithVines(level, pos.m_6625_(2), randomSource, treeConfiguration, Direction.Axis.Y);
            pos.m_122173_(direction);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            this.placeLog(level, pos.m_7494_(), randomSource, treeConfiguration, Direction.Axis.Y);
            pos.m_122173_(direction);
            pos.m_122173_(Direction.UP);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, Direction.Axis.Y);
            pos.m_122173_(Direction.UP);
            this.placeLog(level, (BlockPos)pos, randomSource, treeConfiguration, Direction.Axis.Y);
            this.placeLeavesBlob(level, (BlockPos)pos, randomSource, treeConfiguration);
        } else if (type == 6) {
            pos.m_122173_(direction);
            this.placeLog(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            this.placeLogWithVines(level, pos.m_6625_(2), randomSource, treeConfiguration, direction.m_122434_());
            pos.m_122173_(direction);
            this.placeLog(level, (BlockPos)pos, randomSource, treeConfiguration, Direction.Axis.Y);
            this.placeLogWithVines(level, pos.m_7495_(), randomSource, treeConfiguration, Direction.Axis.Y);
            pos.m_122173_(direction);
            pos.m_122173_(Direction.UP);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            pos.m_122173_(direction);
            pos.m_122173_(Direction.UP);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, Direction.Axis.Y);
            this.placeLeavesBlob(level, (BlockPos)pos, randomSource, treeConfiguration);
        } else if (type == 7) {
            pos.m_122173_(direction);
            this.placeLog(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            this.placeLogWithVines(level, pos.m_6625_(3), randomSource, treeConfiguration, direction.m_122434_());
            pos.m_122173_(direction);
            this.placeLog(level, (BlockPos)pos, randomSource, treeConfiguration, Direction.Axis.Y);
            this.placeLog(level, pos.m_7495_(), randomSource, treeConfiguration, Direction.Axis.Y);
            this.placeLogWithVines(level, pos.m_6625_(2), randomSource, treeConfiguration, Direction.Axis.Y);
            pos.m_122173_(direction);
            pos.m_122173_(Direction.UP);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            pos.m_122173_(direction);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, direction.m_122434_());
            pos.m_122173_(Direction.UP);
            this.placeLogWithVines(level, (BlockPos)pos, randomSource, treeConfiguration, Direction.Axis.Y);
            this.placeLeavesBlob(level, (BlockPos)pos, randomSource, treeConfiguration);
        }
    }

    public boolean placeLeavesBlob(LevelAccessor level, BlockPos pos1, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        BlockPos.MutableBlockPos pos = pos1.m_122032_();
        Random random = new Random();
        this.placeLeavesBlock(level, pos.m_7495_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7495_().m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7495_().m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7495_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_7495_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, (BlockPos)pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2).m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2).m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2).m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2).m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122030_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122030_(2).m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122030_(2).m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122025_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122025_(2).m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122025_(2).m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlockWithVines(level, pos.m_122013_(3), randomSource, treeConfiguration);
        this.placeLeavesBlockWithVines(level, pos.m_122013_(3).m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlockWithVines(level, pos.m_122013_(3).m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlockWithVines(level, pos.m_122020_(3), randomSource, treeConfiguration);
        this.placeLeavesBlockWithVines(level, pos.m_122020_(3).m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlockWithVines(level, pos.m_122020_(3).m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlockWithVines(level, pos.m_122030_(3), randomSource, treeConfiguration);
        this.placeLeavesBlockWithVines(level, pos.m_122030_(3).m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlockWithVines(level, pos.m_122030_(3).m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlockWithVines(level, pos.m_122025_(3), randomSource, treeConfiguration);
        this.placeLeavesBlockWithVines(level, pos.m_122025_(3).m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlockWithVines(level, pos.m_122025_(3).m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlockWithVines(level, pos.m_122013_(2).m_122030_(2), randomSource, treeConfiguration);
        this.placeLeavesBlockWithVines(level, pos.m_122013_(2).m_122025_(2), randomSource, treeConfiguration);
        this.placeLeavesBlockWithVines(level, pos.m_122020_(2).m_122030_(2), randomSource, treeConfiguration);
        this.placeLeavesBlockWithVines(level, pos.m_122020_(2).m_122025_(2), randomSource, treeConfiguration);
        pos.m_122173_(Direction.UP);
        this.placeLeavesBlock(level, (BlockPos)pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2).m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2).m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2).m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2).m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122030_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122030_(2).m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122030_(2).m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122025_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122025_(2).m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122025_(2).m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(3), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(3), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122030_(3), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122025_(3), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2).m_122030_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2).m_122025_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2).m_122030_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2).m_122025_(2), randomSource, treeConfiguration);
        pos.m_122173_(Direction.UP);
        this.placeLeavesBlock(level, (BlockPos)pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_().m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2).m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122013_(2).m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2).m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122020_(2).m_122024_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122030_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122030_(2).m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122030_(2).m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122025_(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122025_(2).m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122025_(2).m_122019_(), randomSource, treeConfiguration);
        pos.m_122173_(Direction.UP);
        this.placeLeavesBlock(level, (BlockPos)pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122012_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122019_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122029_(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.m_122024_(), randomSource, treeConfiguration);
        return true;
    }

    public boolean placeLog(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration, Direction.Axis axis) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (KapokTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.m_7731_(pos, (BlockState)treeConfiguration.trunkProvider.m_213972_(randomSource, pos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis), 2);
        } else {
            return true;
        }
        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        }
        return true;
    }

    public boolean placeLogWithVines(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration, Direction.Axis axis) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos, ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 2);
        } else if (KapokTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.m_7731_(pos, (BlockState)treeConfiguration.trunkProvider.m_213972_(randomSource, pos).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis), 2);
            if (randomSource.m_188503_(3) != 0) {
                KapokTreeFeature.placeVine(level, pos);
            }
        } else {
            return true;
        }
        if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.PEAT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), ((Block)RuBlocks.SILT_DIRT.get()).m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_((Block)RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        } else if (level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_)) {
            level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 2);
        }
        return true;
    }

    private static void placeVine(LevelAccessor level, BlockPos pos) {
        Random random = new Random();
        int size = random.nextInt(10);
        BlockPos place = pos.m_7495_();
        for (int i = 0; i <= size; ++i) {
            if (level.m_8055_(place).m_60795_()) {
                if (i == size) {
                    level.m_7731_(place, (BlockState)((Block)RuBlocks.KAPOK_VINES.get()).m_49966_().m_61124_((Property)SpanishMossBlock.f_53924_, (Comparable)Integer.valueOf(25)), 2);
                } else {
                    level.m_7731_(place, ((Block)RuBlocks.KAPOK_VINES_PLANT.get()).m_49966_(), 2);
                }
            } else {
                if (i == 0) break;
                level.m_7731_(place.m_7494_(), (BlockState)((Block)RuBlocks.KAPOK_VINES.get()).m_49966_().m_61124_((Property)SpanishMossBlock.f_53924_, (Comparable)Integer.valueOf(25)), 2);
                break;
            }
            place = place.m_7495_();
        }
    }

    public void placeBranchDecorator(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (randomSource.m_188503_(10) == 0) {
            int rd = random.nextInt(4);
            if (rd == 0) {
                this.placeNorthBranch(level, pos, randomSource, treeConfiguration);
            } else if (rd == 1) {
                this.placeSouthBranch(level, pos, randomSource, treeConfiguration);
            } else if (rd == 2) {
                this.placeEastBranch(level, pos, randomSource, treeConfiguration);
            } else {
                this.placeWestBranch(level, pos, randomSource, treeConfiguration);
            }
        }
    }

    public void placeNorthBranch(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.m_8055_(pos.m_122012_()).m_247087_() && !level.m_151570_(pos.m_122012_())) {
            level.m_7731_(pos.m_122012_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.NORTH), 2);
        }
        if (level.m_8055_(pos.m_122012_().m_7494_()).m_247087_() && !level.m_151570_(pos.m_122012_().m_7494_())) {
            level.m_7731_(pos.m_122012_().m_7494_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122012_().m_122012_()).m_247087_() && !level.m_151570_(pos.m_122012_().m_122012_())) {
            level.m_7731_(pos.m_122012_().m_122012_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122012_().m_122029_()).m_247087_() && !level.m_151570_(pos.m_122012_().m_122029_())) {
            level.m_7731_(pos.m_122012_().m_122029_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122012_().m_122024_()).m_247087_() && !level.m_151570_(pos.m_122012_().m_122024_())) {
            level.m_7731_(pos.m_122012_().m_122024_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public void placeSouthBranch(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.m_8055_(pos.m_122019_()).m_247087_() && !level.m_151570_(pos.m_122019_())) {
            level.m_7731_(pos.m_122019_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.SOUTH), 2);
        }
        if (level.m_8055_(pos.m_122019_().m_7494_()).m_247087_() && !level.m_151570_(pos.m_122019_().m_7494_())) {
            level.m_7731_(pos.m_122019_().m_7494_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122019_().m_122019_()).m_247087_() && !level.m_151570_(pos.m_122019_().m_122019_())) {
            level.m_7731_(pos.m_122019_().m_122019_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122019_().m_122029_()).m_247087_() && !level.m_151570_(pos.m_122019_().m_122029_())) {
            level.m_7731_(pos.m_122019_().m_122029_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122019_().m_122024_()).m_247087_() && !level.m_151570_(pos.m_122019_().m_122024_())) {
            level.m_7731_(pos.m_122019_().m_122024_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public void placeEastBranch(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.m_8055_(pos.m_122029_()).m_247087_() && !level.m_151570_(pos.m_122029_())) {
            level.m_7731_(pos.m_122029_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.EAST), 2);
        }
        if (level.m_8055_(pos.m_122029_().m_7494_()).m_247087_() && !level.m_151570_(pos.m_122029_().m_7494_())) {
            level.m_7731_(pos.m_122029_().m_7494_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122029_().m_122029_()).m_247087_() && !level.m_151570_(pos.m_122029_().m_122029_())) {
            level.m_7731_(pos.m_122029_().m_122029_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122029_().m_122019_()).m_247087_() && !level.m_151570_(pos.m_122029_().m_122019_())) {
            level.m_7731_(pos.m_122029_().m_122019_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122029_().m_122012_()).m_247087_() && !level.m_151570_(pos.m_122029_().m_122012_())) {
            level.m_7731_(pos.m_122029_().m_122012_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public void placeWestBranch(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (level.m_8055_(pos.m_122024_()).m_247087_() && !level.m_151570_(pos.m_122024_())) {
            level.m_7731_(pos.m_122024_(), (BlockState)treeConfiguration.branchProvider.m_213972_(randomSource, pos).m_61124_((Property)BranchBlock.FACING, (Comparable)Direction.WEST), 2);
        }
        if (level.m_8055_(pos.m_122024_().m_7494_()).m_247087_() && !level.m_151570_(pos.m_122024_().m_7494_())) {
            level.m_7731_(pos.m_122024_().m_7494_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122024_().m_122024_()).m_247087_() && !level.m_151570_(pos.m_122024_().m_122024_())) {
            level.m_7731_(pos.m_122024_().m_122024_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122024_().m_122019_()).m_247087_() && !level.m_151570_(pos.m_122024_().m_122019_())) {
            level.m_7731_(pos.m_122024_().m_122019_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        if (level.m_8055_(pos.m_122024_().m_122012_()).m_247087_() && !level.m_151570_(pos.m_122024_().m_122012_())) {
            level.m_7731_(pos.m_122024_().m_122012_(), (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
    }

    public void placeRoot(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        int rd = random.nextInt(2) + 4;
        BlockPos.MutableBlockPos placePos = pos.m_122032_();
        for (int i = 0; i <= rd; ++i) {
            if (level.m_8055_((BlockPos)placePos).m_247087_() && level.m_8055_(placePos.m_7494_()).m_204336_(BlockTags.f_144274_)) {
                level.m_7731_((BlockPos)placePos, Blocks.f_152548_.m_49966_(), 2);
                break;
            }
            if (!level.m_8055_((BlockPos)placePos).m_204336_(BlockTags.f_144274_) && !level.m_8055_((BlockPos)placePos).m_204336_(BlockTags.f_278411_) && !level.m_46859_((BlockPos)placePos)) break;
            this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
            placePos.m_122173_(Direction.DOWN);
        }
    }

    public boolean placeLeavesBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_247087_()) {
            level.m_7731_(pos, (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
        }
        return true;
    }

    public boolean placeLeavesBlockWithVines(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.m_151570_(pos)) {
            return true;
        }
        if (level.m_8055_(pos).m_247087_()) {
            level.m_7731_(pos, (BlockState)treeConfiguration.foliageProvider.m_213972_(randomSource, pos).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 2);
            if (randomSource.m_188503_(3) == 0) {
                KapokTreeFeature.placeVine(level, pos);
            }
        }
        return true;
    }

    public boolean checkReplaceable(LevelAccessor level, BlockPos pos) {
        if (level.m_151570_(pos)) {
            return false;
        }
        return KapokTreeFeature.isReplaceable((LevelSimulatedReader)level, pos);
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.m_204336_(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, KapokTreeFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.m_204336_(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, KapokTreeFeature::isReplaceableBlock);
    }
}

