/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.network;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.lang3.tuple.Pair;

public final class ZetaMessageSerializer {
    private final HashMap<Class<?>, Pair<Reader, Writer>> handlers = new HashMap();
    private final HashMap<Class<?>, Field[]> fieldCache = new HashMap();

    public ZetaMessageSerializer() {
        this.mapFunctions(Byte.TYPE, FriendlyByteBuf::readByte, FriendlyByteBuf::writeByte);
        this.mapFunctions(Short.TYPE, FriendlyByteBuf::readShort, FriendlyByteBuf::writeShort);
        this.mapFunctions(Integer.TYPE, FriendlyByteBuf::readInt, FriendlyByteBuf::writeInt);
        this.mapFunctions(Long.TYPE, FriendlyByteBuf::readLong, FriendlyByteBuf::writeLong);
        this.mapFunctions(Float.TYPE, FriendlyByteBuf::readFloat, FriendlyByteBuf::writeFloat);
        this.mapFunctions(Double.TYPE, FriendlyByteBuf::readDouble, FriendlyByteBuf::writeDouble);
        this.mapFunctions(Boolean.TYPE, FriendlyByteBuf::readBoolean, FriendlyByteBuf::writeBoolean);
        this.mapFunctions(Character.TYPE, FriendlyByteBuf::readChar, FriendlyByteBuf::writeChar);
        this.mapFunctions(BlockPos.class, FriendlyByteBuf::m_130135_, FriendlyByteBuf::m_130064_);
        this.mapFunctions(Component.class, FriendlyByteBuf::m_130238_, FriendlyByteBuf::m_130083_);
        this.mapFunctions(UUID.class, FriendlyByteBuf::m_130259_, FriendlyByteBuf::m_130077_);
        this.mapFunctions(CompoundTag.class, FriendlyByteBuf::m_130260_, FriendlyByteBuf::m_130079_);
        this.mapFunctions(ItemStack.class, FriendlyByteBuf::m_130267_, ZetaMessageSerializer::writeItemStack);
        this.mapFunctions(String.class, ZetaMessageSerializer::readString, ZetaMessageSerializer::writeString);
        this.mapFunctions(ResourceLocation.class, FriendlyByteBuf::m_130281_, FriendlyByteBuf::m_130085_);
        this.mapFunctions(Date.class, FriendlyByteBuf::m_130282_, FriendlyByteBuf::m_130075_);
        this.mapFunctions(BlockHitResult.class, FriendlyByteBuf::m_130283_, FriendlyByteBuf::m_130062_);
    }

    public <T> T instantiateAndReadObject(Class<T> clazz, FriendlyByteBuf buf) {
        try {
            T msg = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.readObject(msg, buf);
            return msg;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public void readObject(Object obj, FriendlyByteBuf buf) {
        try {
            Field[] clFields;
            Class<?> clazz = obj.getClass();
            for (Field f : clFields = this.getClassFields(clazz)) {
                Class<?> type = f.getType();
                if (!this.acceptField(f, type)) continue;
                this.readField(obj, f, type, buf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at reading message " + String.valueOf(obj), e);
        }
    }

    public void writeObject(Object obj, FriendlyByteBuf buf) {
        try {
            Field[] clFields;
            Class<?> clazz = obj.getClass();
            for (Field f : clFields = this.getClassFields(clazz)) {
                Class<?> type = f.getType();
                if (!this.acceptField(f, type)) continue;
                this.writeField(obj, f, type, buf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error at writing message " + String.valueOf(obj), e);
        }
    }

    private Field[] getClassFields(Class<?> clazz) {
        if (this.fieldCache.containsKey(clazz)) {
            return this.fieldCache.get(clazz);
        }
        Field[] fields = clazz.getFields();
        Arrays.sort(fields, Comparator.comparing(Field::getName));
        this.fieldCache.put(clazz, fields);
        return fields;
    }

    private void writeField(Object obj, Field f, Class<?> clazz, FriendlyByteBuf buf) throws IllegalArgumentException, IllegalAccessException {
        Pair<Reader, Writer> handler = this.getHandler(clazz);
        ((Writer)handler.getRight()).write(buf, f, f.get(obj));
    }

    private void readField(Object obj, Field f, Class<?> clazz, FriendlyByteBuf buf) throws IllegalArgumentException, IllegalAccessException {
        Pair<Reader, Writer> handler = this.getHandler(clazz);
        f.set(obj, ((Reader)handler.getLeft()).read(buf, f));
    }

    private Pair<Reader, Writer> getHandler(Class<?> clazz) {
        Pair<Reader, Writer> pair = this.handlers.get(clazz);
        if (pair == null) {
            throw new RuntimeException("No R/W handler for  " + String.valueOf(clazz));
        }
        return pair;
    }

    private boolean acceptField(Field f, Class<?> type) {
        int mods = f.getModifiers();
        if (Modifier.isFinal(mods) || Modifier.isStatic(mods) || Modifier.isTransient(mods)) {
            return false;
        }
        return this.handlers.containsKey(type);
    }

    private <T> void mapFunctions(Class<T> type, Function<FriendlyByteBuf, T> readerLower, BiConsumer<FriendlyByteBuf, T> writerLower) {
        Reader<Object> reader = (buf, field) -> readerLower.apply(buf);
        Writer<Object> writer = (buf, field, t) -> writerLower.accept(buf, t);
        this.mapHandlers(type, reader, writer);
    }

    private <T> void mapWriterFunction(Class<T> type, Reader<T> reader, BiConsumer<FriendlyByteBuf, T> writerLower) {
        Writer<Object> writer = (buf, field, t) -> writerLower.accept(buf, t);
        this.mapHandlers(type, reader, writer);
    }

    private <T> void mapReaderFunction(Class<T> type, Function<FriendlyByteBuf, T> readerLower, Writer<T> writer) {
        Reader<Object> reader = (buf, field) -> readerLower.apply(buf);
        this.mapHandlers(type, reader, writer);
    }

    public <T> void mapHandlers(Class<T> type, Reader<T> reader, Writer<T> writer) {
        Class<?> arrayType = Array.newInstance(type, 0).getClass();
        Reader<Object[]> arrayReader = (buf, field) -> {
            int count = buf.readInt();
            Object[] arr = (Object[])Array.newInstance(type, count);
            for (int i = 0; i < count; ++i) {
                arr[i] = reader.read(buf, field);
            }
            return arr;
        };
        Writer<Object[]> arrayWriter = (buf, field, t) -> {
            int count = ((Object[])t).length;
            buf.writeInt(count);
            for (int i = 0; i < count; ++i) {
                writer.write(buf, field, t[i]);
            }
        };
        this.handlers.put(type, (Pair<Reader, Writer>)Pair.of(reader, writer));
        this.handlers.put(arrayType, (Pair<Reader, Writer>)Pair.of(arrayReader, arrayWriter));
    }

    private static void writeItemStack(FriendlyByteBuf buf, ItemStack stack) {
        buf.m_130055_(stack);
    }

    private static String readString(FriendlyByteBuf buf) {
        return buf.m_130136_(Short.MAX_VALUE);
    }

    private static void writeString(FriendlyByteBuf buf, String string) {
        buf.m_130070_(string);
    }

    public static interface Writer<T> {
        public void write(FriendlyByteBuf var1, Field var2, T var3);
    }

    public static interface Reader<T> {
        public T read(FriendlyByteBuf var1, Field var2);
    }
}

