/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.villagercomfort.room;

import com.mojang.logging.LogUtils;
import dev.ghen.villagercomfort.room.IRoomBlockAction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.slf4j.Logger;

public class RoomHelper {
    private static Logger LOGGER = LogUtils.getLogger();

    public static void runForEveryBlock(Level level, BlockPos roomStartPos, int maxVolume, IRoomBlockAction action) {
        ArrayList<Long> room = new ArrayList<Long>();
        ArrayDeque<BlockPos> room_run_queue = new ArrayDeque<BlockPos>();
        RoomHelper.checkAddLast(room, room_run_queue, maxVolume, roomStartPos);
        boolean initial_add = true;
        while (!room_run_queue.isEmpty()) {
            BlockPos block = (BlockPos)room_run_queue.pollFirst();
            action.run(block);
            if (!initial_add && (!level.m_8055_(block).m_60713_(Blocks.f_50016_) || !level.m_8055_(block.m_7494_()).m_60713_(Blocks.f_50016_))) continue;
            initial_add = false;
            RoomHelper.checkAddLast(room, room_run_queue, maxVolume, block.m_122012_());
            RoomHelper.checkAddLast(room, room_run_queue, maxVolume, block.m_122019_());
            RoomHelper.checkAddLast(room, room_run_queue, maxVolume, block.m_122024_());
            RoomHelper.checkAddLast(room, room_run_queue, maxVolume, block.m_122029_());
            RoomHelper.checkAddLast(room, room_run_queue, maxVolume, block.m_7494_());
            RoomHelper.checkAddLast(room, room_run_queue, maxVolume, block.m_7495_());
        }
    }

    private static void checkAddLast(List<Long> room, Deque<BlockPos> room_run_queue, int maxVolume, BlockPos pos) {
        if (room.size() >= maxVolume) {
            return;
        }
        if (!room.contains(pos.m_121878_())) {
            room.add(pos.m_121878_());
            room_run_queue.addLast(pos);
        }
    }
}

