/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.villagercomfort.comfort;

import com.mojang.logging.LogUtils;
import dev.ghen.villagercomfort.comfort.WorkplaceComfortValues;
import dev.ghen.villagercomfort.common.capabilty.ComfortValuesCap;
import dev.ghen.villagercomfort.common.capabilty.ModCapabilities;
import dev.ghen.villagercomfort.core.config.CommonConfig;
import dev.ghen.villagercomfort.core.math.MathHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import org.slf4j.Logger;

public class ComfortHelper {
    private static Logger LOGGER = LogUtils.getLogger();

    public static int calculatePriceModifier(Villager villager, ComfortValuesCap cap, int basePrice) {
        int comfort = ComfortHelper.getVillagerComfort(villager);
        int new_price = basePrice;
        if (comfort >= 0) {
            int price_reduction = MathHelper.interpolate(comfort, 0, ((Number)CommonConfig.MAX_COMFORT_RANGE.get()).intValue(), 100, ((Number)CommonConfig.MIN_COMFORT_PRICE_REDUCTION.get()).intValue());
            new_price = Math.round((float)(basePrice * price_reduction) / 100.0f);
        } else {
            int price_increase = MathHelper.interpolate(comfort, 0, -((Number)CommonConfig.MAX_COMFORT_RANGE.get()).intValue(), 0, ((Number)CommonConfig.MAX_COMFORT_PRICE_INCREASE.get()).intValue());
            new_price = basePrice + Math.round((float)(basePrice * price_increase) / 100.0f);
        }
        return new_price - basePrice;
    }

    public static int getVillagerComfort(Villager villager) {
        ComfortValuesCap cap = (ComfortValuesCap)villager.getCapability(ModCapabilities.COMFORT_VALUES_CAP).orElse(null);
        if (cap != null) {
            int days_without_outside;
            boolean has_workplace;
            int comfort = 0;
            int current_day = (int)(villager.m_9236_().m_46468_() / 24000L);
            if (cap.getLastSleepDay() > current_day) {
                cap.setLastSleepDay(-1);
            }
            if (cap.getLastSleepDay() == -2) {
                cap.setLastSleepDay(current_day - 1);
            }
            boolean has_bed = false;
            int last_sleep_day = cap.getLastSleepDay();
            int days_without_sleep = current_day - last_sleep_day - 1;
            if (cap.getBedsCount() > 0 && days_without_sleep <= 0) {
                has_bed = true;
            }
            if (cap.getLastZombieDay() > current_day) {
                cap.setLastZombieDay(-1);
            }
            if (cap.getLastZombieDay() == -2) {
                cap.setLastZombieDay(current_day - 1);
            }
            if (cap.last_day_outside > current_day) {
                cap.last_day_outside = -1;
            }
            if (cap.last_day_outside == -2) {
                cap.last_day_outside = current_day - 1;
            }
            if (villager.m_6274_().m_21874_(MemoryModuleType.f_26360_)) {
                if (cap.getWorkstationsCount() == 0) {
                    villager.m_6274_().m_21952_(MemoryModuleType.f_26360_).ifPresent(workstation -> {
                        cap.last_remembered_workstation_pos = workstation.m_122646_().m_121878_();
                    });
                    WorkplaceComfortValues.setValuesToCap(villager, cap);
                } else {
                    villager.m_6274_().m_21952_(MemoryModuleType.f_26360_).ifPresent(workstation -> {
                        Long workstation_pos = workstation.m_122646_().m_121878_();
                        if (workstation_pos != cap.last_remembered_workstation_pos) {
                            cap.last_remembered_workstation_pos = workstation_pos;
                            WorkplaceComfortValues.setValuesToCap(villager, cap);
                        }
                    });
                }
            }
            boolean bl = has_workplace = villager.m_6274_().m_21874_(MemoryModuleType.f_26360_) && cap.getWorkstationsCount() > 0;
            if (has_bed) {
                comfort = cap.getBedroomSize() >= ((Number)CommonConfig.PREFERRED_BEDROOM_SIZE.get()).intValue() ? (comfort += MathHelper.interpolate(cap.getBedroomSize(), ((Number)CommonConfig.PREFERRED_BEDROOM_SIZE.get()).intValue(), ((Number)CommonConfig.MAX_BEDROOM_SIZE.get()).intValue(), 0, ((Number)CommonConfig.MAX_BEDROOM_SIZE_COMFORT.get()).intValue())) : (comfort += MathHelper.interpolate(cap.getBedroomSize(), ((Number)CommonConfig.PREFERRED_BEDROOM_SIZE.get()).intValue(), ((Number)CommonConfig.MIN_BEDROOM_SIZE.get()).intValue(), 0, ((Number)CommonConfig.MIN_BEDROOM_SIZE_COMFORT.get()).intValue()));
                if (cap.getBedsCount() > ((Number)CommonConfig.BEDS_THRESHOLD.get()).intValue()) {
                    comfort += (cap.getBedsCount() - ((Number)CommonConfig.BEDS_THRESHOLD.get()).intValue()) * ((Number)CommonConfig.COMFORT_PER_BED.get()).intValue();
                }
                if (cap.getBedroomLight() > ((Number)CommonConfig.PREFERRED_BEDROOM_LIGHT.get()).intValue()) {
                    comfort += (cap.getBedroomLight() - ((Number)CommonConfig.PREFERRED_BEDROOM_LIGHT.get()).intValue()) * ((Number)CommonConfig.COMFORT_PER_MORE_BEDROOM_LIGHT.get()).intValue();
                } else if (cap.getBedroomLight() < ((Number)CommonConfig.PREFERRED_BEDROOM_LIGHT.get()).intValue()) {
                    comfort += (((Number)CommonConfig.PREFERRED_BEDROOM_LIGHT.get()).intValue() - cap.getBedroomLight()) * ((Number)CommonConfig.COMFORT_PER_LESS_BEDROOM_LIGHT.get()).intValue();
                }
                if (cap.getIsWorkstationInBedroom()) {
                    comfort += ((Number)CommonConfig.WORKSTATION_IN_BEDROOM_COMFORT.get()).intValue();
                }
            }
            if (has_workplace) {
                comfort = cap.getWorkplaceSize() >= ((Number)CommonConfig.PREFERRED_WORKPLACE_SIZE.get()).intValue() ? (comfort += MathHelper.interpolate(cap.getWorkplaceSize(), ((Number)CommonConfig.PREFERRED_WORKPLACE_SIZE.get()).intValue(), ((Number)CommonConfig.MAX_WORKPLACE_SIZE.get()).intValue(), 0, ((Number)CommonConfig.MAX_WORKPLACE_SIZE_COMFORT.get()).intValue())) : (comfort += MathHelper.interpolate(cap.getWorkplaceSize(), ((Number)CommonConfig.PREFERRED_WORKPLACE_SIZE.get()).intValue(), ((Number)CommonConfig.MIN_WORKPLACE_SIZE.get()).intValue(), 0, ((Number)CommonConfig.MIN_WORKPLACE_SIZE_COMFORT.get()).intValue()));
                if (cap.getWorkstationsCount() > ((Number)CommonConfig.WORKSTATIONS_THRESHOLD.get()).intValue()) {
                    comfort += (cap.getWorkstationsCount() - ((Number)CommonConfig.WORKSTATIONS_THRESHOLD.get()).intValue()) * ((Number)CommonConfig.COMFORT_PER_WORKSTATION.get()).intValue();
                }
                if (cap.getWorkplaceLight() > ((Number)CommonConfig.PREFERRED_WORKPLACE_LIGHT.get()).intValue()) {
                    comfort += (cap.getWorkplaceLight() - ((Number)CommonConfig.PREFERRED_WORKPLACE_LIGHT.get()).intValue()) * ((Number)CommonConfig.COMFORT_PER_MORE_WORKPLACE_LIGHT.get()).intValue();
                } else if (cap.getWorkplaceLight() < ((Number)CommonConfig.PREFERRED_WORKPLACE_LIGHT.get()).intValue()) {
                    comfort += (((Number)CommonConfig.PREFERRED_WORKPLACE_LIGHT.get()).intValue() - cap.getWorkplaceLight()) * ((Number)CommonConfig.COMFORT_PER_LESS_WORKPLACE_LIGHT.get()).intValue();
                }
            }
            if (has_bed && has_workplace) {
                comfort = cap.getBedWorkstationDistance() >= ((Number)CommonConfig.PREFERRED_BED_WORKPLACE_DISTANCE.get()).intValue() ? (comfort += MathHelper.interpolate(cap.getBedWorkstationDistance(), ((Number)CommonConfig.PREFERRED_BED_WORKPLACE_DISTANCE.get()).intValue(), ((Number)CommonConfig.MAX_BED_WORKPLACE_DISTANCE.get()).intValue(), 0, ((Number)CommonConfig.MAX_BED_WORKPLACE_DISTANCE_COMFORT.get()).intValue())) : (comfort += MathHelper.interpolate(cap.getBedWorkstationDistance(), ((Number)CommonConfig.PREFERRED_BED_WORKPLACE_DISTANCE.get()).intValue(), ((Number)CommonConfig.MIN_BED_WORKPLACE_DISTANCE.get()).intValue(), 0, ((Number)CommonConfig.MIN_BED_WORKPLACE_DISTANCE_COMFORT.get()).intValue()));
            }
            if ((days_without_outside = current_day - cap.last_day_outside - 1) >= ((Number)CommonConfig.MAX_DAYS_WITHOUT_OUTSIDE.get()).intValue()) {
                comfort += ((Number)CommonConfig.MAX_DAYS_WITHOUT_OUTSIDE.get()).intValue() * ((Number)CommonConfig.COMFORT_PER_DAY_WITHOUT_OUTSIDE.get()).intValue();
            } else if (days_without_outside > 0) {
                comfort += days_without_outside * ((Number)CommonConfig.COMFORT_PER_DAY_WITHOUT_OUTSIDE.get()).intValue();
            }
            int days_without_zombie = current_day - cap.getLastZombieDay() - 1;
            if (days_without_zombie >= ((Number)CommonConfig.MAX_DAYS_WITHOUT_PANIC.get()).intValue()) {
                comfort += ((Number)CommonConfig.MAX_DAYS_WITHOUT_PANIC.get()).intValue() * ((Number)CommonConfig.COMFORT_PER_DAY_WITHOUT_PANIC.get()).intValue();
            } else if (days_without_zombie > 0) {
                comfort += days_without_zombie * ((Number)CommonConfig.COMFORT_PER_DAY_WITHOUT_PANIC.get()).intValue();
            }
            last_sleep_day = cap.getLastSleepDay();
            days_without_sleep = current_day - last_sleep_day - 1;
            if (days_without_sleep > 0) {
                comfort += days_without_sleep * ((Number)CommonConfig.COMFORT_PER_DAY_WITHOUT_SLEEP.get()).intValue();
            }
            comfort = Mth.m_14045_((int)comfort, (int)(-((Number)CommonConfig.MAX_COMFORT_RANGE.get()).intValue()), (int)((Number)CommonConfig.MAX_COMFORT_RANGE.get()).intValue());
            cap.setComfort(comfort);
            return comfort;
        }
        return 0;
    }
}

