/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.event;

import com.obscuria.obscureapi.event.ObscureAPIEnchantmentsEvent;
import com.obscuria.obscureapi.event.ObscureAPIRegisterBossBarsEvent;
import com.obscuria.obscureapi.event.ObscureAPIRegisterClassesEvent;
import com.obscuria.obscureapi.event.ObscureAPIRegisterHandsEvent;
import com.obscuria.obscureapi.event.ObscureAPIRegisterHeartsEvent;
import com.obscuria.obscureapi.event.combat.ObscureAPICriticalHitEvent;
import com.obscuria.obscureapi.event.combat.ObscureAPIDodgeEvent;
import com.obscuria.obscureapi.event.combat.ObscureAPIParryEvent;
import com.obscuria.obscureapi.event.combat.ObscureAPIRegenerationEvent;
import javax.annotation.Nonnull;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;

public final class ObscureAPIHooks {
    public static boolean onParry(LivingEntity entity, LivingEntity source, float parry) {
        ObscureAPIParryEvent event = new ObscureAPIParryEvent(entity, source, parry);
        return !MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onDodge(LivingEntity entity, LivingEntity source, float dodge) {
        ObscureAPIDodgeEvent event = new ObscureAPIDodgeEvent(entity, source, dodge);
        return !MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static float onRegeneration(LivingEntity entity, float heal) {
        ObscureAPIRegenerationEvent event = new ObscureAPIRegenerationEvent(entity, heal);
        return MinecraftForge.EVENT_BUS.post((Event)event) ? 0.0f : event.getAmount();
    }

    public static float onCriticalHit(LivingEntity target, LivingEntity source, DamageSource damageSource, float damage) {
        ObscureAPICriticalHitEvent event = new ObscureAPICriticalHitEvent(target, source, damageSource, damage);
        return MinecraftForge.EVENT_BUS.post((Event)event) ? 0.0f : event.getAmount();
    }

    public static void registerClassesEvent() {
        ObscureAPIRegisterClassesEvent event = new ObscureAPIRegisterClassesEvent();
        ModLoader.get().postEvent((Event)event);
    }

    public static void registerHeartsEvent() {
        ObscureAPIRegisterHeartsEvent event = new ObscureAPIRegisterHeartsEvent();
        ModLoader.get().postEvent((Event)event);
    }

    public static void registerBossBarsEvent() {
        ObscureAPIRegisterBossBarsEvent event = new ObscureAPIRegisterBossBarsEvent();
        ModLoader.get().postEvent((Event)event);
    }

    public static void registerHandsEvent() {
        ObscureAPIRegisterHandsEvent event = new ObscureAPIRegisterHandsEvent();
        ModLoader.get().postEvent((Event)event);
    }

    @Nonnull
    public static ObscureAPIEnchantmentsEvent registerEnchantmentsEvent() {
        ObscureAPIEnchantmentsEvent event = new ObscureAPIEnchantmentsEvent();
        ModLoader.get().postEvent((Event)event);
        return event;
    }
}

