/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.ISpellContainerMutable;
import io.redspace.ironsspellbooks.command.SpellArgument;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;

public class CreateImbuedSwordCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.irons_spellbooks.create_imbued_sword.failed"));
    private static final SuggestionProvider<CommandSourceStack> SWORD_SUGGESTIONS = (context, builder) -> {
        Set resources = BuiltInRegistries.f_257033_.m_6579_().stream().filter(e -> e.getValue() instanceof SwordItem).map(e -> ((ResourceKey)e.getKey()).m_135782_()).collect(Collectors.toSet());
        return SharedSuggestionProvider.m_82926_(resources, (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher, CommandBuildContext context) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"createImbuedSword").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)context)).suggests(SWORD_SUGGESTIONS).then(Commands.m_82129_((String)"spell", (ArgumentType)SpellArgument.spellArgument()).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CreateImbuedSwordCommand.createImbuedSword((CommandSourceStack)ctx.getSource(), (ItemInput)ctx.getArgument("item", ItemInput.class), (String)ctx.getArgument("spell", String.class), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level")))))));
    }

    private static int createImbuedSword(CommandSourceStack source, ItemInput itemInput, String spell, int spellLevel) throws CommandSyntaxException {
        ItemStack itemstack;
        Item item;
        AbstractSpell abstractSpell;
        if (!((String)spell).contains(":")) {
            spell = "irons_spellbooks:" + (String)spell;
        }
        if (spellLevel > (abstractSpell = (AbstractSpell)SpellRegistry.REGISTRY.get().getValue(ResourceLocation.parse((String)spell))).getMaxLevel()) {
            throw new SimpleCommandExceptionType((Message)Component.m_237110_((String)"commands.irons_spellbooks.create_spell.failed_max_level", (Object[])new Object[]{abstractSpell.getSpellName(), abstractSpell.getMaxLevel()})).create();
        }
        ServerPlayer serverPlayer = source.m_230896_();
        if (serverPlayer != null && (item = (itemstack = new ItemStack((ItemLike)itemInput.m_120979_())).m_41720_()) instanceof SwordItem) {
            SwordItem swordItem = (SwordItem)item;
            ISpellContainerMutable spellContainer = ISpellContainer.create(1, true, false).mutableCopy();
            spellContainer.addSpell(abstractSpell, spellLevel, false);
            ISpellContainer.set(itemstack, spellContainer.toImmutable());
            if (serverPlayer.m_150109_().m_36054_(itemstack)) {
                return 1;
            }
        }
        throw ERROR_FAILED.create();
    }
}

