/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.util;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.interfaces.IDOBlock;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IConcreteDeliverable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomumOrnamentumUtils {
    public static String DO_NBT_TEXTURE_DATA = "textureData";

    @Nullable
    public static IMateriallyTexturedBlock getBlock(@NotNull ItemStack stack) {
        IMateriallyTexturedBlock doBlock;
        BlockItem bi;
        Item item = stack.m_41720_();
        return item instanceof BlockItem && (item = (bi = (BlockItem)item).m_40614_()) instanceof IMateriallyTexturedBlock ? (doBlock = (IMateriallyTexturedBlock)item) : null;
    }

    @NotNull
    public static ItemStack getRequestedStack(@NotNull IRequest<?> request) {
        Object object = request.getRequest();
        if (object instanceof IConcreteDeliverable) {
            IConcreteDeliverable deliverable = (IConcreteDeliverable)object;
            for (ItemStack stack : deliverable.getRequestedItems()) {
                if (DomumOrnamentumUtils.getBlock(stack) == null) continue;
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public static MaterialTextureData getTextureData(@NotNull ItemStack stack) {
        if (!stack.m_41782_()) {
            return MaterialTextureData.EMPTY;
        }
        CompoundTag tag = stack.m_41784_().m_128469_(DO_NBT_TEXTURE_DATA);
        return MaterialTextureData.deserializeFromNBT((CompoundTag)tag);
    }

    public static boolean isDoBlock(Block block) {
        return block instanceof IDOBlock;
    }

    public static MaterialTextureData getTextureDataFromNBT(CompoundTag nbt) {
        if (nbt == null || !nbt.m_128441_(DO_NBT_TEXTURE_DATA)) {
            return null;
        }
        if (nbt.m_128425_(DO_NBT_TEXTURE_DATA, 10)) {
            return MaterialTextureData.deserializeFromNBT((CompoundTag)nbt.m_128469_(DO_NBT_TEXTURE_DATA));
        }
        return null;
    }

    private DomumOrnamentumUtils() {
    }
}

