/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.tileentities;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.tileentities.AbstractTileEntityScarecrow;
import com.minecolonies.api.tileentities.ScareCrowType;
import com.minecolonies.core.Network;
import com.minecolonies.core.network.messages.server.colony.building.fields.FarmFieldRegistrationMessage;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityScarecrow
extends AbstractTileEntityScarecrow {
    private final Random random = new Random();
    private IColony currentColony;
    private ScareCrowType type;
    private int[] fieldSize = new int[]{5, 5, 5, 5};

    public TileEntityScarecrow(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public ScareCrowType getScarecrowType() {
        if (this.type == null) {
            ScareCrowType[] values = ScareCrowType.values();
            this.type = values[this.random.nextInt(values.length)];
        }
        return this.type;
    }

    @Override
    public IColony getCurrentColony() {
        if (this.currentColony == null && this.f_58857_ != null) {
            this.currentColony = IColonyManager.getInstance().getIColony(this.f_58857_, this.f_58858_);
            if (this.currentColony != null) {
                Network.getNetwork().sendToServer(new FarmFieldRegistrationMessage(this.currentColony, this.f_58858_));
            }
        }
        return this.currentColony;
    }

    public void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128385_("radius", this.fieldSize);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        if (compoundTag.m_128441_("radius")) {
            this.fieldSize = compoundTag.m_128465_("radius");
        }
    }

    public void setFieldSize(Direction direction, int radius) {
        this.fieldSize[direction.m_122416_()] = Math.min(radius, 20);
        this.m_6596_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    public int[] getFieldSize() {
        return this.fieldSize;
    }
}

