/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class PlantIngredient
extends Ingredient {
    public static final ResourceLocation ID = new ResourceLocation("minecolonies", "plant");
    private static final Lazy<PlantIngredient> INSTANCE = Lazy.of(() -> new PlantIngredient(ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof BlockItem && (((BlockItem)item).m_40614_() instanceof CropBlock || ((BlockItem)item).m_40614_() instanceof StemBlock)).map(item -> new Ingredient.ItemValue(new ItemStack((ItemLike)item)))));

    protected PlantIngredient(Stream<? extends Ingredient.Value> itemLists) {
        super(itemLists);
    }

    @NotNull
    public static PlantIngredient getInstance() {
        return (PlantIngredient)((Object)INSTANCE.get());
    }

    @NotNull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        Serializer.getInstance().write(json, this);
        return json;
    }

    @NotNull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.getInstance();
    }

    public static class Serializer
    implements IIngredientSerializer<PlantIngredient> {
        private static final Serializer INSTANCE = new Serializer();

        public static Serializer getInstance() {
            return INSTANCE;
        }

        private Serializer() {
        }

        @NotNull
        public PlantIngredient parse(@NotNull JsonObject json) {
            return PlantIngredient.getInstance();
        }

        public void write(@NotNull JsonObject json, @NotNull PlantIngredient ingredient) {
            json.addProperty("type", Objects.requireNonNull(CraftingHelper.getID((IIngredientSerializer)this)).toString());
        }

        @NotNull
        public PlantIngredient parse(@NotNull FriendlyByteBuf buffer) {
            return PlantIngredient.getInstance();
        }

        public void write(@NotNull FriendlyByteBuf buffer, @NotNull PlantIngredient ingredient) {
        }
    }
}

