/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.minecolonies.api.colony.IAnimalData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.Log;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewAnimalViewDataMessage
implements IMessage {
    private int colonyId;
    private ResourceKey<Level> dimension;
    private Set<IAnimalData> animals;
    private FriendlyByteBuf animalBuf;
    private boolean refresh;

    public ColonyViewAnimalViewDataMessage() {
    }

    public ColonyViewAnimalViewDataMessage(@NotNull IColony colony, @NotNull Set<IAnimalData> animals, boolean refresh) {
        this.colonyId = colony.getID();
        this.dimension = colony.getDimension();
        this.animals = animals;
        this.refresh = refresh;
        this.animalBuf = new FriendlyByteBuf(Unpooled.buffer());
        for (IAnimalData data : animals) {
            this.animalBuf.writeInt(data.getId());
            data.serializeViewNetworkData(this.animalBuf);
        }
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.colonyId = buf.readInt();
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(buf.m_130136_(Short.MAX_VALUE)));
        this.refresh = buf.readBoolean();
        this.animalBuf = new FriendlyByteBuf(buf.retain());
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        this.animalBuf.resetReaderIndex();
        buf.writeInt(this.colonyId);
        buf.m_130070_(this.dimension.m_135782_().toString());
        buf.writeBoolean(this.refresh);
        buf.writeInt(this.animals.size());
        buf.writeBytes((ByteBuf)this.animalBuf);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        IColonyView colony = IColonyManager.getInstance().getColonyView(this.colonyId, this.dimension);
        if (colony == null) {
            Log.getLogger().warn("Received animal data for nonexisting colony:" + this.colonyId + " dim:" + String.valueOf(this.dimension));
        } else {
            colony.handleColonyViewAnimalMessage(this.animalBuf, this.refresh);
        }
        this.animalBuf.release();
    }
}

