/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.navigation;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.other.MinecoloniesMinecart;
import com.minecolonies.api.entity.pathfinding.IDynamicHeuristicNavigator;
import com.minecolonies.api.entity.pathfinding.IMinecoloniesNavigator;
import com.minecolonies.api.entity.pathfinding.IStuckHandler;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.ShapeUtil;
import com.minecolonies.api.util.Vec3Mutable;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.entity.other.cavalry.CavalryHorseEntity;
import com.minecolonies.core.entity.pathfinding.PathFindingStatus;
import com.minecolonies.core.entity.pathfinding.PathPointExtended;
import com.minecolonies.core.entity.pathfinding.Pathfinding;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.navigation.AbstractAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.navigation.MovementHandler;
import com.minecolonies.core.entity.pathfinding.navigation.PathingStuckHandler;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobFindTree;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobMoveAwayFromLocation;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobMoveCloseToXNearY;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobMoveToLocation;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobMoveTowards;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobRandomPos;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import com.minecolonies.core.entity.pathfinding.pathresults.TreePathResult;
import com.minecolonies.core.util.WorkerUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinecoloniesAdvancedPathNavigate
extends AbstractAdvancedPathNavigate
implements IDynamicHeuristicNavigator,
IMinecoloniesNavigator {
    private static final double ON_PATH_SPEED_MULTIPLIER = 1.3;
    public static final double MIN_Y_DISTANCE = 0.001;
    public static final int MAX_SPEED_ALLOWED = 2;
    public static final double MIN_SPEED_ALLOWED = 0.1;
    @Nullable
    private PathResult<? extends AbstractPathJob> pathResult;
    private BlockPos spawnedPos = BlockPos.f_121853_;
    private BlockPos safeDestinationPos;
    private IStuckHandler<MinecoloniesAdvancedPathNavigate> stuckHandler;
    private boolean isSneaking = true;
    private double swimSpeedFactor = 1.0;
    private double heuristicAvg = 1.0;
    private int pauseTicks = 0;
    private int pauseTickBackupAmount = 10;
    private BlockPos.MutableBlockPos tempPos = new BlockPos.MutableBlockPos();
    private Vec3Mutable wantedPosition = Vec3Mutable.createEmpty();
    private int checkStuckDelay = 10;
    private long finishTime = Long.MAX_VALUE;

    public MinecoloniesAdvancedPathNavigate(@NotNull Mob entity, Level world) {
        super(entity, world);
        entity.f_21342_ = new MovementHandler(entity);
        this.f_26508_ = new WalkNodeEvaluator();
        this.f_26508_.m_77351_(true);
        this.getPathingOptions().setEnterDoors(true);
        this.f_26508_.m_77355_(true);
        this.getPathingOptions().setCanOpenDoors(true);
        this.f_26508_.m_77358_(true);
        this.getPathingOptions().setCanSwim(true);
        this.stuckHandler = PathingStuckHandler.createStuckHandler().withTakeDamageOnStuck(0.2f).withTeleportSteps(6).withTeleportOnFullStuck();
    }

    @Nullable
    protected PathResult<PathJobMoveAwayFromLocation> walkAwayFrom(BlockPos avoid, double range, double speedFactor, boolean safeDestination) {
        @NotNull BlockPos start = PathfindingUtils.prepareStart((LivingEntity)this.ourEntity);
        return this.setPathJob(new PathJobMoveAwayFromLocation(CompatibilityUtils.getWorldFromEntity((Entity)this.ourEntity), start, avoid, (int)range, (int)this.ourEntity.m_21051_(Attributes.f_22277_).m_22135_(), this.ourEntity), null, speedFactor, safeDestination);
    }

    @Override
    @Nullable
    protected PathResult<AbstractPathJob> walkTowards(BlockPos towards, double range, double speedFactor) {
        return this.setPathJob(new PathJobMoveTowards(CompatibilityUtils.getWorldFromEntity((Entity)this.ourEntity), PathfindingUtils.prepareStart((LivingEntity)this.ourEntity), towards, (int)range, this.ourEntity), null, speedFactor, false);
    }

    @Nullable
    protected PathResult<PathJobRandomPos> walkToRandomPos(int range, double speedFactor) {
        @NotNull BlockPos start = PathfindingUtils.prepareStart((LivingEntity)this.ourEntity);
        PathResult<PathJobRandomPos> result = this.setPathJob(new PathJobRandomPos(CompatibilityUtils.getWorldFromEntity((Entity)this.ourEntity), start, range, (int)this.ourEntity.m_21051_(Attributes.f_22277_).m_22135_(), this.ourEntity), null, speedFactor, true);
        if (result == null) {
            return null;
        }
        ((PathJobRandomPos)result.getJob()).getPathingOptions().withToggleCost((double)1.0).withJumpCost((double)1.0).withDropCost((double)1.0).canDrop = false;
        return result;
    }

    @Nullable
    protected PathResult<PathJobRandomPos> walkToRandomPosAround(int range, double speedFactor, BlockPos pos) {
        PathResult<PathJobRandomPos> result = this.setPathJob(new PathJobRandomPos(CompatibilityUtils.getWorldFromEntity((Entity)this.ourEntity), PathfindingUtils.prepareStart((LivingEntity)this.ourEntity), 3, (int)this.ourEntity.m_21051_(Attributes.f_22277_).m_22135_(), range, this.ourEntity, pos), pos, speedFactor, false);
        if (result == null) {
            return null;
        }
        ((PathJobRandomPos)result.getJob()).getPathingOptions().withToggleCost((double)1.0).withJumpCost((double)1.0).withDropCost((double)1.0).canDrop = false;
        return result;
    }

    protected PathResult<PathJobRandomPos> walkToRandomPos(int range, double speedFactor, Tuple<BlockPos, BlockPos> corners) {
        return this.walkToRandomPos(range, speedFactor, corners, false);
    }

    @Override
    protected PathResult<PathJobRandomPos> walkToRandomPos(int range, double speedFactor, Tuple<BlockPos, BlockPos> corners, boolean preferInside) {
        @NotNull BlockPos start = PathfindingUtils.prepareStart((LivingEntity)this.ourEntity);
        PathResult<PathJobRandomPos> result = this.setPathJob(new PathJobRandomPos(CompatibilityUtils.getWorldFromEntity((Entity)this.ourEntity), start, range, (int)this.ourEntity.m_21051_(Attributes.f_22277_).m_22135_(), this.ourEntity, (BlockPos)corners.m_14418_(), (BlockPos)corners.m_14419_(), preferInside), null, speedFactor, true);
        if (result == null) {
            return null;
        }
        ((PathJobRandomPos)result.getJob()).getPathingOptions().withJumpCost((double)1.0).withDropCost((double)1.0).canDrop = false;
        return result;
    }

    @Override
    protected PathResult<PathJobMoveCloseToXNearY> walkCloseToXNearY(BlockPos desiredPosition, BlockPos nearbyPosition, int distToDesired, double speedFactor, boolean safeDestination) {
        PathJobMoveCloseToXNearY pathJob = new PathJobMoveCloseToXNearY(this.ourEntity.f_19853_, desiredPosition, nearbyPosition, 1, this.ourEntity);
        return this.setPathJob(pathJob, desiredPosition, speedFactor, safeDestination);
    }

    @Override
    @Nullable
    public <T extends AbstractPathJob> PathResult<T> setPathJob(@NotNull AbstractPathJob job, BlockPos dest, double speedFactor, boolean safeDestination) {
        if (this.pauseTicks > 0) {
            return null;
        }
        if (this.ourEntity.m_20089_() != Pose.STANDING) {
            this.ourEntity.m_20124_(Pose.STANDING);
        }
        if (this.pathResult != null) {
            this.pathResult.cancel();
            this.pathResult.setStatus(PathFindingStatus.CANCELLED);
            this.pathResult = null;
        }
        super.m_26573_();
        if (dest != null && job.getStart().m_123331_((Vec3i)dest) > 810000.0) {
            Log.getLogger().error("Entity: " + this.ourEntity.m_5446_().getString() + " is trying to walk too far! distance:" + Math.sqrt(job.getStart().m_123331_((Vec3i)dest)) + " from:" + String.valueOf(job.getStart()) + " to:" + String.valueOf(dest), (Throwable)new Exception());
            if (!dest.equals((Object)BlockPos.f_121853_)) {
                Mob mob = this.ourEntity;
                if (mob instanceof AbstractEntityCitizen) {
                    AbstractEntityCitizen citizen = (AbstractEntityCitizen)mob;
                    BlockPos tpPos = citizen.getCitizenData().getHomePosition();
                    this.ourEntity.m_6027_((double)tpPos.m_123341_(), (double)tpPos.m_123342_(), (double)tpPos.m_123343_());
                    return null;
                }
                this.ourEntity.m_6027_((double)dest.m_123341_(), (double)dest.m_123342_(), (double)dest.m_123343_());
            }
            this.pauseTicks = 6000;
            return null;
        }
        this.finishTime = Long.MAX_VALUE;
        this.originalDestination = dest;
        if (safeDestination) {
            this.safeDestinationPos = dest;
        }
        this.walkSpeedFactor = speedFactor;
        if (speedFactor > 2.0 || speedFactor < 0.1) {
            Log.getLogger().error("Tried to set a bad speed:" + speedFactor + " for entity:" + String.valueOf(this.ourEntity), (Throwable)new Exception());
            return null;
        }
        job.setPathingOptions(this.getPathingOptions());
        this.pathResult = job.getResult();
        this.pathResult.startJob(Pathfinding.getExecutor());
        return this.pathResult;
    }

    public boolean m_26571_() {
        return (this.pathResult == null || this.pathResult.isDone() && this.pathResult.getStatus() != PathFindingStatus.CALCULATION_COMPLETE) && super.m_26571_();
    }

    public void m_7638_() {
        if (this.checkStuckDelay-- < 0) {
            this.checkStuckDelay = 10;
            this.stuckHandler.checkStuck(this);
        }
        if (this.pauseTicks > 0) {
            --this.pauseTicks;
        }
        if (this.pathResult != null) {
            if (!this.pathResult.isDone()) {
                return;
            }
            if (this.pathResult.getStatus() == PathFindingStatus.CALCULATION_COMPLETE) {
                this.processCompletedCalculationResult();
                this.wantedPosition.setEmpty();
            }
        }
        int oldIndex = this.m_26571_() ? 0 : this.m_26570_().m_77399_();
        this.ourEntity.m_21567_(0.0f);
        if (this.handleLadders(oldIndex)) {
            this.m_7636_();
            return;
        }
        if (this.isSneaking) {
            this.isSneaking = false;
            this.f_26494_.m_20260_(false);
        }
        if (this.handleRails()) {
            return;
        }
        ++this.f_26498_;
        if (this.f_26506_) {
            this.m_26569_();
        }
        if (!this.m_26571_()) {
            int currentPathIndex = this.f_26496_.m_77399_();
            this.m_7636_();
            if (this.f_26496_ != null && !this.f_26496_.m_77392_() && (this.wantedPosition.empty() || currentPathIndex != this.f_26496_.m_77399_() && this.f_26496_.m_77399_() < this.f_26496_.m_77398_())) {
                Vec3 vector3d2 = this.f_26496_.m_77380_((Entity)this.f_26494_);
                this.tempPos.m_122178_(Mth.m_14107_((double)vector3d2.f_82479_), Mth.m_14107_((double)vector3d2.f_82480_), Mth.m_14107_((double)vector3d2.f_82481_));
                if (this.wantedPosition.empty() || ChunkPos.m_151388_((BlockPos)this.tempPos) == this.f_26494_.m_146902_().m_45588_() || WorldUtil.isEntityBlockLoaded((LevelAccessor)this.f_26495_, (BlockPos)this.tempPos)) {
                    this.wantedPosition.set(vector3d2.f_82479_, MinecoloniesAdvancedPathNavigate.getSmartGroundY((BlockGetter)this.f_26495_, this.tempPos, vector3d2.f_82480_), vector3d2.f_82481_);
                }
            }
            if (this.wantedPosition != null) {
                this.f_26494_.m_21566_().m_6849_(this.wantedPosition.getX(), this.wantedPosition.getY(), this.wantedPosition.getZ(), this.f_26497_);
            }
        }
        if (this.pathResult != null && this.m_26571_()) {
            this.pathResult.setStatus(PathFindingStatus.COMPLETE);
            if (this.ourEntity.f_19853_.m_46467_() - this.finishTime > (long)(400 + this.pauseTickBackupAmount)) {
                this.pathResult = null;
            }
        }
    }

    public static double getSmartGroundY(BlockGetter world, BlockPos.MutableBlockPos pos, double orgY) {
        VoxelShape voxelshape;
        BlockState state = world.m_8055_((BlockPos)pos);
        if (!state.m_60795_()) {
            if (state.m_60734_() instanceof FenceGateBlock || state.m_60734_() instanceof DoorBlock || state.m_60734_() instanceof TrapDoorBlock) {
                return orgY;
            }
            voxelshape = state.m_60812_(world, (BlockPos)pos);
            if (!ShapeUtil.isEmpty(voxelshape)) {
                return (double)pos.m_123342_() + ShapeUtil.max(voxelshape, Direction.Axis.Y);
            }
        }
        pos.m_122178_(pos.m_123341_(), pos.m_123342_() - 1, pos.m_123343_());
        state = world.m_8055_((BlockPos)pos);
        if (!state.m_60795_() && !ShapeUtil.isEmpty(voxelshape = state.m_60812_(world, (BlockPos)pos))) {
            return (double)pos.m_123342_() + ShapeUtil.max(voxelshape, Direction.Axis.Y);
        }
        return orgY;
    }

    @Nullable
    protected PathResult<PathJobMoveToLocation> walkTo(BlockPos desiredPos, double speedFactor, boolean safeDestination) {
        @NotNull BlockPos start = PathfindingUtils.prepareStart((LivingEntity)this.ourEntity);
        return this.setPathJob(new PathJobMoveToLocation(CompatibilityUtils.getWorldFromEntity((Entity)this.ourEntity), start, desiredPos, (int)this.ourEntity.m_21051_(Attributes.f_22277_).m_22135_(), this.ourEntity), desiredPos, speedFactor, safeDestination);
    }

    @Override
    @Deprecated(since="Do not use, always returns true, vanilla override")
    public boolean walkTo(BlockPos pos, double speedFactor) {
        this.walkTo(pos, speedFactor, false);
        return true;
    }

    protected PathFinder m_5532_(int p_179679_1_) {
        return null;
    }

    protected boolean m_7632_() {
        return true;
    }

    @NotNull
    protected Vec3 m_7475_() {
        return this.ourEntity.m_20182_();
    }

    public Path m_7864_(BlockPos pos, int p_179680_2_) {
        return null;
    }

    protected boolean m_183431_(Vec3 start, Vec3 end) {
        return !WorkerUtil.isPathBlock(this.f_26495_.m_8055_(BlockPos.m_274561_((double)start.f_82479_, (double)(start.f_82480_ - 1.0), (double)start.f_82481_)).m_60734_()) && super.m_183431_(start, end);
    }

    public double getSpeedFactor() {
        if (this.ourEntity.m_20069_()) {
            this.f_26497_ = this.walkSpeedFactor * this.swimSpeedFactor;
            return this.f_26497_;
        }
        this.f_26497_ = this.walkSpeedFactor;
        return this.walkSpeedFactor;
    }

    public void m_26517_(double speedFactor) {
        if (speedFactor > 2.0 || speedFactor < 0.1) {
            Log.getLogger().error("Tried to set a bad speed:" + speedFactor + " for entity:" + String.valueOf(this.ourEntity), (Throwable)new Exception());
            return;
        }
        this.walkSpeedFactor = speedFactor;
    }

    @Deprecated(since="Do not use, always returns true, vanilla override")
    public boolean m_26519_(double x, double y, double z, double speedFactor) {
        this.walkTo(BlockPos.m_274561_((double)x, (double)y, (double)z), speedFactor, false);
        return true;
    }

    public boolean m_5624_(Entity entityIn, double speedFactor) {
        return this.walkTo(entityIn.m_20183_(), speedFactor);
    }

    protected void m_6804_() {
    }

    @Deprecated(since="Do not use, always returns true, vanilla override")
    public boolean m_26536_(@Nullable Path path, double speedFactor) {
        if (path == null) {
            super.m_26573_();
            return false;
        }
        return super.m_26536_(this.convertPath(path), speedFactor);
    }

    private Path convertPath(Path path) {
        int pathLength = path.m_77398_();
        Path tempPath = null;
        if (pathLength > 0 && !(path.m_77375_(0) instanceof PathPointExtended)) {
            @NotNull PathPointExtended[] newPoints = new PathPointExtended[pathLength];
            for (int i = 0; i < pathLength; ++i) {
                Node point = path.m_77375_(i);
                newPoints[i] = !(point instanceof PathPointExtended) ? new PathPointExtended(new BlockPos(point.f_77271_, point.f_77272_, point.f_77273_)) : (PathPointExtended)point;
            }
            tempPath = new Path(Arrays.asList(newPoints), path.m_77406_(), path.m_77403_());
        }
        return tempPath == null ? path : tempPath;
    }

    private void processCompletedCalculationResult() {
        if (this.pathResult == null) {
            return;
        }
        if (this.pathResult != null) {
            this.pathResult.setStatus(PathFindingStatus.IN_PROGRESS_FOLLOWING);
        }
        if (this.pathResult.hasPath() && this.pathResult.getPathLength() > 2 && this.pathResult.costPerDist != 1.0) {
            double factor = 1.0 + (double)this.pathResult.getPathLength() / 30.0;
            this.heuristicAvg -= this.heuristicAvg / (50.0 / factor);
            this.heuristicAvg += this.pathResult.costPerDist / (50.0 / factor);
        }
        if (this.pathResult.failedToReachDestination()) {
            this.pauseTicks = this.pauseTickBackupAmount;
            this.pauseTickBackupAmount += 10;
            if (this.pathResult.searchedNodes >= 5000) {
                this.pauseTicks += 50;
            }
        } else {
            this.pauseTickBackupAmount = 10;
        }
        this.m_26536_(this.pathResult.getPath(), this.getSpeedFactor());
    }

    private boolean handleLadders(int oldIndex) {
        if (!this.m_26571_()) {
            @NotNull PathPointExtended pEx = (PathPointExtended)this.m_26570_().m_77375_(this.m_26570_().m_77399_());
            PathPointExtended pExNext = this.m_26570_().m_77398_() > this.m_26570_().m_77399_() + 1 ? (PathPointExtended)this.m_26570_().m_77375_(this.m_26570_().m_77399_() + 1) : null;
            this.tempPos.m_122178_(pEx.f_77271_, pEx.f_77272_, pEx.f_77273_);
            if (pEx.isOnLadder() && pExNext != null && (pEx.f_77272_ != pExNext.f_77272_ || this.f_26494_.m_20186_() > (double)pEx.f_77272_) && PathfindingUtils.isLadder(this.f_26495_.m_8055_((BlockPos)this.tempPos), this.pathResult != null ? this.pathResult.getJob().getPathingOptions() : this.getPathingOptions()) && this.f_26495_.m_8055_((BlockPos)this.tempPos).m_60819_().m_76178_()) {
                return this.handlePathPointOnLadder(pEx);
            }
            if (this.ourEntity.m_20069_()) {
                return this.handleEntityInWater(oldIndex, pEx);
            }
            if (this.f_26495_.f_46441_.m_188503_(20) == 0) {
                this.f_26497_ = !pEx.isOnLadder() && pExNext != null && pExNext.isOnLadder() ? this.getSpeedFactor() / 4.0 : (WorkerUtil.isPathBlock(this.f_26495_.m_8055_(this.findBlockUnderEntity((Entity)this.ourEntity)).m_60734_()) ? 1.3 * this.getSpeedFactor() : this.getSpeedFactor());
            }
        }
        return false;
    }

    private BlockPos findBlockUnderEntity(@NotNull Entity parEntity) {
        int blockX = (int)Math.round(parEntity.m_20185_());
        int blockY = Mth.m_14107_((double)(parEntity.m_20186_() - 0.2));
        int blockZ = (int)Math.round(parEntity.m_20189_());
        return this.tempPos.m_122178_(blockX, blockY, blockZ);
    }

    private boolean handleRails() {
        if (!this.m_26571_()) {
            PathPointExtended pExNext;
            @NotNull PathPointExtended pEx = (PathPointExtended)this.m_26570_().m_77375_(this.m_26570_().m_77399_());
            PathPointExtended pathPointExtended = pExNext = this.m_26570_().m_77398_() > this.m_26570_().m_77399_() + 1 ? (PathPointExtended)this.m_26570_().m_77375_(this.m_26570_().m_77399_() + 1) : null;
            if (pExNext != null && pEx.f_77271_ == pExNext.f_77271_ && pEx.f_77273_ == pExNext.f_77273_) {
                PathPointExtended pathPointExtended2 = pExNext = this.m_26570_().m_77398_() > this.m_26570_().m_77399_() + 2 ? (PathPointExtended)this.m_26570_().m_77375_(this.m_26570_().m_77399_() + 2) : null;
            }
            if (pEx.isOnRails() || pEx.isRailsExit()) {
                return this.handlePathOnRails(pEx, pExNext);
            }
        }
        return false;
    }

    private boolean handlePathOnRails(PathPointExtended pEx, PathPointExtended pExNext) {
        if (pEx.isRailsEntry()) {
            this.tempPos.m_122178_(pEx.f_77271_, pEx.f_77272_, pEx.f_77273_);
            if (!this.spawnedPos.equals((Object)this.tempPos)) {
                BlockState blockstate = this.f_26495_.m_8055_((BlockPos)this.tempPos);
                RailShape railshape = blockstate.m_60734_() instanceof BaseRailBlock ? ((BaseRailBlock)blockstate.m_60734_()).getRailDirection(blockstate, (BlockGetter)this.f_26495_, (BlockPos)this.tempPos, null) : RailShape.NORTH_SOUTH;
                double yOffset = 0.0;
                if (railshape.m_61745_()) {
                    yOffset = 0.5;
                }
                if (this.f_26494_.f_19824_ instanceof MinecoloniesMinecart) {
                    ((MinecoloniesMinecart)this.f_26494_.f_19824_).m_38160_(1);
                } else {
                    MinecoloniesMinecart minecart = (MinecoloniesMinecart)ModEntities.MINECART.m_20615_(this.f_26495_);
                    double x = (double)pEx.f_77271_ + 0.5;
                    double y = (double)pEx.f_77272_ + 0.625 + yOffset;
                    double z = (double)pEx.f_77273_ + 0.5;
                    minecart.m_6034_(x, y, z);
                    minecart.m_20256_(Vec3.f_82478_);
                    minecart.f_19854_ = x;
                    minecart.f_19855_ = y;
                    minecart.f_19856_ = z;
                    this.f_26495_.m_7967_((Entity)minecart);
                    minecart.m_38160_(1);
                    this.f_26494_.m_7998_((Entity)minecart, true);
                }
                this.spawnedPos = this.tempPos.m_7949_();
            }
        } else {
            this.spawnedPos = BlockPos.f_121853_;
        }
        if (this.f_26494_.f_19824_ instanceof MinecoloniesMinecart && pExNext != null) {
            Vec3 motion = this.f_26494_.f_19824_.m_20184_();
            switch (BlockPosUtil.directionFromDelta(pExNext.f_77271_ - pEx.f_77271_, 0, pExNext.f_77273_ - pEx.f_77273_).m_122424_()) {
                case EAST: {
                    double forward = Math.min(Math.max(motion.m_7096_() - 0.01, -1.0), 0.0);
                    this.f_26494_.f_19824_.m_20256_(motion.m_82520_(forward == -1.0 ? -1.0 : -0.01, 0.0, 0.0));
                    break;
                }
                case WEST: {
                    double forward = Math.max(Math.min(motion.m_7096_() + 0.01, 1.0), 0.0);
                    this.f_26494_.f_19824_.m_20256_(motion.m_82520_(forward == 1.0 ? 1.0 : 0.01, 0.0, 0.0));
                    break;
                }
                case NORTH: {
                    double forward = Math.max(Math.min(motion.m_7094_() + 0.01, 1.0), 0.0);
                    this.f_26494_.f_19824_.m_20256_(motion.m_82520_(0.0, 0.0, forward == 1.0 ? 1.0 : 0.01));
                    break;
                }
                case SOUTH: {
                    double forward = Math.min(Math.max(motion.m_7094_() - 0.01, -1.0), 0.0);
                    this.f_26494_.f_19824_.m_20256_(motion.m_82520_(0.0, 0.0, forward == -1.0 ? -1.0 : -0.01));
                    break;
                }
            }
        }
        return false;
    }

    private boolean handlePathPointOnLadder(PathPointExtended pEx) {
        Vec3 vec3 = this.m_26570_().m_77380_((Entity)this.ourEntity);
        BlockPos entityPos = this.ourEntity.m_20183_();
        if (vec3.m_82531_(this.ourEntity.m_20185_(), vec3.f_82480_, this.ourEntity.m_20189_()) < 0.6 && Math.abs(vec3.f_82480_ - (double)entityPos.m_123342_()) <= 2.0) {
            double newSpeed = 0.3;
            switch (pEx.getLadderFacing()) {
                case NORTH: {
                    vec3 = vec3.m_82520_(0.0, 0.0, 0.8);
                    break;
                }
                case SOUTH: {
                    vec3 = vec3.m_82520_(0.0, 0.0, -0.8);
                    break;
                }
                case WEST: {
                    vec3 = vec3.m_82520_(0.8, 0.8, 0.0);
                    break;
                }
                case EAST: {
                    vec3 = vec3.m_82520_(-0.8, 0.0, 0.0);
                    break;
                }
                case UP: {
                    vec3 = vec3.m_82520_(0.0, 1.0, 0.0);
                    break;
                }
                default: {
                    newSpeed = 0.0;
                    if (!this.isSneaking) {
                        this.f_26494_.m_20260_(true);
                        this.isSneaking = true;
                    }
                    this.ourEntity.m_21566_().m_6849_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.2);
                    this.wantedPosition.set(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                }
            }
            if (newSpeed > 0.0) {
                if (!(this.f_26495_.m_8055_(this.ourEntity.m_20183_()).m_60734_() instanceof LadderBlock)) {
                    this.ourEntity.m_20256_(this.ourEntity.m_20184_().m_82520_(0.0, 0.1, 0.0));
                }
                this.ourEntity.m_21566_().m_6849_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, newSpeed);
                this.wantedPosition.set(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            } else {
                if (!PathfindingUtils.isLadder(this.f_26495_.m_8055_(entityPos.m_7495_()), this.getPathingOptions()) && !(this.ourEntity.m_20186_() > (double)pEx.f_77272_)) {
                    return false;
                }
                this.ourEntity.m_21567_(-0.5f);
                return true;
            }
        }
        return false;
    }

    private boolean handleEntityInWater(int oldIndex, PathPointExtended pEx) {
        if (!this.ourEntity.getEyeInFluidType().isAir()) {
            return false;
        }
        int curIndex = this.m_26570_().m_77399_();
        if (curIndex > 0 && curIndex + 1 < this.m_26570_().m_77398_() && this.m_26570_().m_77375_((int)(curIndex - 1)).f_77272_ != pEx.f_77272_) {
            oldIndex = curIndex + 1;
        }
        this.m_26570_().m_77393_(oldIndex);
        Vec3 Vector3d = this.m_26570_().m_77380_((Entity)this.ourEntity);
        Vec3 vec3 = new Vec3(this.ourEntity.m_20185_(), Vector3d.f_82480_, this.ourEntity.m_20189_());
        if (Vector3d.m_82557_(vec3) < 0.1 && Math.abs(this.ourEntity.m_20186_() - Vector3d.f_82480_) < 0.5) {
            this.m_26570_().m_77374_();
            if (this.m_26571_()) {
                return true;
            }
            Vector3d = this.m_26570_().m_77380_((Entity)this.ourEntity);
        }
        this.ourEntity.m_21566_().m_6849_(Vector3d.f_82479_, Vector3d.f_82480_, Vector3d.f_82481_, this.getSpeedFactor());
        this.wantedPosition.set(Vector3d.f_82479_, Vector3d.f_82480_, Vector3d.f_82481_);
        return false;
    }

    protected void m_7636_() {
        this.getSpeedFactor();
        int curNode = this.f_26496_.m_77399_();
        int curNodeNext = curNode + 1;
        if (curNodeNext < this.f_26496_.m_77398_()) {
            if (!(this.f_26496_.m_77375_(curNode) instanceof PathPointExtended)) {
                this.f_26496_ = this.convertPath(this.f_26496_);
            }
            PathPointExtended pEx = (PathPointExtended)this.f_26496_.m_77375_(curNode);
            PathPointExtended pExNext = (PathPointExtended)this.f_26496_.m_77375_(curNodeNext);
            if (pEx.isOnLadder() && pEx.getLadderFacing() == Direction.DOWN && !pExNext.isOnLadder()) {
                Vec3 vec3 = this.m_7475_();
                if (vec3.f_82480_ - (double)pEx.f_77272_ < 0.001) {
                    this.f_26496_.m_77393_(curNodeNext);
                }
                return;
            }
            if (!pEx.isOnRails() && this.ourEntity.f_19824_ != null && !(this.ourEntity.f_19824_ instanceof CavalryHorseEntity)) {
                Entity entity = this.ourEntity.f_19824_;
                this.ourEntity.m_8127_();
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        this.f_26505_ = 0.5f;
        boolean wentAhead = false;
        boolean isTracking = PathfindingUtils.trackingMap.containsValue(this.ourEntity.m_20148_());
        HashSet<BlockPos> reached = null;
        if (isTracking) {
            reached = new HashSet<BlockPos>();
        }
        for (int i = this.f_26496_.m_77399_(); i < Math.min(this.f_26496_.m_77398_(), this.f_26496_.m_77399_() + 4); ++i) {
            Node node = this.f_26496_.m_77375_(i);
            double nextX = (double)node.f_77271_ + (double)((int)(this.f_26494_.m_20205_() + 1.0f)) * 0.5;
            double nextY = node.f_77272_;
            double nextZ = (double)node.f_77273_ + (double)((int)(this.f_26494_.m_20205_() + 1.0f)) * 0.5;
            if (!(Math.abs(this.f_26494_.m_20185_() - nextX) < (double)this.f_26505_ - Math.abs(this.f_26494_.m_20186_() - nextY) * 0.1) || !(Math.abs(this.f_26494_.m_20189_() - nextZ) < (double)this.f_26505_ - Math.abs(this.f_26494_.m_20186_() - nextY) * 0.1) || !(Math.abs(this.f_26494_.m_20186_() - nextY) <= 1.0)) continue;
            this.f_26496_.m_77374_();
            wentAhead = true;
            if (!isTracking) continue;
            Node point = this.f_26496_.m_77375_(i);
            reached.add(new BlockPos(point.f_77271_, point.f_77272_, point.f_77273_));
        }
        if (isTracking) {
            PathfindingUtils.syncDebugReachedPositions(reached, this.pathResult.getDebugWatchers());
            reached.clear();
        }
        if (this.f_26496_.m_77392_()) {
            this.onPathFinish();
            return;
        }
        if (wentAhead) {
            return;
        }
        if (curNode >= this.f_26496_.m_77398_() || curNode <= 1) {
            return;
        }
        Vec3 curr = this.f_26496_.m_77382_((Entity)this.f_26494_, curNode - 1);
        Vec3 next = this.f_26496_.m_77382_((Entity)this.f_26494_, curNode);
        if (this.f_26494_.m_20182_().m_82554_(curr) >= 2.0 && this.f_26494_.m_20182_().m_82554_(next) >= 2.0) {
            for (int currentIndex = curNode - 1; currentIndex > 0; --currentIndex) {
                Vec3 tempoPos = this.f_26496_.m_77382_((Entity)this.f_26494_, currentIndex);
                if (this.f_26494_.m_20182_().m_82554_(tempoPos) <= 1.0) {
                    this.f_26496_.m_77393_(currentIndex);
                    continue;
                }
                if (!isTracking) continue;
                reached.add(BlockPos.m_274561_((double)tempoPos.f_82479_, (double)tempoPos.f_82480_, (double)tempoPos.f_82481_));
            }
        }
        if (isTracking) {
            PathfindingUtils.syncDebugReachedPositions(reached, this.pathResult.getDebugWatchers());
            reached.clear();
        }
    }

    private void onPathFinish() {
        this.finishTime = this.ourEntity.f_19853_.m_46467_();
        super.m_26573_();
    }

    public void m_26569_() {
    }

    protected void m_6481_(@NotNull Vec3 positionVec3) {
    }

    public void m_26573_() {
        if (this.pathResult != null) {
            this.pathResult.cancel();
            this.pathResult.setStatus(PathFindingStatus.CANCELLED);
            this.pathResult = null;
            if (this.ourEntity.m_20202_() != null && !(this.ourEntity.m_20202_() instanceof CavalryHorseEntity)) {
                Entity entity = this.ourEntity.m_20202_();
                this.ourEntity.m_8127_();
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        this.safeDestinationPos = BlockPos.f_121853_;
        this.stuckHandler.resetGlobalStuckTimers();
        super.m_26573_();
    }

    @Override
    public void recalc() {
        if (this.pathResult != null) {
            this.pathResult.cancel();
            this.pathResult.setStatus(PathFindingStatus.CANCELLED);
        }
        super.m_26573_();
    }

    @Override
    public TreePathResult walkToTree(BlockPos startRestriction, BlockPos endRestriction, double speed, List<ItemStorage> excludedTrees, int dyntreesize, IColony colony) {
        @NotNull BlockPos start = PathfindingUtils.prepareStart((LivingEntity)this.ourEntity);
        BlockPos furthestRestriction = BlockPosUtil.getFurthestCorner(start, startRestriction, endRestriction);
        PathJobFindTree job = new PathJobFindTree(CompatibilityUtils.getWorldFromEntity((Entity)this.f_26494_), start, startRestriction, endRestriction, furthestRestriction, excludedTrees, dyntreesize, colony, this.ourEntity);
        return (TreePathResult)this.setPathJob(job, null, speed, true);
    }

    @Override
    public TreePathResult walkToTree(int range, double speed, List<ItemStorage> excludedTrees, int dyntreesize, IColony colony) {
        @NotNull BlockPos start = PathfindingUtils.prepareStart((LivingEntity)this.ourEntity);
        BlockPos buildingPos = ((AbstractEntityCitizen)this.f_26494_).getCitizenColonyHandler().getWorkBuilding().getPosition();
        if (BlockPosUtil.getDistance2D(buildingPos, this.f_26494_.m_20183_()) > (long)(range * 4)) {
            start = buildingPos;
        }
        return (TreePathResult)this.setPathJob(new PathJobFindTree(CompatibilityUtils.getWorldFromEntity((Entity)this.f_26494_), start, buildingPos, range, excludedTrees, dyntreesize, colony, this.ourEntity), null, speed, true);
    }

    @Nullable
    public PathResult<PathJobMoveToLocation> walkToEntity(@NotNull Entity e, double speed) {
        return this.walkTo(e.m_20183_(), speed, false);
    }

    @Nullable
    public PathResult<PathJobMoveAwayFromLocation> moveAwayFromLivingEntity(@NotNull Entity e, double distance, double speed) {
        return this.walkAwayFrom(e.m_20183_(), distance, speed, true);
    }

    public void m_7008_(boolean canSwim) {
        super.m_7008_(canSwim);
        this.getPathingOptions().setCanSwim(canSwim);
    }

    @Override
    public BlockPos getSafeDestination() {
        return this.safeDestinationPos;
    }

    @Override
    public void setSafeDestinationPos(BlockPos pos) {
        this.safeDestinationPos = pos;
    }

    @Override
    public void setStuckHandler(IStuckHandler stuckHandler) {
        this.stuckHandler = stuckHandler;
    }

    @Override
    public void setSwimSpeedFactor(double factor) {
        this.swimSpeedFactor = factor;
    }

    @Override
    public double getAvgHeuristicModifier() {
        return this.heuristicAvg;
    }

    @Override
    public void setPauseTicks(int pauseTicks) {
        if (pauseTicks > 2400) {
            Log.getLogger().warn("Tried to pause entity pathfinding for " + String.valueOf(this.f_26494_) + " too long for " + pauseTicks + " ticks.", (Throwable)new Exception());
            this.pauseTicks = 50;
        } else {
            this.pauseTicks = pauseTicks;
        }
    }

    @Override
    public PathResult getPathResult() {
        return this.pathResult;
    }

    @Override
    public IStuckHandler<MinecoloniesAdvancedPathNavigate> getStuckHandler() {
        return this.stuckHandler;
    }

    public boolean m_26577_() {
        return this.stuckHandler.getStuckLevel() >= 3;
    }
}

