/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.education;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingLibrary;
import com.minecolonies.core.colony.jobs.JobStudent;
import com.minecolonies.core.datalistener.StudyItemListener;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAISkill;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIStudy
extends AbstractEntityAISkill<JobStudent, BuildingLibrary> {
    public static final String RENDER_META_BOOK = "book";
    public static final String RENDER_META_STUDYING = "study";
    public static final int ONE_IN_X_CHANCE = 8;
    private static final int STUDY_DELAY = 1200;
    private BlockPos studyPos = null;
    public int walkDelay = 0;

    public EntityAIStudy(@NotNull JobStudent job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget<Object>(AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget<Object>(AIWorkerState.STUDY, this::study, 20));
        this.worker.m_21553_(true);
    }

    @Override
    public Class<BuildingLibrary> getExpectedBuildingClass() {
        return BuildingLibrary.class;
    }

    @Override
    protected void updateRenderMetaData() {
        Object renderMeta;
        Object object = renderMeta = this.getState() == AIWorkerState.IDLE ? "" : "working";
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), itemStack -> itemStack.m_41720_() == Items.f_42517_ || itemStack.m_41720_() == Items.f_42516_)) {
            renderMeta = (String)renderMeta + RENDER_META_BOOK;
        }
        if (this.worker.getNavigation().m_26571_()) {
            renderMeta = (String)renderMeta + RENDER_META_STUDYING;
        }
        this.worker.setRenderMetadata((String)renderMeta);
    }

    private IAIState study() {
        ICitizenData data = this.worker.getCitizenData();
        if (this.studyPos == null) {
            this.studyPos = ((BuildingLibrary)this.building).getRandomBookShelf();
        }
        if (!this.walkToSafePos(this.studyPos) && this.walkDelay < 1200) {
            this.walkDelay += 20;
            return this.getState();
        }
        this.walkDelay = 0;
        Collection<StudyItemListener.StudyItem> studyItems = StudyItemListener.getAllStudyItems().values();
        ArrayList<StudyItemListener.StudyItem> availableItemKeys = new ArrayList<StudyItemListener.StudyItem>();
        HashMap<StudyItemListener.StudyItem, Integer> availableItems = new HashMap<StudyItemListener.StudyItem, Integer>();
        for (StudyItemListener.StudyItem curItem : studyItems) {
            int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((ICapabilityProvider)this.worker, item -> item.m_150930_(curItem.item()));
            if (slot == -1) continue;
            availableItemKeys.add(curItem);
            availableItems.put(curItem, slot);
        }
        if (availableItems.isEmpty()) {
            ArrayList<ItemStack> itemsToRequest = new ArrayList<ItemStack>();
            int amountToRequest = 1;
            for (StudyItemListener.StudyItem studyItem : studyItems) {
                int bSlot = InventoryUtils.findFirstSlotInProviderWith((ICapabilityProvider)this.building, studyItem.item());
                if (bSlot > -1) {
                    this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(itemStack -> studyItem.item() == itemStack.m_41720_(), 10);
                    return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                }
                ItemStack itemStack2 = new ItemStack((ItemLike)studyItem.item(), studyItem.item().m_7968_().m_41741_());
                itemsToRequest.add(itemStack2);
                amountToRequest = Math.max(amountToRequest, studyItem.breakChance() / 10 > 0 ? studyItem.breakChance() : 1);
            }
            this.checkIfRequestForItemExistOrCreate(new StackList(itemsToRequest, "Study Items", amountToRequest));
            data.getCitizenSkillHandler().tryLevelUpIntelligence(data.getRandom(), 8.0, data);
            this.worker.m_21008_(InteractionHand.MAIN_HAND, ItemStackUtils.EMPTY);
        } else {
            StudyItemListener.StudyItem chosenItem = (StudyItemListener.StudyItem)availableItemKeys.get(this.world.f_46441_.m_188503_(availableItems.size()));
            int chosenSlot = (Integer)availableItems.get(chosenItem);
            this.worker.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)chosenItem.item(), 1));
            if (data.getCitizenSkillHandler().tryLevelUpIntelligence(data.getRandom(), 8.0 * (10.0 / (double)chosenItem.skillIncreaseChance()), data)) {
                ((BuildingLibrary)this.building).getModule(BuildingModules.STATS_MODULE).increment("int_leveled");
            }
            if (this.world.f_46441_.m_188503_(100) <= chosenItem.breakChance()) {
                data.getInventory().extractItem(chosenSlot, 1, false);
                ((BuildingLibrary)this.building).getModule(BuildingModules.STATS_MODULE).increment("item_used;" + chosenItem.item().m_5524_());
            }
        }
        this.worker.decreaseSaturationForContinuousAction();
        this.studyPos = null;
        this.worker.queueSound(SoundEvents.f_11713_, this.worker.m_20183_().m_7494_(), 80, 15, 0.25f, 1.5f);
        this.setDelay(1200);
        return this.getState();
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (!this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.STUDY;
    }
}

