/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.blocks;

import com.minecolonies.api.blocks.huts.AbstractBlockMinecoloniesDefault;
import com.minecolonies.api.blocks.interfaces.IBuildingBrowsableBlock;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildingextensions.registry.BuildingExtensionRegistries;
import com.minecolonies.core.client.gui.containers.WindowField;
import com.minecolonies.core.colony.buildingextensions.FarmField;
import com.minecolonies.core.tileentities.TileEntityScarecrow;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockScarecrow
extends AbstractBlockMinecoloniesDefault<BlockScarecrow>
implements EntityBlock,
IBuildingBrowsableBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;

    public BlockScarecrow() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60913_(10.0f, 10.0f));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("minecolonies", "blockhutfield");
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        if (blockState.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            return null;
        }
        return new TileEntityScarecrow(blockPos, blockState);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (worldIn.f_46443_) {
            DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
            BlockEntity entity = worldIn.m_7702_(half == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos);
            if (entity instanceof TileEntityScarecrow) {
                TileEntityScarecrow scarecrow = (TileEntityScarecrow)entity;
                new WindowField(scarecrow).open();
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = worldIn.m_8055_(blockpos);
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return blockstate.m_60783_((BlockGetter)worldIn, blockpos, Direction.UP);
        }
        return blockstate.m_60734_() == this;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83048_((double)0.1f, (double)((float)(0.0 - (double)(state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? 1 : 0))), (double)0.1f, (double)0.9f, (double)((float)(2.2 - (double)(state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? 1 : 0))), (double)0.9f);
    }

    public void m_7592_(Level worldIn, BlockPos pos, Explosion explosionIn) {
        this.notifyColonyAboutDestruction(worldIn, pos);
        super.m_7592_(worldIn, pos, explosionIn);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction dir;
        Direction direction = dir = context.m_43723_() == null ? Direction.NORTH : Direction.m_122364_((double)(context.m_43723_().m_146908_() + 180.0f));
        if (context.m_8083_().m_123342_() < context.m_43725_().m_151558_() && context.m_43725_().m_8055_(context.m_8083_().m_7494_()).m_60629_(context)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)dir)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        worldIn.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        if (worldIn.f_46443_) {
            return;
        }
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, pos);
        if (colony != null) {
            colony.getBuildingManager().addBuildingExtension(FarmField.create(pos, worldIn));
        }
    }

    public void m_5707_(Level worldIn, @NotNull BlockPos pos, BlockState state, @NotNull Player player) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        BlockPos otherpos = half == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_();
        BlockState otherstate = worldIn.m_8055_(otherpos);
        if (otherstate.m_60734_() == this && otherstate.m_61143_(HALF) != half) {
            worldIn.m_7731_(otherpos, Blocks.f_50016_.m_49966_(), 35);
        }
        this.notifyColonyAboutDestruction(worldIn, pos);
        super.m_5707_(worldIn, pos, state, player);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF, FACING});
    }

    private void notifyColonyAboutDestruction(Level worldIn, BlockPos pos) {
        IColony colony;
        if (!worldIn.m_5776_() && (colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, pos)) != null) {
            colony.getBuildingManager().removeBuildingExtension(field -> field.getBuildingExtensionType().equals(BuildingExtensionRegistries.farmField.get()) && field.getPosition().equals((Object)pos));
        }
    }
}

