/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.ClientFutureProcessor;
import com.ldtteam.structurize.storage.ServerFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.IOPool;
import com.ldtteam.structurize.util.RotationMirror;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ChunkCapData;
import com.minecolonies.api.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColonyUtils {
    private ColonyUtils() {
    }

    public static CompletableFuture<Blueprint> queueBlueprintLoad(Level world, String structurePack, String structurePath, Consumer<Blueprint> afterLoad) {
        return ColonyUtils.queueBlueprintLoad(world, structurePack, structurePath, afterLoad, e -> Log.getLogger().warn(e));
    }

    public static CompletableFuture<Blueprint> queueBlueprintLoad(Level world, String structurePack, String structurePath, Consumer<Blueprint> afterLoad, Consumer<String> errorHandler) {
        CompletableFuture<Blueprint> future = CompletableFuture.supplyAsync(() -> StructurePacks.getBlueprint((String)structurePack, (String)structurePath, (boolean)FMLEnvironment.production), IOPool.getExecutor());
        if (world.f_46443_) {
            ClientFutureProcessor.queueBlueprint((ClientFutureProcessor.BlueprintProcessingData)new ClientFutureProcessor.BlueprintProcessingData(future, blueprint -> {
                if (blueprint == null) {
                    errorHandler.accept("Couldn't find structure with name: " + structurePack + " in: " + structurePath + ". Aborting loading procedure");
                } else {
                    afterLoad.accept((Blueprint)blueprint);
                }
            }));
            return future;
        }
        ServerFutureProcessor.queueBlueprint((ServerFutureProcessor.BlueprintProcessingData)new ServerFutureProcessor.BlueprintProcessingData(future, world, blueprint -> {
            if (blueprint == null) {
                errorHandler.accept("Couldn't find structure with name: " + structurePack + " in: " + structurePath + ". Aborting loading procedure");
            } else {
                afterLoad.accept((Blueprint)blueprint);
            }
        }));
        return future;
    }

    public static Tuple<BlockPos, BlockPos> calculateCorners(BlockPos pos, Level world, Blueprint blueprint, int rotation, boolean isMirrored) {
        if (blueprint == null) {
            return new Tuple((Object)pos, (Object)pos);
        }
        blueprint.setRotationMirror(RotationMirror.of((Rotation)BlockPosUtil.getRotationFromRotations(rotation), (Mirror)(isMirrored ? Mirror.FRONT_BACK : Mirror.NONE)), world);
        BlockPos zeroPos = pos.m_121996_((Vec3i)blueprint.getPrimaryBlockOffset());
        BlockPos pos1 = new BlockPos(zeroPos.m_123341_(), zeroPos.m_123342_(), zeroPos.m_123343_());
        BlockPos pos2 = new BlockPos(zeroPos.m_123341_() + blueprint.getSizeX() - 1, zeroPos.m_123342_() + blueprint.getSizeY() - 1, zeroPos.m_123343_() + blueprint.getSizeZ() - 1);
        return new Tuple((Object)pos1, (Object)pos2);
    }

    public static Tuple<BlockPos, BlockPos> calculateCorners(@NotNull AABB box) {
        BlockPos min = BlockPos.m_274561_((double)box.f_82288_, (double)box.f_82289_, (double)box.f_82290_);
        BlockPos max = BlockPos.m_274561_((double)box.f_82291_, (double)box.f_82292_, (double)box.f_82293_);
        return new Tuple((Object)min, (Object)max);
    }

    public static int getOwningColony(LevelChunk chunk) {
        IColonyTagCapability cap = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        return cap == null ? 0 : cap.getOwningColony();
    }

    public static Map<Integer, Set<BlockPos>> getAllClaimingBuildings(LevelChunk chunk) {
        IColonyTagCapability cap = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        return cap == null ? new HashMap() : cap.getAllClaimingBuildings();
    }

    public static List<Integer> getStaticClaims(LevelChunk chunk) {
        IColonyTagCapability cap = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        return cap == null ? new ArrayList() : cap.getStaticClaimColonies();
    }

    @Nullable
    public static ChunkCapData getChunkCapData(LevelChunk chunk) {
        IColonyTagCapability cap = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        return cap == null ? new ChunkCapData(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_) : new ChunkCapData(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_, cap.getOwningColony(), cap.getStaticClaimColonies(), cap.getAllClaimingBuildings());
    }
}

