/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.quests;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.quests.ITriggerReturnData;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public interface IQuestTriggerTemplate {
    public ITriggerReturnData canTriggerQuest(IColony var1);

    default public ITriggerReturnData canTriggerQuest(ResourceLocation questId, IColony colony) {
        return this.canTriggerQuest(colony);
    }

    public static boolean matchNbt(Tag nbtTag, JsonElement matchTag) {
        return IQuestTriggerTemplate.matchNbt(nbtTag, matchTag, 1);
    }

    public static boolean matchNbt(Tag nbtTag, JsonElement matchTag, int count) {
        if (nbtTag instanceof CompoundTag) {
            CompoundTag nbtCompound = (CompoundTag)nbtTag;
            if (!(matchTag instanceof JsonObject)) {
                return false;
            }
            JsonObject matchObject = (JsonObject)matchTag;
            for (String key : matchObject.keySet()) {
                if (!nbtCompound.m_128441_(key)) {
                    return false;
                }
                if (IQuestTriggerTemplate.matchNbt(nbtCompound.m_128423_(key), matchObject.get(key))) continue;
                return false;
            }
            return true;
        }
        if (nbtTag instanceof ListTag) {
            ListTag nbtList = (ListTag)nbtTag;
            int matchCount = 0;
            for (Tag tag : nbtList) {
                if (!IQuestTriggerTemplate.matchNbt(tag, matchTag) || ++matchCount < count) continue;
                return true;
            }
            if (!(matchTag instanceof JsonArray)) {
                return false;
            }
            JsonArray arrayTag = (JsonArray)matchTag;
            for (JsonElement element : arrayTag) {
                boolean matched = false;
                for (Tag tag : nbtList) {
                    if (!IQuestTriggerTemplate.matchNbt(tag, element)) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                return false;
            }
            return true;
        }
        if (!(matchTag instanceof JsonPrimitive)) {
            return false;
        }
        if (nbtTag instanceof StringTag && ((JsonPrimitive)matchTag).isString()) {
            return nbtTag.m_7916_().equals(matchTag.getAsString());
        }
        if (nbtTag instanceof ByteTag && ((JsonPrimitive)matchTag).isBoolean()) {
            return ((ByteTag)nbtTag).m_7063_() == 0 != matchTag.getAsBoolean();
        }
        if (nbtTag instanceof NumericTag && ((JsonPrimitive)matchTag).isNumber()) {
            return ((NumericTag)nbtTag).m_7061_() >= matchTag.getAsDouble();
        }
        return false;
    }
}

