/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.crafting.registry.ModRecipeSerializer;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZeroWasteRecipe
extends ShapelessRecipe {
    public ZeroWasteRecipe(@NotNull ResourceLocation id, @NotNull ItemStack output, @NotNull NonNullList<Ingredient> inputs) {
        super(id, "", CraftingBookCategory.MISC, output, inputs);
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingContainer container) {
        NonNullList remainingItems = super.m_7457_((Container)container);
        Collections.fill(remainingItems, ItemStack.f_41583_);
        return remainingItems;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializer.ZeroWasteRecipeSerializer.get();
    }

    public static Builder build(@NotNull RecipeCategory category, @NotNull ItemLike output, int count) {
        return new Builder(category, output, count);
    }

    public static class Builder
    extends CraftingRecipeBuilder
    implements RecipeBuilder {
        private final RecipeCategory category;
        private final Item output;
        private final int count;
        private final List<Ingredient> ingredients = Lists.newArrayList();
        private final Advancement.Builder advancement = Advancement.Builder.m_285878_();

        public Builder(@NotNull RecipeCategory category, @NotNull ItemLike output, int count) {
            this.category = category;
            this.output = output.m_5456_();
            this.count = count;
        }

        public Builder requires(@NotNull TagKey<Item> tag) {
            return this.requires(Ingredient.m_204132_(tag));
        }

        public Builder requires(@NotNull ItemLike item) {
            return this.requires(item, 1);
        }

        public Builder requires(@NotNull ItemLike item, int count) {
            for (int i = 0; i < count; ++i) {
                this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
            }
            return this;
        }

        public Builder requires(@NotNull Ingredient ingredient) {
            return this.requires(ingredient, 1);
        }

        public Builder requires(@NotNull Ingredient ingredient, int count) {
            for (int i = 0; i < count; ++i) {
                this.ingredients.add(ingredient);
            }
            return this;
        }

        @NotNull
        public Builder unlockedBy(@NotNull String name, @NotNull CriterionTriggerInstance criterion) {
            this.advancement.m_138386_(name, criterion);
            return this;
        }

        @NotNull
        public Item m_142372_() {
            return this.output.m_5456_();
        }

        @NotNull
        public RecipeBuilder m_126145_(@Nullable String group) {
            return this;
        }

        public void m_126140_(@NotNull Consumer<FinishedRecipe> consumer, @NotNull ResourceLocation id) {
            this.ensureValid(id);
            this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
            consumer.accept(new Result(id, this.output, this.count, this.ingredients, this.advancement, id.m_246208_("recipes/" + this.category.m_247710_() + "/")));
        }

        private void ensureValid(@NotNull ResourceLocation id) {
            if (this.advancement.m_138405_().isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
            }
        }

        public static class Result
        implements FinishedRecipe {
            private final ResourceLocation id;
            private final Item output;
            private final int count;
            private final List<Ingredient> inputs;
            private final Advancement.Builder advancement;
            private final ResourceLocation advancementId;

            public Result(@NotNull ResourceLocation id, @NotNull Item output, int count, @NotNull List<Ingredient> inputs, @NotNull Advancement.Builder advancement, @NotNull ResourceLocation advancementId) {
                this.id = id;
                this.output = output;
                this.count = count;
                this.inputs = inputs;
                this.advancement = advancement;
                this.advancementId = advancementId;
            }

            public void m_7917_(@NotNull JsonObject json) {
                JsonArray jsonInputs = new JsonArray();
                for (Ingredient ingredient : this.inputs) {
                    jsonInputs.add(ingredient.m_43942_());
                }
                json.add("ingredients", (JsonElement)jsonInputs);
                JsonObject result = new JsonObject();
                result.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.output).toString());
                if (this.count > 1) {
                    result.addProperty("count", (Number)this.count);
                }
                json.add("result", (JsonElement)result);
            }

            @NotNull
            public RecipeSerializer<?> m_6637_() {
                return (RecipeSerializer)ModRecipeSerializer.ZeroWasteRecipeSerializer.get();
            }

            @NotNull
            public ResourceLocation m_6445_() {
                return this.id;
            }

            @Nullable
            public JsonObject m_5860_() {
                return this.advancement.m_138400_();
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return this.advancementId;
            }
        }
    }

    public static class Serializer
    implements RecipeSerializer<ZeroWasteRecipe> {
        @NotNull
        public ZeroWasteRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122779_();
            for (int i = 0; i < array.size(); ++i) {
                inputs.add((Object)Ingredient.m_288218_((JsonElement)array.get(i), (boolean)false));
            }
            return new ZeroWasteRecipe(id, output, (NonNullList<Ingredient>)inputs);
        }

        @Nullable
        public ZeroWasteRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            int count = buf.m_130242_();
            NonNullList inputs = NonNullList.m_122780_((int)count, (Object)Ingredient.f_43901_);
            for (int i = 0; i < count; ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack output = buf.m_130267_();
            return new ZeroWasteRecipe(id, output, (NonNullList<Ingredient>)inputs);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull ZeroWasteRecipe recipe) {
            buf.m_130130_(recipe.m_7527_().size());
            for (Ingredient input : recipe.m_7527_()) {
                input.m_43923_(buf);
            }
            buf.m_130055_(recipe.m_8043_(null));
        }
    }
}

