/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.compatibility.newstruct;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlueprintMapping {
    private static Map<String, String> styleMapping = new HashMap<String, String>();
    private static Map<String, String> pathMapping = new HashMap<String, String>();

    public static String getStyleMapping(String key) {
        return styleMapping.getOrDefault(key, key);
    }

    public static String getPathMapping(String style, String hut) {
        return pathMapping.getOrDefault(style + ":" + hut, pathMapping.get(":" + hut));
    }

    private static void runForAlt(Map<String, List<String>> foldersToHuts, String style) {
        for (Map.Entry<String, List<String>> entry : foldersToHuts.entrySet()) {
            for (String hut : entry.getValue()) {
                pathMapping.put(style + ":" + hut, entry.getKey() + "/alt" + hut);
            }
        }
    }

    private static void runForStyle(Map<String, List<String>> foldersToHuts, String style) {
        for (Map.Entry<String, List<String>> entry : foldersToHuts.entrySet()) {
            for (String hut : entry.getValue()) {
                pathMapping.put(style + ":" + hut, entry.getKey() + "/" + hut);
            }
        }
    }

    static {
        styleMapping.put("medievaloak", "Medieval Oak");
        styleMapping.put("medievalspruce", "Medieval Spruce");
        styleMapping.put("medievaldarkoak", "Medieval Dark Oak");
        styleMapping.put("medievalbirch", "Medieval Birch");
        styleMapping.put("caledonia", "Caledonia");
        styleMapping.put("darkoak", "Dark Oak Treehouse");
        styleMapping.put("fortress", "Fortress");
        styleMapping.put("birch", "Urban Birch");
        styleMapping.put("jungle", "Jungle Treehouse");
        styleMapping.put("lostcity", "Lost Mesa City");
        styleMapping.put("incan", "Incan");
        styleMapping.put("nordic", "Nordic Spruce");
        styleMapping.put("sandstone", "Desert Oasis");
        styleMapping.put("spacewars", "Spacewars");
        styleMapping.put("warped", "Warped Netherlands");
        styleMapping.put("truedwarven", "Stalactite Caves");
        styleMapping.put("stone", "Minecolonies Original");
        styleMapping.put("acacia", "Urban Savanna");
        styleMapping.put("wooden", "Minecolonies Original");
        styleMapping.put("asian", "Pagoda");
        styleMapping.put("asianalternative", "Pagoda");
        styleMapping.put("fortressalternative", "Fortress");
        styleMapping.put("junglealternative", "Jungle Treehouse");
        styleMapping.put("woodalternative", "Minecolonies Original");
        styleMapping.put("stonealternative", "Minecolonies Original");
        styleMapping.put("medievaloakalternative", "Medieval Oak");
        styleMapping.put("medievalsprucealternative", "Medieval Spruce");
        styleMapping.put("medievaldarkoakalternative", "Medieval Dark Oak");
        styleMapping.put("medievalbirchalternative", "Medieval Birch");
        styleMapping.put("caledoniaalternative", "Caledonia");
        HashMap<String, List<String>> foldersToHuts = new HashMap<String, List<String>>();
        foldersToHuts.put("agriculture/horticulture", Arrays.asList("composter", "farmer", "florist", "plantation"));
        foldersToHuts.put("agriculture/husbandry", Arrays.asList("beekeeper", "chickenherder", "cowboy", "fisherman", "rabbithutch", "shepherd", "swineherder"));
        foldersToHuts.put("craftsmanship/carpentry", Arrays.asList("fletcher", "sawmill"));
        foldersToHuts.put("craftsmanship/luxury", Arrays.asList("alchemist", "baker", "concretemixer", "dyer", "glassblower"));
        foldersToHuts.put("craftsmanship/masonry", Arrays.asList("crusher", "sifter", "stonemason", "stonesmeltery"));
        foldersToHuts.put("craftsmanship/metallurgy", Arrays.asList("blacksmith", "mechanic", "smeltery"));
        foldersToHuts.put("craftsmanship/storage", Arrays.asList("deliveryman", "warehouse"));
        foldersToHuts.put("education", Arrays.asList("library", "school", "university"));
        foldersToHuts.put("fundamentals", Arrays.asList("builder", "residence", "cook", "hospital", "lumberjack", "miner", "tavern", "townhall"));
        foldersToHuts.put("military", Arrays.asList("archery", "barracks", "barrackstower", "combatacademy", "guardtower"));
        foldersToHuts.put("mystic", Arrays.asList("enchanter", "netherworker", "mysticalsite", "graveyard"));
        foldersToHuts.put("infrastructure/mineshafts", Arrays.asList("simplequarry", "mediumquarry"));
        BlueprintMapping.runForStyle(foldersToHuts, "medievaloak");
        BlueprintMapping.runForStyle(foldersToHuts, "medievalspruce");
        BlueprintMapping.runForStyle(foldersToHuts, "medievaldarkoak");
        BlueprintMapping.runForStyle(foldersToHuts, "medievalbirch");
        BlueprintMapping.runForStyle(foldersToHuts, "asian");
        BlueprintMapping.runForStyle(foldersToHuts, "wooden");
        BlueprintMapping.runForStyle(foldersToHuts, "stone");
        BlueprintMapping.runForStyle(foldersToHuts, "spacewars");
        BlueprintMapping.runForStyle(foldersToHuts, "sandstone");
        BlueprintMapping.runForStyle(foldersToHuts, "nordic");
        BlueprintMapping.runForStyle(foldersToHuts, "medievalspruce");
        BlueprintMapping.runForStyle(foldersToHuts, "medievaloak");
        BlueprintMapping.runForStyle(foldersToHuts, "medievaldarkoeak");
        BlueprintMapping.runForStyle(foldersToHuts, "medievalbirch");
        BlueprintMapping.runForStyle(foldersToHuts, "lostcity");
        BlueprintMapping.runForStyle(foldersToHuts, "jungle");
        BlueprintMapping.runForStyle(foldersToHuts, "incan");
        BlueprintMapping.runForStyle(foldersToHuts, "fortress");
        BlueprintMapping.runForStyle(foldersToHuts, "darkoak");
        BlueprintMapping.runForStyle(foldersToHuts, "caledonia");
        BlueprintMapping.runForStyle(foldersToHuts, "birch");
        BlueprintMapping.runForStyle(foldersToHuts, "asian");
        BlueprintMapping.runForStyle(foldersToHuts, "acacia");
        BlueprintMapping.runForStyle(foldersToHuts, "fortress");
        BlueprintMapping.runForStyle(foldersToHuts, "");
        BlueprintMapping.runForAlt(foldersToHuts, "medievalbirchalternative");
        BlueprintMapping.runForAlt(foldersToHuts, "medievaloakalternative");
        BlueprintMapping.runForAlt(foldersToHuts, "medievaldarkoakalternative");
        BlueprintMapping.runForAlt(foldersToHuts, "medievalsprucealternative");
        BlueprintMapping.runForAlt(foldersToHuts, "fortressalternative");
        BlueprintMapping.runForAlt(foldersToHuts, "asianalternative");
        pathMapping.put(":home", "fundamentals/residence");
        pathMapping.put(":citizen", "fundamentals/residence");
        pathMapping.put("woodalternative:citizen", "fundamentals/altresidence");
        pathMapping.put("woodalternative:shepherd", "agriculture/husbandry/shepherdalt");
        pathMapping.put("woodalternative:deliveryman", "craftsmanship/storage/deliverymanalt");
        pathMapping.put("woodalternative:warehouse", "craftsmanship/storage/warehousealt");
        pathMapping.put("junglealternative:farmer", "agriculture/horticulture/farmeralt");
        pathMapping.put("caledoniaalternative:farmer", "agriculture/horticulture/farmeralt");
        pathMapping.put("caledoniaalternative:guardtower", "military/guardtoweralt");
    }
}

