/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class Tool
implements IDeliverable {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(Tool.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());
    private static final String NBT_TYPE = "Type";
    private static final String NBT_MIN_LEVEL = "MinLevel";
    private static final String NBT_MAX_LEVEL = "MaxLevel";
    private static final String NBT_RESULT = "Result";
    @NotNull
    private final EquipmentTypeEntry equipmentType;
    @NotNull
    private final Integer minLevel;
    @NotNull
    private final Integer maxLevel;
    @NotNull
    private ItemStack result = ItemStackUtils.EMPTY;

    public Tool(@NotNull EquipmentTypeEntry equipmentType, @NotNull Integer minLevel, @NotNull Integer maxLevel) {
        this(equipmentType, minLevel, maxLevel, ItemStackUtils.EMPTY);
    }

    public Tool(@NotNull EquipmentTypeEntry equipmentType, @NotNull Integer minLevel, @NotNull Integer maxLevel, @NotNull ItemStack result) {
        this.equipmentType = equipmentType;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        this.result = result;
    }

    @NotNull
    public static CompoundTag serialize(IFactoryController controller, Tool equipment) {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_(NBT_TYPE, equipment.getEquipmentType().getRegistryName().toString());
        compound.m_128405_(NBT_MIN_LEVEL, equipment.getMinLevel().intValue());
        compound.m_128405_(NBT_MAX_LEVEL, equipment.getMaxLevel().intValue());
        compound.m_128365_(NBT_RESULT, (Tag)equipment.getResult().serializeNBT());
        return compound;
    }

    @NotNull
    public EquipmentTypeEntry getEquipmentType() {
        return this.equipmentType;
    }

    @NotNull
    public Integer getMinLevel() {
        return this.minLevel;
    }

    @NotNull
    public Integer getMaxLevel() {
        return this.maxLevel;
    }

    @NotNull
    public static Tool deserialize(IFactoryController controller, CompoundTag nbt) {
        String resLoc = nbt.m_128461_(NBT_TYPE);
        EquipmentTypeEntry type = (EquipmentTypeEntry)ModEquipmentTypes.getRegistry().getValue(EquipmentTypeEntry.parseResourceLocation(resLoc));
        Integer minLevel = nbt.m_128451_(NBT_MIN_LEVEL);
        Integer maxLevel = nbt.m_128451_(NBT_MAX_LEVEL);
        ItemStack result = ItemStack.m_41712_((CompoundTag)nbt.m_128469_(NBT_RESULT));
        return new Tool(type, minLevel, maxLevel, result);
    }

    public static void serialize(IFactoryController controller, FriendlyByteBuf buffer, Tool input) {
        buffer.m_130085_(input.getEquipmentType().getRegistryName());
        buffer.writeInt(input.getMinLevel().intValue());
        buffer.writeInt(input.getMaxLevel().intValue());
        buffer.writeBoolean(!ItemStackUtils.isEmpty(input.result));
        if (!ItemStackUtils.isEmpty(input.result)) {
            buffer.m_130055_(input.result);
        }
    }

    public static Tool deserialize(IFactoryController controller, FriendlyByteBuf buffer) {
        EquipmentTypeEntry type = (EquipmentTypeEntry)ModEquipmentTypes.getRegistry().getValue(buffer.m_130281_());
        int minLevel = buffer.readInt();
        int maxLevel = buffer.readInt();
        ItemStack result = buffer.readBoolean() ? buffer.m_130267_() : ItemStack.f_41583_;
        return new Tool(type, minLevel, maxLevel, result);
    }

    @Override
    public boolean matches(@NotNull ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack)) {
            return false;
        }
        try {
            return ItemStackUtils.hasEquipmentLevel(stack, this.getEquipmentType(), this.getMinLevel(), this.getMaxLevel());
        }
        catch (Exception e) {
            Log.getLogger().warn("Got exception for Itemstack when trying to match equipment level: " + String.valueOf(stack.m_41611_()) + " - " + stack.m_41720_().getCreatorModId(stack), (Throwable)e);
            return false;
        }
    }

    @Override
    public int getCount() {
        return 1;
    }

    @Override
    public int getMinimumCount() {
        return 1;
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    @Override
    public IDeliverable copyWithCount(int newCount) {
        return new Tool(this.equipmentType, this.minLevel, this.maxLevel, this.result);
    }

    public boolean isArmor() {
        return this.equipmentType == ModEquipmentTypes.helmet.get() || this.equipmentType == ModEquipmentTypes.leggings.get() || this.equipmentType == ModEquipmentTypes.chestplate.get() || this.equipmentType == ModEquipmentTypes.boots.get();
    }

    public int hashCode() {
        int result1 = this.getEquipmentType().hashCode();
        result1 = 31 * result1 + this.getMinLevel().hashCode();
        result1 = 31 * result1 + this.getMaxLevel().hashCode();
        result1 = 31 * result1 + this.getResult().hashCode();
        return result1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tool)) {
            return false;
        }
        Tool equipment = (Tool)o;
        if (!this.getEquipmentType().equals(equipment.getEquipmentType())) {
            return false;
        }
        if (!this.getMinLevel().equals(equipment.getMinLevel())) {
            return false;
        }
        if (!this.getMaxLevel().equals(equipment.getMaxLevel())) {
            return false;
        }
        return ItemStackUtils.compareItemStacksIgnoreStackSize(this.getResult(), equipment.getResult());
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

