/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.connections;

import com.minecolonies.api.colony.connections.DiplomacyStatus;
import com.minecolonies.api.util.BlockPosUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class ColonyConnection {
    public DiplomacyStatus diplomacyStatus;
    public int id;
    public String name;
    public BlockPos pos;

    public ColonyConnection(int id, String name, BlockPos pos, DiplomacyStatus diplomacyStatus) {
        this.id = id;
        this.name = name;
        this.pos = pos;
        this.diplomacyStatus = diplomacyStatus;
    }

    public ColonyConnection() {
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128405_("id", this.id);
        compoundTag.m_128359_("name", this.name);
        BlockPosUtil.write(compoundTag, "pos", this.pos);
        compoundTag.m_128405_("status", this.diplomacyStatus.ordinal());
        return compoundTag;
    }

    public ColonyConnection deserializeNBT(CompoundTag compoundTag) {
        this.id = compoundTag.m_128451_("id");
        this.name = compoundTag.m_128461_("name");
        this.pos = BlockPosUtil.read(compoundTag, "pos");
        this.diplomacyStatus = DiplomacyStatus.values()[compoundTag.m_128451_("status")];
        return this;
    }

    public void serializeByteBuf(FriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.m_130070_(this.name);
        buf.m_130064_(this.pos);
        buf.writeInt(this.diplomacyStatus.ordinal());
    }

    public ColonyConnection deserializeByteBuf(FriendlyByteBuf buf) {
        this.id = buf.readInt();
        this.name = buf.m_130277_();
        this.pos = buf.m_130135_();
        this.diplomacyStatus = DiplomacyStatus.values()[buf.readInt()];
        return this;
    }
}

