/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.buildingextensions.registry;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.colony.buildingextensions.modules.IBuildingExtensionModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.Validate;

public class BuildingExtensionRegistries {
    public static final ResourceLocation FARM_FIELD_ID = new ResourceLocation("minecolonies", "farmfield");
    public static final ResourceLocation PLANTATION_SUGAR_CANE_FIELD_ID = new ResourceLocation("minecolonies", "plantation_sugar_cane");
    public static final ResourceLocation PLANTATION_CACTUS_FIELD_ID = new ResourceLocation("minecolonies", "plantation_cactus");
    public static final ResourceLocation PLANTATION_BAMBOO_FIELD_ID = new ResourceLocation("minecolonies", "plantation_bamboo");
    public static final ResourceLocation PLANTATION_COCOA_BEANS_FIELD_ID = new ResourceLocation("minecolonies", "plantation_cocoa_beans");
    public static final ResourceLocation PLANTATION_VINES_FIELD_ID = new ResourceLocation("minecolonies", "plantation_vines");
    public static final ResourceLocation PLANTATION_KELP_FIELD_ID = new ResourceLocation("minecolonies", "plantation_kelp");
    public static final ResourceLocation PLANTATION_SEAGRASS_FIELD_ID = new ResourceLocation("minecolonies", "plantation_seagrass");
    public static final ResourceLocation PLANTATION_SEA_PICKLES_FIELD_ID = new ResourceLocation("minecolonies", "plantation_sea_pickles");
    public static final ResourceLocation PLANTATION_GLOWBERRIES_FIELD_ID = new ResourceLocation("minecolonies", "plantation_glowberries");
    public static final ResourceLocation PLANTATION_WEEPING_VINES_FIELD_ID = new ResourceLocation("minecolonies", "plantation_weeping_vines");
    public static final ResourceLocation PLANTATION_TWISTING_VINES_FIELD_ID = new ResourceLocation("minecolonies", "plantation_twisting_vines");
    public static final ResourceLocation PLANTATION_CRIMSON_PLANTS_FIELD_ID = new ResourceLocation("minecolonies", "plantation_crimson_plants");
    public static final ResourceLocation PLANTATION_WARPED_PLANTS_FIELD_ID = new ResourceLocation("minecolonies", "plantation_warped_plants");
    public static RegistryObject<BuildingExtensionEntry> farmField;
    public static RegistryObject<BuildingExtensionEntry> plantationSugarCaneField;
    public static RegistryObject<BuildingExtensionEntry> plantationCactusField;
    public static RegistryObject<BuildingExtensionEntry> plantationBambooField;
    public static RegistryObject<BuildingExtensionEntry> plantationCocoaBeansField;
    public static RegistryObject<BuildingExtensionEntry> plantationVinesField;
    public static RegistryObject<BuildingExtensionEntry> plantationKelpField;
    public static RegistryObject<BuildingExtensionEntry> plantationSeagrassField;
    public static RegistryObject<BuildingExtensionEntry> plantationSeaPicklesField;
    public static RegistryObject<BuildingExtensionEntry> plantationGlowberriesField;
    public static RegistryObject<BuildingExtensionEntry> plantationWeepingVinesField;
    public static RegistryObject<BuildingExtensionEntry> plantationTwistingVinesField;
    public static RegistryObject<BuildingExtensionEntry> plantationCrimsonPlantsField;
    public static RegistryObject<BuildingExtensionEntry> plantationWarpedPlantsField;

    private BuildingExtensionRegistries() {
    }

    public static IForgeRegistry<BuildingExtensionEntry> getBuildingExtensionRegistry() {
        return IMinecoloniesAPI.getInstance().getBuildingExtensionRegistry();
    }

    public static class BuildingExtensionEntry {
        private final ResourceLocation registryName;
        private final BiFunction<BuildingExtensionEntry, BlockPos, IBuildingExtension> extensionProducer;
        private final List<Function<IBuildingExtension, IBuildingExtensionModule>> extensionModuleProducers;

        private BuildingExtensionEntry(ResourceLocation registryName, BiFunction<BuildingExtensionEntry, BlockPos, IBuildingExtension> extensionProducer, List<Function<IBuildingExtension, IBuildingExtensionModule>> extensionModuleProducers) {
            this.registryName = registryName;
            this.extensionProducer = extensionProducer;
            this.extensionModuleProducers = extensionModuleProducers;
        }

        public IBuildingExtension produceExtension(BlockPos position) {
            IBuildingExtension extension = this.extensionProducer.apply(this, position);
            for (Function<IBuildingExtension, IBuildingExtensionModule> moduleProducer : this.extensionModuleProducers) {
                extension.registerModule(moduleProducer.apply(extension));
            }
            return extension;
        }

        public List<Function<IBuildingExtension, IBuildingExtensionModule>> getExtensionModuleProducers() {
            return Collections.unmodifiableList(this.extensionModuleProducers);
        }

        public ResourceLocation getRegistryName() {
            return this.registryName;
        }

        public int hashCode() {
            return this.registryName.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BuildingExtensionEntry that = (BuildingExtensionEntry)o;
            return this.registryName.equals((Object)that.registryName);
        }

        public static class Builder {
            private final List<Function<IBuildingExtension, IBuildingExtensionModule>> extensionModuleProducers = new ArrayList<Function<IBuildingExtension, IBuildingExtensionModule>>();
            private ResourceLocation registryName;
            private BiFunction<BuildingExtensionEntry, BlockPos, IBuildingExtension> extensionProducer;

            public Builder setRegistryName(ResourceLocation registryName) {
                this.registryName = registryName;
                return this;
            }

            public Builder setExtensionProducer(BiFunction<BuildingExtensionEntry, BlockPos, IBuildingExtension> extensionProducer) {
                this.extensionProducer = extensionProducer;
                return this;
            }

            public Builder addExtensionModuleProducer(Function<IBuildingExtension, IBuildingExtensionModule> moduleProducer) {
                this.extensionModuleProducers.add(moduleProducer);
                return this;
            }

            public BuildingExtensionEntry createExtensionEntry() {
                Validate.notNull((Object)this.registryName);
                Validate.notNull(this.extensionProducer);
                return new BuildingExtensionEntry(this.registryName, this.extensionProducer, this.extensionModuleProducers);
            }
        }
    }
}

