/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony;

import com.minecolonies.api.colony.CitizenNameFile;
import com.minecolonies.api.colony.ColonyState;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.connections.IColonyConnectionManager;
import com.minecolonies.api.colony.managers.interfaces.IAnimalManager;
import com.minecolonies.api.colony.managers.interfaces.ICitizenManager;
import com.minecolonies.api.colony.managers.interfaces.IColonyPackageManager;
import com.minecolonies.api.colony.managers.interfaces.IEventDescriptionManager;
import com.minecolonies.api.colony.managers.interfaces.IEventManager;
import com.minecolonies.api.colony.managers.interfaces.IGraveManager;
import com.minecolonies.api.colony.managers.interfaces.IRaiderManager;
import com.minecolonies.api.colony.managers.interfaces.IRegisteredStructureManager;
import com.minecolonies.api.colony.managers.interfaces.IReproductionManager;
import com.minecolonies.api.colony.managers.interfaces.IStatisticsManager;
import com.minecolonies.api.colony.managers.interfaces.ITravellingManager;
import com.minecolonies.api.colony.managers.interfaces.IVisitorManager;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.quests.IQuestManager;
import com.minecolonies.api.research.IResearchManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.event.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IColony {
    public static final Capability<IColonyTagCapability> CLOSE_COLONY_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IColonyTagCapability>(){});

    public void onWorldLoad(@NotNull Level var1);

    public void onWorldUnload(@NotNull Level var1);

    public void onServerTick(@NotNull TickEvent.ServerTickEvent var1);

    @NotNull
    public IWorkManager getWorkManager();

    public void onWorldTick(@NotNull TickEvent.LevelTickEvent var1);

    public BlockPos getCenter();

    public String getName();

    public void setName(String var1);

    public IPermissions getPermissions();

    public boolean isCoordInColony(Level var1, BlockPos var2);

    public long getDistanceSquared(BlockPos var1);

    public boolean hasTownHall();

    public int getID();

    public boolean hasWarehouse();

    public boolean hasBuilding(ResourceLocation var1, int var2, boolean var3);

    public ChatFormatting getTeamColonyColor();

    public ListTag getColonyFlag();

    public boolean isDay();

    public int getLastContactInHours();

    public Level getWorld();

    @NotNull
    public IRequestManager getRequestManager();

    public void markDirty();

    public boolean canBeAutoDeleted();

    @Nullable
    public IRequester getRequesterBuildingForPosition(@NotNull BlockPos var1);

    public void removeVisitingPlayer(Player var1);

    @NotNull
    public List<Player> getMessagePlayerEntities();

    @NotNull
    default public List<BlockPos> getWayPoints(@NotNull BlockPos position, @NotNull BlockPos target) {
        ArrayList<BlockPos> tempWayPoints = new ArrayList<BlockPos>();
        tempWayPoints.addAll(this.getWayPoints().keySet());
        tempWayPoints.addAll(this.getBuildingManager().getBuildings().keySet());
        double maxX = Math.max(position.m_123341_(), target.m_123341_());
        double maxZ = Math.max(position.m_123343_(), target.m_123343_());
        double minX = Math.min(position.m_123341_(), target.m_123341_());
        double minZ = Math.min(position.m_123343_(), target.m_123343_());
        Iterator iterator = tempWayPoints.iterator();
        while (iterator.hasNext()) {
            BlockPos p = (BlockPos)iterator.next();
            int x = p.m_123341_();
            int z = p.m_123343_();
            if (!((double)x < minX || (double)x > maxX || (double)z < minZ) && !((double)z > maxZ)) continue;
            iterator.remove();
        }
        return tempWayPoints;
    }

    public double getOverallHappiness();

    public Map<BlockPos, BlockState> getWayPoints();

    public String getStructurePack();

    public void setStructurePack(String var1);

    public IRegisteredStructureManager getBuildingManager();

    public ICitizenManager getCitizenManager();

    public IGraveManager getGraveManager();

    public IVisitorManager getVisitorManager();

    public IAnimalManager getAnimalManager();

    public IRaiderManager getRaiderManager();

    public IEventManager getEventManager();

    public IReproductionManager getReproductionManager();

    public IEventDescriptionManager getEventDescriptionManager();

    public IColonyPackageManager getPackageManager();

    public ITravellingManager getTravellingManager();

    public IColonyConnectionManager getConnectionManager();

    public void addVisitingPlayer(Player var1);

    public ResourceKey<Level> getDimension();

    public boolean isRemote();

    public IResearchManager getResearchManager();

    public void usedMercenaries();

    public long getMercenaryUseTime();

    public CompoundTag getColonyTag();

    public boolean isColonyUnderAttack();

    public boolean isValidAttackingPlayer(Player var1);

    public boolean isValidAttackingGuard(AbstractEntityCitizen var1);

    public void setColonyColor(ChatFormatting var1);

    public void setColonyFlag(ListTag var1);

    public void addWayPoint(BlockPos var1, BlockState var2);

    public void addGuardToAttackers(AbstractEntityCitizen var1, Player var2);

    public void addFreePosition(BlockPos var1);

    public void addFreeBlock(Block var1);

    public void removeFreePosition(BlockPos var1);

    public void removeFreeBlock(Block var1);

    public void setCanBeAutoDeleted(boolean var1);

    public CompoundTag write(CompoundTag var1);

    public void read(CompoundTag var1);

    @NotNull
    public List<Player> getImportantMessageEntityPlayers();

    public boolean isManualHiring();

    public boolean isManualHousing();

    public boolean canMoveIn();

    public boolean useAdditionalChildTime(int var1);

    public void updateHasChilds();

    public void addLoadedChunk(long var1, LevelChunk var3);

    public void removeLoadedChunk(long var1);

    public int getLoadedChunkCount();

    public Set<Long> getLoadedChunks();

    public ColonyState getState();

    public boolean isActive();

    public Set<Long> getTicketedChunks();

    public void setTextureStyle(String var1);

    public String getTextureStyleId();

    public String getNameStyle();

    public void setNameStyle(String var1);

    public CitizenNameFile getCitizenNameFile();

    public IStatisticsManager getStatisticsManager();

    public int getDay();

    public IQuestManager getQuestManager();

    public ICitizen getCitizen(int var1);
}

