/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstoragecreateintegration.network;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.compat.create.ContraptionHelper;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageBase;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.storage.MountedSophisticatedStorage;

public record MountedStorageOpennessMessage(int contraptionEntityId, BlockPos localPos, boolean shouldBeOpen) {
    public static void encode(MountedStorageOpennessMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(msg.contraptionEntityId);
        packetBuffer.m_130064_(msg.localPos);
        packetBuffer.writeBoolean(msg.shouldBeOpen);
    }

    public static MountedStorageOpennessMessage decode(FriendlyByteBuf packetBuffer) {
        return new MountedStorageOpennessMessage(packetBuffer.readInt(), packetBuffer.m_130135_(), packetBuffer.readBoolean());
    }

    static void onMessage(MountedStorageOpennessMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MountedStorageOpennessMessage.handleMessage(msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(MountedStorageOpennessMessage msg) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Entity entity = player.m_9236_().m_6815_(msg.contraptionEntityId());
        if (entity instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entity;
            MountedStorageBase mountedStorage = ContraptionHelper.getMountedStorage((AbstractContraptionEntity)contraptionEntity, (BlockPos)msg.localPos());
            if (!(mountedStorage instanceof MountedSophisticatedStorage)) {
                return;
            }
            MountedSophisticatedStorage mountedSophisticatedStorage = (MountedSophisticatedStorage)mountedStorage;
            mountedSophisticatedStorage.setShouldBeOpen(msg.shouldBeOpen());
        }
    }
}

