/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.util;

import com.jab125.mpuc.Hotfixes;
import com.jab125.mpuc.config.ConfigInstances;
import com.jab125.mpuc.config.MpucConfig;
import com.jab125.mpuc.util.HotfixEventHandler;
import com.jab125.mpuc.util.Platform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class HotfixApplier {
    private static volatile double progress;
    private static volatile boolean downloading;
    private static volatile long estimatedTimeRemaining;

    public static double getProgress() {
        return progress;
    }

    public static long getEstimatedTimeRemaining() {
        return estimatedTimeRemaining;
    }

    public static boolean isDownloading() {
        return downloading;
    }

    public static boolean applyHotfixes(List<String> hotfixesToApply, HotfixEventHandler a) {
        progress = 0.0;
        downloading = true;
        int matches = hotfixesToApply.size();
        try {
            AtomicInteger i = new AtomicInteger();
            new Thread(() -> {
                long start = System.currentTimeMillis();
                for (String hotfix : hotfixesToApply) {
                    HotfixEventHandler hotfixEventHandler = a;
                    synchronized (hotfixEventHandler) {
                        a.beforeDownload(i.get() + 1, matches, hotfix, (int)(progress * 100.0));
                        byte[] bytes = new byte[]{};
                        try {
                            MpucConfig config = ConfigInstances.getModpackUpdateCheckerConfig();
                            bytes = Hotfixes.fetchUrlAsBytes(config.updateCheckerId + "hotfixes/" + config.currentVersion + "/" + hotfix);
                        }
                        catch (IOException | InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        Path c = Platform.getGameDir().resolve(hotfix);
                        c.toFile().getParentFile().mkdirs();
                        try {
                            Files.write(c, bytes, new OpenOption[0]);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        i.getAndIncrement();
                        HotfixApplier.updateProgress(matches, i.get());
                        estimatedTimeRemaining = (long)((double)(System.currentTimeMillis() - start) / (double)i.get() * (double)(matches - i.get()) / 1000.0);
                    }
                }
                progress = 0.0;
                downloading = false;
                estimatedTimeRemaining = 0L;
                a.afterDownload();
                try {
                    Hotfixes.init();
                }
                catch (IOException | InterruptedException e) {
                    throw new RuntimeException(e);
                }
                a.afterHotfixInit();
            }).start();
        }
        catch (Exception e) {
            progress = 0.0;
            downloading = false;
            a.onError();
            estimatedTimeRemaining = 0L;
            return false;
        }
        return false;
    }

    private static void updateProgress(long matches, int a) {
        progress = (double)a / (double)matches;
    }
}

