/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.config;

import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jab125.mpuc.config.ConfigInstances;
import com.jab125.mpuc.config.MpucConfig;
import com.jab125.mpuc.util.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public class PlatformMods {
    public static final Path PLATFORM_MODS_JSON = MpucConfig.MPUC_CONFIG_FOLDER.resolve("platform-mods.json");

    public static boolean hasMissingMods() {
        for (PlatformMod platformMod : ConfigInstances.getPlatformMods()) {
            if (platformMod.presenceChecker.isPresent(platformMod)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAutomatic(List<PlatformMod> platformMods) {
        return platformMods instanceof PlatformModList && ((PlatformModList)platformMods).automaticDownload;
    }

    public static void autoDownloadMods(List<PlatformMod> platformMods) {
        if (!(platformMods instanceof PlatformModList)) {
            return;
        }
        for (PlatformMod platformMod : PlatformMods.toIterable(platformMods.stream().filter(a -> a.fulfilledSource == null).filter(a -> a.downloadLink().direct()).iterator())) {
            PlatformMods.downloadMod(platformMod, DownloadSource.CLIENT_LAUNCH);
        }
    }

    private static <T> Iterable<T> toIterable(Iterator<T> iterator) {
        return () -> iterator;
    }

    public static PlatformModList deserialize() {
        String s = null;
        try {
            s = Files.readString(PLATFORM_MODS_JSON);
        }
        catch (IOException e) {
            return new PlatformModList();
        }
        PlatformModList platformMods = new PlatformModList();
        JsonObject object = (JsonObject)MpucConfig.GSON.fromJson(s, JsonObject.class);
        platformMods.automaticDownload = false;
        if (object.getAsJsonPrimitive("schemaVersion").getAsInt() != 1) {
            throw new RuntimeException("Unsupported schema version!");
        }
        for (JsonElement mod : object.getAsJsonArray("mods")) {
            if (!mod.isJsonObject()) {
                throw new RuntimeException("Needs to be a JSON object!");
            }
            platformMods.add(PlatformMod.deserialize(mod.getAsJsonObject()));
        }
        return platformMods;
    }

    private static <T extends Throwable> void sneakyThrow(Throwable t) throws T {
        throw t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadMod(PlatformMod platformMod, DownloadSource source) {
        if (!platformMod.downloadLink().direct()) {
            PlatformMods.sneakyThrow(new Throwable("Not Direct Link!"));
            return false;
        }
        try {
            String filename;
            String urlString = platformMod.downloadLink().link();
            URL url = new URL(urlString);
            URLConnection con = url.openConnection();
            String fieldValue = con.getHeaderField("Content-Disposition");
            if (fieldValue == null || !fieldValue.contains("filename=\"")) {
                // empty if block
            }
            if (fieldValue != null) {
                filename = fieldValue.substring(fieldValue.indexOf("filename=\"") + 10, fieldValue.length() - 2);
            } else {
                int i = (urlString.endsWith("/") ? urlString.substring(0, urlString.length() - 1) : urlString).lastIndexOf("/");
                if (i >= 0) {
                    filename = urlString.substring(i);
                } else {
                    throw new RuntimeException("We tried everything we could to get the file name, and **every single one** failed.");
                }
            }
            File download = new File(Platform.getGameDir().resolve("mods").toFile(), filename);
            ReadableByteChannel rbc = Channels.newChannel(con.getInputStream());
            try (FileOutputStream fos = new FileOutputStream(download);){
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            }
            platformMod.fulfilledSource = source;
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public static final class PlatformMod {
        private static final String DIRECT = "direct:";
        public final String displayName;
        public final String[] predicates;
        public final PresenceCheckers presenceChecker;
        public final String download;
        public final String id;
        public DownloadSource fulfilledSource = null;

        private static PlatformMod deserialize(JsonObject object) {
            String[] stringArray;
            String id = object.getAsJsonPrimitive("id").getAsString();
            if (object.has("predicate")) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = object.getAsJsonPrimitive("predicate").getAsString();
            } else {
                stringArray = (String[])Streams.stream((Iterator)object.getAsJsonArray("predicates").iterator()).map(JsonElement::getAsString).toArray(String[]::new);
            }
            String[] predicates = stringArray;
            String displayName = object.has("displayName") ? object.getAsJsonPrimitive("displayName").getAsString() : id;
            PresenceCheckers presenceChecker = PresenceCheckers.valueOf(object.getAsJsonPrimitive("presenceChecker").getAsString().toUpperCase(Locale.ROOT));
            String download = object.getAsJsonPrimitive("download").getAsString();
            return new PlatformMod(displayName, predicates, id, download, presenceChecker);
        }

        public PlatformMod(String displayName, String[] predicates, String id, String download, PresenceCheckers presenceChecker) {
            this.displayName = displayName;
            this.predicates = predicates;
            this.id = id;
            this.download = download;
            this.presenceChecker = presenceChecker;
        }

        public Download downloadLink() {
            return this.download.startsWith(DIRECT) ? new Download(this.download.substring(DIRECT.length()), true) : new Download(this.download);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            PlatformMod that = (PlatformMod)obj;
            return Objects.equals(this.displayName, that.displayName) && Arrays.equals(this.predicates, that.predicates) && Objects.equals(this.download, that.download);
        }

        public int hashCode() {
            return Objects.hash(this.displayName, this.id, this.download, this.presenceChecker, this.predicates);
        }

        public String toString() {
            return "PlatformMod[displayName=" + this.displayName + ", predicate=" + String.valueOf(this.predicates) + ", download=" + this.download + "]";
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum PresenceCheckers implements PresenceChecker
    {
        ID_VERSION_EXACT_MATCH{

            @Override
            public boolean isPresent(PlatformMod platformMod) {
                String[] predicates;
                Optional<Platform.Mod> optionalMod = Platform.getModList().stream().filter(a -> a.getId().equals(platformMod.id)).findFirst();
                if (optionalMod.isEmpty()) {
                    return false;
                }
                Platform.Mod mod = optionalMod.get();
                for (String version : predicates = platformMod.predicates) {
                    if (!mod.getVersion().equals(version)) continue;
                    return true;
                }
                return false;
            }
        }
        ,
        ID_MATCH{

            @Override
            public boolean isPresent(PlatformMod platformMod) {
                Optional<Platform.Mod> optionalMod = Platform.getModList().stream().filter(a -> a.getId().equals(platformMod.id)).findFirst();
                return optionalMod.isPresent();
            }
        };

    }

    private static class PlatformModList
    extends ArrayList<PlatformMod> {
        boolean automaticDownload;

        private PlatformModList() {
        }
    }

    public static enum DownloadSource {
        CLIENT_LAUNCH("screen.modpack-update-checker.missing-mods.downloaded.client-launch"),
        MANUAL("screen.modpack-update-checker.missing-mods.downloaded.manual");

        private final String translationText;

        private DownloadSource(String translationText) {
            this.translationText = translationText;
        }

        public String getTranslationKey() {
            return this.translationText;
        }
    }

    public static final class Download {
        private final String link;
        private final boolean direct;

        private Download(String link, boolean direct) {
            this.link = link;
            this.direct = direct;
        }

        private Download(String link) {
            this(link, false);
        }

        public String link() {
            return this.link;
        }

        public boolean direct() {
            return this.direct;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Download that = (Download)obj;
            return Objects.equals(this.link, that.link) && this.direct == that.direct;
        }

        public int hashCode() {
            return Objects.hash(this.link, this.direct);
        }

        public String toString() {
            return "Download[link=" + this.link + ", direct=" + this.direct + "]";
        }
    }

    public static interface PresenceChecker {
        public boolean isPresent(PlatformMod var1);
    }
}

