/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.util;

import com.jab125.mpuc.client.gui.screen.DebugScreen;
import com.jab125.mpuc.client.gui.screen.EditorScreen;
import com.jab125.mpuc.client.gui.screen.flow.ScrollableFlowScreen;
import com.jab125.mpuc.client.util.Context;
import com.jab125.mpuc.util.Platform;
import com.mojang.blaze3d.systems.RenderSystem;
import java.net.URI;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public interface ButtonUtils {
    default public Button createButton(int x, int y, int width, int height, Component message, Button.OnPress onPress) {
        return this.createButton(x, y, width, height, message, onPress, () -> true);
    }

    default public Button createButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, Supplier<Boolean> active) {
        Button button = Button.m_253074_((Component)message, (Button.OnPress)onPress).m_252987_(x, y, width, height).m_253136_();
        button.f_93623_ = active.get();
        return button;
    }

    default public Button createButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, Function<@Nullable Button, Component> tooltipSupplier) {
        return this.createButton(x, y, width, height, message, onPress, tooltipSupplier, () -> true);
    }

    default public Button createButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, Function<@Nullable Button, Component> tooltipSupplier, Supplier<Boolean> active) {
        Button button = Button.m_253074_((Component)message, (Button.OnPress)onPress).m_252987_(x, y, width, height).m_257505_(Tooltip.m_257550_((Component)tooltipSupplier.apply(null))).m_253136_();
        button.f_93623_ = active.get();
        return button;
    }

    default public void setTooltip(Button button, Function<@Nullable Button, Component> tooltipSupplier) {
        button.m_257544_(Tooltip.m_257550_((Component)tooltipSupplier.apply(button)));
    }

    public static Button creat\u00e9Button(int x, int y, int width, int height, Component message, Button.OnPress onPress) {
        return Button.m_253074_((Component)message, (Button.OnPress)onPress).m_252987_(x, y, width, height).m_253136_();
    }

    public void addButtonWidget(Button var1);

    public static Button createDebugButton(Screen parent, int offset) {
        return new Button(parent.f_96543_ - 3 - 20 - offset, 3, 20, 20, (Component)Component.m_237119_(), b -> Minecraft.m_91087_().m_91152_((Screen)new DebugScreen(parent)), Supplier::get){};
    }

    public static Button createFlowTestButton(Screen parent, int offset) {
        return new Button(parent.f_96543_ - 3 - 20 - offset, 3, 20, 20, (Component)Component.m_237119_(), b -> Minecraft.m_91087_().m_91152_((Screen)new ScrollableFlowScreen(parent)), Supplier::get){};
    }

    public static Button createEditorButton(Screen parent, int offset) {
        return new Button(parent.f_96543_ - 3 - 20 - offset, 3, 20, 20, (Component)Component.m_237119_(), b -> Minecraft.m_91087_().m_91152_((Screen)new EditorScreen(parent)), Supplier::get){};
    }

    public static void confirmLink(Screen parent, boolean trusted, String url) {
        Minecraft.m_91087_().m_91152_((Screen)new ConfirmLinkScreen(a -> {
            if (a) {
                ButtonUtils.openLink(URI.create(url));
            } else {
                Minecraft.m_91087_().m_91152_(parent);
            }
        }, url, trusted));
    }

    public static Button createKofiButton(Screen parent, int offset) {
        return new Button(parent.f_96543_ - 3 - 20 - offset, 3, 20, 20, (Component)Component.m_237119_(), b -> Minecraft.m_91087_().m_91152_((Screen)new ConfirmLinkScreen(a -> {
            if (a) {
                ButtonUtils.openLink(URI.create("https://ko-fi.com/Jab125"));
            } else {
                Minecraft.m_91087_().m_91152_(parent);
            }
        }, "https://ko-fi.com/Jab125", true)), Supplier::get){

            public void m_87963_(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
                super.m_87963_(drawContext, mouseX, mouseY, delta);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
                new Context(drawContext).drawTexture(ResourceLocation.m_214293_((String)"modpack-update-checker", (String)"textures/gui/kofi.png"), this.m_252754_(), this.m_252907_(), 20, 20, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        };
    }

    default public void addCredits() {
        boolean isDevelopmentEnvironment = Platform.isDevelopmentEnvironment();
        int offset = 0;
        BiFunction<Screen, Integer, Button> editorButton = ButtonUtils::createEditorButton;
        BiFunction<Screen, Integer, Button> debugButton = ButtonUtils::createDebugButton;
        BiFunction<Screen, Integer, Button> kofiButton = ButtonUtils::createKofiButton;
        BiFunction<Screen, Integer, Button> flowTestButton = ButtonUtils::createFlowTestButton;
        ArrayList<BiFunction<Screen, Integer, Button>> buttons = new ArrayList<BiFunction<Screen, Integer, Button>>();
        if (Platform.mpucAuthor()) {
            buttons.add(editorButton);
        }
        if (this.fJKve()) {
            buttons.add(kofiButton);
        }
        if (isDevelopmentEnvironment && !(this instanceof DebugScreen)) {
            buttons.add(debugButton);
            buttons.add(flowTestButton);
        }
        for (BiFunction biFunction : buttons) {
            this.addButtonWidget((Button)biFunction.apply((Screen)this, offset));
            offset += 22;
        }
    }

    private static void openLink(URI link) {
        Util.m_137581_().m_137648_(link);
    }

    default public boolean fJKve() {
        return true;
    }

    public static void handleBasicTextClick(Screen screen, Style style) {
        screen.m_5561_(style);
    }
}

