/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.widget.flow.widgets;

import com.jab125.mpuc.client.gui.widget.flow.widgets.AbstractWidget;
import com.jab125.mpuc.client.util.ButtonUtils;
import com.jab125.mpuc.client.util.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class TextWidget
extends AbstractWidget {
    private final FormattedText text;
    private int width;
    private final double scale;
    private final boolean wrap;
    private int height;
    private List<FormattedCharSequence> orderedTexts;

    public TextWidget(Minecraft client, FormattedText text, int width, int height, double scale, boolean wrap) {
        super(client);
        this.text = text;
        this.width = width;
        this.height = height;
        this.scale = scale;
        this.wrap = wrap;
        this.orderedTexts = wrap ? client.f_91062_.m_92923_(text, width) : this.makey(text);
        Objects.requireNonNull(client.f_91062_);
        this.height = Mth.m_14165_((double)(scale * 9.0 * (double)this.orderedTexts.size()));
        if (!wrap) {
            this.width = Mth.m_14165_((double)(scale * (double)client.f_91062_.m_92724_(this.orderedTexts.get(0))));
        }
    }

    private List<FormattedCharSequence> makey(FormattedText text) {
        ArrayList<FormattedText> texts = new ArrayList<FormattedText>();
        texts.add(text);
        return Language.m_128107_().m_128112_(texts);
    }

    @Override
    public void render(Context context, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        int y = 0;
        context.getMatrices().push();
        context.getMatrices().scale((float)this.scale, (float)this.scale, 1.0);
        for (FormattedCharSequence orderedText : this.orderedTexts) {
            context.drawTextWithShadow(this.client.f_91062_, orderedText, 0, y, -1);
            Objects.requireNonNull(this.client.f_91062_);
            y += 9;
        }
        context.getMatrices().pop();
    }

    @Override
    public int getRequestedWidth() {
        return this.width;
    }

    @Override
    public int getRequestedHeight() {
        return this.height;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Style textStyleAt = this.getTextStyleAt(mouseX, mouseY);
        if (textStyleAt != null && this.client.f_91080_ != null) {
            ButtonUtils.handleBasicTextClick(this.client.f_91080_, textStyleAt);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private Style getTextStyleAt(double x, double y) {
        if (this.wrap) {
            Objects.requireNonNull(this.client.f_91062_);
            int i = (int)(y / 9.0);
            if (i >= 0 && i < this.orderedTexts.size()) {
                FormattedCharSequence text = this.orderedTexts.get(i);
                return this.client.f_91062_.m_92865_().m_92338_(text, Mth.m_14107_((double)x));
            }
            return null;
        }
        return this.client.f_91062_.m_92865_().m_92386_(this.text, Mth.m_14107_((double)x));
    }
}

