/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.widget.flow.markdown;

import com.jab125.mpuc.client.gui.widget.flow.markdown.ExtendedListFeature;
import com.jab125.mpuc.client.gui.widget.flow.markdown.HeaderFeature;
import com.jab125.mpuc.client.gui.widget.flow.markdown.ImageFeature;
import com.jab125.mpuc.client.gui.widget.flow.markdown.LinkFeature;
import com.jab125.mpuc.client.gui.widget.flow.widgets.AbstractWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.FlexFlowWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.FlowWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.HeaderFlexFlowWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.ImageWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.QuotedFlexFlowWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.TextWidget;
import com.jab125.mpuc.client.util.TextureSizeLookup;
import com.jab125.mpuc.server.util.Widths;
import dev.jab125.lavendermd.MarkdownFeature;
import dev.jab125.lavendermd.MarkdownProcessor;
import dev.jab125.lavendermd.compiler.MarkdownCompiler;
import dev.jab125.lavendermd.feature.BasicFormattingFeature;
import dev.jab125.lavendermd.feature.BlockQuoteFeature;
import dev.jab125.lavendermd.feature.ColorFeature;
import dev.jab125.lavendermd.util.TextBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Stack;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class WidgetCompiler
implements MarkdownCompiler<AbstractWidget> {
    private final TextBuilder builder = new TextBuilder();
    private final FlowWidget widget;
    private final Stack<FlowWidget> widgets;
    private final int assumedOutputWidth;
    private int quoteDepth = 0;
    private int listDepth = 0;
    private int headerDepth = 0;

    public WidgetCompiler() {
        this(50, 0, 0);
    }

    public WidgetCompiler(int assumedOutputWidth, int maxWidth, int maxHeight) {
        this(assumedOutputWidth, maxWidth, maxHeight, ChatFormatting.GRAY);
    }

    public WidgetCompiler(int assumedOutputWidth, int maxWidth, int maxHeight, ChatFormatting formatting) {
        this.assumedOutputWidth = assumedOutputWidth;
        this.widget = new FlexFlowWidget(Minecraft.m_91087_(), maxWidth, maxHeight, FlowWidget.Direction.VERTICAL);
        this.widgets = ((Supplier<Stack>)() -> {
            Stack<FlowWidget> widgets = new Stack<FlowWidget>();
            widgets.push(this.widget);
            return widgets;
        }).get();
        if (formatting != null) {
            this.visitStyle(a -> a.m_131140_(formatting));
        }
    }

    public void visitText(String text) {
        if (this.listDepth != 0 && text.contains("\n")) {
            if (text.equals("\n")) {
                this.builder.append(Component.m_237113_((String)("\n   " + "  ".repeat(this.listDepth - 1))));
            } else {
                String[] lines = text.split("\n");
                for (int i = 0; i < lines.length; ++i) {
                    this.builder.append(Component.m_237113_((String)((i > 0 ? "\n   " : "   ") + "  ".repeat(this.listDepth - 1))).m_7220_((Component)Component.m_237113_((String)lines[i])));
                }
            }
        } else {
            this.builder.append(Component.m_237113_((String)text));
        }
    }

    public void visitStyle(UnaryOperator<Style> style) {
        this.builder.pushStyle(style);
    }

    public void visitStyleEnd() {
        this.builder.popStyle();
    }

    public void visitBlockQuote() {
        ++this.quoteDepth;
        this.addText(this.builder.build());
        QuotedFlexFlowWidget f = new QuotedFlexFlowWidget(Minecraft.m_91087_(), FlowWidget.Direction.VERTICAL);
        this.widgets.peek().addChild(f);
        this.widgets.push(f);
        this.builder.pushStyle(style -> style.m_131140_(ChatFormatting.DARK_GRAY));
    }

    public void visitBlockQuoteEnd() {
        this.builder.popStyle();
        this.addText(this.builder.build());
        this.widgets.pop();
        --this.quoteDepth;
        if (this.quoteDepth <= 0) {
            this.builder.append(Component.m_237113_((String)"\n"));
        }
    }

    public void visitHeader(int num) {
        this.headerDepth += num;
        this.addText(this.builder.build());
        HeaderFlexFlowWidget f = new HeaderFlexFlowWidget(Minecraft.m_91087_(), FlowWidget.Direction.VERTICAL, this.headerDepth);
        this.widgets.peek().addChild(f);
        this.widgets.push(f);
    }

    public void visitHeaderEnd(int num) {
        MutableComponent build = this.builder.build();
        this.addText(build);
        this.widgets.pop();
        this.headerDepth -= num;
        if (this.headerDepth > 0) {
            // empty if block
        }
    }

    private MutableComponent quoteMarker() {
        return Component.m_237113_((String)("\n >" + ">".repeat(this.quoteDepth) + " ")).m_130940_(ChatFormatting.DARK_GRAY);
    }

    public void visitHorizontalRule() {
        this.builder.append(Component.m_237113_((String)"-".repeat(this.assumedOutputWidth / Widths.WIDTH_CACHE.get('-'))).m_130940_(ChatFormatting.DARK_GRAY));
    }

    public void visitImage(ResourceLocation image, String description, boolean fit) {
        this.addText(this.builder.build());
        TextureSizeLookup.Size size = TextureSizeLookup.sizeOf(image);
        if (fit) {
            this.widgets.peek().addChild(new ImageWidget(this.widgets.peek().client, image, 100, 100));
        } else {
            this.widgets.peek().addChild(new ImageWidget(this.widgets.peek().client, image, size.width(), size.height()));
        }
    }

    private void addText(MutableComponent build) {
        ArrayList<TextWidget> text = new ArrayList<TextWidget>();
        List texts = this.widgets.peek().client.f_91062_.m_92865_().m_92414_((FormattedText)build, this.assumedOutputWidth, Style.f_131099_);
        for (FormattedText formattedText : texts) {
            Minecraft minecraft = this.widgets.peek().client;
            int n = this.widgets.peek().client.f_91062_.m_92852_(formattedText);
            Objects.requireNonNull(this.widgets.peek().client.f_91062_);
            TextWidget text2 = new TextWidget(minecraft, formattedText, n, 9, 1.0, false);
            text.add(text2);
        }
        for (AbstractWidget abstractWidget : text) {
            this.widgets.peek().addChild(abstractWidget);
        }
    }

    public void visitListItem(OptionalInt ordinal) {
        String listPrefix;
        String string = listPrefix = ordinal.isPresent() ? " " + ordinal.getAsInt() + ". " : " \u2022 ";
        if (this.listDepth > 0) {
            this.builder.append(Component.m_237113_((String)("\n" + "   ".repeat(this.listDepth) + listPrefix)));
        } else {
            this.builder.append(Component.m_237113_((String)listPrefix));
        }
        ++this.listDepth;
    }

    public void visitListItemEnd() {
        --this.listDepth;
        if (this.listDepth > 0) {
            this.builder.append(Component.m_237113_((String)"   ".repeat(this.listDepth)));
        } else {
            this.builder.append(Component.m_237113_((String)"\n"));
        }
    }

    public AbstractWidget compile() {
        this.addText(this.builder.build());
        return this.widget;
    }

    public String name() {
        return "mpuc_flow";
    }

    public static MarkdownProcessor<AbstractWidget> widget(int assumedOutputWidth, int maxWidth, int maxHeight) {
        return WidgetCompiler.widget(assumedOutputWidth, maxWidth, maxHeight, ChatFormatting.GRAY);
    }

    public static MarkdownProcessor<AbstractWidget> widget(int assumedOutputWidth, int maxWidth, int maxHeight, ChatFormatting formatting) {
        return new MarkdownProcessor(() -> new WidgetCompiler(assumedOutputWidth, maxWidth, maxHeight, formatting), new MarkdownFeature[]{new BasicFormattingFeature(), new ColorFeature(), new LinkFeature(), new ExtendedListFeature(), new BlockQuoteFeature(), new ImageFeature(), new HeaderFeature()});
    }
}

