/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.mpuc.client.gui.screen.changelog;

import com.jab125.mpuc.Hotfixes;
import com.jab125.mpuc.api.MarkdownRenderer;
import com.jab125.mpuc.client.gui.screen.HotfixScreen;
import com.jab125.mpuc.client.gui.screen.TemplateScreen;
import com.jab125.mpuc.client.gui.widget.ScrollableFlowWidget;
import com.jab125.mpuc.client.gui.widget.flow.FlowMarkdownUtils;
import com.jab125.mpuc.client.gui.widget.flow.widgets.ChangelogVersionButtonWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.FlowWidget;
import com.jab125.mpuc.client.gui.widget.flow.widgets.InfoButtonWidget;
import com.jab125.mpuc.client.util.ButtonUtils;
import com.jab125.mpuc.client.util.Context;
import com.jab125.mpuc.config.ConfigInstances;
import com.jab125.mpuc.util.OnlineInfo;
import com.jab125.mpuc.util.Platform;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class NewChangelogScreen
extends TemplateScreen {
    private final Screen parent;
    private ScrollableFlowWidget changelogFlowWidget;
    private ScrollableFlowWidget versionsFlowWidget;
    private Button markdownSwitchButton;
    private MarkdownRenderer renderer;
    private final Map<String, OnlineInfo.Version> versions;
    private OnlineInfo.Version currentVersion;
    private Button modrinthButton;
    private Button downloadButton;
    private Button curseforgeButton;

    public NewChangelogScreen(Screen parent) {
        super((Component)Component.m_237119_());
        String markdownRenderer;
        this.versions = ConfigInstances.getModpackUpdateCheckerConfig().getAssociatedOnlineInfo().versions;
        this.currentVersion = null;
        this.parent = parent;
        if (Platform.mpucAuthor()) {
            ConfigInstances.getModpackUpdateCheckerConfig().clearCachedText();
        }
        this.renderer = FlowMarkdownUtils.isAvailable(markdownRenderer = ConfigInstances.getModpackUpdateCheckerConfig().markdownRenderer) ? FlowMarkdownUtils.COMPILERS.get(markdownRenderer) : (FlowMarkdownUtils.isAvailable("builtin:mpuc_lavendermd") ? FlowMarkdownUtils.COMPILERS.get("builtin:mpuc_lavendermd") : MarkdownRenderer.BASIC);
    }

    protected void m_7856_() {
        double changelogScrollAmount = this.getChangelogScrollAmount();
        double versionsScrollAmount = this.getVersionsScrollAmount();
        super.m_7856_();
        int changelogPaneWidth = this.f_96543_ / 3 * 2;
        int left = this.f_96543_ - changelogPaneWidth;
        int right = this.f_96543_ - 4;
        int width = (right - left) / 3 - 2;
        this.modrinthButton = this.createButton(left, 78, width, 20, (Component)Component.m_237113_((String)"Modrinth"), b -> ButtonUtils.confirmLink(this, false, this.currentVersion.promotions.getDownloadLink("modrinth")));
        this.modrinthButton.f_93623_ = this.currentVersion != null && this.currentVersion.promotions != null && this.currentVersion.promotions.hasDownloadLinks() && this.currentVersion.promotions.getDownloadLinkOptional("modrinth").isPresent();
        this.downloadButton = this.createButton(left + width + 2, 78, width, 20, (Component)Component.m_237113_((String)"Generic"), b -> ButtonUtils.confirmLink(this, false, this.currentVersion.promotions.getDownloadLink("generic")));
        this.downloadButton.f_93623_ = this.currentVersion != null && this.currentVersion.promotions != null && this.currentVersion.promotions.hasDownloadLinks() && this.currentVersion.promotions.getDownloadLinkOptional("generic").isPresent();
        this.curseforgeButton = this.createButton(left + width * 2 + 4, 78, width, 20, (Component)Component.m_237113_((String)"CurseForge"), b -> ButtonUtils.confirmLink(this, false, this.currentVersion.promotions.getDownloadLink("curseforge")));
        this.curseforgeButton.f_93623_ = this.currentVersion != null && this.currentVersion.promotions != null && this.currentVersion.promotions.hasDownloadLinks() && this.currentVersion.promotions.getDownloadLinkOptional("curseforge").isPresent();
        this.changelogFlowWidget = new ScrollableFlowWidget(this.f_96541_, changelogPaneWidth, this.f_96544_ - 70, 102, this.f_96544_ - 32);
        this.m_142416_((GuiEventListener)this.changelogFlowWidget);
        this.changelogFlowWidget.m_93507_(this.f_96543_ - changelogPaneWidth);
        this.addButtonWidget(this.modrinthButton);
        this.addButtonWidget(this.downloadButton);
        this.addButtonWidget(this.curseforgeButton);
        int versionsPaneWidth = this.f_96543_ - changelogPaneWidth - 6;
        this.markdownSwitchButton = this.createButton(versionsPaneWidth - 34 - 6 - 20, this.f_96544_ - 20 - 32, 54, 20, (Component)Component.m_237119_(), b -> this.markdownToggled(), this::markdownButtonTooltip);
        this.setRenderer(this.renderer);
        int o = 0;
        this.versionsFlowWidget = new ScrollableFlowWidget(this.f_96541_, versionsPaneWidth, this.f_96544_ - 20, 32, this.f_96544_ - 20 - 32 - o);
        this.m_142416_((GuiEventListener)this.versionsFlowWidget);
        for (Map.Entry<String, OnlineInfo.Version> version : this.versions.entrySet()) {
            if (!ConfigInstances.getModpackUpdateCheckerConfig().tags.passes(version.getValue().tags)) continue;
            this.versionsFlowWidget.addChild(0, new ChangelogVersionButtonWidget(this.f_96541_, this, version.getValue(), versionsPaneWidth));
        }
        this.versionsFlowWidget.addChild(0, new InfoButtonWidget(this.f_96541_, this, versionsPaneWidth));
        this.versionsFlowWidget.addChild(FlowMarkdownUtils.process(versionsPaneWidth - 20, versionsPaneWidth - 20, 0, ""));
        this.versionsFlowWidget.addChild(new FlowWidget(this.f_96541_, 0, 20, FlowWidget.Direction.VERTICAL));
        if (!Hotfixes.hotfixAvailable) {
            this.addButtonWidget(this.createButton(this.f_96543_ / 2 - 100, this.f_96544_ - 25, 200, 20, CommonComponents.f_130655_, button -> this.f_96541_.m_91152_(this.parent)));
        } else {
            this.addButtonWidget(this.createButton(this.f_96543_ / 2 - 100, this.f_96544_ - 25, 98, 20, CommonComponents.f_130655_, button -> this.f_96541_.m_91152_(this.parent)));
            this.addButtonWidget(this.createButton(this.f_96543_ / 2 + 2, this.f_96544_ - 25, 98, 20, (Component)Component.m_237115_((String)"screen.modpack-update-checker.hotfix.title"), button -> this.f_96541_.m_91152_((Screen)new HotfixScreen(this))));
        }
        this.addCredits();
        this.addButtonWidget(this.markdownSwitchButton);
        this.changelogFlowWidget.m_93410_(changelogScrollAmount);
        this.versionsFlowWidget.m_93410_(versionsScrollAmount);
    }

    private void setRenderer(MarkdownRenderer renderer) {
        this.renderer = renderer;
        this.markdownSwitchButton.m_93666_((Component)Component.m_237115_((String)this.renderer.getDisplayNameTranslationKey()));
        this.changelogFlowWidget.clearBacking();
        this.renderChangelog();
        this.changelogFlowWidget.m_93410_(0.0);
    }

    private Component markdownButtonTooltip(Button widget) {
        return Component.m_237115_((String)this.renderer.getDescriptionTranslationKey());
    }

    private void markdownToggled() {
        List collect = FlowMarkdownUtils.COMPILERS.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        List collect1 = collect.stream().map(Map.Entry::getValue).collect(Collectors.toList());
        int rendererIndex = collect1.indexOf(this.renderer);
        int nextRendererIndex = rendererIndex + 1;
        if (nextRendererIndex >= collect1.size()) {
            nextRendererIndex = 0;
        }
        this.setRenderer((MarkdownRenderer)collect1.get(nextRendererIndex));
        this.setTooltip(this.markdownSwitchButton, this::markdownButtonTooltip);
    }

    private void renderChangelog() {
        int changelogPaneWidth = this.f_96543_ / 3 * 2;
        String text = this.currentVersion != null ? this.currentVersion.changelog() : ConfigInstances.getModpackUpdateCheckerConfig().getInfoText();
        this.changelogFlowWidget.addChild(this.renderer.render(changelogPaneWidth - 20, changelogPaneWidth - 20, 0, text, ChatFormatting.GRAY));
        this.changelogFlowWidget.addChild(new FlowWidget(this.f_96541_, 0, 20, FlowWidget.Direction.VERTICAL));
    }

    public OnlineInfo.Version getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(OnlineInfo.Version version) {
        if (version == this.currentVersion) {
            return;
        }
        int changelogPaneWidth = this.f_96543_ / 3 * 2;
        int versionsPaneWidth = this.f_96543_ - changelogPaneWidth - 5;
        this.currentVersion = version;
        this.changelogFlowWidget.clearBacking();
        this.renderChangelog();
        this.changelogFlowWidget.m_93410_(0.0);
        if (version != null && version.promotions != null && version.promotions.hasDownloadLinks()) {
            this.modrinthButton.f_93623_ = version.promotions.getDownloadLinkOptional("modrinth").isPresent();
            this.curseforgeButton.f_93623_ = version.promotions.getDownloadLinkOptional("curseforge").isPresent();
            this.downloadButton.f_93623_ = version.promotions.getDownloadLinkOptional("generic").isPresent();
        } else {
            this.modrinthButton.f_93623_ = false;
            this.curseforgeButton.f_93623_ = false;
            this.downloadButton.f_93623_ = false;
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public double getChangelogScrollAmount() {
        return this.changelogFlowWidget == null ? 0.0 : this.changelogFlowWidget.m_93517_();
    }

    public double getVersionsScrollAmount() {
        return this.versionsFlowWidget == null ? 0.0 : this.versionsFlowWidget.m_93517_();
    }

    public void m_88315_(GuiGraphics matrices, int mouseX, int mouseY, float delta) {
        this.m_280273_(matrices);
        super.m_88315_(matrices, mouseX, mouseY, delta);
        matrices.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"screen.modpack-update-checker.modpack-update.title"), this.f_96543_ / 2, 5, -1);
        Context context = new Context(matrices);
        FormattedCharSequence formattedCharSequence = Language.m_128107_().m_5536_((FormattedText)Component.m_237113_((String)"Markdown").m_130940_(ChatFormatting.GRAY));
        Objects.requireNonNull(this.f_96547_);
        context.drawTextWithShadow(this.f_96547_, formattedCharSequence, 9, this.f_96544_ - 20 - 32 + (10 - 9 / 2), -1);
        FormattedCharSequence formattedCharSequence2 = Language.m_128107_().m_5536_((FormattedText)Component.m_237113_((String)ConfigInstances.getModpackUpdateCheckerConfig().modpackName));
        int n = this.f_96543_ - this.f_96543_ / 3 * 2;
        Objects.requireNonNull(this.f_96547_);
        Objects.requireNonNull(this.f_96547_);
        context.drawTextWithShadow(this.f_96547_, formattedCharSequence2, n, 54 - 9 - 2 - 9 - 2, -1);
        FormattedCharSequence formattedCharSequence3 = Language.m_128107_().m_5536_((FormattedText)(this.currentVersion == null ? Component.m_237115_((String)"screen.modpack-update-checker.changelog.modpackInfo") : Component.m_237113_((String)(this.currentVersion.id.startsWith("v") ? this.currentVersion.id : "v" + this.currentVersion.id))).m_130940_(ChatFormatting.GRAY));
        int n2 = this.f_96543_ - this.f_96543_ / 3 * 2;
        Objects.requireNonNull(this.f_96547_);
        context.drawTextWithShadow(this.f_96547_, formattedCharSequence3, n2, 54 - 9 - 2, -1);
        context.drawTextWithShadow(this.f_96547_, Language.m_128107_().m_5536_((FormattedText)Component.m_237110_((String)"screen.modpack-update-checker.changelog.modpackAuthors", (Object[])new Object[]{ConfigInstances.getModpackUpdateCheckerConfig().modpackAuthor}).m_130940_(ChatFormatting.GRAY)), this.f_96543_ - this.f_96543_ / 3 * 2, 54, -1);
    }
}

