/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import journeymap.client.Constants;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.ButtonList;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class Button
extends net.minecraft.client.gui.components.Button {
    protected Integer customFrameColorLight = new Color(160, 160, 160).getRGB();
    protected Integer customFrameColorDark = new Color(120, 120, 120).getRGB();
    protected Integer customBgColor = new Color(100, 100, 100).getRGB();
    protected Integer customBgHoverColor = new Color(125, 135, 190).getRGB();
    protected Integer customBgHoverColor2 = new Color(100, 100, 100).getRGB();
    protected Integer labelColor;
    protected Integer varLabelColor;
    protected Integer hoverLabelColor;
    protected Integer disabledLabelColor;
    public static final int UNSET_ACTIVE_COLOR = -1;
    protected int packedActiveColor = -1;
    protected Integer disabledBgColor = new Color(45, 45, 45).getRGB();
    protected boolean drawFrame;
    protected boolean drawBackground;
    protected boolean drawBackgroundOnDisable = true;
    protected boolean drawLabelShadow = true;
    protected boolean showDisabledHoverText;
    protected boolean defaultStyle = true;
    protected int WIDTH_PAD = 12;
    protected String[] tooltip;
    protected String label;
    protected Font fontRenderer;
    protected Rectangle2D.Double bounds;
    protected ArrayList<Function<Button, Boolean>> clickListeners;
    private int tooltipSize;
    private DrawUtil.HAlign horizontalAlignment;
    private boolean drawHovered;
    private HoverState onHoverState;
    private boolean wasHovered;

    public Button(String label) {
        this(0, 0, label, Button.emptyPressable());
        this.resetLabelColors();
    }

    public Button(String label, Button.OnPress onPress) {
        this(0, 0, label, onPress);
        this.resetLabelColors();
    }

    public Button(int width, int height, String label, Button.OnPress onPress) {
        super(0, 0, width, height, (Component)Constants.getStringTextComponent(label), onPress, f_252438_);
        this.fontRenderer = Minecraft.m_91087_().f_91062_;
        this.clickListeners = new ArrayList(0);
        this.tooltipSize = 200;
        this.horizontalAlignment = DrawUtil.HAlign.Center;
        this.drawHovered = true;
        this.wasHovered = false;
        this.label = label;
        this.finishInit();
    }

    public static Button.OnPress emptyPressable() {
        return button -> {};
    }

    public void resetLabelColors() {
        this.labelColor = new Color(0xE0E0E0).getRGB();
        this.hoverLabelColor = new Color(0xFFFFA0).getRGB();
        this.disabledLabelColor = Color.gray.getRGB();
    }

    public int getActiveColor() {
        if (this.packedActiveColor != -1) {
            return this.packedActiveColor;
        }
        return this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
    }

    protected void finishInit() {
        this.setEnabled(true);
        this.setDrawButton(true);
        this.setDrawFrame(true);
        this.setDrawBackground(true);
        if (this.f_93619_ == 0) {
            this.setHeight(20);
        }
        if (this.f_93618_ == 0) {
            this.m_93674_(200);
        }
        this.updateBounds();
    }

    protected void updateLabel() {
    }

    public boolean m_142518_() {
        return this.isEnabled();
    }

    public int getFitWidth(Font fr) {
        int max = fr.m_92895_(this.m_6035_().getString());
        return max + this.WIDTH_PAD + (fr.m_92718_() ? (int)Math.ceil((double)max * 0.25) : 0);
    }

    public String getLabel() {
        return this.label;
    }

    public void fitWidth(Font fr) {
        this.m_93674_(this.getFitWidth(fr));
    }

    public void drawPartialScrollable(GuiGraphics graphics, Minecraft minecraft, int x, int y, int width, int height) {
        int k = 0;
        graphics.m_280218_(f_93617_, x, y, 0, 46 + k * 20, width / 2, height);
        graphics.m_280218_(f_93617_, x + width / 2, y, 200 - width / 2, 46 + k * 20, width / 2, height);
    }

    public void showDisabledOnHover(boolean show) {
        this.showDisabledHoverText = show;
    }

    public boolean m_5953_(double x, double y) {
        return super.m_5953_((double)super.m_252754_(), (double)super.m_252907_());
    }

    public boolean isMouseOver() {
        return super.m_5953_((double)super.m_252754_(), (double)super.m_252907_());
    }

    public void setMouseOver(boolean hover) {
        this.setHovered(hover);
    }

    public void m_7435_(SoundManager soundHandler) {
        if (this.isEnabled()) {
            super.m_7435_(soundHandler);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.isVisible()) {
            return;
        }
        if (this.defaultStyle) {
            super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        } else {
            Minecraft minecraft = Minecraft.m_91087_();
            minecraft.m_91097_().m_174784_(f_93617_);
            RenderWrapper.setShader(GameRenderer::m_172817_);
            RenderWrapper.setShaderTexture(0, f_93617_);
            RenderWrapper.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.setHovered(mouseX >= super.m_252754_() && mouseY >= super.m_252907_() && mouseX < super.m_252754_() + this.f_93618_ && mouseY < super.m_252907_() + this.f_93619_);
            if (this.isDrawFrame()) {
                DrawUtil.drawRectangle(graphics.m_280168_(), super.m_252754_(), super.m_252907_(), this.f_93618_, 1.0, this.customFrameColorLight, 1.0f);
                DrawUtil.drawRectangle(graphics.m_280168_(), super.m_252754_(), super.m_252907_(), 1.0, this.f_93619_, this.customFrameColorLight, 1.0f);
                DrawUtil.drawRectangle(graphics.m_280168_(), super.m_252754_(), super.m_252907_() + this.f_93619_ - 1, this.f_93618_ - 1, 1.0, this.customFrameColorDark, 1.0f);
                DrawUtil.drawRectangle(graphics.m_280168_(), super.m_252754_() + this.f_93618_ - 1, super.m_252907_() + 1, 1.0, this.f_93619_ - 1, this.customFrameColorDark, 1.0f);
            }
            if (this.isDrawBackground() || !this.drawBackgroundOnDisable && this.isEnabled()) {
                DrawUtil.drawRectangle(graphics.m_280168_(), super.m_252754_() + 1, super.m_252907_() + 1, this.f_93618_ - 2, this.f_93619_ - 2, this.f_93622_ && this.drawHovered ? this.customBgHoverColor : this.customBgColor, 1.0f);
            } else if (this.isEnabled() && this.m_274382_() && this.drawHovered) {
                DrawUtil.drawRectangle(graphics.m_280168_(), super.m_252754_() + 1, super.m_252907_() + 1, this.f_93618_ - 2, this.f_93619_ - 2, this.customBgHoverColor2, 0.5f);
            }
            this.renderBg(graphics, minecraft, mouseX, mouseY);
            this.varLabelColor = this.labelColor;
            if (!this.isEnabled()) {
                this.varLabelColor = this.disabledLabelColor;
                if (this.drawBackground) {
                    float alpha = 0.7f;
                    int widthOffset = this.f_93618_ - (this.f_93619_ >= 20 ? 3 : 2);
                    DrawUtil.drawRectangle(graphics.m_280168_(), this.m_252754_() + 1, this.m_252907_() + 1, widthOffset, this.f_93619_ - 2, this.disabledBgColor, alpha);
                }
            } else if (this.m_274382_() && this.drawHovered) {
                this.varLabelColor = this.hoverLabelColor;
            } else if (this.labelColor != null) {
                this.varLabelColor = this.labelColor;
            } else if (this.getActiveColor() != 0) {
                this.varLabelColor = this.getActiveColor();
            }
            DrawUtil.drawLabel(graphics, this.m_6035_().getString(), switch (this.horizontalAlignment) {
                case DrawUtil.HAlign.Left -> this.getRightX() - this.WIDTH_PAD / 2;
                case DrawUtil.HAlign.Right -> this.m_252754_() + this.WIDTH_PAD / 2;
                default -> this.getCenterX();
            }, this.getMiddleY(), this.horizontalAlignment, DrawUtil.VAlign.Middle, null, 0.0f, this.varLabelColor, 1.0f, 1.0, this.drawLabelShadow, 0.0);
        }
    }

    protected void renderBg(GuiGraphics graphics, Minecraft $$1, int $$2, int $$3) {
    }

    public void renderSpecialDecoration(GuiGraphics graphics, int mouseX, int mouseY, int x, int y, int width, int height) {
    }

    public void setHorizontalAlignment(DrawUtil.HAlign horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public void drawHovered(boolean drawHovered) {
        this.drawHovered = drawHovered;
    }

    public void drawCenteredString(GuiGraphics graphics, Font fontRenderer, String text, float x, float y, int color) {
        fontRenderer.m_271703_(text, x - (float)(fontRenderer.m_92895_(text) / 2), y, color, true, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)graphics.m_280091_(), Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
    }

    public void drawUnderline(PoseStack poseStack) {
        if (this.isVisible()) {
            DrawUtil.drawRectangle(poseStack, super.m_252754_(), super.m_252907_() + this.f_93619_, this.f_93618_, 1.0, this.customFrameColorDark, 1.0f);
        }
    }

    public void secondaryDrawButton() {
    }

    public void m_5691_() {
        if (this.clickListeners == null || this.clickListeners.size() == 0) {
            super.m_5691_();
        } else {
            this.checkClickListeners();
        }
    }

    public void m_94757_(double mouseX, double mouseY) {
        if (this.onHoverState != null) {
            if (this.m_274382_() && !this.wasHovered) {
                this.wasHovered = true;
                this.onHoverState.onHoverState(this, this.wasHovered);
            } else if (this.wasHovered && !this.m_274382_()) {
                this.wasHovered = false;
                this.onHoverState.onHoverState(this, this.wasHovered);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean mousePressed(double mouseX, double mouseY, boolean checkClickListeners) {
        boolean clicked = this.isEnabled() && this.isVisible() && this.mouseOver(mouseX, mouseY);
        return clicked && (!checkClickListeners || this.checkClickListeners());
    }

    public boolean checkClickListeners() {
        boolean clicked = true;
        if (!this.clickListeners.isEmpty()) {
            try {
                for (Function<Button, Boolean> listener : this.clickListeners) {
                    if (!listener.apply(this).booleanValue()) break;
                }
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Error trying to toggle button '" + this.m_6035_() + "': " + LogFormatter.toString(t));
                clicked = false;
            }
        }
        return clicked;
    }

    public String getUnformattedTooltip() {
        if (this.tooltip != null && this.tooltip.length > 0) {
            return this.tooltip[0];
        }
        return null;
    }

    public List<FormattedCharSequence> getFormattedTooltip() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        if (this.tooltip != null) {
            for (String line : this.tooltip) {
                list.addAll(this.fontRenderer.m_92923_((FormattedText)Constants.getTranslatedTextComponent(line), this.tooltipSize));
            }
            return list;
        }
        if (!this.isEnabled() && this.showDisabledHoverText) {
            list.add(FormattedCharSequence.m_13714_((String)Constants.getString("jm.common.disabled_feature"), (Style)Style.f_131099_.m_131155_(Boolean.valueOf(true))));
        }
        return list;
    }

    public void setTooltip(String ... tooltip) {
        this.tooltip = tooltip;
    }

    public void setTooltip(int size, String ... tooltip) {
        this.tooltipSize = size;
        this.tooltip = tooltip;
    }

    public boolean mouseOver(double mouseX, double mouseY) {
        return this.isVisible() && this.getBounds().contains(mouseX, mouseY);
    }

    protected Rectangle2D.Double updateBounds() {
        this.bounds = new Rectangle2D.Double(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_());
        return this.bounds;
    }

    public Rectangle2D.Double getBounds() {
        if (this.bounds == null) {
            return this.updateBounds();
        }
        return this.bounds;
    }

    public int getScrollableWidth() {
        return this.f_93618_;
    }

    public void m_93674_(int width) {
        if (this.f_93618_ != width) {
            this.f_93618_ = width;
            this.bounds = null;
        }
    }

    public void setScrollableWidth(int width) {
        this.m_93674_(width);
    }

    public int getButtonHeight() {
        return this.m_93694_();
    }

    public void setHeight(int height) {
        if (this.f_93619_ != height) {
            this.f_93619_ = height;
            this.bounds = null;
            if (height != 20) {
                this.defaultStyle = false;
            }
        }
    }

    public void setTextOnly(Font fr) {
        Objects.requireNonNull(fr);
        this.setHeight(9 + 1);
        this.fitWidth(fr);
        this.setDrawBackground(false);
        this.setDrawFrame(false);
    }

    public void drawScrollable(GuiGraphics graphics, Minecraft mc, int mouseX, int mouseY) {
        this.m_88315_(graphics, mouseX, mouseY, 0.0f);
    }

    public void clickScrollable(Minecraft mc, int mouseX, int mouseY) {
    }

    public void m_252865_(int x) {
        if (super.m_252754_() != x) {
            super.m_252865_(x);
            this.bounds = null;
        }
    }

    public void m_253211_(int y) {
        if (super.m_252907_() != y) {
            super.m_253211_(y);
            this.bounds = null;
        }
    }

    public int getCenterX() {
        return super.m_252754_() + this.f_93618_ / 2;
    }

    public int getMiddleY() {
        return super.m_252907_() + this.f_93619_ / 2;
    }

    public int getBottomY() {
        return super.m_252907_() + this.f_93619_;
    }

    public int getRightX() {
        return super.m_252754_() + this.f_93618_;
    }

    public void setScrollablePosition(int x, int y) {
        this.m_252865_(x);
        this.m_253211_(y);
    }

    public Button leftOf(int x) {
        this.m_252865_(x - this.m_5711_());
        return this;
    }

    public Button rightOf(int x) {
        this.m_252865_(x);
        return this;
    }

    public Button centerHorizontalOn(int x) {
        this.m_252865_(x - this.f_93618_ / 2);
        return this;
    }

    public Button centerVerticalOn(int y) {
        this.m_253211_(y - this.f_93619_ / 2);
        return this;
    }

    public Button leftOf(Button other, int margin) {
        this.m_252865_(other.m_252754_() - this.m_5711_() - margin);
        return this;
    }

    public Button rightOf(Button other, int margin) {
        this.m_252865_(other.m_252754_() + other.m_5711_() + margin);
        return this;
    }

    public Button above(Button other, int margin) {
        this.m_253211_(other.m_252907_() - this.m_93694_() - margin);
        return this;
    }

    public Button above(int y) {
        this.m_253211_(y - this.m_93694_());
        return this;
    }

    public Button below(Button other, int margin) {
        this.m_253211_(other.m_252907_() + other.m_93694_() + margin);
        return this;
    }

    public Button below(ButtonList list, int margin) {
        this.m_253211_(list.getBottomY() + margin);
        return this;
    }

    public Button below(int y) {
        this.m_253211_(y);
        return this;
    }

    public Button alignTo(Button other, DrawUtil.HAlign hAlign, int hgap, DrawUtil.VAlign vAlign, int vgap) {
        int x = this.m_252754_();
        int y = this.m_252907_();
        switch (hAlign) {
            case Right: {
                x = other.getRightX() + hgap;
                break;
            }
            case Left: {
                x = other.m_252754_() - hgap;
                break;
            }
            case Center: {
                x = other.getCenterX();
            }
        }
        switch (vAlign) {
            case Above: {
                y = other.m_252907_() - vgap - this.m_93694_();
                break;
            }
            case Below: {
                y = other.getBottomY() + vgap;
                break;
            }
            case Middle: {
                y = other.getMiddleY() - this.m_93694_() / 2;
            }
        }
        this.m_252865_(x);
        this.m_253211_(y);
        return this;
    }

    public boolean isEnabled() {
        return this.f_93623_;
    }

    public void setEnabled(boolean enabled) {
        this.f_93623_ = enabled;
    }

    public boolean isVisible() {
        return this.f_93624_;
    }

    public void setVisible(boolean visible) {
        this.f_93624_ = visible;
    }

    public void setDrawButton(boolean drawButton) {
        if (drawButton != this.f_93624_) {
            this.f_93624_ = drawButton;
        }
    }

    public boolean isDrawFrame() {
        return this.drawFrame;
    }

    public void setDrawFrame(boolean drawFrame) {
        this.drawFrame = drawFrame;
    }

    public boolean isDrawBackground() {
        return this.drawBackground;
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    public boolean isDefaultStyle() {
        return this.defaultStyle;
    }

    public void setDefaultStyle(boolean defaultStyle) {
        this.defaultStyle = defaultStyle;
    }

    public void setBackgroundColors(Integer customBgColor, Integer customBgHoverColor, Integer customBgHoverColor2) {
        this.customBgColor = customBgColor;
        this.customBgHoverColor = customBgHoverColor;
        this.customBgHoverColor2 = customBgHoverColor2;
    }

    public void setDrawLabelShadow(boolean draw) {
        this.drawLabelShadow = draw;
    }

    public void setLabelColors(Integer labelColor, Integer hoverLabelColor, Integer disabledLabelColor) {
        this.labelColor = labelColor;
        this.packedActiveColor = labelColor;
        if (hoverLabelColor != null) {
            this.hoverLabelColor = hoverLabelColor;
        }
        if (disabledLabelColor != null) {
            this.disabledLabelColor = disabledLabelColor;
        }
    }

    public String getDisplayString() {
        return this.m_6035_().getString();
    }

    public void setOnHover(HoverState hoverState) {
        this.onHoverState = hoverState;
    }

    public boolean isDrawBackgroundOnDisable() {
        return this.drawBackgroundOnDisable;
    }

    public void setDrawBackgroundOnDisable(boolean drawBackgroundOnDisable) {
        this.drawBackgroundOnDisable = drawBackgroundOnDisable;
    }

    public void refresh() {
    }

    public Integer getLabelColor() {
        return this.labelColor;
    }

    public boolean m_274382_() {
        return super.m_274382_();
    }

    public void setHovered(boolean hovered) {
        this.f_93622_ = hovered;
    }

    public void addClickListener(Function<Button, Boolean> listener) {
        this.clickListeners.add(listener);
    }

    public String toString() {
        return new StringJoiner(", ", Button.class.getSimpleName() + "[", "]").add("label='" + this.label + "'").toString();
    }

    public static interface HoverState {
        public void onHoverState(Button var1, boolean var2);
    }
}

