/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.mojang.blaze3d.platform.NativeImage;
import info.journeymap.shaded.org.jetbrains.annotations.Nullable;
import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectOpenHashMap;
import journeymap.client.cartography.color.RGB;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.Texture;
import journeymap.common.Journeymap;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class DynamicTextureImpl
extends DynamicTexture
implements Texture {
    private float alpha;
    protected String description;
    private Integer renderWidth;
    private Integer renderHeight;
    private final Float2ObjectMap<Texture> scaledImageMap = new Float2ObjectOpenHashMap();
    @Nullable
    private ResourceLocation resourceLocation;

    public DynamicTextureImpl(NativeImage nativeImage) {
        super(nativeImage);
    }

    public DynamicTextureImpl(NativeImage nativeImage, ResourceLocation location) {
        this(nativeImage);
        this.resourceLocation = location;
    }

    public DynamicTextureImpl(int width, int height, boolean useCalloc) {
        this(new NativeImage(width, height, useCalloc));
    }

    @Override
    @Nullable
    public ResourceLocation getLocation() {
        return this.resourceLocation;
    }

    public void m_117985_() {
        try {
            if (super.m_117991_() != null) {
                super.m_117966_();
                super.m_117991_().m_85040_(0, 0, 0, false);
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error uploading image to framebuffer:", (Throwable)e);
        }
    }

    @Override
    public int getWidth() {
        return this.renderWidth == null ? super.m_117991_().m_84982_() : this.renderWidth.intValue();
    }

    @Override
    public int getHeight() {
        return this.renderHeight == null ? super.m_117991_().m_85084_() : this.renderHeight.intValue();
    }

    @Override
    public void setDisplayWidth(int width) {
        this.renderWidth = width;
    }

    @Override
    public void setDisplayHeight(int height) {
        this.renderHeight = height;
    }

    @Override
    public Texture getScaledImage(float drawScale) {
        if (drawScale == 1.0f) {
            return this;
        }
        Texture scaledTexture = (Texture)this.scaledImageMap.get(drawScale);
        try {
            if (scaledTexture == null) {
                NativeImage img = ImageUtil.getScaledImage(drawScale, super.m_117991_(), false);
                scaledTexture = new DynamicTextureImpl(img);
                this.scaledImageMap.put(drawScale, (Object)scaledTexture);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return scaledTexture;
    }

    @Override
    public Integer getRGB(int x, int y) {
        int rgba = this.getNativeImage().m_84985_(x, y);
        return RGB.rgbaToRgb(rgba);
    }

    @Override
    public int getTextureId() {
        return this.f_117950_;
    }

    @Override
    public void release() {
        super.m_117964_();
    }

    @Override
    public boolean hasImage() {
        return super.m_117991_() != null && super.m_117991_().f_84964_ > 0L;
    }

    @Override
    public void remove() {
        ImageUtil.clearAndClose(super.m_117991_());
    }

    @Override
    public void setNativeImage(NativeImage image) {
        super.m_117988_(image);
    }

    @Override
    public NativeImage getNativeImage() {
        return super.m_117991_();
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

