/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldapoth.util;

import dev.muon.otherworldapoth.OtherworldApoth;
import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastResult;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.network.casting.OnCastStartedPacket;
import io.redspace.ironsspellbooks.network.casting.OnClientCastPacket;
import io.redspace.ironsspellbooks.network.casting.SyncTargetingDataPacket;
import io.redspace.ironsspellbooks.network.casting.UpdateCastingStatePacket;
import io.redspace.ironsspellbooks.setup.PacketDistributor;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.entity.PartEntity;

public class SpellCastUtil {
    public static void castSpell(LivingEntity caster, AbstractSpell spell, int spellLevel, LivingEntity target) {
        if (caster.m_9236_().m_5776_()) {
            return;
        }
        MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)caster);
        if (magicData.isCasting()) {
            OtherworldApoth.LOGGER.debug("SpellTriggerAffix: Entity is still casting {}, forcing spell completion", (Object)magicData.getCastingSpellId());
            AbstractSpell oldSpell = magicData.getCastingSpell().getSpell();
            oldSpell.onCast(caster.m_9236_(), magicData.getCastingSpellLevel(), caster, magicData.getCastSource(), magicData);
            oldSpell.onServerCastComplete(caster.m_9236_(), magicData.getCastingSpellLevel(), caster, magicData, false);
            magicData.resetCastingState();
            magicData = MagicData.getPlayerMagicData((LivingEntity)caster);
        }
        OtherworldApoth.LOGGER.debug("SpellTriggerAffix: Merging target data, target: {}", (Object)target.m_7755_().getString());
        SpellCastUtil.updateTargetData(caster, (Entity)target, magicData, spell, x -> true);
        if (caster instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)caster;
            OtherworldApoth.LOGGER.debug("Casting SPELL FOR SERVERPLAYA");
            SpellCastUtil.castSpellForPlayer(spell, spellLevel, serverPlayer, magicData);
        } else if (caster instanceof IMagicEntity) {
            IMagicEntity magicEntity = (IMagicEntity)caster;
            magicEntity.initiateCastSpell(spell, spellLevel);
        } else if (caster instanceof LivingEntity && spell.checkPreCastConditions(caster.m_9236_(), spellLevel, caster, magicData)) {
            spell.onCast(caster.m_9236_(), spellLevel, caster, CastSource.COMMAND, magicData);
            spell.onServerCastComplete(caster.m_9236_(), spellLevel, caster, magicData, false);
        }
    }

    private static void castSpellForPlayer(AbstractSpell spell, int spellLevel, ServerPlayer serverPlayer, MagicData magicData) {
        CastResult castResult = spell.canBeCastedBy(spellLevel, CastSource.COMMAND, magicData, (Player)serverPlayer);
        if (castResult.message != null) {
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket(castResult.message));
        }
        if (magicData.isCasting()) {
            OtherworldApoth.LOGGER.warn("Attempted to trigger affix-cast while player was already casting");
            return;
        }
        if (serverPlayer.m_6117_()) {
            serverPlayer.m_5810_();
        }
        int effectiveCastTime = 0;
        if (spell.getCastType() == CastType.CONTINUOUS) {
            effectiveCastTime = spell.getEffectiveCastTime(spellLevel, (LivingEntity)serverPlayer);
        }
        magicData.initiateCast(spell, spellLevel, effectiveCastTime, CastSource.COMMAND, "command");
        magicData.setPlayerCastingItem(ItemStack.f_41583_);
        spell.onServerPreCast(serverPlayer.m_9236_(), spellLevel, (LivingEntity)serverPlayer, magicData);
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (Object)new UpdateCastingStatePacket(spell.getSpellId(), spellLevel, effectiveCastTime, CastSource.COMMAND, "command"));
        PacketDistributor.sendToPlayersTrackingEntity((Entity)serverPlayer, (Object)new OnCastStartedPacket(serverPlayer.m_20148_(), spell.getSpellId(), spellLevel));
        ICastData iCastData = magicData.getAdditionalCastData();
        if (iCastData instanceof TargetEntityCastData) {
            TargetEntityCastData targetingData = (TargetEntityCastData)iCastData;
        } else {
            OtherworldApoth.LOGGER.warn("Tried to merge Targeting Data but was overridden. Current cast data for spell {}: {}", (Object)magicData.getCastingSpellId(), (Object)magicData.getAdditionalCastData().getClass().getName());
        }
        if (effectiveCastTime == 0) {
            spell.onCast(serverPlayer.m_9236_(), spellLevel, (LivingEntity)serverPlayer, CastSource.COMMAND, magicData);
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (Object)new OnClientCastPacket(spell.getSpellId(), spellLevel, CastSource.COMMAND, magicData.getAdditionalCastData()));
        }
    }

    public static void updateTargetData(LivingEntity caster, Entity entityHit, MagicData playerMagicData, AbstractSpell spell, Predicate<LivingEntity> filter) {
        LivingEntity livingParent;
        PartEntity partEntity;
        Entity entity;
        LivingEntity livingEntity;
        LivingEntity livingTarget = null;
        if (entityHit instanceof LivingEntity && filter.test(livingEntity = (LivingEntity)entityHit)) {
            livingTarget = livingEntity;
        } else if (entityHit instanceof PartEntity && (entity = (partEntity = (PartEntity)entityHit).getParent()) instanceof LivingEntity && filter.test(livingParent = (LivingEntity)entity)) {
            livingTarget = livingParent;
        }
        if (livingTarget != null) {
            ServerPlayer serverPlayer;
            playerMagicData.setAdditionalCastData((ICastData)new TargetEntityCastData(livingTarget));
            if (caster instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)caster;
                if (spell.getCastType() != CastType.INSTANT) {
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (Object)new SyncTargetingDataPacket(livingTarget, spell));
                }
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"ui.irons_spellbooks.spell_target_success", (Object[])new Object[]{livingTarget.m_5446_().getString(), spell.getDisplayName((Player)serverPlayer)}).m_130940_(ChatFormatting.GREEN)));
            }
            if (livingTarget instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)livingTarget;
                Utils.sendTargetedNotification((ServerPlayer)serverPlayer, (LivingEntity)caster, (AbstractSpell)spell);
            }
        } else if (caster instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)caster;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"ui.irons_spellbooks.cast_error_target").m_130940_(ChatFormatting.RED)));
        }
    }
}

