/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.otherworldapoth.mixin.apoth;

import dev.muon.otherworldapoth.LootCategories;
import dev.muon.otherworldapoth.OtherworldApoth;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AffixHelper.class}, remap=false)
public class AffixHelperMixin {
    @Unique
    private static final Random jRand = new Random();

    @Inject(method={"setAffixes"}, at={@At(value="HEAD")})
    private static void replaceStaffDurability(ItemStack stack, Map<DynamicHolder<? extends Affix>, AffixInstance> affixes, CallbackInfo ci) {
        AffixType[] affixTypeArray;
        LootCategory cat = LootCategory.forItem((ItemStack)stack);
        if (!cat.equals((Object)LootCategories.STAFF)) {
            return;
        }
        DynamicHolder<? extends Affix> durableKey = null;
        AffixInstance durableInstance = null;
        for (Map.Entry<DynamicHolder<? extends Affix>, AffixInstance> entry : affixes.entrySet()) {
            if (!entry.getKey().getId().m_135815_().equals("durable")) continue;
            durableKey = entry.getKey();
            durableInstance = entry.getValue();
            break;
        }
        if (durableKey == null) {
            return;
        }
        LootRarity rarity = (LootRarity)durableInstance.rarity().get();
        OtherworldApoth.LOGGER.debug("[StaffDurabilityCompensation] Removing DURABLE affix from {} (rarity: {})", (Object)stack.m_41720_(), (Object)rarity);
        affixes.remove(durableKey);
        HashSet<DynamicHolder<? extends Affix>> currentAffixes = new HashSet<DynamicHolder<? extends Affix>>(affixes.keySet());
        int rarityOrdinal = rarity.ordinal();
        AffixType[][] compensationByRarity = new AffixType[][]{{AffixType.STAT}, {AffixType.STAT}, {AffixType.STAT}, {AffixType.STAT, AffixType.POTION}, {AffixType.STAT, AffixType.POTION}, {AffixType.STAT, AffixType.STAT, AffixType.POTION}};
        if (rarityOrdinal < compensationByRarity.length) {
            affixTypeArray = compensationByRarity[rarityOrdinal];
        } else {
            AffixType[] affixTypeArray2 = new AffixType[1];
            affixTypeArray = affixTypeArray2;
            affixTypeArray2[0] = AffixType.STAT;
        }
        AffixType[] compensationTypes = affixTypeArray;
        jRand.setSeed(System.nanoTime());
        int addedCount = 0;
        for (AffixType targetType : compensationTypes) {
            if (!AffixHelperMixin.tryAddAffix(stack, rarity, affixes, currentAffixes, targetType)) continue;
            ++addedCount;
        }
        if (addedCount == 0) {
            OtherworldApoth.LOGGER.warn("[StaffDurabilityCompensation] No replacement affixes available for staff!");
        } else {
            OtherworldApoth.LOGGER.debug("[StaffDurabilityCompensation] Added {} compensation affix(es) for {} rarity", (Object)addedCount, (Object)rarity);
        }
    }

    @Unique
    private static boolean tryAddAffix(ItemStack stack, LootRarity rarity, Map<DynamicHolder<? extends Affix>, AffixInstance> affixes, Set<DynamicHolder<? extends Affix>> currentAffixes, AffixType targetType) {
        AffixType[] fallbackOrder;
        for (AffixType type : fallbackOrder = new AffixType[]{targetType, AffixType.STAT, AffixType.POTION, AffixType.ABILITY}) {
            List available = LootController.getAvailableAffixes((ItemStack)stack, (LootRarity)rarity, currentAffixes, (AffixType)type);
            if (available.isEmpty()) continue;
            Collections.shuffle(available, jRand);
            DynamicHolder chosen = (DynamicHolder)available.get(0);
            OtherworldApoth.LOGGER.debug("[StaffDurabilityCompensation] Adding {} affix: {}", (Object)type, (Object)chosen.getId());
            AffixInstance replacement = new AffixInstance(chosen, stack, RarityRegistry.INSTANCE.holder((CodecProvider)rarity), jRand.nextFloat());
            affixes.put((DynamicHolder<? extends Affix>)chosen, replacement);
            currentAffixes.add((DynamicHolder<? extends Affix>)chosen);
            return true;
        }
        return false;
    }
}

